/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import java.util.Map;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.AbstractStateSpaceCommand;

public class SetPropertiesCommand
extends AbstractStateSpaceCommand {
    private Map<String, String> properties;
    private Integer maxStateDistance;

    public SetPropertiesCommand(StateSpaceManager manager, Map<String, String> properties) {
        super("set properties", manager);
        this.properties = properties;
    }

    public void setMaxStateDistance(int maxStateDistance) {
        this.maxStateDistance = maxStateDistance;
    }

    @Override
    public void doExecute() throws StateSpaceException {
        StateSpace stateSpace = this.getStateSpaceManager().getStateSpace();
        stateSpace.getProperties().clear();
        stateSpace.getProperties().putAll(this.properties);
        if (this.maxStateDistance != null) {
            stateSpace.setMaxStateDistance(this.maxStateDistance.intValue());
        }
    }

    public boolean canUndo() {
        return false;
    }
}

