/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.gc2ac.util;

import java.util.Set;
import laxcondition.Operator;
import laxcondition.Quantifier;
import morphisms.Mapping;
import morphisms.MorphismsFactory;
import morphisms.MorphismsPackage;
import morphisms.Pair;
import nestedcondition.Formula;
import nestedcondition.Morphism;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.NodeMapping;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.OverlapOptimizer;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.MorphismPair;
import org.eclipse.emf.henshin.ocl2ac.ocl2gc.util.JointPairs;

public class Shifter {
    private Morphism morphism;
    private NestedCondition condition;
    private EPackage typeModel;
    private NestedCondition result;
    private final NestedconditionFactory factory = NestedconditionFactory.eINSTANCE;
    private static boolean enableOptimizer = false;
    private static Rule rule;
    private static NestedConstraint constraint;
    private static boolean recursionEnd;

    static {
        recursionEnd = false;
    }

    public Shifter(Morphism morphism, NestedCondition condition, EPackage typeModel) {
        this.morphism = morphism;
        this.condition = condition;
        this.typeModel = typeModel;
    }

    public NestedCondition getResult() {
        return this.result;
    }

    public void shift() {
        if (recursionEnd) {
            this.result = null;
            return;
        }
        if (this.condition instanceof True) {
            this.shiftTrue();
        }
        if (this.condition instanceof Formula) {
            this.shiftFormular();
        }
        if (this.condition instanceof QuantifiedCondition) {
            this.shiftQuantifiedCondition();
        }
    }

    private void shiftQuantifiedCondition() {
        QuantifiedCondition cond = (QuantifiedCondition)this.condition;
        EList<MorphismPair> morphismPairs = this.constructMorphismPairs(this.morphism, cond.getMorphism());
        if (morphismPairs == null || morphismPairs.size() == 0 || recursionEnd) {
            recursionEnd = true;
            this.result = null;
            return;
        }
        if (morphismPairs.size() == 1) {
            MorphismPair pair = (MorphismPair)morphismPairs.get(0);
            this.result = this.constructQuantifiedCondition(cond, pair);
        } else {
            Formula ret = this.factory.createFormula();
            ret.setDomain(this.morphism.getTo());
            if (cond.getQuantifier().equals((Object)Quantifier.EXISTS)) {
                ret.setOperator(Operator.OR);
            } else {
                ret.setOperator(Operator.AND);
            }
            for (MorphismPair pair : morphismPairs) {
                QuantifiedCondition quantifiedCondition = this.constructQuantifiedCondition(cond, pair);
                ret.getArguments().add((Object)quantifiedCondition);
            }
            this.result = ret;
        }
    }

    private QuantifiedCondition constructQuantifiedCondition(QuantifiedCondition cond, MorphismPair pair) {
        if (recursionEnd) {
            recursionEnd = true;
            this.result = null;
            return null;
        }
        QuantifiedCondition ret = this.factory.createQuantifiedCondition();
        ret.setQuantifier(cond.getQuantifier());
        ret.setDomain(pair.getAPrime().getFrom());
        ret.setCodomain(pair.getAPrime().getTo());
        ret.setMorphism(pair.getAPrime());
        Shifter shifter = new Shifter(pair.getBPrime(), cond.getCondition(), this.typeModel);
        shifter.shift();
        ret.setCondition(shifter.getResult());
        return ret;
    }

    private EList<MorphismPair> constructMorphismPairs(Morphism b, Morphism a) {
        BasicEList morphismPairs = new BasicEList();
        Pair span = MorphismsPackage.eINSTANCE.getMorphismsFactory().createPair();
        span.setA(this.convertMorphismEMF2Graph(a));
        span.setB(this.convertMorphismEMF2Graph(b));
        Set pairs = JointPairs.getCommutingPairs((Pair)span);
        if (this.isEnableOptimizer()) {
            OverlapOptimizer oo = new OverlapOptimizer(rule, constraint, pairs);
            oo.optimizeOverlap();
            if (pairs.size() == 0) {
                System.out.println("The size of the pairs after the optimization is " + pairs.size());
            }
        }
        if (pairs.size() == 0 || recursionEnd) {
            recursionEnd = true;
            return null;
        }
        for (Pair pair : pairs) {
            MorphismPair morphismPair = new MorphismPair();
            morphismPair.setMorphismAPrime(this.convertMorphismGraph2EMF(pair.getB()));
            morphismPair.setMorphismBPrime(this.convertMorphismGraph2EMF(pair.getA()));
            morphismPairs.add((Object)morphismPair);
        }
        return morphismPairs;
    }

    private Morphism convertMorphismGraph2EMF(morphisms.Morphism morphismGraph) {
        NestedconditionFactory factory = NestedconditionFactory.eINSTANCE;
        Morphism morphismEMF = factory.createMorphism();
        morphismEMF.setFrom(morphismGraph.getDomain());
        morphismEMF.setTo(morphismGraph.getCodomain());
        for (Mapping m : morphismGraph.getMappings()) {
            NodeMapping nm = factory.createNodeMapping();
            nm.setOrigin(m.getOrigin());
            nm.setImage(m.getImage());
            morphismEMF.getNodeMappings().add((Object)nm);
        }
        return morphismEMF;
    }

    private morphisms.Morphism convertMorphismEMF2Graph(Morphism morphismEMF) {
        MorphismsFactory factory = MorphismsFactory.eINSTANCE;
        morphisms.Morphism morphismGraph = factory.createMorphism();
        morphismGraph.setDomain(morphismEMF.getFrom());
        morphismGraph.setCodomain(morphismEMF.getTo());
        for (NodeMapping m : morphismEMF.getNodeMappings()) {
            Mapping mapping = factory.createMapping();
            mapping.setOrigin(m.getOrigin());
            mapping.setImage(m.getImage());
            morphismGraph.getMappings().add((Object)mapping);
        }
        return morphismGraph;
    }

    private void shiftFormular() {
        if (recursionEnd) {
            recursionEnd = true;
            this.result = null;
            return;
        }
        Formula formula = (Formula)this.condition;
        Formula ret = this.factory.createFormula();
        ret.setDomain(this.morphism.getTo());
        ret.setOperator(formula.getOperator());
        for (NestedCondition arg : formula.getArguments()) {
            Shifter shifter = new Shifter(this.morphism, arg, this.typeModel);
            shifter.shift();
            if (recursionEnd) {
                recursionEnd = true;
                this.result = null;
                return;
            }
            ret.getArguments().add((Object)shifter.getResult());
        }
        this.result = ret;
    }

    private void shiftTrue() {
        if (recursionEnd) {
            recursionEnd = true;
            this.result = null;
            return;
        }
        this.result = this.factory.createTrue();
        this.result.setDomain(this.morphism.getTo());
    }

    public boolean isEnableOptimizer() {
        return enableOptimizer;
    }

    public void setEnableOptimizer(boolean enableOptimizer, Rule rule, NestedConstraint constraint) {
        Shifter.enableOptimizer = enableOptimizer;
        Shifter.rule = rule;
        Shifter.constraint = constraint;
    }

    public static void reset() {
        recursionEnd = false;
        enableOptimizer = false;
    }
}

