/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.preprocessing;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.preprocessing.DirectoryUtil;

public class RuleSetModifier {
    public void removeMultiRules(String sourcePath, String targetPath) {
        File dir = new File(sourcePath);
        List<String> pathsToHenshinFiles = DirectoryUtil.inspectDirectoryForHenshinFiles(dir);
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            for (Unit unit : module.getUnits()) {
                Rule rule;
                if (!(unit instanceof Rule) || (rule = (Rule)unit).getMultiRules().size() <= 0) continue;
                LinkedList multiRules = new LinkedList();
                multiRules.addAll(rule.getMultiRules());
                rule.getMultiRules().removeAll(multiRules);
            }
            String resultPath = pathToHenshinFiles.replace(sourcePath, targetPath);
            HenshinResourceSet resultResourceSet = new HenshinResourceSet();
            resultResourceSet.saveEObject((EObject)module, resultPath);
        }
    }

    public void removeUnits(String sourcePath, String targetPath) {
        File dir = new File(sourcePath);
        List<String> pathsToHenshinFiles = DirectoryUtil.inspectDirectoryForHenshinFiles(dir);
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            HashSet<Unit> units = new HashSet<Unit>();
            for (Unit unit : module.getUnits()) {
                if (unit instanceof Rule) continue;
                units.add(unit);
            }
            module.getUnits().removeAll(units);
            String resultPath = pathToHenshinFiles.replace(sourcePath, targetPath);
            HenshinResourceSet resultResourceSet = new HenshinResourceSet();
            resultResourceSet.saveEObject((EObject)module, resultPath);
        }
    }

    public void removeApplicationConditions(String sourcePath, String targetPath) {
        File dir = new File(sourcePath);
        List<String> pathsToHenshinFiles = DirectoryUtil.inspectDirectoryForHenshinFiles(dir);
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            HashSet units = new HashSet();
            for (Unit unit : module.getUnits()) {
                Rule rule;
                Formula formula;
                if (!(unit instanceof Rule) || (formula = (rule = (Rule)unit).getLhs().getFormula()) == null) continue;
                rule.getLhs().setFormula(null);
            }
            module.getUnits().removeAll(units);
            String resultPath = pathToHenshinFiles.replace(sourcePath, targetPath);
            HenshinResourceSet resultResourceSet = new HenshinResourceSet();
            resultResourceSet.saveEObject((EObject)module, resultPath);
        }
    }

    public void transformDeleteToPreserve(String sourcePath, String targetPath, boolean adaptRuleName) {
        File dir = new File(sourcePath);
        List<String> pathsToHenshinFiles = DirectoryUtil.inspectDirectoryForHenshinFiles(dir);
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            HashSet<Unit> units = new HashSet<Unit>();
            units.addAll((Collection<Unit>)module.getUnits());
            this.transformDeleteToPreserve(units, adaptRuleName);
            String resultPath = pathToHenshinFiles.replace(sourcePath, targetPath);
            HenshinResourceSet resultResourceSet = new HenshinResourceSet();
            resultResourceSet.saveEObject((EObject)module, resultPath);
        }
    }

    private void transformDeleteToPreserve(Set<Unit> units, boolean adaptRuleName) {
        for (Unit unit : units) {
            if (!(unit instanceof Rule)) continue;
            Rule rule = (Rule)unit;
            RuleSetModifier.transformDeleteToPreserve(rule, adaptRuleName);
        }
    }

    public static void transformDeleteToPreserve(Rule rule, boolean adaptRuleName) {
        HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
        Action deleteAction = new Action(Action.Type.DELETE);
        EList deletionNodes = rule.getActionNodes(deleteAction);
        for (Node deletionNode : deletionNodes) {
            Node newNodeInRHS = henshinFactory.createNode(rule.getRhs(), deletionNode.getType(), deletionNode.getName());
            rule.getMappings().add(deletionNode, newNodeInRHS);
        }
        EList deletionEdges = rule.getActionEdges(deleteAction);
        for (Edge edge : deletionEdges) {
            MappingList mappingList = rule.getMappings();
            Node sourceNodeInRHS = mappingList.getImage(edge.getSource(), rule.getRhs());
            Node targetNodeInRHS = mappingList.getImage(edge.getTarget(), rule.getRhs());
            henshinFactory.createEdge(sourceNodeInRHS, targetNodeInRHS, edge.getType());
        }
        if (adaptRuleName) {
            rule.setName(String.valueOf(rule.getName()) + "_preserve");
        }
    }

    public static List<Rule> getDeleteToPreserveCopyOfRules(List<Rule> rules, boolean adaptRuleName) {
        LinkedList<Rule> copyOfRules = new LinkedList<Rule>();
        for (Rule rule : rules) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Rule copiedRule = (Rule)copier.copy((EObject)rule);
            copier.copyReferences();
            copyOfRules.add(copiedRule);
            RuleSetModifier.transformDeleteToPreserve(copiedRule, true);
        }
        return copyOfRules;
    }
}

