/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.unitTest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.henshin.multicda.cda.framework.CdaWorker;
import org.eclipse.emf.henshin.multicda.cda.framework.Condition;
import org.eclipse.emf.henshin.multicda.cda.framework.CpaWorker;
import org.eclipse.emf.henshin.multicda.cda.framework.Options;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class UltimateTest {
    private static CdaWorker cda;
    private static CpaWorker cpa;
    private static CdaWorker cdaD;
    private static CpaWorker cpaD;
    private static String henshin;
    private static Options options;
    private static Options optionsD;
    private static boolean executeAll;
    private static boolean executeCpa;
    private static boolean compare;
    private static Map<String, Set<String>> prooved;
    private static long allTime;

    static {
        henshin = "testData/main/test.henshin";
        options = new Options(256, new int[0]);
        optionsD = new Options(256, 1);
        executeAll = false;
        compare = executeCpa = false;
        prooved = new HashMap<String, Set<String>>();
        allTime = 0L;
    }

    @BeforeClass
    public static void before() {
        CdaWorker.ignore = prooved;
        options.remove(32, 64);
        optionsD.remove(32, 64);
    }

    private static String time(long time) {
        long milis = time % 1000L;
        long seconds = time / 1000L % 60L;
        long minutes = time / 60000L % 60L;
        long hours = time / 3600000L % 24L;
        long days = time / 86400000L % 365L;
        long years = time / 31536000000L;
        return String.valueOf(years == 0L ? "" : String.valueOf(years) + "y, ") + (days == 0L ? "" : String.valueOf(days) + "d, ") + (hours == 0L ? "" : String.valueOf(hours) + "h, ") + (minutes == 0L ? "" : String.valueOf(minutes) + "m, ") + seconds + "s, " + milis + "ms";
    }

    private static Set<Reason> computeReasons(String r1, String r2) {
        Set<String> r2s = prooved.get(r1);
        TreeSet<Reason> cdaResult = new TreeSet<Reason>();
        if (r2s == null || !r2s.contains(r2)) {
            HashSet<CriticalPair> cpaResult = new HashSet<CriticalPair>();
            cda = executeAll ? new CdaWorker(henshin, options) : new CdaWorker(henshin, r1, r2, options);
            cdaResult.addAll(cda.getResult());
            if (executeCpa) {
                cpa = executeAll ? new CpaWorker(henshin, options) : new CpaWorker(henshin, new String[]{r1}, new String[]{r2}, options);
                cpaResult.addAll(cpa.getResult());
            }
            if (compare) {
                cda.compare(cpa.getResult(), new boolean[0]);
            }
            if (options.is(32) || options.is(64)) {
                System.out.println("----------------------------------------------------------------");
            }
            cdaD = executeAll ? new CdaWorker(henshin, optionsD) : new CdaWorker(henshin, r1, r2, optionsD);
            cdaResult.addAll(cdaD.getResult());
            if (executeCpa) {
                cpaD = executeAll ? new CpaWorker(henshin, optionsD) : new CpaWorker(henshin, new String[]{r1}, new String[]{r2}, optionsD);
                cpaResult.addAll(cpaD.getResult());
            }
            if (options.is(32) || options.is(64)) {
                System.out.println("Reasons found: " + cdaResult.size());
            }
            if (executeCpa) {
                System.out.println("Critical Pairs found: " + cpaResult.size());
            }
            if (compare) {
                cdaD.compare(cpaD.getResult(), new boolean[0]);
            }
            if (options.is(32) || options.is(64)) {
                System.out.println("______________________________________________________________________________");
            }
            if (r2s == null) {
                r2s = new HashSet<String>();
            }
            r2s.add(r2);
            prooved.put(r1, r2s);
        } else {
            cda.reset();
            cdaD.reset();
        }
        return cdaResult;
    }

    @Test
    public void deleteTest() {
        long time = System.currentTimeMillis();
        UltimateTest.computeReasons("d1", "p1");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "p2");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "p6");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "d1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "d2");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "d6");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "d7");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "c1");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "c3");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "c4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "c6");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "f1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("d1", "f2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d1", "f3");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "f4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "f6");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "f7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d1", "r1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "r2");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "r3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "r6");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "r7");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d1", "ch");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "p1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "p2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "p6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "d1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "d2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "d6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "d7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "c1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "c3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "c4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "c6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "f1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d2", "f2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d2", "f3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "f4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "f6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "f7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d2", "r1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "r2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "r6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "r7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d2", "ch");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "p3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "d3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "d4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d3", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d3", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("d3", "f5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("d3", "r5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "r3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "r4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "p1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "p2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "p3");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "p6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "d3");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "d4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d4", "d5");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d4", "d6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "c1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "c3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "c4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "c6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "f3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("d4", "f5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d4", "f6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "f7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d4", "r1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r3");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r5");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "r7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d4", "ch");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "p1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "p3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "p2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "p6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "d1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "d4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "d5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "d3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "d6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "c1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "c3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "c4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "c6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "f1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d5", "f2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d5", "f3");
        cda.check(new Condition.ReasonSize(5));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "f4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "f5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("d5", "f6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "f7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d5", "r1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "p6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "r6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d5", "ch");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "p6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "d6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "c6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d6", "d7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "r6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "r7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d6", "ch");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "p1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "p2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "p6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "d1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "d2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "d6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "d7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "c1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "c3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "c4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "f1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d7", "f2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d7", "f3");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "f4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "f7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d7", "r1");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "r2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "r6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "r7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d7", "ch");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        time = System.currentTimeMillis() - time;
        allTime += time;
        System.out.println("Delete complete... " + UltimateTest.time(time));
    }

    @Test
    public void createTest() {
        long time = System.currentTimeMillis();
        UltimateTest.computeReasons("c1", "p1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c1", "p2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "d1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "d2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "c1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c1", "c3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "c4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "c6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "f1");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c1", "f2");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c1", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "f6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "f7");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c1", "r1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c1", "r2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c2", "p1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c2", "p2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "d1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "d2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "c1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c2", "c3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "c4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "c6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "f1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c2", "f2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c2", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "f6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "f7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c2", "r1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c2", "r2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c3", "p3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c3", "f5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c3", "d3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c3", "f3");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c3", "f4");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c3", "r5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c3", "r3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c3", "r4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "p1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "p2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "p3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "d3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "c1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "c3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "c4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "c6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "f4");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c4", "f5");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c4", "f6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "f7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c4", "r1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "r2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "r3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "r4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "r5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "r5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "p1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c5", "p3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c5", "p2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "d1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c5", "d3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c5", "d4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c5", "d5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c5", "c1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c5", "c3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "c4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "c6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "f1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c5", "f2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c5", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(5));
        UltimateTest.computeReasons("c5", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "f5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c5", "f6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "f7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c5", "r1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "r5");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c5", "r2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c5", "r3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c5", "r4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c6", "p6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c6", "d6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c6", "d7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c6", "c6");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c6", "ch");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c6", "r6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c6", "r7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "p1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c7", "p2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "p6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "d1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "d2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "d6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "d7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "c1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c7", "c3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "c4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "f1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c7", "f2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c7", "f3");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "f4");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "f7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c7", "r1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "r2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c7", "r6");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "r7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("c7", "ch");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(3));
        time = System.currentTimeMillis() - time;
        allTime += time;
        System.out.println("Create complete... " + UltimateTest.time(time));
    }

    @Test
    public void changeTest() {
        long time = System.currentTimeMillis();
        UltimateTest.computeReasons("ch", "p6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("ch", "d6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("ch", "r6");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("ch", "r7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("ch", "ch");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        UltimateTest.computeReasons("ch", "d7");
        cda.check(new Condition.ReasonSize(3));
        cdaD.check(new Condition.ReasonSize(3));
        time = System.currentTimeMillis() - time;
        allTime += time;
        System.out.println("Change complete... " + UltimateTest.time(time));
    }

    @Test
    public void edgeNodeTest() {
        long time = System.currentTimeMillis();
        UltimateTest.computeReasons("c3", "d1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c3", "d2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c3", "d4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c3", "d5");
        cda.check(new Condition.ReasonSize(5));
        cdaD.check(new Condition.ReasonSize(1));
        UltimateTest.computeReasons("c3", "d7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c4", "d1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "d2");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("c4", "d4");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("c4", "d5");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("c4", "d7");
        cda.check(new Condition.ReasonSize(6));
        cdaD.check(new Condition.ReasonSize());
        UltimateTest.computeReasons("d3", "d1");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d3", "d2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d3", "d5");
        cda.check(new Condition.ReasonSize(1));
        cdaD.check(new Condition.ReasonSize(5));
        UltimateTest.computeReasons("d3", "d7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d4", "d1");
        cda.check(new Condition.ReasonSize(2));
        cdaD.check(new Condition.ReasonSize(2));
        UltimateTest.computeReasons("d4", "d2");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        UltimateTest.computeReasons("d4", "d7");
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize(6));
        time = System.currentTimeMillis() - time;
        allTime += time;
        System.out.println("Edge-Node complete... " + UltimateTest.time(time));
    }

    @Test
    public void restTest() {
        long time = System.currentTimeMillis();
        UltimateTest.computeReasons(null, null);
        cda.check(new Condition.ReasonSize());
        cdaD.check(new Condition.ReasonSize());
        time = System.currentTimeMillis() - time;
        allTime += time;
        System.out.println("Zero Reason pairs complete... " + UltimateTest.time(time));
    }

    @Test
    public void heavyTest() {
        String henshin = "testData/main/attributes.henshin";
        cda = new CdaWorker(henshin, "complex", new Options(new boolean[0]));
        cdaD = new CdaWorker(henshin, "complex", new Options(1, new int[0]));
        Condition.ConditionsSet cons = new Condition.ConditionsSet(false, false, true, new Condition.Conditions[0]);
        cons.add(new Condition.ChCR(Condition.StateProvider.REQUIRE, new Condition.Node("3_2")));
        cons.add(new Condition.ChCR(new Condition.Node("3_3")));
        cons.add(new Condition.DCR(new Condition.Node("8_8")));
        cons.add(new Condition.DCR(new Condition.Node("1_1")));
        cons.add(new Condition.DCR(new Condition.Node("1_1"), new Condition.Node("8_3")));
        cons.add(new Condition.DCR(new Condition.Node("1_1"), new Condition.Node("8_8")));
        cons.add(new Condition.CCR(new Condition.Node("4_4")));
        cons.add(new Condition.CCR(new Condition.Node("6_6")));
        cons.add(new Condition.CCR(new Condition.Node("6_6"), new Condition.Node("4_4")));
        cons.add(new Condition.CEDNCR(new Condition.Node("3_8")));
        cons.add(new Condition.CEDNCR(new Condition.Node("3_8"), new Condition.Node("1_1")));
        cda.check(cons);
        cons = new Condition.ConditionsSet(false, false, true, new Condition.Conditions[0]);
        cons.add(new Condition.ChCR(Condition.StateProvider.DEPENDENCY, new Condition.Node("3_1")));
        cons.add(new Condition.CCR(Condition.StateProvider.DEPENDENCY, new Condition.Edge("4_4", "3_1")));
        cons.add(new Condition.CCR(Condition.StateProvider.DEPENDENCY, new Condition.Edge("4_4", "3_1"), new Condition.Node("6_3")));
        cons.add(new Condition.CCR(Condition.StateProvider.DEPENDENCY, new Condition.Edge("4_4", "3_1"), new Condition.Node("6_2")));
        cons.add(new Condition.CCR(Condition.StateProvider.DEPENDENCY_REQUIRE, new Condition.Node("4_2")));
        cons.add(new Condition.CCR(Condition.StateProvider.DEPENDENCY_REQUIRE, new Condition.Node("6_2")));
        cdaD.check(cons);
    }

    @Test
    public void heavyTestF() {
        String henshin = "testData/main/attributes.henshin";
        cda = new CdaWorker(henshin, "complexF1", "complexF2", new Options(new boolean[0]));
        cdaD = new CdaWorker(henshin, "complexF1", "complexF2", new Options(1, new int[0]));
        Condition.ConditionsSet cons = new Condition.ConditionsSet(false, false, true, new Condition.Conditions[0]);
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Node("4_44")));
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Node("3_44")));
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Edge("5_22", "4_11")));
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Edge("5_22", "4_33")));
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Edge("5_22", "4_11"), new Condition.Node("3_44")));
        cons.add(new Condition.CCR(Condition.StateProvider.FORBID, new Condition.Edge("5_22", "4_33"), new Condition.Node("3_44")));
        cda.check(cons);
        cons = new Condition.ConditionsSet(false, false, true, new Condition.Conditions[0]);
        cons.add(new Condition.DCR(Condition.StateProvider.DEPENDENCY_FORBID, new Condition.Node("1_44")));
        cons.add(new Condition.DCR(Condition.StateProvider.DEPENDENCY_FORBID, new Condition.Edge("2_22", "1_11")));
        cons.add(new Condition.DCR(Condition.StateProvider.DEPENDENCY_FORBID, new Condition.Edge("2_22", "1_33")));
        cdaD.check(cons);
    }

    @AfterClass
    public static void after() {
        System.out.println("\ncomplete time: " + UltimateTest.time(allTime));
    }
}

