/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.tasks;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.tasks.AtomicResultContainer;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class CalculateAtomicCpaTask
implements Callable<Set<Atom>> {
    Rule firstRule;
    Rule secondRule;
    long conflictAtomRunTime;
    AtomicResultContainer resultKeeper;

    public CalculateAtomicCpaTask(AtomicResultContainer resultKeeper) {
        this.resultKeeper = resultKeeper;
        this.firstRule = resultKeeper.getFirstRule();
        this.secondRule = resultKeeper.getSecondRule();
    }

    @Override
    public Set<Atom> call() throws Exception {
        ConflictAnalysis atomicCoreCPA = new ConflictAnalysis(this.firstRule, this.secondRule);
        HashSet<Atom> computeConflictAtoms = new HashSet();
        long normalStartTime = System.currentTimeMillis();
        try {
            computeConflictAtoms = new HashSet<Atom.ConflictAtom>(atomicCoreCPA.computeAtoms());
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Timeout!");
        }
        long normalEndTime = System.currentTimeMillis();
        this.conflictAtomRunTime = normalEndTime - normalStartTime;
        this.resultKeeper.addResult(computeConflictAtoms);
        this.resultKeeper.setCalculationTime(this.conflictAtomRunTime);
        this.resultKeeper.setCandidates(new HashSet<Atom>(atomicCoreCPA.computeAtoms()));
        this.resultKeeper.setConflictReasons(new HashSet<Reason>(atomicCoreCPA.computeResultsCoarse()));
        HashSet<ConflictReason.DeleteConflictReason> minimalConflictReasons = new HashSet<ConflictReason.DeleteConflictReason>();
        for (Reason reason : atomicCoreCPA.computeResultsCoarse()) {
            minimalConflictReasons.add(new ConflictReason.DeleteConflictReason((Span)reason));
        }
        long l = System.currentTimeMillis();
        Set<ConflictReason> initialReasons = atomicCoreCPA.computeResultsFine();
        HashSet<Reason> filteredConflictReasons = new HashSet<Reason>();
        for (Reason reason : initialReasons) {
            reason.getMappingsInRule1();
            reason.getMappingsInRule2();
        }
        long l2 = System.currentTimeMillis();
        long conflictReasonAdditionalRunTime = l2 - l;
        long conflictReasonOverallRuneTime = this.conflictAtomRunTime + conflictReasonAdditionalRunTime;
        this.resultKeeper.setConflictReasonOverallTime(conflictReasonOverallRuneTime);
        this.resultKeeper.setConflictReasons(filteredConflictReasons);
        return computeConflictAtoms;
    }
}

