/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.framework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.multicda.cda.DependencyAnalysis;
import org.eclipse.emf.henshin.multicda.cda.MultiGranularAnalysis;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.framework.Condition;
import org.eclipse.emf.henshin.multicda.cda.framework.Options;
import org.eclipse.emf.henshin.multicda.cda.framework.Worker;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SymmetricReason;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;
import org.eclipse.emf.henshin.preprocessing.RulePreparator;
import org.junit.Assert;

public class CdaWorker
extends Worker {
    private MultiGranularAnalysis analyser;
    public Set<Rule> first = new HashSet<Rule>();
    public Set<Rule> second = new HashSet<Rule>();
    private Set<Reason> minimalReasons = new TreeSet<Reason>();
    private Set<Reason> reasons = new TreeSet<Reason>();
    private Set<Atom> atoms = new HashSet<Atom>();
    private int iCheckedCounter = 0;
    private Options options;
    private boolean reseted = true;
    public static Map<String, Set<String>> ignore = new HashMap<String, Set<String>>();
    private Module module;
    private Set<CriticalPair> cps = null;

    public CdaWorker(String henshin, String rule, Options ... options) {
        this(henshin, rule, rule, options);
    }

    public CdaWorker(String henshin, Options ... options) {
        this(henshin, (String)null, (String)null, options);
    }

    public CdaWorker(String henshin, String firstRule, String secondRule, Options ... options) {
        this.options = new Options(new boolean[0]);
        if (options.length != 0) {
            this.options = options[0];
        }
        if (henshin.isEmpty() || (firstRule != null && !firstRule.isEmpty()) ^ (secondRule != null && !secondRule.isEmpty())) {
            return;
        }
        HenshinResourceSet resourceSet = new HenshinResourceSet(henshin.substring(0, henshin.lastIndexOf("/") + 1));
        try {
            this.module = resourceSet.getModule(henshin.substring(henshin.lastIndexOf("/") + 1, henshin.length()), false);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
        if (firstRule == null) {
            firstRule = "All";
            for (Unit u : this.module.getUnits()) {
                if (!(u instanceof Rule)) continue;
                this.first.add((Rule)u);
            }
        } else {
            this.first.add((Rule)this.module.getUnit(firstRule));
        }
        if (secondRule == null) {
            secondRule = "All";
            for (Unit u : this.module.getUnits()) {
                if (!(u instanceof Rule)) continue;
                this.second.add((Rule)u);
            }
        } else {
            this.second.add((Rule)this.module.getUnit(secondRule));
        }
        if (this.first == null) {
            System.err.println("Rule " + firstRule + " not found");
        }
        if (this.second == null) {
            System.err.println("Rule " + secondRule + " not found");
        }
        if (this.first == null || this.second == null) {
            return;
        }
        for (Rule r1 : this.first) {
            for (Rule r2 : this.second) {
                if (r1 == null || r2 == null || ignore.get(r1.getName()) != null && ignore.get(r1.getName()).contains(r2.getName())) continue;
                CdaWorker tester = new CdaWorker(r1, r2, options);
                this.analyser = tester.analyser;
                this.NAME = tester.NAME;
                this.minimalReasons.addAll(tester.getMinimalReasons());
                this.atoms.addAll(tester.getAtoms());
                this.reasons.addAll(tester.getResult());
            }
        }
        this.reseted = false;
    }

    public CdaWorker(Rule first, Rule second, Options ... options) {
        this.first.add(first);
        this.second.add(second);
        this.options = new Options(new boolean[0]);
        if (options.length != 0) {
            this.options = options[0];
        }
        this.init();
    }

    protected void init() {
        this.reseted = false;
        this.NAME = "CDA Tester";
        Rule f = this.first.iterator().next();
        Rule s = this.second.iterator().next();
        Assert.assertTrue((String)this.print("No first rules are found", true, false), (f != null ? 1 : 0) != 0);
        Assert.assertTrue((String)this.print("No second rules are found", true, false), (s != null ? 1 : 0) != 0);
        if (this.options.is(8)) {
            if (this.first != this.second) {
                f = RulePreparator.prepareRule(f);
                s = RulePreparator.prepareRule(s);
            } else {
                s = f = RulePreparator.prepareRule(f);
            }
        }
        this.analyser = this.options.is(1) ? new DependencyAnalysis(f, s) : new ConflictAnalysis(f, s);
        this.atoms = new HashSet<Atom>(this.analyser.computeAtoms());
        this.minimalReasons = new HashSet<Reason>(this.analyser.computeResultsCoarse());
        this.reasons = new HashSet<Reason>(this.analyser.computeResultsFine());
        for (Reason r : this.reasons) {
            if (!r.is("CFCR")) continue;
            System.out.println(r + "\n" + r.getRule1().getName() + "\n" + r.getRule2().getName());
        }
        if (!(!this.options.is(32) || this.options.is(256) && this.reasons.isEmpty())) {
            System.out.println("\n\t\t  " + f.getName() + " --> " + s.getName() + "\n\t\t\tCDA");
            this.print(String.valueOf(this.options.toCDAString()) + "\n", new boolean[0]);
        }
        if (!(!this.options.is(64) || this.options.is(256) && this.reasons.isEmpty())) {
            CdaWorker.print(new TreeSet<Reason>(this.reasons), false, this.options.is(512));
            this.print();
            System.out.println();
        }
    }

    public Set<Reason> getMinimalReasons() {
        return this.minimalReasons;
    }

    public Set<Reason> getResult() {
        return this.reasons;
    }

    public Set<Atom> getAtoms() {
        return this.atoms;
    }

    public boolean check(Condition.Provable ... conditions) {
        if (this.reseted) {
            return false;
        }
        return this.check(true, false, false, conditions);
    }

    private boolean check(boolean printError, boolean print, boolean assertError, Condition.Provable ... conditions) {
        boolean result = false;
        Condition.Provable[] provableArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition.Provable p = provableArray[n2];
            result = this.iChecker(p, printError);
            String ruleNames = this.getRuleNames();
            String methodName = Thread.currentThread().getStackTrace()[3].getMethodName();
            if (assertError) {
                Assert.assertTrue((String)(String.valueOf(methodName) + ": " + p + "   '" + ruleNames + "' - failed"), (boolean)result);
            }
            if (result && print) {
                System.out.println(String.valueOf(methodName) + ": " + p + "   '" + ruleNames + "' - succeed");
            }
            if (p instanceof Condition.Conditions && !result && printError) {
                System.err.println(String.valueOf(methodName) + ": " + p + "   '" + ruleNames + "' - failed");
            }
            ++n2;
        }
        return result;
    }

    private String getRuleNames() {
        String result = "";
        for (Rule r : this.first) {
            result = r == null ? String.valueOf(result) + ", first rule not found" : String.valueOf(result) + ", \"" + r.getName() + "\"";
        }
        result = String.valueOf(result.substring(2)) + ", ";
        String temp = "";
        for (Rule r : this.second) {
            temp = r == null ? String.valueOf(temp) + ", second rule not found" : String.valueOf(temp) + ", \"" + r.getName() + "\"";
        }
        return String.valueOf(result) + (temp.isEmpty() ? "" : temp.substring(2));
    }

    private boolean iChecker(Condition.Provable conditions, boolean printError) {
        String methodName = Thread.currentThread().getStackTrace()[4].getMethodName();
        String ruleNames = this.getRuleNames();
        if (conditions instanceof Condition.ReasonSize) {
            Condition.ReasonSize rs = (Condition.ReasonSize)conditions;
            boolean failed = false;
            if (rs instanceof Condition.AtomSize) {
                failed = !rs.proove(this.getAtoms().size());
            } else if (rs instanceof Condition.MinimalSize) {
                failed = !rs.proove(this.getMinimalReasons().size());
            } else {
                boolean bl = failed = !rs.proove(this.getResult().size());
            }
            if (failed) {
                if (printError) {
                    System.err.println(String.valueOf(methodName) + ": " + conditions + "   '" + ruleNames + "' - failed:  not " + conditions + " but " + this.getResult().size() + "\n" + CdaWorker.print(this.getResult(), false, true, false));
                }
                return false;
            }
            return true;
        }
        if (conditions instanceof Condition.ConditionsSet) {
            HashSet<Span> spans = new HashSet<Span>();
            Condition.ConditionsSet cs = (Condition.ConditionsSet)conditions;
            if (cs.atoms) {
                spans.addAll(this.atoms);
            }
            if (cs.minimals) {
                spans.addAll(this.minimalReasons);
            }
            if (cs.reasons) {
                spans.addAll(this.reasons);
            }
            HashSet<Span> remained = new HashSet<Span>();
            for (Span r : spans) {
                if (!(r instanceof Atom && cs.atoms || r instanceof Reason && ((Reason)r).isMinimalReason() && cs.minimals) && (!(r instanceof Reason) || ((Reason)r).isMinimalReason() || !cs.reasons) || cs.proove(r)) continue;
                remained.add(r);
            }
            if (!cs.getRest().isEmpty()) {
                boolean error = false;
                for (Condition.Provable p : cs.getRest()) {
                    if (!(p.getState().is(Condition.StateProvider.ATOM) && cs.atoms || p.getState().is(Condition.StateProvider.MINIMAL) && cs.minimals) && (p.getState().is(Condition.StateProvider.MINIMAL) || p.getState().is(Condition.StateProvider.ATOM) || !cs.reasons)) continue;
                    error = true;
                    if (!printError) continue;
                    System.err.println(String.valueOf(methodName) + ": " + p + "\n - failed: not found!");
                }
                return !error;
            }
            if (printError && !remained.isEmpty()) {
                System.err.println(String.valueOf(methodName) + ": folowing Reasons were not defined in your conditions:\n" + CdaWorker.print(remained, false, false, false));
            }
            return true;
        }
        if (conditions instanceof Condition.Conditions) {
            if (((Condition.Conditions)conditions).state.is(Condition.State.Atom)) {
                for (Atom a : this.atoms) {
                    if (!conditions.proove(a)) continue;
                    return true;
                }
            } else if (((Condition.Conditions)conditions).state.is(Condition.State.Minimal)) {
                for (Reason m : this.minimalReasons) {
                    if (!conditions.proove(m)) continue;
                    return true;
                }
            } else {
                for (Reason r : this.getResult()) {
                    if (!conditions.proove(r)) continue;
                    return true;
                }
            }
        } else if (printError) {
            System.err.println(String.valueOf(methodName) + ": Condition '" + conditions + "' was not found in '" + ruleNames + "'");
        }
        return false;
    }

    private Set<? extends Reason> getSymmetricReasons() {
        HashSet<Reason> result = new HashSet<Reason>();
        for (Reason r : this.getResult()) {
            if (!(r instanceof SymmetricReason)) continue;
            result.add(r);
        }
        return result;
    }

    private Set<? extends Reason> getAsymmetricReasons() {
        HashSet<Reason> result = new HashSet<Reason>();
        for (Reason r : this.getResult()) {
            if (r instanceof SymmetricReason) continue;
            result.add(r);
        }
        return result;
    }

    public void reset() {
        this.reseted = true;
        this.reasons.clear();
        this.minimalReasons.clear();
        this.atoms.clear();
        this.cps = null;
    }

    public static String print(Set<? extends Span> reasons, boolean ... errorCompleteOut) {
        ArrayList<? extends Span> result = new ArrayList<Span>();
        result.addAll(reasons);
        return CdaWorker.print(result, errorCompleteOut);
    }

    public static String print(List<? extends Span> reasons, boolean ... errorCompleteOut) {
        String result = "";
        boolean error = errorCompleteOut.length != 0 && errorCompleteOut[0];
        boolean out = errorCompleteOut.length < 3 || errorCompleteOut[2];
        for (Span span : reasons) {
            result = String.valueOf(result) + span + "\n";
        }
        if (out) {
            if (error) {
                System.err.println("\n" + result + "\n");
            } else {
                System.out.println(result);
            }
        }
        return result;
    }

    public Set<Rule> getRules() {
        HashSet<Rule> result = new HashSet<Rule>(this.first);
        result.addAll(this.second);
        return result;
    }

    public Map<CriticalPair, Reason> compare(Set<CriticalPair> cps, boolean ... assertsPrint) {
        this.cps = cps;
        this.comparedResults = Utils.compare(cps, this.getResult());
        if (assertsPrint.length < 2 || assertsPrint[1]) {
            if (this.comparedResults.size() == this.getResult().size() && this.comparedResults.size() == cps.size()) {
                System.out.println("Comparison finished normaly...");
            } else {
                System.err.println("Not all CPs are perfectly matched with CRs.\nFound matches: " + this.comparedResults.size() + " of " + this.getResult().size() + " CRs and " + cps.size() + " CPs");
            }
        }
        Assert.assertTrue((String)("\nNot all CPs are perfectly matched with CRs.\nFound matches: " + this.comparedResults.size() + " of " + this.getResult().size() + " CRs and " + cps.size() + " CPs"), (assertsPrint.length == 0 || !assertsPrint[0] || this.comparedResults.size() == this.getResult().size() && this.comparedResults.size() == cps.size() ? 1 : 0) != 0);
        return this.comparedResults;
    }

    @Override
    public void ready() {
        int iRest = this.reasons.size() - this.iCheckedCounter;
        if (iRest > 0) {
            this.print("Not all Conflict Reasons are tested. " + iRest + (iRest == 1 ? " is" : " are") + " remaining.", new boolean[0]);
        }
        if (this.comparedResults != null) {
            this.print("Found matches: " + this.comparedResults.size() + " of " + this.getResult().size() + " Reasons and " + this.cps.size() + " Critical Pairs", this.comparedResults.size() != this.getResult().size() || this.comparedResults.size() != this.cps.size());
        }
        super.ready();
        this.reset();
    }

    public String toString() {
        if (this.analyser instanceof ConflictAnalysis) {
            return String.valueOf(this.reasons.size()) + (this.reasons.size() > 1 ? " Conflict Reasons" : " Conflict Reason");
        }
        if (this.analyser instanceof DependencyAnalysis) {
            return String.valueOf(this.reasons.size()) + (this.reasons.size() > 1 ? " Dependency Reasons" : " Dependency Reason");
        }
        return super.toString();
    }

    public Options getOptions() {
        return this.options;
    }

    public Module getModule() {
        return this.module;
    }
}

