/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.giraph.GiraphConfig;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.jdt.core.JavaConventions;

public class GiraphValidator
extends GiraphConfig {
    public IStatus validateAll() {
        IStatus result = this.pickSevereStatus(this.validateNames(), this.validateModel());
        if (this.testEnvironment) {
            result = this.pickSevereStatus(GiraphValidator.validatePlatformForTesting(), GiraphValidator.validateSshForTesting());
        }
        return result;
    }

    public IStatus validateNames() {
        if (this.projectName == null || this.projectName.trim().isEmpty()) {
            return GiraphValidator.newStatus(4, "Empty project name");
        }
        if (this.packageName == null || this.packageName.trim().isEmpty()) {
            return GiraphValidator.newStatus(4, "Empty package name");
        }
        if (this.className == null || this.className.trim().isEmpty()) {
            return GiraphValidator.newStatus(4, "Empty class name");
        }
        if (this.inputName == null || this.inputName.trim().isEmpty()) {
            return GiraphValidator.newStatus(4, "Empty input name");
        }
        return this.pickSevereStatus(JavaConventions.validatePackageName((String)this.packageName, (String)"1.6", (String)"1.6"), JavaConventions.validateJavaTypeName((String)this.className, (String)"1.6", (String)"1.6"));
    }

    public IStatus validateModel() {
        if (this.mainUnit == null) {
            return GiraphValidator.newStatus(4, "Main unit not set");
        }
        ArrayList<Unit> allUnits = new ArrayList<Unit>();
        allUnits.add(this.mainUnit);
        allUnits.addAll((Collection<Unit>)this.mainUnit.getSubUnits(true));
        IStatus warning = null;
        for (Unit unit : allUnits) {
            if (unit.getName() == null || unit.getName().trim().isEmpty()) {
                return GiraphValidator.newStatus(4, "Empty unit or rule name");
            }
            if (!unit.getParameters().isEmpty()) {
                warning = GiraphValidator.newStatus(2, "Unit or rule parameters are not supported");
            }
            if (!(unit instanceof Rule)) continue;
            Rule rule = (Rule)unit;
            if (rule.getMultiRules().size() != 1) {
                return GiraphValidator.newStatus(4, "Rule " + rule.getName() + " must have exactly 1 multi-rule, but has " + rule.getMultiRules().size() + ". You must add '*' to all node actions, e.g. " + '\u00ab' + "create*" + '\u00bb' + " instead of " + '\u00ab' + "create" + '\u00bb' + ".");
            }
            if (!rule.getLhs().getNodes().isEmpty() || !rule.getRhs().getNodes().isEmpty()) {
                return GiraphValidator.newStatus(4, "Rule " + rule.getName() + " must have an empty kernel rule");
            }
            if (rule.getLhs().getFormula() != null) {
                return GiraphValidator.newStatus(4, "Rule " + rule.getName() + " must not have an associated formula");
            }
            Rule multiRule = (Rule)rule.getMultiRules().get(0);
            if (!multiRule.getMultiRules().isEmpty()) {
                return GiraphValidator.newStatus(4, "Multi-rule of rule " + rule.getName() + " must not have nested multi-rules");
            }
            if (multiRule.getLhs().getNodes().isEmpty()) {
                return GiraphValidator.newStatus(4, "Multi-rule LHS of rule " + rule.getName() + " empty");
            }
            for (Node node : multiRule.getActionNodes(null)) {
                if (node.getAttributes().isEmpty()) continue;
                warning = GiraphValidator.newStatus(2, "Attributes are not supported");
            }
            if (rule.getAttributeConditions().isEmpty() && multiRule.getAttributeConditions().isEmpty()) continue;
            warning = GiraphValidator.newStatus(2, "Attribute conditions are not supported");
        }
        if (warning != null) {
            return warning;
        }
        return Status.OK_STATUS;
    }

    public static IStatus validatePlatformForTesting() {
        if ("win32".equals(Platform.getOS())) {
            return GiraphValidator.newStatus(4, "Test environment not supported on Windows");
        }
        String hostname = GiraphValidator.getHostName();
        if (hostname == null || hostname.trim().isEmpty()) {
            return GiraphValidator.newStatus(4, "Error determining hostname");
        }
        char[] cArray = hostname.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character ch = Character.valueOf(cArray[n2]);
            if (Character.isUpperCase(ch.charValue())) {
                return GiraphValidator.newStatus(2, "Warning: upper-case character in hostname detected (" + hostname + "). If you get connection errors, consider switching to a lower-case hostname.");
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public static IStatus validateSshForTesting() {
        IStatus errorStatus = GiraphValidator.newStatus(4, "SSH public-key login to localhost not working. This is required for running Hadoop. See http://giraph.apache.org/quick_start.html to fix it.");
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ssh", "-o", "BatchMode=yes", "-o", "ConnectTimeout=10", "-o", "StrictHostKeyChecking=no", GiraphValidator.getHostName(), "echo", "OK"});
            if (process.waitFor() != 0) {
                return errorStatus;
            }
        }
        catch (IOException iOException) {
            return errorStatus;
        }
        catch (InterruptedException interruptedException) {
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    private static IStatus newStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.emf.henshin.giraph", message);
    }

    private IStatus pickSevereStatus(IStatus ... status) {
        IStatus s;
        int maxSeverity = 0;
        IStatus[] iStatusArray = status;
        int n = status.length;
        int n2 = 0;
        while (n2 < n) {
            s = iStatusArray[n2];
            if (s.getSeverity() > maxSeverity) {
                maxSeverity = s.getSeverity();
            }
            ++n2;
        }
        iStatusArray = status;
        n = status.length;
        n2 = 0;
        while (n2 < n) {
            s = iStatusArray[n2];
            if (s.getSeverity() == maxSeverity) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    protected static String getHostName() {
        String hostname = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec("hostname");
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                hostname = line;
                break;
            }
            input.close();
        }
        catch (IOException iOException) {
            hostname = null;
        }
        if (hostname == null) {
            hostname = "localhost";
        }
        return hostname;
    }
}

