/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.INT_VECTOR;
import java.util.Enumeration;

public class COLIM_GRAPH
implements COLIM_DEFS {
    protected COLIM_VECTOR f_node;
    protected COLIM_VECTOR f_edge;
    protected INT_VECTOR f_source;
    protected INT_VECTOR f_target;

    public COLIM_GRAPH() {
        this.f_node = new COLIM_VECTOR();
        this.f_edge = new COLIM_VECTOR();
        this.f_source = new INT_VECTOR();
        this.f_target = new INT_VECTOR();
    }

    public COLIM_GRAPH(COLIM_VECTOR nodes, COLIM_VECTOR edges, INT_VECTOR source, INT_VECTOR target) {
        this.f_node = new COLIM_VECTOR(nodes);
        this.f_edge = new COLIM_VECTOR(edges);
        this.f_source = new INT_VECTOR(source);
        this.f_target = new INT_VECTOR(target);
    }

    public int insert_node(Object node_attr) {
        int n = this.f_node.size();
        this.f_node.push_back(node_attr);
        return n;
    }

    public int insert_edge(Object edge_attr, int s, int t) {
        int e = this.f_edge.size();
        this.f_edge.push_back(edge_attr);
        this.f_source.push_back(s);
        this.f_target.push_back(t);
        return e;
    }

    public Object node_attr(int node) {
        return this.f_node.item(node);
    }

    public Object edge_attr(int edge) {
        return this.f_edge.item(edge);
    }

    public int source(int edge) {
        return this.f_source.item(edge);
    }

    public int target(int edge) {
        return this.f_target.item(edge);
    }

    public String toString() {
        StringBuffer Result2 = new StringBuffer("\nnodes: ");
        Enumeration en = this.f_node.elements();
        while (en.hasMoreElements()) {
            Object n = en.nextElement();
            if (n == null) continue;
            Result2.append(n.toString());
            if (!en.hasMoreElements()) continue;
            Result2.append(",");
        }
        Result2.append("\nedges: ");
        int index = 0;
        Enumeration en2 = this.f_edge.elements();
        while (en2.hasMoreElements()) {
            Object e = en2.nextElement();
            if (e != null) {
                Result2.append(this.f_node.item(this.f_source.item(index)).toString());
                Result2.append("--");
                Result2.append(e.toString());
                Result2.append("->");
                Result2.append(this.f_node.item(this.f_target.item(index)).toString());
                if (en2.hasMoreElements()) {
                    Result2.append(", ");
                }
            }
            ++index;
        }
        Result2.append("\n");
        return new String(Result2);
    }
}

