/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.CopyMemory;
import agg.util.ExtObservable;
import agg.util.LinkedGOHashSet;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedGraph;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.w3c.dom.Element;

public class Graph
extends ExtObservable
implements Observer,
XMLObject {
    public boolean xyAttr = false;
    protected Vector<Observer> observer;
    protected LinkedGOHashSet<Node> itsNodes;
    protected LinkedGOHashSet<Arc> itsArcs;
    protected Hashtable<String, HashSet<GraphObject>> itsTypeObjectsMap;
    protected Vector<OrdinaryMorphism> itsUsingMorphs;
    protected String kind;
    protected String itsName;
    protected String comment;
    protected String info;
    protected AttrContext itsAttrContext;
    boolean notificationRequired;
    protected boolean attributed;
    protected boolean changed;
    protected TypeSet itsTypes;
    protected boolean completeGraph;
    String s;

    public Graph() {
        this.itsTypes = new TypeSet();
        this.init();
    }

    public Graph(TypeSet aTypeSet) {
        this.itsTypes = aTypeSet;
        this.init();
    }

    public Graph(boolean completeGraph) {
        this.itsTypes = new TypeSet();
        this.completeGraph = completeGraph;
        this.init();
    }

    public Graph(TypeSet aTypeSet, boolean completeGraph) {
        this.itsTypes = aTypeSet;
        this.completeGraph = completeGraph;
        this.init();
    }

    private void init() {
        this.observer = new Vector();
        this.itsNodes = new LinkedGOHashSet();
        this.itsArcs = new LinkedGOHashSet();
        this.itsTypeObjectsMap = new Hashtable();
        this.itsUsingMorphs = new Vector();
        this.kind = "GRAPH";
        this.comment = "";
        this.itsName = "Graph";
        this.info = "";
    }

    @Override
    public synchronized void addObserver(Observer o) {
        if (!this.observer.contains(o)) {
            this.observer.add(o);
            this.notificationRequired = true;
            super.addObserver(o);
        }
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        if (this.observer.contains(o)) {
            this.observer.remove(o);
            super.deleteObserver(o);
            if (this.observer.isEmpty()) {
                this.notificationRequired = false;
            }
        }
    }

    public List<Observer> getObservers() {
        return this.observer;
    }

    public void setObservers(List<?> o) {
        if (o == null) {
            return;
        }
        int i = 0;
        while (i < o.size()) {
            this.addObserver((Observer)o.get(i));
            ++i;
        }
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String aKind) {
        this.kind = aKind;
    }

    public void setNotificationRequired(boolean b) {
        this.notificationRequired = b;
    }

    public boolean isNotificationRequired() {
        return this.notificationRequired;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    public void setTypeSet(TypeSet types) {
        this.itsTypes = types;
    }

    public TypeSet getTypeSet() {
        return this.itsTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCopyOfGraph(Graph g, boolean disabledTypeGraph) {
        Graph graph = this;
        synchronized (graph) {
            block12: {
                if (disabledTypeGraph && this.itsTypes.getLevelOfTypeGraphCheck() != 0) break block12;
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(g.getSize());
                for (Node vtxOrig : g.getNodesSet()) {
                    Node vtxCopy = null;
                    Type type = this.itsTypes.getSimilarType(vtxOrig.getType());
                    if (type == null && (type = this.itsTypes.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                        type = null;
                    }
                    try {
                        if (type == null) continue;
                        vtxCopy = this.createNode(type);
                        vtxCopy.setObjectName(vtxOrig.getObjectName());
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                        this.propagateChange(new Change(10, vtxCopy));
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                for (Arc arcOrig : g.getArcsSet()) {
                    Arc arcCopy = null;
                    Type type = this.itsTypes.getSimilarType(arcOrig.getType());
                    if (type == null && (type = this.itsTypes.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                        type = null;
                    }
                    try {
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        Node tgtImg = (Node)memo1.get(target);
                        arcCopy = this.createArc(type, srcImg, tgtImg);
                        arcCopy.setObjectName(arcOrig.getObjectName());
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                        this.propagateChange(new Change(10, arcCopy));
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                memo1.clear();
                if (failed) break block12;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean integrateCopyOfGraph(Graph g) {
        Graph graph = this;
        synchronized (graph) {
            block16: {
                Type type;
                if (this.itsTypes.getLevelOfTypeGraphCheck() != 0) break block16;
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(g.getSize());
                for (Node vtxOrig : g.getNodesSet()) {
                    Node vtxCopy = null;
                    type = this.itsTypes.getSimilarType(vtxOrig.getType());
                    if (type == null && (type = this.itsTypes.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                        type = null;
                    }
                    try {
                        if (type == null) continue;
                        boolean found = false;
                        String keystr = type.convertToKey();
                        HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
                        if (objSet != null) {
                            for (GraphObject o : objSet) {
                                if (!vtxOrig.compareTo(o)) continue;
                                found = true;
                                memo1.put(vtxOrig, (Node)o);
                            }
                        }
                        if (found) continue;
                        vtxCopy = this.createNode(type);
                        vtxCopy.setObjectName(vtxOrig.getObjectName());
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                        this.propagateChange(new Change(10, vtxCopy));
                    }
                    catch (TypeException found) {
                        // empty catch block
                    }
                }
                for (Arc arcOrig : g.getArcsSet()) {
                    type = this.itsTypes.getSimilarType(arcOrig.getType());
                    if (type == null && (type = this.itsTypes.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                        type = null;
                    }
                    try {
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node src = (Node)memo1.get(source);
                        Node tar = (Node)memo1.get(target);
                        boolean found = false;
                        String keystr = String.valueOf(src.convertToKey()) + arcOrig.getType().convertToKey() + tar.convertToKey();
                        HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
                        if (objSet != null) {
                            for (GraphObject o : objSet) {
                                if (!arcOrig.compareTo(o)) continue;
                                found = true;
                            }
                        }
                        if (found) continue;
                        Arc arcCopy = this.createArc(type, src, tar);
                        arcCopy.setObjectName(arcOrig.getObjectName());
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                        this.propagateChange(new Change(10, arcCopy));
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
                memo1.clear();
                if (failed) break block16;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph copyLight(TypeSet typeSet) {
        Graph graph = this;
        synchronized (graph) {
            Graph theCopy;
            block20: {
                Type type;
                TypeError typeError = null;
                int tglevel = typeSet.getLevelOfTypeGraphCheck();
                if (tglevel == 30) {
                    typeSet.setLevelOfTypeGraphCheck(20);
                }
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
                theCopy = BaseFactory.theFactory().createGraph(typeSet);
                theCopy.setCompleteGraph(this.isCompleteGraph());
                if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                    AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                    theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                }
                for (Node vtxOrig : this.itsNodes) {
                    Node vtxCopy = null;
                    type = typeSet.getSimilarType(vtxOrig.getType());
                    if (type == null && (type = typeSet.getTypeByName(vtxOrig.getType().getName())) != null && !type.isNodeType()) {
                        type = null;
                    }
                    if (type == null) continue;
                    try {
                        vtxCopy = theCopy.createNode(type);
                        if (vtxCopy == null) continue;
                        typeError = typeSet.checkType(vtxCopy, this.isCompleteGraph());
                        if (typeError != null) {
                            theCopy.dispose();
                            throw new TypeException(typeError);
                        }
                        vtxCopy.setObjectName(vtxOrig.getObjectName());
                        if (vtxOrig.getAttribute() != null) {
                            if (vtxCopy.getAttribute() == null) {
                                vtxCopy.createAttributeInstance();
                            }
                            ((ValueTuple)vtxCopy.getAttribute()).copyEntriesToSimilarMembers(vtxOrig.getAttribute());
                        }
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                Iterator iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    Arc arcCopy = null;
                    type = typeSet.getSimilarType(arcOrig.getType());
                    if (type == null && (type = typeSet.getTypeByName(arcOrig.getType().getName())) != null && !type.isArcType()) {
                        type = null;
                    }
                    if (type == null) continue;
                    try {
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        Node tgtImg = (Node)memo1.get(target);
                        arcCopy = theCopy.createArc(type, srcImg, tgtImg);
                        if (arcCopy == null) continue;
                        arcCopy.setObjectName(arcOrig.getObjectName());
                        if (arcOrig.getAttribute() != null) {
                            if (arcCopy.getAttribute() == null) {
                                arcCopy.createAttributeInstance();
                            }
                            ((ValueTuple)arcCopy.getAttribute()).copyEntriesToSimilarMembers(arcOrig.getAttribute());
                        }
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                if (!failed && tglevel == 30) {
                    typeSet.setLevelOfTypeGraphCheck(30);
                }
                memo1.clear();
                if (!failed) break block20;
                return null;
            }
            return theCopy;
        }
    }

    public Graph copy(TypeSet types) {
        return this.graphcopy(types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph graphcopy(TypeSet typeSet) {
        Graph graph = this;
        synchronized (graph) {
            Graph theCopy;
            block14: {
                Type type;
                TypeError typeError = null;
                int tglevel = typeSet.getLevelOfTypeGraphCheck();
                if (tglevel == 30) {
                    typeSet.setLevelOfTypeGraphCheck(20);
                }
                boolean failed = false;
                Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
                theCopy = BaseFactory.theFactory().createGraph(typeSet);
                theCopy.setCompleteGraph(this.isCompleteGraph());
                if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                    AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                    theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                }
                Iterator iter = this.itsNodes.iterator();
                while (!failed && iter.hasNext()) {
                    Node vtxOrig = (Node)iter.next();
                    Node vtxCopy = null;
                    try {
                        type = typeSet.getSimilarType(vtxOrig.getType());
                        if (type == null || (vtxCopy = theCopy.createNode(type)) == null) continue;
                        typeError = typeSet.checkType(vtxCopy, this.isCompleteGraph());
                        if (typeError != null) {
                            theCopy.dispose();
                            throw new TypeException(typeError);
                        }
                        vtxCopy.setObjectName(vtxOrig.getObjectName());
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        memo1.put(vtxOrig, vtxCopy);
                        this.propagateChange(new Change(10, vtxCopy));
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    Arc arcCopy = null;
                    try {
                        Node tgtImg;
                        type = typeSet.getSimilarType(arcOrig.getType());
                        if (type == null) continue;
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)memo1.get(source);
                        arcCopy = theCopy.createArc(type, srcImg, tgtImg = (Node)memo1.get(target));
                        if (arcCopy == null) continue;
                        arcCopy.setObjectName(arcOrig.getObjectName());
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                if (!failed && tglevel == 30) {
                    typeSet.setLevelOfTypeGraphCheck(30);
                }
                memo1.clear();
                if (!failed) break block14;
                return null;
            }
            return theCopy;
        }
    }

    public Graph copy(Hashtable<GraphObject, GraphObject> orig2copy) {
        return this.graphcopy(orig2copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Graph graphcopy(Hashtable<GraphObject, GraphObject> orig2copy) {
        Graph graph = this;
        synchronized (graph) {
            int currentLevelOfTGcheck = this.getTypeSet().getLevelOfTypeGraphCheck();
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(20);
            }
            boolean failed = false;
            Graph theCopy = BaseFactory.theFactory().createGraph(this.getTypeSet());
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            Iterator iter = this.itsNodes.iterator();
            while (!failed && iter.hasNext()) {
                Node vtxOrig = (Node)iter.next();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.copyNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    orig2copy.put(vtxOrig, vtxCopy);
                }
                catch (TypeException e) {
                    failed = true;
                    theCopy.dispose();
                }
            }
            iter = this.itsArcs.iterator();
            while (!failed && iter.hasNext()) {
                Arc arcOrig = (Arc)iter.next();
                Node source = (Node)arcOrig.getSource();
                Node target = (Node)arcOrig.getTarget();
                Node srcImg = (Node)orig2copy.get(source);
                Node tgtImg = (Node)orig2copy.get(target);
                try {
                    Arc arcCopy = theCopy.copyArc(arcOrig, srcImg, tgtImg);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    orig2copy.put(arcOrig, arcCopy);
                }
                catch (TypeException e) {
                    failed = true;
                    theCopy.dispose();
                }
            }
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(currentLevelOfTGcheck);
            }
            if (!failed) {
                return theCopy;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph graphcopy(int n) {
        Graph graph = this;
        synchronized (graph) {
            Graph theCopy;
            block13: {
                int currentLevelOfTGcheck = this.getTypeSet().getLevelOfTypeGraphCheck();
                if (currentLevelOfTGcheck == 30) {
                    this.getTypeSet().setLevelOfTypeGraph(20);
                }
                boolean failed = false;
                CopyMemory.INSTALL(n);
                theCopy = BaseFactory.theFactory().createGraph(this.getTypeSet());
                if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                    AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                    theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
                }
                theCopy.setCompleteGraph(this.isCompleteGraph());
                theCopy.setName(String.valueOf(this.getName()) + "_copy");
                Iterator iter = this.itsNodes.iterator();
                while (!failed && iter.hasNext()) {
                    Node vtxOrig = (Node)iter.next();
                    Node vtxCopy = null;
                    try {
                        vtxCopy = theCopy.newNode(vtxOrig.getType());
                        vtxCopy.setObjectName(vtxOrig.getObjectName());
                        vtxCopy.copyAttributes(vtxOrig);
                        vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                        CopyMemory.STORE(vtxOrig, vtxCopy, n);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                iter = this.itsArcs.iterator();
                while (!failed && iter.hasNext()) {
                    Arc arcOrig = (Arc)iter.next();
                    try {
                        Node source = (Node)arcOrig.getSource();
                        Node target = (Node)arcOrig.getTarget();
                        Node srcImg = (Node)CopyMemory.SELECT(source, n);
                        Node tgtImg = (Node)CopyMemory.SELECT(target, n);
                        Arc arcCopy = theCopy.newArc(arcOrig.getType(), srcImg, tgtImg);
                        if (arcCopy == null) continue;
                        arcCopy.setObjectName(arcOrig.getObjectName());
                        arcCopy.copyAttributes(arcOrig);
                        arcCopy.setContextUsage(arcOrig.getContextUsage());
                        CopyMemory.STORE(arcOrig, arcCopy, n);
                    }
                    catch (TypeException e) {
                        failed = true;
                        theCopy.dispose();
                    }
                }
                if (currentLevelOfTGcheck == 30) {
                    this.getTypeSet().setLevelOfTypeGraph(currentLevelOfTGcheck);
                }
                if (!failed) break block13;
                return null;
            }
            return theCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph graphcopy() {
        Graph graph = this;
        synchronized (graph) {
            int currentLevelOfTGcheck = this.getTypeSet().getLevelOfTypeGraphCheck();
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(20);
            }
            boolean failed = false;
            Graph theCopy = BaseFactory.theFactory().createGraph(this.itsTypes);
            if (this.getAttrContext() != null && ((ContextView)this.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            theCopy.setCompleteGraph(this.isCompleteGraph());
            theCopy.setName(String.valueOf(this.getName()) + "_copy");
            Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
            Iterator iter = this.itsNodes.iterator();
            while (!failed && iter.hasNext()) {
                Node vtxOrig = (Node)iter.next();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.newNode(vtxOrig.getType());
                    vtxCopy.setObjectName(vtxOrig.getObjectName());
                    vtxCopy.copyAttributes(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    memo1.put(vtxOrig, vtxCopy);
                }
                catch (TypeException e) {
                    failed = true;
                    theCopy.dispose();
                }
            }
            iter = this.itsArcs.iterator();
            while (!failed && iter.hasNext()) {
                Arc arcOrig = (Arc)iter.next();
                try {
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)memo1.get(source);
                    Node tgtImg = (Node)memo1.get(target);
                    Arc arcCopy = theCopy.newArc(arcOrig.getType(), srcImg, tgtImg);
                    if (arcCopy == null) continue;
                    arcCopy.setObjectName(arcOrig.getObjectName());
                    arcCopy.copyAttributes(arcOrig);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                }
                catch (TypeException e) {
                    failed = true;
                    theCopy.dispose();
                }
            }
            memo1.clear();
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(currentLevelOfTGcheck);
            }
            return failed ? null : theCopy;
        }
    }

    public Graph copy() {
        return this.graphcopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph graphcopy(Graph g) {
        Graph graph = g;
        synchronized (graph) {
            int currentLevelOfTGcheck = this.getTypeSet().getLevelOfTypeGraphCheck();
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(20);
            }
            boolean failed = false;
            Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(g.getSize());
            Graph theCopy = this;
            if (g.getAttrContext() != null && ((ContextView)g.getAttrContext()).getAllowedMapping() == 2) {
                AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
                theCopy.setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
            }
            Iterator<Node> vtxList = g.getNodesSet().iterator();
            while (!failed && vtxList.hasNext()) {
                Node vtxOrig = vtxList.next();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.copyNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    memo1.put(vtxOrig, vtxCopy);
                }
                catch (TypeException e) {
                    failed = true;
                }
            }
            Iterator<Arc> arcList = g.getArcsSet().iterator();
            while (!failed && arcList.hasNext()) {
                try {
                    Arc arcOrig = arcList.next();
                    Node source = (Node)arcOrig.getSource();
                    Node target = (Node)arcOrig.getTarget();
                    Node srcImg = (Node)memo1.get(source);
                    Node tgtImg = (Node)memo1.get(target);
                    Arc arcCopy = theCopy.copyArc(arcOrig, srcImg, tgtImg);
                    if (arcCopy == null) continue;
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                }
                catch (TypeException e) {
                    failed = true;
                }
            }
            memo1.clear();
            if (currentLevelOfTGcheck == 30) {
                this.getTypeSet().setLevelOfTypeGraph(currentLevelOfTGcheck);
            }
            if (failed) {
                theCopy.clear();
            }
            return theCopy;
        }
    }

    @Override
    public void dispose() {
        if (this.observer != null) {
            this.observer.clear();
            this.observer.trimToSize();
            super.dispose();
        }
        this.itsName = "Graph";
        if (this.itsUsingMorphs != null) {
            this.itsUsingMorphs.clear();
            this.itsUsingMorphs.trimToSize();
        }
        this.destroyArcs();
        this.destroyNodes();
        this.itsNodes = null;
        this.itsArcs = null;
        this.itsAttrContext = null;
        this.itsTypes = null;
        this.changed = false;
    }

    @Override
    public void finalize() {
    }

    private void destroyNodes() {
        if (this.itsNodes != null) {
            Iterator iter = this.itsNodes.iterator();
            while (iter.hasNext()) {
                this.destroyNodeFast((Node)iter.next());
                iter = this.itsNodes.iterator();
            }
        }
    }

    private void destroyArcs() {
        if (this.itsArcs != null) {
            Iterator iter = this.itsArcs.iterator();
            while (iter.hasNext()) {
                this.destroyArcFast((Arc)iter.next());
                iter = this.itsArcs.iterator();
            }
        }
    }

    @Override
    public final void update(Observable obs, Object change) {
    }

    public final void setName(String n) {
        this.itsName = n;
    }

    public final String getName() {
        return this.itsName;
    }

    public void setHelpInfo(String str) {
        this.info = str;
    }

    public String getHelpInfo() {
        return this.info;
    }

    public String getHelpInfoAboutVariableEquality() {
        if (this.info.indexOf(":VariableEquality:") != -1) {
            String[] array = this.info.split(":VariableEquality:");
            if (array.length == 1) {
                return array[0];
            }
            if (array.length == 2) {
                return array[1];
            }
        }
        return "";
    }

    public String getHelpInfoAboutPAC() {
        if (this.info.indexOf(":VariableEquality:") != -1) {
            String[] array = this.info.split(":VariableEquality:");
            if (array.length == 2 && array[0].indexOf("PAC") != -1) {
                return array[0].replaceFirst("PAC:", "");
            }
        } else if (this.info.indexOf("PAC") != -1) {
            return this.info.replaceFirst("PAC:", "");
        }
        return "";
    }

    public String getHelpInfoAboutNAC() {
        if (this.info.indexOf(":VariableEquality:") != -1) {
            String[] array = this.info.split(":VariableEquality:");
            if (array.length == 2 && array[0].indexOf("NAC:") != -1) {
                return array[0].replaceFirst("NAC:", "");
            }
        } else if (this.info.indexOf("NAC:") != -1) {
            return this.info.replaceFirst("NAC:", "");
        }
        return "";
    }

    public void setTextualComment(String text) {
        this.comment = text;
    }

    public String getTextualComment() {
        return this.comment;
    }

    public final Enumeration<Type> getTypes() {
        return this.itsTypes.getTypes();
    }

    public Vector<Type> getUsedTypes() {
        Vector<Type> vec = new Vector<Type>();
        this.getTypesOfGOs(this.itsNodes.iterator(), vec);
        this.getTypesOfGOs(this.itsArcs.iterator(), vec);
        vec.trimToSize();
        return vec;
    }

    private void getTypesOfGOs(Iterator<?> iter, Vector<Type> result) {
        while (iter.hasNext()) {
            GraphObject o = (GraphObject)iter.next();
            if (result.contains(o.getType())) continue;
            result.add(o.getType());
        }
    }

    public Vector<Type> getUsedAndInheritedTypes() {
        Type t;
        Vector<Type> vec = new Vector<Type>();
        for (GraphObject graphObject : this.itsNodes) {
            t = graphObject.getType();
            if (!vec.contains(t)) {
                vec.add(t);
            }
            Vector<Type> pars = t.getAllParents();
            int i = 0;
            while (i < pars.size()) {
                Type pt = pars.get(i);
                if (!vec.contains(pt)) {
                    vec.add(pt);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : this.itsArcs) {
            t = graphObject.getType();
            if (vec.contains(t)) continue;
            vec.add(t);
        }
        vec.trimToSize();
        return vec;
    }

    public void addNode(Node n) {
        if (!this.itsNodes.contains(n)) {
            this.itsNodes.add(n);
            this.addToTypeObjectsMap(n);
            this.attributed = this.attributed || n.getAttribute() != null;
            this.changed = true;
        }
    }

    protected void removeNode(Node n) {
        if (n.getContext() == this) {
            Arc aNeighbor;
            int i = 0;
            while (i < this.itsUsingMorphs.size()) {
                this.itsUsingMorphs.get(i).removeMapping(n);
                ++i;
            }
            Iterator<Arc> anIter = n.getIncomingArcsSet().iterator();
            while (anIter.hasNext()) {
                aNeighbor = anIter.next();
                this.removeArc(aNeighbor);
                anIter = n.getIncomingArcsSet().iterator();
            }
            anIter = n.getOutgoingArcsSet().iterator();
            while (anIter.hasNext()) {
                aNeighbor = anIter.next();
                this.removeArc(aNeighbor);
                anIter = n.getOutgoingArcsSet().iterator();
            }
            this.itsNodes.remove(n);
            this.removeNodeFromTypeObjectsMap(n);
            this.changed = true;
        }
    }

    public void addArc(Arc anArc) {
        if (!this.itsArcs.contains(anArc)) {
            this.itsArcs.add(anArc);
            this.addToTypeObjectsMap(anArc);
            this.attributed = this.attributed || anArc.getAttribute() != null;
            this.changed = true;
        }
    }

    protected void removeArc(Arc a) {
        if (a.getContext() == this) {
            ((Node)a.getSource()).removeOut(a);
            ((Node)a.getTarget()).removeIn(a);
            int i = 0;
            while (i < this.itsUsingMorphs.size()) {
                this.itsUsingMorphs.get(i).removeMapping(a);
                ++i;
            }
            this.itsArcs.remove(a);
            this.removeArcFromTypeObjectsMap(a);
            this.changed = true;
        }
    }

    protected Node newNode(Type t) throws TypeException {
        Node aNode = new Node(t, this);
        TypeError typeError = this.itsTypes.checkType(aNode, this.isCompleteGraph());
        if (typeError != null) {
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || aNode.getAttribute() != null;
        this.itsNodes.add(aNode);
        this.addToTypeObjectsMap(aNode);
        this.changed = true;
        this.propagateChange(new Change(10, aNode));
        return aNode;
    }

    protected Node newNodeFast(Type t) {
        Node aNode = new Node(t, this);
        this.attributed = this.attributed || aNode.getAttribute() != null;
        this.itsNodes.add(aNode);
        this.addToTypeObjectsMap(aNode);
        this.changed = true;
        this.propagateChange(new Change(10, aNode));
        return aNode;
    }

    public Node createNode(Type type) throws TypeException {
        Type t = this.itsTypes.adoptClan(type);
        Node aNode = new Node(t, this);
        TypeError typeError = this.itsTypes.checkType(aNode, this.isCompleteGraph());
        if (typeError != null) {
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || aNode.getAttribute() != null;
        this.itsNodes.add(aNode);
        this.addToTypeObjectsMap(aNode);
        this.changed = true;
        this.propagateChange(new Change(10, aNode));
        return aNode;
    }

    public Node createNode(Node orig) throws TypeException {
        Node aNode = this.createNode(orig.getType());
        if (aNode != null && orig.getAttribute() != null) {
            ((ValueTuple)aNode.getAttribute()).copyEntries(orig.getAttribute());
        }
        return aNode;
    }

    public Node copyNode(Node orig) throws TypeException {
        try {
            Node node = this.createNode(orig.getType());
            if (node != null) {
                node.setObjectName(orig.getObjectName());
                if (orig.getAttribute() != null) {
                    node.createAttributeInstance();
                    ((ValueTuple)node.getAttribute()).copyEntries(orig.getAttribute());
                }
            } else {
                throw new TypeException("Graph.copyNode:: Cannot create a Node of type : " + orig.getType().getStringRepr());
            }
            return node;
        }
        catch (TypeException ex) {
            throw new TypeException("Graph.copyNode::  " + ex.getLocalizedMessage());
        }
    }

    public void destroyNode(Node node) throws TypeException {
        this.destroyNode(node, true);
    }

    public synchronized void destroyNode(Node node, boolean checkFirst) throws TypeException {
        this.destroyNode(node, checkFirst, false);
    }

    public synchronized void destroyNode(Node node, boolean checkFirst, boolean forceDestroy) throws TypeException {
        TypeError typeError;
        if (checkFirst && this.isCompleteGraph() && !forceDestroy && (typeError = this.itsTypes.checkIfRemovable(node)) != null) {
            typeError.setContainingGraph(this);
            throw new TypeException(typeError);
        }
        int i = 0;
        while (i < this.itsUsingMorphs.size()) {
            OrdinaryMorphism morph = this.itsUsingMorphs.get(i);
            morph.removeMapping(node);
            ++i;
        }
        Iterator<Arc> iter = node.getIncomingArcsSet().iterator();
        while (iter.hasNext()) {
            Arc a = iter.next();
            this.destroyArc(a, false, false);
            iter = node.getIncomingArcsSet().iterator();
        }
        iter = node.getOutgoingArcsSet().iterator();
        while (iter.hasNext()) {
            Arc a = iter.next();
            this.destroyArc(a, false, false);
            iter = node.getOutgoingArcsSet().iterator();
        }
        this.propagateChange(new Change(120, node));
        this.removeNodeFromTypeObjectsMap(node);
        this.itsNodes.remove(node);
        node.dispose();
        this.changed = true;
        this.propagateChange(new Change(12, node));
    }

    public synchronized void destroyNodeFast(Node node) {
        int i = 0;
        while (i < this.itsUsingMorphs.size()) {
            this.itsUsingMorphs.get(i).removeMapping(node);
            ++i;
        }
        while (node.getIncomingArcsSet().iterator().hasNext()) {
            this.destroyArcFast(node.getIncomingArcsSet().iterator().next());
        }
        while (node.getOutgoingArcsSet().iterator().hasNext()) {
            this.destroyArcFast(node.getOutgoingArcsSet().iterator().next());
        }
        this.propagateChange(new Change(120, node));
        this.removeNodeFromTypeObjectsMap(node);
        this.itsNodes.remove(node);
        node.dispose();
        this.changed = true;
        this.propagateChange(new Change(12, node));
    }

    protected Arc newArc(Type t, Node src, Node tar) throws TypeException {
        TypeError typeError = this.checkConnectValid(t, src, tar);
        if (typeError != null) {
            throw new TypeException(typeError);
        }
        Arc anArc = new Arc(t, (GraphObject)src, (GraphObject)tar, this);
        anArc.setDirected(!(this instanceof UndirectedGraph));
        typeError = this.itsTypes.checkType(anArc, this.isCompleteGraph());
        if (typeError != null) {
            ((Node)anArc.getSource()).removeOut(anArc);
            ((Node)anArc.getTarget()).removeIn(anArc);
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    protected Arc newArcFast(Type t, Node src, Node tar) {
        Arc anArc = new Arc(t, (GraphObject)src, (GraphObject)tar, this);
        anArc.setDirected(!(this instanceof UndirectedGraph));
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    public Arc createArc(Type type, Node src, Node tar) throws TypeException {
        TypeError typeError;
        if (src == null || tar == null) {
            throw new TypeException("Graph.createArc:: Cannot create an Arc of type : " + type.getStringRepr() + "   Source or target node is null!");
        }
        if (!this.isNode(src) || !this.isNode(tar)) {
            throw new TypeException("Graph.createArc:: Cannot create an Arc of type : " + type.getStringRepr() + "  Source or target is not a Node!");
        }
        Type t = null;
        if (this.itsTypes.containsType(type)) {
            t = type;
        }
        if (t == null) {
            t = this.itsTypes.getSimilarType(type);
            if (t == null) {
                t = this.itsTypes.addType(type);
            }
            if (t.getAdditionalRepr().indexOf("[EDGE]") == -1) {
                t.setAdditionalRepr("[EDGE]");
            }
        }
        if ((typeError = this.checkConnectValid(t, src, tar)) != null) {
            throw new TypeException(typeError);
        }
        Arc anArc = new Arc(t, (GraphObject)src, (GraphObject)tar, this);
        anArc.setDirected(!(this instanceof UndirectedGraph));
        typeError = this.itsTypes.checkType(anArc, this.isCompleteGraph());
        if (typeError != null) {
            ((Node)anArc.getSource()).removeOut(anArc);
            ((Node)anArc.getTarget()).removeIn(anArc);
            throw new TypeException(typeError);
        }
        this.attributed = this.attributed || anArc.getAttribute() != null;
        this.itsArcs.add(anArc);
        this.addToTypeObjectsMap(anArc);
        this.changed = true;
        this.propagateChange(new Change(10, anArc));
        return anArc;
    }

    public Arc copyArc(Arc orig, Node src, Node tar) throws TypeException {
        Arc arc;
        block5: {
            arc = null;
            try {
                arc = this.createArc(orig.getType(), src, tar);
                if (arc != null) {
                    arc.setDirected(!(this instanceof UndirectedGraph));
                    arc.setObjectName(orig.getObjectName());
                    if (orig.getAttribute() != null) {
                        arc.createAttributeInstance();
                        ((ValueTuple)arc.getAttribute()).copyEntries(orig.getAttribute());
                    }
                    break block5;
                }
                throw new TypeException("Graph.copyArc:: Cannot create an Arc of type : " + orig.getType().getName());
            }
            catch (TypeException ex) {
                if (src != null && tar != null) {
                    throw new TypeException("   " + orig.getType().getName() + " from  " + src.getType().getName() + " to  " + tar.getType().getName() + "   " + ex.getLocalizedMessage());
                }
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        return arc;
    }

    public void destroyArc(Arc arc) throws TypeException {
        this.destroyArc(arc, true, false);
    }

    public synchronized void destroyArc(Arc arc, boolean checkFirst) throws TypeException {
        this.destroyArc(arc, checkFirst, false);
    }

    public synchronized void destroyArc(Arc arc, boolean checkFirst, boolean forceDestroy) throws TypeException {
        if (arc != null) {
            TypeError typeError;
            if (checkFirst && this.isCompleteGraph() && !forceDestroy && (typeError = this.itsTypes.checkIfRemovable(arc)) != null) {
                typeError.setContainingGraph(this);
                throw new TypeException(typeError);
            }
            this.propagateChange(new Change(120, arc));
            int i = 0;
            while (i < this.itsUsingMorphs.size()) {
                OrdinaryMorphism morph = this.itsUsingMorphs.get(i);
                morph.removeMapping(arc);
                ++i;
            }
            this.removeArcFromTypeObjectsMap(arc);
            this.itsArcs.remove(arc);
            arc.dispose();
            this.changed = true;
            this.propagateChange(new Change(12, arc));
        }
    }

    public synchronized void destroyArcFast(Arc arc) {
        this.propagateChange(new Change(120, arc));
        int i = 0;
        while (i < this.itsUsingMorphs.size()) {
            this.itsUsingMorphs.get(i).removeMapping(arc);
            ++i;
        }
        this.removeArcFromTypeObjectsMap(arc);
        this.itsArcs.remove(arc);
        arc.dispose();
        this.changed = true;
        this.propagateChange(new Change(12, arc));
    }

    public void destroyObject(GraphObject obj) throws TypeException {
        if (obj.isNode()) {
            this.destroyNode((Node)obj, true, false);
        } else if (obj.isArc()) {
            this.destroyArc((Arc)obj, true, false);
        }
    }

    public void forceDestroyObject(GraphObject obj) throws TypeException {
        if (obj.isNode()) {
            this.destroyNode((Node)obj, true, true);
        } else if (obj.isArc()) {
            this.destroyArc((Arc)obj, true, true);
        }
    }

    public boolean destroyObjectsOfType(Type t) {
        boolean done = false;
        for (Arc arc : this.itsArcs) {
            if (!arc.getType().compareTo(t)) continue;
            try {
                this.destroyArc(arc, false, true);
                done = true;
            }
            catch (TypeException e) {
                System.out.println("Graph.destroyObjectsOfType  FAILED! " + e.getMessage());
            }
        }
        if (done) {
            return true;
        }
        for (Node node : this.itsNodes) {
            if (!t.isParentOf(node.getType())) continue;
            try {
                this.destroyNode(node, false, true);
                done = true;
            }
            catch (TypeException e) {
                System.out.println("Graph.destroyObjectsOfType  FAILED! " + e.getMessage());
            }
        }
        return done;
    }

    public Vector<String> destroyObjectsOfTypes(Vector<Type> types) {
        Vector<String> failed = null;
        int i = 0;
        while (i < types.size()) {
            Type t = types.get(i);
            if (!this.destroyObjectsOfType(t)) {
                if (failed == null) {
                    failed = new Vector<String>(5);
                }
                failed.add("Graph:  ".concat(this.itsName).concat("   Type:  ").concat(t.getName()));
            }
            ++i;
        }
        return failed;
    }

    public HashSet<Node> getNodesSet() {
        return this.itsNodes;
    }

    public Collection<Node> getNodesCollection() {
        return this.itsNodes;
    }

    public Enumeration<Node> getNodes() {
        return this.itsNodes.elements();
    }

    public List<Node> getNodesList() {
        return this.itsNodes.list();
    }

    public int getNodesCount() {
        return this.itsNodes.size();
    }

    public Node getNodeWithAttrMember(AttrType attrType, ValueMember mem) {
        Object var3_3 = null;
        for (GraphObject graphObject : this.itsNodes) {
            if (graphObject.getAttribute() == null || graphObject.getAttribute().getTupleType() != attrType) continue;
            int i = 0;
            while (i < graphObject.getAttribute().getNumberOfEntries()) {
                if ((ValueMember)graphObject.getAttribute().getMemberAt(i) == mem) {
                    return (Node)graphObject;
                }
                ++i;
            }
        }
        return null;
    }

    public Arc getEdgeWithAttrMember(AttrType attrType, ValueMember mem) {
        Object var3_3 = null;
        for (GraphObject graphObject : this.itsArcs) {
            if (graphObject.getAttribute() == null || graphObject.getAttribute().getTupleType() != attrType) continue;
            int i = 0;
            while (i < graphObject.getAttribute().getNumberOfEntries()) {
                if ((ValueMember)graphObject.getAttribute().getMemberAt(i) == mem) {
                    return (Arc)graphObject;
                }
                ++i;
            }
        }
        return null;
    }

    public HashSet<Arc> getArcsSet() {
        return this.itsArcs;
    }

    public Collection<Arc> getArcsCollection() {
        return this.itsArcs;
    }

    public Enumeration<Arc> getArcs() {
        return this.itsArcs.elements();
    }

    public List<Arc> getArcsList() {
        return this.itsArcs.list();
    }

    public int getArcsCount() {
        return this.itsArcs.size();
    }

    public Vector<Arc> getArcs(GraphObject src, GraphObject tar) {
        Vector<Arc> res = null;
        for (Arc go : ((Node)src).getOutgoingArcsSet()) {
            if (go.getTarget() != tar) continue;
            if (res == null) {
                res = new Vector<Arc>();
            }
            res.add(go);
        }
        return res;
    }

    public List<Node> getNodes(Type t) {
        Vector<Node> res = null;
        for (Node go : this.itsNodes) {
            if (!t.isParentOf(go.getType())) continue;
            if (res == null) {
                res = new Vector<Node>();
            }
            res.add(go);
        }
        return res;
    }

    public Vector<Node> getNodesByParentType(Type t) {
        Vector<Node> res = null;
        for (Node go : this.itsNodes) {
            if (!t.isParentOf(go.getType())) continue;
            if (res == null) {
                res = new Vector<Node>();
            }
            res.add(go);
        }
        return res;
    }

    public Vector<Node> getNodesByCompareType(Type t) {
        Vector<Node> res = null;
        for (Node go : this.itsNodes) {
            if (!go.getType().compareTo(t)) continue;
            if (res == null) {
                res = new Vector<Node>();
            }
            res.add(go);
        }
        return res;
    }

    public Vector<Arc> getArcs(Type t, GraphObject src, GraphObject tar) {
        Vector<Arc> res = null;
        for (Arc go : ((Node)src).getOutgoingArcsSet()) {
            if (go.getTarget() != tar || !go.getType().compareTo(t)) continue;
            if (res == null) {
                res = new Vector<Arc>();
            }
            res.add(go);
        }
        return res;
    }

    public Vector<Arc> getArcs(Type type) {
        Vector<Arc> res = null;
        for (Arc obj : this.itsArcs) {
            if (!obj.getType().compareTo(type)) continue;
            if (res == null) {
                res = new Vector<Arc>();
            }
            res.add(obj);
        }
        return res;
    }

    public Vector<String> getTypeNamesOfGraphObjects() {
        Vector<String> v = new Vector<String>(this.getSize());
        this.getTypeNamesOfGOs(this.itsNodes.iterator(), v);
        this.getTypeNamesOfGOs(this.itsArcs.iterator(), v);
        return v;
    }

    private void getTypeNamesOfGOs(Iterator<?> iter, Vector<String> result) {
        while (iter.hasNext()) {
            GraphObject o = (GraphObject)iter.next();
            String goname = o.getType().getName();
            if (goname.equals("")) {
                goname = "[UNNAMED_NODE]";
            }
            result.add(goname);
        }
    }

    public Enumeration<GraphObject> getElements() {
        Vector<Node> elems = new Vector<Node>(this.itsNodes);
        elems.addAll(this.itsArcs);
        return elems.elements();
    }

    public Enumeration<GraphObject> getElementsOfType(String typeName) {
        return this.getElementsOfTypeAsVector(typeName).elements();
    }

    public Vector<GraphObject> getElementsOfTypeAsVector(String typeName) {
        Vector<GraphObject> elems = new Vector<GraphObject>();
        if (!this.getElemsOfTypeName(typeName, this.itsNodes.iterator(), elems)) {
            this.getElemsOfTypeName(typeName, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    private boolean getElemsOfTypeName(String typeName, Iterator<?> iter, Vector<GraphObject> result) {
        while (iter.hasNext()) {
            GraphObject obj = (GraphObject)iter.next();
            if (!obj.getType().getName().equals(typeName)) continue;
            result.addElement(obj);
        }
        return !result.isEmpty();
    }

    public Enumeration<GraphObject> getElementsOfType(Type type) {
        return this.getElementsOfTypeAsVector(type).elements();
    }

    public Vector<GraphObject> getElementsOfTypeAsVector(Type type) {
        Vector<GraphObject> elems = new Vector<GraphObject>();
        if (!this.getElemsOfType(type, this.itsNodes.iterator(), elems)) {
            this.getElemsOfType(type, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    private boolean getElemsOfType(Type type, Iterator<?> iter, Vector<GraphObject> result) {
        while (iter.hasNext()) {
            GraphObject obj = (GraphObject)iter.next();
            if (!obj.getType().compareTo(type)) continue;
            result.addElement(obj);
        }
        return !result.isEmpty();
    }

    public Vector<GraphObject> getParentsOfType(Type type) {
        Vector<GraphObject> elems = this.getParsOfType(type, this.itsNodes.iterator(), false);
        if (elems.isEmpty()) {
            this.getElemsOfType(type, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    public Vector<GraphObject> getElemsAndParentsOfType(Type type) {
        Vector<GraphObject> elems = this.getParsOfType(type, this.itsNodes.iterator(), true);
        if (elems.isEmpty()) {
            this.getElemsOfType(type, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    public Vector<GraphObject> getChildrenOfType(Type type) {
        Vector<GraphObject> elems = this.getChildsOfType(type, this.itsNodes.iterator(), false);
        if (elems.isEmpty()) {
            this.getElemsOfType(type, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    public Vector<GraphObject> getElemsAndChildrenOfType(Type type) {
        Vector<GraphObject> elems = this.getChildsOfType(type, this.itsNodes.iterator(), true);
        if (elems.isEmpty()) {
            this.getElemsOfType(type, this.itsArcs.iterator(), elems);
        }
        return elems;
    }

    private Vector<GraphObject> getChildsOfType(Type type, Iterator<?> iter, boolean withElemsOfType) {
        Vector<GraphObject> result = new Vector<GraphObject>(2);
        while (iter.hasNext()) {
            GraphObject obj = (GraphObject)iter.next();
            if ((!withElemsOfType || !obj.getType().compareTo(type)) && !obj.getType().isChildOf(type)) continue;
            result.addElement(obj);
        }
        return result;
    }

    private Vector<GraphObject> getParsOfType(Type type, Iterator<?> iter, boolean withElemsOfType) {
        Vector<GraphObject> result = new Vector<GraphObject>(2);
        while (iter.hasNext()) {
            GraphObject obj = (GraphObject)iter.next();
            if ((!withElemsOfType || !obj.getType().compareTo(type)) && !obj.getType().isParentOf(type)) continue;
            result.addElement(obj);
        }
        return result;
    }

    public Vector<GraphObject> getElementsOfTypeAsVector(Type type, boolean withChildren) {
        Vector<GraphObject> elems = new Vector<GraphObject>();
        for (Node node : this.itsNodes) {
            if (!node.getType().compareTo(type) && (!withChildren || !node.getType().isChildOf(type))) continue;
            elems.addElement(node);
        }
        if (!elems.isEmpty()) {
            return elems;
        }
        for (Arc arc : this.itsArcs) {
            if (!arc.getType().compareTo(type)) continue;
            elems.addElement(arc);
        }
        return elems;
    }

    public Enumeration<GraphObject> getElementsOfType(Type type, Type src, Type tar) {
        return this.getElementsOfTypeAsVector(type, src, tar).elements();
    }

    public Vector<GraphObject> getElementsOfTypeAsVector(Type type, Type src, Type tar) {
        Vector<GraphObject> elems = new Vector<GraphObject>();
        for (Arc obj : this.itsArcs) {
            if (!obj.getType().compareTo(type) || !obj.getSource().getType().compareTo(src) && !obj.getSource().getType().isChildOf(src) || !obj.getTarget().getType().compareTo(tar) && !obj.getTarget().getType().isChildOf(tar)) continue;
            elems.addElement(obj);
        }
        return elems;
    }

    public Enumeration<GraphObject> getElementsOfType(GraphObject type) {
        return this.getElementsOfTypeAsVector(type).elements();
    }

    public Vector<GraphObject> getElementsOfTypeAsVector(GraphObject type) {
        Vector<Object> elems = new Vector();
        if (type.isNode() ? !(elems = this.getElementsOfTypeAsVector(type.getType())).isEmpty() : !(elems = this.getElementsOfTypeAsVector(type.getType(), ((Arc)type).getSource().getType(), ((Arc)type).getTarget().getType())).isEmpty()) {
            return elems;
        }
        return elems;
    }

    public void setAttrContext(AttrContext context) {
        this.itsAttrContext = context;
    }

    public AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    public AttrManager getAttrManager() {
        return AttrTupleManager.getDefaultManager();
    }

    public void createAttrInstanceWhereNeeded() {
        for (Node go : this.itsNodes) {
            if (go.getType().isAttrTypeEmpty() && go.getType().isParentAttrTypeEmpty() || go.getAttribute() != null) continue;
            go.createAttributeInstance();
        }
        for (Arc go : this.itsArcs) {
            if (go.getType().isAttrTypeEmpty() || go.getAttribute() != null) continue;
            go.createAttributeInstance();
        }
    }

    public void createAttrInstanceOfTypeWhereNeeded(Type t) {
        for (Node go : this.itsNodes) {
            if (go.getType() != t && !t.isParentOf(go.getType()) || t.isAttrTypeEmpty() && t.isParentAttrTypeEmpty() || go.getAttribute() != null) continue;
            go.createAttributeInstance();
        }
        for (Arc go : this.itsArcs) {
            if (go.getType() != t || t.isAttrTypeEmpty() || go.getAttribute() != null) continue;
            go.createAttributeInstance();
        }
    }

    protected void propagateChange(Change ch) {
        if (this.notificationRequired) {
            this.setChanged();
            this.notifyObservers(ch);
        }
    }

    public void addUsingMorph(OrdinaryMorphism m) {
        this.itsUsingMorphs.add(m);
    }

    public boolean removeUsingMorph(OrdinaryMorphism m) {
        return this.itsUsingMorphs.remove(m);
    }

    public boolean isEmpty() {
        return this.itsNodes.isEmpty();
    }

    public boolean isElement(GraphObject obj) {
        if (this.itsNodes == null) {
            System.out.println(this.itsName);
        }
        return obj.getContext() == this;
    }

    public boolean isNode(Node obj) {
        return this.itsNodes.contains(obj);
    }

    public boolean isArc(Arc obj) {
        return this.itsArcs.contains(obj);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isUsingType(GraphObject t) {
        block3: {
            if (!t.isArc()) ** GOTO lbl12
            hasTypeGraphArc = this.getTypeSet().getTypeGraphArc(t.getType(), ((Arc)t).getSource().getType(), ((Arc)t).getTarget().getType()) != null;
            for (Arc o : this.itsArcs) {
                if (!(hasTypeGraphArc != false ? !(o.getType().compareTo(t.getType()) == false || o.getSource().getType().compareTo(((Arc)t).getSource().getType()) == false && o.getSource().getType().isChildOf(((Arc)t).getSource().getType()) == false || o.getTarget().getType().compareTo(((Arc)t).getTarget().getType()) == false && o.getTarget().getType().isChildOf(((Arc)t).getTarget().getType()) == false) : o.getType().compareTo(t.getType()) != false)) continue;
                return true;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                o = (Node)this.itsNodes.iterator().next();
                if (o.getType().compareTo(t.getType())) {
                    return true;
                }
                if (!o.getType().isChildOf(t.getType())) continue;
                return true;
lbl12:
                // 2 sources

                ** while (this.itsNodes.iterator().hasNext())
            }
        }
        return false;
    }

    public boolean isUsingType(Type t) {
        return this.doesUseType(t, this.itsNodes.iterator()) || this.doesUseType(t, this.itsArcs.iterator());
    }

    private boolean doesUseType(Type t, Iterator<?> iter) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getType().compareTo(t)) {
                return true;
            }
            if (!go.getType().isChildOf(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isUsingVariable(VarMember v) {
        return this.doesUseVar(v, this.itsNodes.iterator()) || this.doesUseVar(v, this.itsArcs.iterator());
    }

    private boolean doesUseVar(VarMember v, Iterator<?> iter) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int j = 0;
            while (j < val.getSize()) {
                ValueMember mem = val.getValueMemberAt(j);
                if (mem.getExpr() != null && (mem.getExpr().isVariable() ? mem.getDeclaration().getTypeName().equals(v.getDeclaration().getTypeName()) && mem.getExprAsText().equals(v.getName()) : mem.getExpr().isComplex() && mem.getAllVariableNamesOfExpression().contains(v.getName()))) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public boolean isUsingConstant() {
        return this.doesUseConst(this.itsNodes.iterator()) || this.doesUseConst(this.itsArcs.iterator());
    }

    private boolean doesUseConst(Iterator<?> iter) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int j = 0;
            while (j < val.getSize()) {
                ValueMember mem = val.getValueMemberAt(j);
                if (mem.getExpr() != null && mem.getExpr().isConstant()) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public void clear() {
        this.changed = false;
        this.itsUsingMorphs.clear();
        this.destroyArcs();
        this.destroyNodes();
        this.propagateChange(new Change(12, null));
    }

    public synchronized boolean glue(GraphObject keep, GraphObject glue) throws TypeException {
        return this.glue(keep, glue, null);
    }

    public synchronized boolean glue(GraphObject keep, GraphObject glue, GraphObject targetObj) throws TypeException {
        ValueMember amGlue;
        ValueMember amKeep;
        if (keep.equals(glue)) {
            return true;
        }
        if (glue == null || !glue.getType().isParentOf(keep.getType())) {
            return false;
        }
        if (!(!keep.isArc() || this.glue(((Arc)keep).getSource(), ((Arc)glue).getSource()) && this.glue(((Arc)keep).getTarget(), ((Arc)glue).getTarget()))) {
            return false;
        }
        if (keep.getAttribute() != null && glue.getAttribute() != null) {
            int i = 0;
            while (i < ((ValueTuple)keep.getAttribute()).getNumberOfEntries()) {
                amKeep = ((ValueTuple)keep.getAttribute()).getValueMemberAt(i);
                amGlue = ((ValueTuple)glue.getAttribute()).getValueMemberAt(amKeep.getName());
                if (amKeep.isSet() && amGlue != null && amGlue.isSet()) {
                    if (amKeep.getExpr().isConstant()) {
                        ValueMember tarVal;
                        if (amGlue.getExpr().isConstant() && (targetObj != null ? (tarVal = ((ValueTuple)targetObj.getAttribute()).getValueMemberAt(amKeep.getName())) != null && !tarVal.isSet() && !amKeep.getExprAsText().equals(amGlue.getExprAsText()) : !amKeep.getExprAsText().equals(amGlue.getExprAsText()))) {
                            throw new TypeException("Graph.glue: Checking attribute constant values of objects to glue failed!");
                        }
                    } else if (!amKeep.getExpr().isVariable()) {
                        throw new TypeException("Graph.glue: Checking attribute (expresion) values of objects to glue failed!");
                    }
                }
                ++i;
            }
        }
        if (glue.isNode()) {
            Vector<Arc> incoms = new Vector<Arc>(((Node)glue).getIncomingArcsSet());
            int i = 0;
            while (i < incoms.size()) {
                Arc arc = (Arc)incoms.get(i);
                if (this.itsTypes.checkIfRemovableFromTarget(arc) != null || this.itsTypes.checkIfEdgeCreatable(arc.getType(), (Node)arc.getSource(), (Node)keep) != null) {
                    throw new TypeException("Graph.glue: Checking arcs (type multiplicity) to glue failed!");
                }
                this.propagateChange(new Change(26, arc));
                arc.setTarget((Node)keep);
                this.propagateChange(new Change(25, arc));
                ++i;
            }
            incoms.clear();
            Vector<Arc> outcoms = new Vector<Arc>(((Node)glue).getOutgoingArcsSet());
            int i2 = 0;
            while (i2 < outcoms.size()) {
                Arc arc = (Arc)outcoms.get(i2);
                if (this.itsTypes.checkIfRemovableFromSource(arc) != null || this.itsTypes.checkIfEdgeCreatable(arc.getType(), (Node)keep, (Node)arc.getTarget()) != null) {
                    throw new TypeException("Graph.glue: Checking arcs (type multiplicity) to glue failed!");
                }
                this.propagateChange(new Change(24, arc));
                arc.setSource((Node)keep);
                this.propagateChange(new Change(23, arc));
                ++i2;
            }
            outcoms.clear();
        }
        if (keep.getAttribute() != null && glue.getAttribute() != null) {
            int i = 0;
            while (i < ((ValueTuple)keep.getAttribute()).getNumberOfEntries()) {
                amKeep = ((ValueTuple)keep.getAttribute()).getValueMemberAt(i);
                amGlue = ((ValueTuple)glue.getAttribute()).getValueMemberAt(i);
                if ((!amKeep.isSet() || amKeep.getExpr().isVariable()) && amGlue != null && amGlue.isSet() && amGlue.getExpr().isConstant()) {
                    amKeep.setExprAsText(amGlue.getExprAsText());
                }
                ++i;
            }
        }
        if (glue.isNode()) {
            this.destroyNode((Node)glue, true, false);
        } else {
            this.destroyArc((Arc)glue, true, false);
        }
        this.propagateChange(new Change(12, glue));
        return true;
    }

    public boolean isReadyForTransform() {
        return this.isAttributeSet(this.itsNodes.iterator(), null) && this.isAttributeSet(this.itsArcs.iterator(), null);
    }

    protected boolean isAttributeSet(Iterator<?> iter, Vector<GraphObject> storeOfFailedObjs) {
        boolean failed = false;
        while (iter.hasNext() && !failed) {
            GraphObject o = (GraphObject)iter.next();
            if (o.getAttribute() == null) {
                if (o.getType().getAttrType() == null || o.getType().getAttrType().getNumberOfEntries() == 0) continue;
                o.createAttributeInstance();
                this.attributed = true;
            }
            if (o.isNode()) {
                failed = !this.applyDefaultAttrValuesOfTypeGraph((Node)o, storeOfFailedObjs);
                continue;
            }
            boolean bl = failed = !this.applyDefaultAttrValuesOfTypeGraph((Arc)o, storeOfFailedObjs);
        }
        return !failed;
    }

    public GraphObject getObjectWithVariableOfAttrs(VarMember v) {
        for (Node n : this.itsNodes) {
            if (n.getAttribute() == null) continue;
            AttrInstance attrs = n.getAttribute();
            int i = 0;
            while (i < attrs.getNumberOfEntries()) {
                ValueMember val = (ValueMember)attrs.getMemberAt(i);
                if (val.getExpr() != null && val.getExprAsText().equals(v.getName())) {
                    return n;
                }
                ++i;
            }
        }
        for (Arc a : this.itsArcs) {
            if (a.getAttribute() == null) continue;
            AttrInstance attrs = a.getAttribute();
            int i = 0;
            while (i < attrs.getNumberOfEntries()) {
                ValueMember val = (ValueMember)attrs.getMemberAt(i);
                if (val.getExpr() != null && val.getExprAsText().equals(v.getName())) {
                    return a;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean hasObjectWithVarOrConstInAttrs(boolean withvar, boolean withconst) {
        for (Node n : this.itsNodes) {
            if (n.getAttribute() == null) continue;
            AttrInstance attrs = n.getAttribute();
            int i = 0;
            while (i < attrs.getNumberOfEntries()) {
                ValueMember val = (ValueMember)attrs.getMemberAt(i);
                if (val.isSet() && (withconst && val.getExpr().isConstant() || withvar && val.getExpr().isVariable())) {
                    return true;
                }
                ++i;
            }
        }
        for (Arc a : this.itsArcs) {
            if (a.getAttribute() == null) continue;
            AttrInstance attrs = a.getAttribute();
            int i = 0;
            while (i < attrs.getNumberOfEntries()) {
                ValueMember val = (ValueMember)attrs.getMemberAt(i);
                if (val.isSet() && (withconst && val.getExpr().isConstant() || withvar && val.getExpr().isVariable())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected boolean applyDefaultAttrValuesOfTypeGraph(Node go, Vector<GraphObject> storeOfFailedObjs) {
        Node typeNode = go.getType().getTypeGraphNodeObject();
        if (typeNode != null && typeNode.getAttribute() != null) {
            ValueTuple value = (ValueTuple)go.getAttribute();
            Vector<Type> itsParents = go.getType().getAllParents();
            int p = 0;
            while (p < itsParents.size()) {
                ValueTuple pNodeAttr;
                Node pNode = itsParents.get(p).getTypeGraphNodeObject();
                if (pNode != null && (pNodeAttr = (ValueTuple)pNode.getAttribute()) != null) {
                    int i = 0;
                    while (i < value.getSize()) {
                        ValueMember pnvm;
                        ValueMember vm = value.getValueMemberAt(i);
                        if (!vm.isSet() && (pnvm = pNodeAttr.getValueMemberAt(vm.getName())) != null && pnvm.isSet()) {
                            vm.setExpr(pnvm.getExpr());
                        }
                        ++i;
                    }
                }
                ++p;
            }
            if (!this.getTypeSet().isEmptyAttrAllowed()) {
                int i = 0;
                while (i < value.getSize()) {
                    ValueMember vm = value.getValueMemberAt(i);
                    if (!vm.isSet()) {
                        if (storeOfFailedObjs != null) {
                            storeOfFailedObjs.add(go);
                        } else {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    protected boolean applyDefaultAttrValuesOfTypeGraph(Arc go, Vector<GraphObject> storeOfFailedObjs) {
        Arc typeArc = go.getType().getTypeGraphArcObject(go.getSourceType(), go.getTargetType());
        if (typeArc != null && typeArc.getAttribute() != null) {
            ValueMember vm;
            ValueTuple typeValue = (ValueTuple)typeArc.getAttribute();
            ValueTuple value = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                ValueMember typevm;
                vm = value.getValueMemberAt(i);
                if (!vm.isSet() && (typevm = typeValue.getValueMemberAt(vm.getName())) != null && typevm.isSet()) {
                    vm.setExprAsText(typevm.getExprAsText());
                }
                ++i;
            }
            i = 0;
            while (i < value.getSize()) {
                vm = value.getValueMemberAt(i);
                if (!vm.isSet()) {
                    if (storeOfFailedObjs != null) {
                        storeOfFailedObjs.add(go);
                    } else {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isReadyForTransform(Vector<GraphObject> storeOfFailedObjs) {
        return this.isAttributeSet(this.itsNodes.iterator(), storeOfFailedObjs) && this.isAttributeSet(this.itsArcs.iterator(), storeOfFailedObjs);
    }

    public boolean isIsomorphicTo(Graph g) {
        OrdinaryMorphism h = this.getIsomorphicWith(g);
        return h != null;
    }

    public OrdinaryMorphism getIsomorphicWith(Graph g) {
        if (this.getNodesCount() != g.getNodesCount() || this.getArcsCount() != g.getArcsCount()) {
            return null;
        }
        boolean result = false;
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        if (h.nextCompletion()) {
            result = true;
            if (this.getTypeSet().getTypeGraph() != null && this.getTypeSet().hasInheritance()) {
                Iterator origs = this.itsNodes.iterator();
                while (origs.hasNext() && result) {
                    Node orig = (Node)origs.next();
                    if (orig.getType().compareTo(h.getImage(orig).getType())) continue;
                    result = false;
                }
            }
        }
        if (!result) {
            h.dispose();
            h = null;
        }
        return h;
    }

    public Vector<OrdinaryMorphism> getIsomorphicWith(Graph g, Hashtable<GraphObject, GraphObject> map) {
        if (this.getNodesCount() != g.getNodesCount() || this.getArcsCount() != g.getArcsCount()) {
            return null;
        }
        Vector<OrdinaryMorphism> isos = new Vector<OrdinaryMorphism>(5);
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        Enumeration<GraphObject> keys = map.keys();
        while (keys.hasMoreElements()) {
            GraphObject o = keys.nextElement();
            GraphObject i = map.get(o);
            if (o == null || i == null) continue;
            try {
                h.addMapping(o, i);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        while (h.nextCompletion()) {
            boolean result = true;
            if (this.getTypeSet().getTypeGraph() != null && this.getTypeSet().getLevelOfTypeGraphCheck() >= 10 && this.getTypeSet().hasInheritance()) {
                Iterator origs = this.itsNodes.iterator();
                while (origs.hasNext() && result) {
                    Node orig = (Node)origs.next();
                    if (orig.getType().compareTo(h.getImage(orig).getType())) continue;
                    result = false;
                }
            }
            if (!result) continue;
            OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
            Enumeration<GraphObject> e = h.getDomain();
            while (e.hasMoreElements()) {
                GraphObject o = e.nextElement();
                m.addMapping(o, h.getImage(o));
            }
            isos.add(m);
        }
        return isos.isEmpty() ? null : isos;
    }

    public Vector<OrdinaryMorphism> getIsomorphicWith(Graph g, boolean all) {
        Vector<OrdinaryMorphism> allIsos = new Vector<OrdinaryMorphism>(5);
        if (!all) {
            OrdinaryMorphism h = this.getIsomorphicWith(g);
            if (h != null) {
                allIsos.add(h);
            }
            return allIsos;
        }
        if (this.getNodesCount() != g.getNodesCount() || this.getArcsCount() != g.getArcsCount()) {
            return null;
        }
        OrdinaryMorphism h = BaseFactory.theFactory().createMorphism(this, g);
        h.setCompletionStrategy(new Completion_InjCSP());
        while (h.nextCompletion()) {
            boolean result = true;
            if (this.getTypeSet().getTypeGraph() != null && this.getTypeSet().getLevelOfTypeGraphCheck() >= 10 && this.getTypeSet().hasInheritance()) {
                Iterator origs = this.itsNodes.iterator();
                while (origs.hasNext() && result) {
                    Node orig = (Node)origs.next();
                    if (orig.getType().compareTo(h.getImage(orig).getType())) continue;
                    result = false;
                }
            }
            if (!result) continue;
            OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
            Enumeration<GraphObject> e = h.getDomain();
            while (e.hasMoreElements()) {
                GraphObject o = e.nextElement();
                try {
                    m.addMapping(o, h.getImage(o));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            allIsos.add(m);
        }
        return allIsos;
    }

    public OrdinaryMorphism isoToCopy(int n) {
        return this.isomorphicCopy();
    }

    public OrdinaryMorphism isomorphicCopy() {
        return this.isomorphicCopy(false);
    }

    public OrdinaryMorphism isoCopy() {
        return this.isomorphicCopy(false);
    }

    public OrdinaryMorphism inverseIsoCopy() {
        return this.isomorphicCopy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism plainCopy() {
        Graph graph = this;
        synchronized (graph) {
            Graph copy = BaseFactory.theFactory().createGraph(this.getTypeSet(), this.isCompleteGraph());
            OrdinaryMorphism iso = new OrdinaryMorphism(this, copy, AttrTupleManager.getDefaultManager().newContext(0));
            copy.setName(this.getName().concat("_copy"));
            iso.setName("IsoMorph");
            if (this.makeIsocopy(false, iso, copy)) {
                return iso;
            }
            iso.dispose();
            copy.dispose();
            copy = null;
            iso = null;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrdinaryMorphism isomorphicCopy(boolean inverse) {
        Graph graph = this;
        synchronized (graph) {
            Graph copy = BaseFactory.theFactory().createGraph(this.getTypeSet(), this.isCompleteGraph());
            OrdinaryMorphism iso = null;
            iso = inverse ? BaseFactory.theFactory().createMorphism(copy, this) : BaseFactory.theFactory().createMorphism(this, copy);
            copy.setName(this.getName().concat("_copy"));
            iso.setName("IsoMorph");
            if (this.makeIsocopy(inverse, iso, copy)) {
                return iso;
            }
            iso.dispose();
            copy.dispose();
            copy = null;
            iso = null;
            return null;
        }
    }

    public boolean makeIsocopy(boolean inverse, OrdinaryMorphism iso, Graph theCopy) {
        boolean failed = false;
        Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
        Iterator iter = this.itsNodes.iterator();
        while (!failed && iter.hasNext()) {
            Node vtxOrig = (Node)iter.next();
            try {
                Node vtxCopy = theCopy.copyNode(vtxOrig);
                vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                memo1.put(vtxOrig, vtxCopy);
                try {
                    if (inverse) {
                        iso.addPlainMapping(vtxCopy, vtxOrig);
                        continue;
                    }
                    iso.addPlainMapping(vtxOrig, vtxCopy);
                }
                catch (BadMappingException bme) {
                    failed = true;
                }
            }
            catch (TypeException ex) {
                failed = true;
            }
        }
        iter = this.itsArcs.iterator();
        while (!failed && iter.hasNext()) {
            Arc arcOrig = (Arc)iter.next();
            Node source = (Node)arcOrig.getSource();
            Node target = (Node)arcOrig.getTarget();
            Node srcImg = (Node)memo1.get(source);
            Node tgtImg = (Node)memo1.get(target);
            if (srcImg == null || tgtImg == null) continue;
            try {
                Arc arcCopy = theCopy.copyArc(arcOrig, srcImg, tgtImg);
                arcCopy.setContextUsage(arcOrig.getContextUsage());
                try {
                    if (inverse) {
                        iso.addPlainMapping(arcCopy, arcOrig);
                        continue;
                    }
                    iso.addPlainMapping(arcOrig, arcCopy);
                }
                catch (BadMappingException bme) {
                    failed = true;
                }
            }
            catch (TypeException ex) {
                failed = true;
            }
        }
        memo1.clear();
        return !failed;
    }

    public OrdinaryMorphism isoGraph() {
        return this.isomorphicGraph(false);
    }

    public OrdinaryMorphism inverseIsoGraph() {
        return this.isomorphicGraph(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism isomorphicGraph(boolean inverse) {
        Graph graph = this;
        synchronized (graph) {
            boolean failed = false;
            Graph theCopy = BaseFactory.theFactory().createGraph(this.getTypeSet(), this.isCompleteGraph());
            OrdinaryMorphism iso = null;
            iso = inverse ? BaseFactory.theFactory().createMorphism(theCopy, this) : BaseFactory.theFactory().createMorphism(this, theCopy);
            theCopy.setName(this.getName().concat("_copy"));
            iso.setName("IsoMorph");
            Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
            Iterator iter = this.itsNodes.iterator();
            while (!failed && iter.hasNext()) {
                Node vtxOrig = (Node)iter.next();
                try {
                    Node vtxCopy = theCopy.createNode(vtxOrig.getType());
                    vtxCopy.setObjectName(vtxOrig.getObjectName());
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    memo1.put(vtxOrig, vtxCopy);
                    try {
                        if (inverse) {
                            iso.addPlainMapping(vtxCopy, vtxOrig);
                            continue;
                        }
                        iso.addPlainMapping(vtxOrig, vtxCopy);
                    }
                    catch (BadMappingException bme) {
                        failed = true;
                        iso.dispose();
                        theCopy.dispose();
                    }
                }
                catch (TypeException vtxCopy) {
                    // empty catch block
                }
            }
            iter = this.itsArcs.iterator();
            while (!failed && iter.hasNext()) {
                Arc arcOrig = (Arc)iter.next();
                Node srcImg = (Node)memo1.get(arcOrig.getSource());
                Node tgtImg = (Node)memo1.get(arcOrig.getTarget());
                if (srcImg == null || tgtImg == null) continue;
                try {
                    Arc arcCopy = theCopy.createArc(arcOrig.getType(), srcImg, tgtImg);
                    arcCopy.setObjectName(arcOrig.getObjectName());
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    try {
                        if (inverse) {
                            iso.addPlainMapping(arcCopy, arcOrig);
                            continue;
                        }
                        iso.addPlainMapping(arcOrig, arcCopy);
                    }
                    catch (BadMappingException bme) {
                        failed = true;
                        iso.dispose();
                        theCopy.dispose();
                    }
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
            memo1.clear();
            return iso;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism reverseIsomorphicCopy() {
        Graph graph = this;
        synchronized (graph) {
            boolean failed = false;
            Iterator arcList = this.itsArcs.iterator();
            Iterator vtxList = this.itsNodes.iterator();
            Graph theCopy = BaseFactory.theFactory().createGraph(this.getTypeSet());
            theCopy.setName(this.getName().concat("_copy"));
            OrdinaryMorphism iso = BaseFactory.theFactory().createMorphism(theCopy, this);
            iso.setName("IsoMorph");
            Hashtable<Node, Node> memo1 = new Hashtable<Node, Node>(this.getSize());
            while (vtxList.hasNext()) {
                Node vtxOrig = (Node)vtxList.next();
                Node vtxCopy = null;
                try {
                    vtxCopy = theCopy.copyNode(vtxOrig);
                    vtxCopy.setContextUsage(vtxOrig.getContextUsage());
                    iso.addMapping(vtxCopy, vtxOrig);
                    memo1.put(vtxOrig, vtxCopy);
                }
                catch (TypeException e) {
                    failed = true;
                }
            }
            while (!failed && arcList.hasNext()) {
                Arc arcOrig = (Arc)arcList.next();
                Node source = (Node)arcOrig.getSource();
                Node target = (Node)arcOrig.getTarget();
                Node srcImg = (Node)memo1.get(source);
                Node tgtImg = (Node)memo1.get(target);
                Arc arcCopy = null;
                if (srcImg == null || tgtImg == null) continue;
                try {
                    arcCopy = theCopy.copyArc(arcOrig, srcImg, tgtImg);
                    arcCopy.setContextUsage(arcOrig.getContextUsage());
                    iso.addMapping(arcCopy, arcOrig);
                }
                catch (TypeException e) {
                    failed = true;
                }
            }
            memo1.clear();
            return iso;
        }
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, boolean withIsomorphic) {
        return BaseFactory.theBaseFactory.getOverlappings(this, g, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, boolean disjunion, boolean withIsomorphic) {
        return BaseFactory.theBaseFactory.getOverlappings(this, g, disjunion, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, int sizeOfInclusions, boolean withIsomorphic) {
        return BaseFactory.theBaseFactory.getOverlappings(this, g, sizeOfInclusions, withIsomorphic);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Graph g, int sizeOfInclusions, boolean disjunion, boolean withIsomorphic) {
        return BaseFactory.theBaseFactory.getOverlappings(this, g, sizeOfInclusions, disjunion, withIsomorphic);
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        this.refreshAttributed();
        this.changed = false;
        h.openNewElem("Graph", this);
        if (!this.kind.equals("")) {
            h.addAttr("kind", this.kind);
        }
        h.addAttr("name", this.getName());
        if (!this.comment.equals("")) {
            h.addAttr("comment", this.comment);
        }
        if (!this.info.equals("")) {
            h.addAttr("info", this.info);
        }
        h.addIteration("", this.itsNodes.iterator(), true);
        h.addIteration("", this.itsArcs.iterator(), true);
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Graph", this)) {
            Type t;
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            str = h.readAttr("comment");
            if (!str.equals("")) {
                this.comment = str.toString();
            }
            if (!(str = h.readAttr("info")).equals("")) {
                this.info = str.toString();
            }
            Enumeration<Element> en = h.getEnumeration("", null, true, "Node");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                if (t != null) {
                    Node n = null;
                    try {
                        n = this.newNode(t);
                        n = (Node)h.loadObject(n);
                    }
                    catch (TypeException e) {
                        System.out.println("Graph.XreadObject: cannot load a Node :  <" + t.getName() + ">  into graph  <" + this.getName() + ">   " + e.getMessage());
                    }
                }
                h.close();
            }
            en = h.getEnumeration("", null, true, "Edge");
            while (en.hasMoreElements()) {
                h.peekElement(en.nextElement());
                t = (Type)h.getObject("type", null, false);
                Node n1 = (Node)h.getObject("source", null, false);
                Node n2 = (Node)h.getObject("target", null, false);
                if (t != null && n1 != null && n2 != null) {
                    try {
                        Arc a = this.newArc(t, n1, n2);
                        a = (Arc)h.loadObject(a);
                    }
                    catch (TypeException e) {
                        System.out.println("Graph.XreadObject: cannot load an Arc :  <" + t.getName() + ">  into graph <" + this.getName() + ">   " + e.getMessage());
                    }
                }
                h.close();
            }
            h.close();
        }
    }

    public String toString() {
        return this.showGraph();
    }

    public String showGraph() {
        String result = this.getName();
        result = "\nGraph: " + this.getName() + " {\n";
        for (Arc arc : this.itsArcs) {
            result = String.valueOf(result) + ((Node)arc.getSource()).toString() + arc.toString() + ((Node)arc.getTarget()).toString();
        }
        if (this.isTypeGraph()) {
            Vector<Arc> inheritArcs = this.getTypeSet().getInheritanceArcs();
            for (Arc arc : inheritArcs) {
                result = String.valueOf(result) + ((Node)arc.getSource()).toString() + "--inherits-->" + ((Node)arc.getTarget()).toString();
            }
        }
        for (Node node : this.itsNodes) {
            if (node.getIncomingArcsSet().iterator().hasNext() || node.getOutgoingArcsSet().iterator().hasNext()) continue;
            result = String.valueOf(result) + node.toString();
        }
        result = String.valueOf(result) + " }\n";
        return result;
    }

    public boolean isGraph(List<GraphObject> goSet) {
        int i = 0;
        while (i < goSet.size()) {
            GraphObject go = goSet.get(i);
            if (!(!go.isArc() || goSet.contains(((Arc)go).getSource()) && goSet.contains(((Arc)go).getTarget()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTypeGraph() {
        if (this.itsTypes == null) {
            return false;
        }
        return this == this.itsTypes.getTypeGraph();
    }

    public boolean isAttributed() {
        return this.attributed;
    }

    public boolean areAnyAttributesSet(Iterator<?> iter) {
        boolean anyAttrsSet = false;
        block0: while (iter.hasNext()) {
            GraphObject a = (GraphObject)iter.next();
            if (a.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)a.getAttribute();
            int j = 0;
            while (j < value.getSize()) {
                if (value.getValueMemberAt(j).isSet()) {
                    anyAttrsSet = true;
                    continue block0;
                }
                ++j;
            }
        }
        return anyAttrsSet;
    }

    public boolean areAnyAttributesOfNodesSet() {
        return this.areAnyAttributesSet(this.itsNodes.iterator());
    }

    public boolean areAnyAttributesOfArcsSet() {
        return this.areAnyAttributesSet(this.itsArcs.iterator());
    }

    public boolean isCompleteGraph() {
        return this.completeGraph;
    }

    public void setCompleteGraph(boolean complete) {
        this.completeGraph = complete;
    }

    public boolean isDirected() {
        return this.getTypeSet().isArcDirected();
    }

    public boolean isNacGraph() {
        return this.kind == "NAC";
    }

    public boolean isPacGraph() {
        return this.kind == "PAC";
    }

    public boolean isApplCondGraph() {
        return this.kind == "AC";
    }

    public boolean compareTo(Graph g) {
        if (this.getNodesCount() != g.getNodesCount()) {
            return false;
        }
        if (this.getArcsCount() != g.getArcsCount()) {
            return false;
        }
        boolean result = false;
        OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(this, g);
        m.setCompletionStrategy(new Completion_InjCSP(), true);
        while (!result && m.nextCompletionWithConstantsChecking()) {
            GraphObject i;
            GraphObject o;
            result = true;
            Iterator<GraphObject> e = g.getNodesSet().iterator();
            while (result && e.hasNext()) {
                o = e.next();
                if (m.getInverseImage(o).hasMoreElements()) continue;
                result = false;
            }
            e = g.getArcsSet().iterator();
            while (result && e.hasNext()) {
                o = e.next();
                if (m.getInverseImage(o).hasMoreElements()) continue;
                result = false;
            }
            e = this.getNodesSet().iterator();
            while (result && e.hasNext()) {
                o = e.next();
                if (o.compareTo(i = m.getImage(o))) continue;
                result = false;
            }
            e = this.getArcsSet().iterator();
            while (result && e.hasNext()) {
                o = e.next();
                if (o.compareTo(i = m.getImage(o))) continue;
                result = false;
            }
        }
        m.dispose();
        m = null;
        return result;
    }

    public boolean contains(Graph g) {
        return this.contains(g, null);
    }

    public boolean contains(Graph g, MorphCompletionStrategy mcs) {
        boolean result = false;
        if (g.isEmpty()) {
            result = true;
        } else if (this.getSize() >= g.getSize()) {
            if (!this.isEmpty() && mcs != null) {
                if (mcs.getProperties().get(0) && this.getSize() < g.getSize()) {
                    return false;
                }
                OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g, this);
                m.setCompletionStrategy(mcs, true);
                while (!result && m.nextCompletionWithConstantsChecking()) {
                    GraphObject i;
                    GraphObject o;
                    result = true;
                    Iterator<GraphObject> e = g.getNodesSet().iterator();
                    while (result && e.hasNext()) {
                        o = e.next();
                        if (o.compareTo(i = m.getImage(o))) continue;
                        result = false;
                    }
                    e = g.getArcsSet().iterator();
                    while (result && e.hasNext()) {
                        o = e.next();
                        if (o.compareTo(i = m.getImage(o))) continue;
                        result = false;
                    }
                }
                m.dispose();
                m = null;
            }
        } else {
            result = true;
        }
        return result;
    }

    public int getSize() {
        return this.itsNodes.size() + this.itsArcs.size();
    }

    public int getSizeOfNodes() {
        return this.itsNodes.size();
    }

    public int getSizeOfArcs() {
        return this.itsArcs.size();
    }

    public TypeError checkConnectValid(Type edgeType, Node src, Node tar) {
        if (this.itsTypes.getTypeGraph() == null || this.itsTypes.getLevelOfTypeGraphCheck() == 0 || this.itsTypes.getLevelOfTypeGraphCheck() == 5) {
            if (this.isParallelArcAllowed(edgeType, src, tar)) {
                return null;
            }
            return new TypeError(29, "No parallel edges allowed");
        }
        Arc typearc = this.itsTypes.getTypeGraphArc(edgeType, src.getType(), tar.getType());
        if (typearc != null) {
            if (this.isParallelArcAllowed(edgeType, src, tar)) {
                return null;
            }
            return new TypeError(29, "No parallel edges allowed");
        }
        return new TypeError(21, "The edge of the type \"" + edgeType.getName() + "\" is not allowed between node types \"" + src.getType().getName() + "\"  and  \"" + tar.getType().getName() + "\".");
    }

    public boolean isParallelArcAllowed(Type edgeType, Node src, Node tar) {
        return this.itsTypes.isArcParallel() || src.getOutgoingArc(edgeType, tar) == null;
    }

    public TypeError checkNodeRequiresArc(int actTypeGraphLevel) {
        if (this.itsTypes.getTypeGraph() == null || actTypeGraphLevel != 30) {
            return null;
        }
        for (Node n : this.itsNodes) {
            List<String> list = this.itsTypes.nodeRequiresArc(n);
            if (list == null || list.isEmpty()) continue;
            return new TypeError(23, "Node type  \"" + n.getType().getName() + "\" \n" + "requires edge(s) of type: \n" + list.toString(), n.getType());
        }
        return null;
    }

    public TypeError canCreateNode(Type nodeType, int currentTypeGraphLevel) {
        return this.itsTypes.canCreateNode(this, nodeType, currentTypeGraphLevel);
    }

    public TypeError canCreateArc(Type edgeType, Node source, Node target, int currentTypeGraphLevel) {
        return this.itsTypes.canCreateArc(this, edgeType, source, target, currentTypeGraphLevel);
    }

    public Vector<String> getVariableNamesOfAttributes() {
        Vector<String> result = new Vector<String>();
        this.getVarNamesOfAttrs(this.itsNodes.iterator(), result);
        this.getVarNamesOfAttrs(this.itsArcs.iterator(), result);
        return result;
    }

    private void getVarNamesOfAttrs(Iterator<?> iter, Vector<String> result) {
        while (iter.hasNext()) {
            GraphObject o = (GraphObject)iter.next();
            if (o.getAttribute() == null) continue;
            Vector<String> vars = o.getVariableNamesOfAttribute();
            int i = 0;
            while (i < vars.size()) {
                String name = vars.elementAt(i);
                if (!result.contains(name)) {
                    result.addElement(name);
                }
                ++i;
            }
        }
    }

    public Vector<VarMember> getSameVariablesOfAttributes() {
        Vector<VarMember> result = new Vector<VarMember>();
        AttrContext ac = this.getAttrContext();
        VarTuple avt = (VarTuple)ac.getVariables();
        Hashtable<VarMember, Boolean> used = new Hashtable<VarMember, Boolean>(avt.getSize());
        int i = 0;
        while (i < avt.getSize()) {
            VarMember var = avt.getVarMemberAt(i);
            used.put(var, false);
            ++i;
        }
        if (used.isEmpty()) {
            return result;
        }
        this.getSameVarsOfAttrs(avt, this.itsNodes.iterator(), used, result);
        this.getSameVarsOfAttrs(avt, this.itsArcs.iterator(), used, result);
        return result;
    }

    public void getSameVarsOfAttrs(VarTuple avt, Iterator<?> iter, Hashtable<VarMember, Boolean> used, Vector<VarMember> result) {
        while (iter.hasNext()) {
            GraphObject o = (GraphObject)iter.next();
            if (o.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int k = 0;
            while (k < vt.getSize()) {
                VarMember var;
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && !(var = avt.getVarMemberAt(vm.getExprAsText())).isInputParameter()) {
                    if (!used.get(var).booleanValue()) {
                        used.put(var, true);
                    } else if (!result.contains(var)) {
                        result.add(var);
                    }
                }
                ++k;
            }
        }
    }

    public void graphDidChange() {
        this.propagateChange(new Change(22));
    }

    public void unsetCriticalObjects() {
        for (GraphObject graphObject : this.itsArcs) {
            graphObject.setCritical(false);
        }
        for (GraphObject graphObject : this.itsNodes) {
            graphObject.setCritical(false);
        }
    }

    public void unsetTransientAttrValues() {
        this.unsetTransAttrValues(this.itsNodes.iterator());
        this.unsetTransAttrValues(this.itsArcs.iterator());
    }

    private void unsetTransAttrValues(Iterator<?> iter) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember vm = val.getValueMemberAt(i);
                if (vm.isTransient()) {
                    vm.setExpr(null);
                }
                ++i;
            }
        }
    }

    public void unsetAttributeValueWhereVariable() {
        this.unsetAttrValueWhichIsVar(this.itsNodes.iterator());
        this.unsetAttrValueWhichIsVar(this.itsArcs.iterator());
    }

    private void unsetAttrValueWhichIsVar(Iterator<?> iter) {
        while (iter.hasNext()) {
            GraphObject go = (GraphObject)iter.next();
            if (go.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)go.getAttribute();
            int j = 0;
            while (j < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(j);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    vm.setExpr(null);
                }
                ++j;
            }
        }
    }

    public Vector<Hashtable<GraphObject, GraphObject>> getPartialMorphismIntoSet(Vector<GraphObject> set) {
        if (set.isEmpty() || set.size() > this.getSize()) {
            return null;
        }
        Vector<Hashtable<GraphObject, GraphObject>> result = new Vector<Hashtable<GraphObject, GraphObject>>();
        Hashtable<GraphObject, GraphObject> store = new Hashtable<GraphObject, GraphObject>();
        Graph g = BaseFactory.theFactory().createGraph(this.getTypeSet());
        int i = 0;
        while (i < set.size()) {
            GraphObject go = set.get(i);
            if (go.isNode()) {
                try {
                    Node n = g.copyNode((Node)go);
                    store.put(n, go);
                }
                catch (TypeException n) {}
            } else {
                try {
                    Arc a = g.copyArc((Arc)go, (Node)((Arc)go).getSource(), (Node)((Arc)go).getTarget());
                    store.put(a, go);
                }
                catch (TypeException a) {
                    // empty catch block
                }
            }
            ++i;
        }
        OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(g, this);
        ((AttrTupleManager)m.getAttrManager()).setVariableContext(true);
        while (m.nextCompletion()) {
            Hashtable<GraphObject, GraphObject> table = new Hashtable<GraphObject, GraphObject>();
            Enumeration<GraphObject> en = m.getDomain();
            while (en.hasMoreElements()) {
                GraphObject obj = en.nextElement();
                GraphObject img = m.getImage(obj);
                table.put(img, (GraphObject)store.get(obj));
            }
            result.add(table);
        }
        return result;
    }

    public Hashtable<String, HashSet<GraphObject>> getTypeObjectsMap() {
        if (this.itsTypeObjectsMap.isEmpty()) {
            this.fillTypeObjectsMap();
        }
        return this.itsTypeObjectsMap;
    }

    public void updateTypeObjectsMap() {
        this.itsTypeObjectsMap.clear();
        this.fillTypeObjectsMap();
    }

    protected void addToTypeObjectsMap(GraphObject anObj) {
        if (anObj.isNode()) {
            this.extendTypeObjectsMapByNode((Node)anObj);
        } else {
            this.extendTypeObjectsMapByArc((Arc)anObj);
        }
    }

    protected void removeNodeFromTypeObjectsMap(Node anObj) {
        if (anObj.getType().hasParent()) {
            Vector<Type> myParents = anObj.getType().getAllParents();
            int i = 0;
            while (i < myParents.size()) {
                String keystr = myParents.get(i).convertToKey();
                HashSet<GraphObject> anObjVec = this.itsTypeObjectsMap.get(keystr);
                if (anObjVec != null) {
                    anObjVec.remove(anObj);
                }
                ++i;
            }
        } else {
            String keystr = anObj.getType().convertToKey();
            HashSet<GraphObject> anObjVec = this.itsTypeObjectsMap.get(keystr);
            if (anObjVec != null) {
                anObjVec.remove(anObj);
            }
        }
    }

    protected void removeArcFromTypeObjectsMap(Arc anObj) {
        if (anObj.getSource() != null && anObj.getTarget() != null) {
            if (anObj.getSource().getType().hasParent() || anObj.getTarget().getType().hasParent()) {
                Vector<Type> mySrcParents = anObj.getSource().getType().getAllParents();
                Vector<Type> myTarParents = anObj.getTarget().getType().getAllParents();
                int i = 0;
                while (i < mySrcParents.size()) {
                    int j = 0;
                    while (j < myTarParents.size()) {
                        String keystr = String.valueOf(mySrcParents.get(i).convertToKey()) + anObj.getType().convertToKey() + myTarParents.get(j).convertToKey();
                        HashSet<GraphObject> anObjVec = this.itsTypeObjectsMap.get(keystr);
                        if (anObjVec != null) {
                            anObjVec.remove(anObj);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                String keystr = anObj.convertToKey();
                HashSet<GraphObject> anObjVec = this.itsTypeObjectsMap.get(keystr);
                if (anObjVec != null) {
                    anObjVec.remove(anObj);
                }
            }
        }
    }

    protected void removeFromTypeObjectsMap(GraphObject anObj) {
        if (anObj instanceof Node) {
            this.removeNodeFromTypeObjectsMap((Node)anObj);
        } else {
            this.removeArcFromTypeObjectsMap((Arc)anObj);
        }
    }

    public void fillTypeObjectsMap() {
        for (Node obj : this.itsNodes) {
            this.extendTypeObjectsMapByNode(obj);
        }
        Iterator iter = this.itsArcs.iterator();
        while (iter.hasNext()) {
            this.extendTypeObjectsMapByArc((Arc)iter.next());
        }
    }

    protected void extendTypeObjectsMap(Type childType, Type parentType) {
        for (Node obj : this.itsNodes) {
            if (!childType.isParentOf(obj.getType())) continue;
            this.extendTypeObjectsMapByNode(obj, parentType);
            Iterator<Arc> iter2 = obj.getOutgoingArcsSet().iterator();
            while (iter2.hasNext()) {
                this.extendTypeObjectsMapByArc(iter2.next());
            }
            iter2 = obj.getIncomingArcsSet().iterator();
            while (iter2.hasNext()) {
                this.extendTypeObjectsMapByArc(iter2.next());
            }
        }
    }

    private void extendTypeObjectsMapByNode(Node node, Type parent) {
        Vector<Type> newParents = parent.getAllParents();
        int i = 0;
        while (i < newParents.size()) {
            String keystr = newParents.get(i).convertToKey();
            HashSet<GraphObject> anObjVec = this.itsTypeObjectsMap.get(keystr);
            if (anObjVec == null) {
                anObjVec = new LinkedHashSet<GraphObject>();
                this.itsTypeObjectsMap.put(keystr, anObjVec);
            }
            anObjVec.add(node);
            ++i;
        }
    }

    protected void extendTypeObjectsMapByNode(Node node) {
        if (node.getType().hasParent()) {
            Vector<Type> myParents = node.getType().getAllParents();
            int i = 0;
            while (i < myParents.size()) {
                String keystr = myParents.get(i).convertToKey();
                HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
                if (objSet == null) {
                    objSet = new LinkedHashSet<GraphObject>();
                    this.itsTypeObjectsMap.put(keystr, objSet);
                }
                objSet.add(node);
                ++i;
            }
        } else {
            String keystr = node.convertToKey();
            HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
            if (objSet == null) {
                objSet = new LinkedHashSet<GraphObject>();
                this.itsTypeObjectsMap.put(keystr, objSet);
            }
            objSet.add(node);
        }
    }

    protected void extendTypeObjectsMapByArc(Arc arc) {
        if (this.itsTypes.hasInheritance() && arc.getSource().getType().hasParent() || arc.getTarget().getType().hasParent()) {
            Vector<Type> srcParents = arc.getSource().getType().getAllParents();
            Vector<Type> tarParents = arc.getTarget().getType().getAllParents();
            int i = 0;
            while (i < srcParents.size()) {
                int j = 0;
                while (j < tarParents.size()) {
                    String keystr = String.valueOf(srcParents.get(i).convertToKey()) + arc.getType().convertToKey() + tarParents.get(j).convertToKey();
                    HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
                    if (objSet == null) {
                        objSet = new LinkedHashSet<GraphObject>();
                        this.itsTypeObjectsMap.put(keystr, objSet);
                    }
                    objSet.add(arc);
                    ++j;
                }
                ++i;
            }
        } else {
            String keystr = arc.convertToKey();
            HashSet<GraphObject> objSet = this.itsTypeObjectsMap.get(keystr);
            if (objSet == null) {
                objSet = new LinkedHashSet<GraphObject>();
                this.itsTypeObjectsMap.put(keystr, objSet);
            }
            objSet.add(arc);
        }
    }

    public void refreshAttributed() {
        this.attributed = false;
        for (GraphObject graphObject : this.itsNodes) {
            if (graphObject.getType().getAttrType() == null || graphObject.getType().getAttrType().getNumberOfEntries() == 0) continue;
            this.attributed = true;
        }
        for (GraphObject graphObject : this.itsArcs) {
            if (graphObject.getType().getAttrType() == null || graphObject.getType().getAttrType().getNumberOfEntries() == 0) continue;
            this.attributed = true;
        }
    }

    public void trimToSize() {
        this.observer.trimToSize();
        this.itsUsingMorphs.trimToSize();
    }
}

