/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.impl.VarTuple;
import agg.util.csp.Variable;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MatchHelper;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ShiftedPAC;
import agg.xt_basis.Type;
import java.util.BitSet;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class Completion_NAC
extends MorphCompletionStrategy {
    private MorphCompletionStrategy itsStrategy;
    private final Vector<GraphObject> itsSavedState = new Vector();
    private boolean globalNAC;
    private boolean globalPAC;

    public Completion_NAC(MorphCompletionStrategy strategy) {
        BitSet aSupportedBits = (BitSet)strategy.getSupportedProperties().clone();
        aSupportedBits.set(3);
        aSupportedBits.set(4);
        aSupportedBits.set(5);
        this.initialize(aSupportedBits, strategy.getProperties());
        this.getProperties().set(3);
        this.getProperties().set(4);
        this.getProperties().set(5);
        this.itsStrategy = strategy;
        this.randomDomain = strategy.randomDomain;
    }

    @Override
    public void dispose() {
        this.itsStrategy.dispose();
        this.itsSavedState.clear();
    }

    @Override
    public String getName() {
        return this.itsStrategy.getName();
    }

    @Override
    public void setRandomisedDomain(boolean b) {
        this.itsStrategy.setRandomisedDomain(b);
        this.randomDomain = b;
    }

    public MorphCompletionStrategy getSourceStrategy() {
        return this.itsStrategy;
    }

    @Override
    public AttrContext getAttrContext() {
        return this.itsStrategy.getAttrContext();
    }

    public void setProperties(MorphCompletionStrategy fromStrategy) {
        BitSet aSupportedBits = (BitSet)fromStrategy.getSupportedProperties().clone();
        aSupportedBits.set(3);
        aSupportedBits.set(4);
        aSupportedBits.set(5);
        this.initialize(aSupportedBits, (BitSet)fromStrategy.getProperties().clone());
        this.getProperties().set(3);
        this.getProperties().set(4);
        this.getProperties().set(5);
    }

    @Override
    public final void reset() {
        this.itsStrategy.reset();
    }

    @Override
    public void enableParallelSearch(boolean b) {
        this.parallel = b;
        this.itsStrategy.enableParallelSearch(b);
    }

    @Override
    public void setStartParallelSearchByFirst(boolean b) {
        this.startParallelMatchByFirstCSPVar = b;
        this.itsStrategy.setStartParallelSearchByFirst(b);
    }

    @Override
    public void resetSolverQuery_Type() {
        this.itsStrategy.resetSolverQuery_Type();
    }

    @Override
    public void resetSolver(boolean doUpdateQueries) {
        this.itsStrategy.resetSolver(doUpdateQueries);
    }

    @Override
    public final void initialize(OrdinaryMorphism morph) {
        this.itsStrategy.initialize(morph);
    }

    @Override
    public void reinitializeSolver(boolean doUpdateQueries) {
        this.itsStrategy.reinitializeSolver(doUpdateQueries);
    }

    @Override
    public void resetSolverVariables() {
        this.itsStrategy.resetSolverVariables();
    }

    @Override
    public void removeFromObjectVarMap(GraphObject anObj) {
        this.itsStrategy.removeFromObjectVarMap(anObj);
    }

    @Override
    public void removeFromTypeObjectsMap(GraphObject anObj) {
        this.itsStrategy.removeFromTypeObjectsMap(anObj);
    }

    @Override
    public void resetTypeMap(Hashtable<String, HashSet<GraphObject>> typeMap) {
        this.itsStrategy.resetTypeMap(typeMap);
    }

    @Override
    public void resetTypeMap(Graph g) {
        this.itsStrategy.resetTypeMap(g);
    }

    @Override
    public void resetVariableDomain(boolean resetByNull) {
        this.itsStrategy.resetVariableDomain(resetByNull);
    }

    @Override
    public void resetVariableDomain(GraphObject go) {
        this.itsStrategy.resetVariableDomain(go);
    }

    @Override
    public void setPartialMorphism(OrdinaryMorphism morph) {
        this.itsStrategy.setPartialMorphism(morph);
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t) {
        return this.itsStrategy.isDomainOfTypeEmpty(t);
    }

    @Override
    public boolean isDomainOfTypeEmpty(Type t, Type src, Type tar) {
        return this.itsStrategy.isDomainOfTypeEmpty(t, src, tar);
    }

    @Override
    public void setRelatedInstanceVarMap(Dictionary<Object, Variable> relatedVarMap) {
        this.itsStrategy.setRelatedInstanceVarMap(relatedVarMap);
    }

    @Override
    public Dictionary<Object, Variable> getInstanceVarMap() {
        return this.itsStrategy.getInstanceVarMap();
    }

    @Override
    public Object clone() {
        Completion_NAC aClone = new Completion_NAC((MorphCompletionStrategy)this.itsStrategy.clone());
        aClone.itsProperties = (BitSet)this.itsProperties.clone();
        aClone.randomDomain = this.randomDomain;
        aClone.parallel = this.parallel;
        aClone.startParallelMatchByFirstCSPVar = this.startParallelMatchByFirstCSPVar;
        return aClone;
    }

    @Override
    public final boolean next(OrdinaryMorphism morph) {
        if (morph instanceof Match) {
            if (this.itsStrategy.next(morph)) {
                return this.areLeftApplCondSatisfied((Match)morph);
            }
            return false;
        }
        return this.itsStrategy.next(morph);
    }

    @Override
    public final boolean next(OrdinaryMorphism morph, Collection<Node> nodes, Collection<Arc> edges) {
        if (morph instanceof Match) {
            if (this.itsStrategy.next(morph, nodes, edges)) {
                return this.areLeftApplCondSatisfied((Match)morph);
            }
            return false;
        }
        return this.itsStrategy.next(morph, nodes, edges);
    }

    private boolean areLeftApplCondSatisfied(Match aMatch) {
        boolean matchCompletionDone = true;
        while (matchCompletionDone) {
            if (!this.itsProperties.get(5) || aMatch.getRule().evalFormula()) {
                if (this.itsProperties.get(4)) {
                    if (this.arePACsSatisfied(aMatch)) {
                        if (this.itsProperties.get(3)) {
                            if (this.areNACsSatisfied(aMatch)) {
                                return true;
                            }
                            if (this.globalNAC && !aMatch.getTarget().isAttributed() && ((VarTuple)aMatch.getAttrContext().getVariables()).getSize() == 0) {
                                return false;
                            }
                            matchCompletionDone = this.itsStrategy.next(aMatch);
                            continue;
                        }
                        return true;
                    }
                    if (this.globalPAC && !aMatch.getTarget().isAttributed() && ((VarTuple)aMatch.getAttrContext().getVariables()).getSize() == 0) {
                        return false;
                    }
                    matchCompletionDone = this.itsStrategy.next(aMatch);
                    continue;
                }
                if (this.getProperties().get(3)) {
                    if (this.areNACsSatisfied(aMatch)) {
                        return true;
                    }
                    if (this.globalNAC && !aMatch.getTarget().isAttributed() && ((VarTuple)aMatch.getAttrContext().getVariables()).getSize() == 0) {
                        return false;
                    }
                    matchCompletionDone = this.itsStrategy.next(aMatch);
                    continue;
                }
                return true;
            }
            matchCompletionDone = this.itsStrategy.next(aMatch);
        }
        return false;
    }

    private final boolean areNACsSatisfied(Match match) {
        if (match.getRule().hasNACs()) {
            this.globalNAC = true;
            Enumeration<OrdinaryMorphism> nacs = match.getRule().getNACs();
            while (nacs.hasMoreElements()) {
                OrdinaryMorphism nac = nacs.nextElement();
                if (!nac.isEnabled()) continue;
                if (nac.getSize() != 0) {
                    this.globalNAC = false;
                }
                if (MatchHelper.isDomainOfApplCondEmpty(match, nac) || match.checkNAC(nac) == null) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean arePACsSatisfied(Match match) {
        if (match.getRule().hasPACs()) {
            this.globalPAC = true;
            Enumeration<OrdinaryMorphism> pacs = match.getRule().getPACs();
            while (pacs.hasMoreElements()) {
                OrdinaryMorphism pac = pacs.nextElement();
                if (!pac.isEnabled() || pac.isShifted()) continue;
                if (pac.getSize() != 0) {
                    this.globalPAC = false;
                }
                if (!MatchHelper.isDomainOfApplCondEmpty(match, pac)) {
                    if (match.checkPAC(pac) != null) continue;
                    return false;
                }
                return false;
            }
        }
        return this.areShiftedPACsSatisfied(match);
    }

    private boolean areShiftedPACsSatisfied(Match match) {
        boolean ok;
        boolean bl = ok = match.getRule().getShiftedPACs() == null || match.getRule().getShiftedPACs().isEmpty();
        if (!ok) {
            int i = 0;
            while (i < match.getRule().getShiftedPACs().size() && !ok) {
                ShiftedPAC shiftedPAC = match.getRule().getShiftedPACs().get(i);
                if (shiftedPAC.eval(match)) {
                    ok = true;
                }
                ++i;
            }
            this.globalPAC = false;
        }
        return ok;
    }
}

