/*
 * Decompiled with CFR 0.152.
 */
package agg.util;

import agg.util.XMLObject;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XMLHelper
implements ExceptionListener {
    private long lID;
    boolean isAGG;
    private Document doc;
    private Map<Object, Object> object2index;
    private Map<Object, Object> index2object;
    private Map<Object, Object> index2element;
    private Map<Object, Object> element2index;
    private Vector<Node> estack;
    private Vector<Node> chld_stack;
    private int esp;
    private static final String VERSION = "1.0";
    private String version = "";
    private String ioException = "";
    private String dir = System.getProperty("user.dir");

    public XMLHelper() {
        this.doc = new DocumentImpl();
        Element top_elem = null;
        Element e = this.doc.createElement("Document");
        this.version = VERSION;
        e.setAttribute("version", this.version);
        this.doc.appendChild(e);
        top_elem = this.doc.getDocumentElement();
        this.object2index = new HashMap<Object, Object>(400);
        this.index2object = new HashMap<Object, Object>(400);
        this.index2element = new HashMap<Object, Object>(400);
        this.element2index = new HashMap<Object, Object>(400);
        this.estack = new Vector();
        this.chld_stack = new Vector();
        this.esp = 0;
        this.push(top_elem);
    }

    public String getDocumentVersion() {
        return this.version;
    }

    public String getO2I(Object o) {
        if (this.object2index.containsKey(o)) {
            return (String)this.object2index.get(o);
        }
        return "";
    }

    public Object getI2O(String i) {
        if (this.index2object.containsKey(i)) {
            return this.index2object.get(i);
        }
        return null;
    }

    private String newO2I(Object o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = String.valueOf("I").concat(String.valueOf(this.index2object.size()));
            this.index2object.put(o, newi);
            this.object2index.put(o, newi);
        }
        return newi;
    }

    public boolean save_to_xml(String fname) {
        OutputFormat format = new OutputFormat(this.doc, "UTF-8", true);
        File f = new File(fname);
        if (f.exists()) {
            this.dir = f.getParent();
            if (this.dir == null) {
                this.dir = System.getProperty("user.dir");
            }
            if (!new File(this.dir).canWrite()) {
                this.dir = System.getProperty("user.dir");
                if (!new File(this.dir).canWrite()) {
                    System.out.println("XMLHelper.save_to_xml: cannot write file to  " + this.dir);
                    return false;
                }
            }
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            XMLSerializer serializer = new XMLSerializer(os, format);
            serializer.setOutputByteStream(os);
            serializer.serialize(this.doc);
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean read_from_xml(String fname) {
        Node n;
        File f = new File(fname);
        if (f.exists()) {
            this.dir = f.getParent();
            if (this.dir == null) {
                this.dir = System.getProperty("user.dir");
            }
            if (!new File(this.dir).canWrite()) {
                this.dir = System.getProperty("user.dir");
                if (!new File(this.dir).canWrite()) {
                    System.out.println("XMLHelper.read_from_xml " + fname + ": failed! Cannot write to directory: " + this.dir);
                    return false;
                }
            }
        } else {
            System.out.println("XMLHelper.read_from_xml::  Cannot read! File: " + fname + "  doesn't exist!");
            return false;
        }
        this.esp = 0;
        try {
            InputSource inSrc = new InputSource();
            BufferedReader in = new BufferedReader(new FileReader(fname));
            inSrc.setCharacterStream(in);
            DOMParser parser = new DOMParser();
            try {
                parser.parse(inSrc);
                this.doc = parser.getDocument();
                this.doc.getDocumentElement().normalize();
            }
            catch (SAXParseException saxex) {
                System.out.println("XMLHelper.read_from_xml -> DOMParser.parse: " + saxex.getLocalizedMessage());
                return false;
            }
        }
        catch (IOException iox) {
            System.out.println("XMLHelper.read_from_xml: " + iox.getLocalizedMessage());
            return false;
        }
        catch (Exception e) {
            System.out.println("XMLHelper.read_from_xml: " + e.getLocalizedMessage());
            return false;
        }
        this.isAGG = fname.endsWith(".ggx") || fname.endsWith(".cpx") || fname.endsWith(".rsx");
        this.push(this.doc.getDocumentElement());
        NodeIterator ni = ((DocumentTraversal)((Object)this.doc)).createNodeIterator(this.top(), -1, new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() != 1) {
                    return 3;
                }
                Element e = (Element)n;
                if (e.getAttributeNode("ID") == null && XMLHelper.this.isAGG) {
                    return 3;
                }
                return 1;
            }
        }, true);
        while ((n = ni.nextNode()) != null) {
            Element e = (Element)n;
            String id = "";
            if (e.getAttributeNode("ID") != null) {
                id = e.getAttribute("ID");
                this.index2element.put(id, e);
                continue;
            }
            if (this.isAGG) break;
            id = "I".concat(String.valueOf(this.lID++));
            this.index2element.put(id, e);
            this.element2index.put(e, id);
        }
        this.version = this.doc.getDocumentElement().getAttribute("version");
        return true;
    }

    public String getIOException() {
        return this.ioException;
    }

    public void push(Node e) {
        this.estack.setSize(this.esp + 1);
        this.estack.set(this.esp, e);
        this.chld_stack.setSize(this.esp + 1);
        this.chld_stack.set(this.esp, e.getFirstChild());
        ++this.esp;
    }

    public Element top() {
        if (this.esp <= 0) {
            return null;
        }
        return (Element)this.estack.get(this.esp - 1);
    }

    private Element top_child() {
        return this.next_child(this.esp - 1);
    }

    private Element next_child(int i) {
        Node n;
        if (i < 0) {
            return null;
        }
        Node m = n = this.chld_stack.get(i);
        while (m != null && m.getNodeType() != 1) {
            m = m.getNextSibling();
        }
        if (m != null) {
            Node sib;
            Node sib1 = sib = m.getNextSibling();
            while (sib1 != null && sib1.getNodeType() != 1) {
                sib1 = sib1.getNextSibling();
            }
            this.chld_stack.set(i, sib1);
        } else {
            this.chld_stack.set(i, this.top().getFirstChild());
        }
        return (Element)m;
    }

    private Element parent() {
        if (this.esp <= 1) {
            return null;
        }
        return (Element)this.estack.get(this.esp - 2);
    }

    private void pop() {
        if (this.esp <= 0) {
            return;
        }
        --this.esp;
        this.estack.setSize(this.esp);
        this.chld_stack.setSize(this.esp);
    }

    public Document getDoc() {
        return this.doc;
    }

    public boolean openObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String newi = this.getO2I(o);
        String thisi = this.getO2I(t);
        if (newi.length() == 0 || thisi.length() == 0) {
            return false;
        }
        this.push((Element)this.index2element.get(newi));
        if (this.index2element.get(thisi) == null) {
            this.index2element.put(thisi, this.top());
        }
        return true;
    }

    public boolean reopenObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String newi = this.getO2I(o);
        String thisi = this.getO2I(t);
        if (newi.length() == 0 || thisi.length() == 0) {
            return false;
        }
        this.push((Element)this.index2element.get(newi));
        if (this.index2element.get(thisi) == null) {
            this.index2element.put(thisi, this.top());
        }
        return true;
    }

    public boolean peekObject(XMLObject o, XMLObject t) {
        if (o == null) {
            return false;
        }
        String id = this.getO2I(o);
        if (id.length() == 0) {
            return false;
        }
        if (t != null && this.getO2I(t).length() == 0) {
            this.object2index.put(id, t);
        }
        this.push((Element)this.index2element.get(id));
        return true;
    }

    public void openNewElem(String tagname, XMLObject t) {
        String newi = this.getO2I(t);
        if (newi.length() != 0 && !"".equals(tagname)) {
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            this.index2element.put(newi, e);
            this.push(e);
        }
    }

    public void openSubTag(String tagname) {
        if (!"".equals(tagname)) {
            Element e = this.doc.createElement(tagname);
            this.top().appendChild(e);
            this.push(e);
        }
    }

    public boolean readSubTag(String tagname) {
        Element e;
        do {
            if ((e = this.top_child()) != null) continue;
            return false;
        } while (!e.getTagName().equals(tagname));
        this.push(e);
        return true;
    }

    public boolean readSubTag(List<String> tagnames) {
        Element e;
        do {
            if ((e = this.top_child()) != null) continue;
            return false;
        } while (!tagnames.contains(e.getTagName()));
        this.push(e);
        return true;
    }

    public String readSubTag() {
        String tagname = "";
        Element e = this.top_child();
        if (e == null) {
            return null;
        }
        tagname = e.getTagName();
        this.push(e);
        return tagname;
    }

    public void addObject(String mem_name, XMLObject o, boolean sub) {
        if (o == null) {
            return;
        }
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            Element el;
            newi = this.newO2I(o);
            this.index2element.put(newi, null);
            o.XwriteObject(this);
            if (this.index2element.get(newi) != null && (el = (Element)this.index2element.get(newi)).getParentNode() == null) {
                if (sub) {
                    this.top().appendChild(el);
                } else {
                    this.parent().appendChild(el);
                }
            }
        }
        if (!sub) {
            this.top().setAttribute(mem_name, newi);
        }
    }

    public void addObjectRef(String mem_name, XMLObject o) {
        this.addObject(mem_name, o, false);
    }

    public void addObjectSub(XMLObject o) {
        this.addObject("", o, true);
    }

    public XMLObject getObject(String mem_name, XMLObject templ, boolean sub) {
        Element e;
        String s;
        if (!sub) {
            String i = "";
            String s2 = this.top().getAttribute(mem_name);
            if (!s2.equals("")) {
                i = s2;
                XMLObject o = (XMLObject)this.index2object.get(i);
                if (o == null && templ != null) {
                    o = templ;
                    this.index2object.put(i, o);
                    this.object2index.put(o, i);
                    o.XreadObject(this);
                    if (this.index2element.get(i) == null) {
                        System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
                    }
                }
                return o;
            }
            return null;
        }
        do {
            if ((e = this.top_child()) == null) {
                return null;
            }
            s = e.getAttribute("ID");
            s.equals("");
        } while (s.equals(""));
        if (!s.equals("")) {
            String i = s;
            if (this.index2object.get(i) != null) {
                System.err.println("XMLHelper: FATAL: subobject ID=" + i + " already read in.");
                return (XMLObject)this.index2object.get(i);
            }
            this.index2object.put(i, templ);
            this.object2index.put(templ, i);
            templ.XreadObject(this);
            if (this.index2element.get(i) == null) {
                System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
            }
            return templ;
        }
        System.err.println("XMLHelper: getObject: next SubElement  " + e + "  has no ID attribute");
        return null;
    }

    public XMLObject getObjectRef(String mem_name, XMLObject templ) {
        return this.getObject(mem_name, templ, false);
    }

    public XMLObject getObjectSub(XMLObject templ) {
        return this.getObject("", templ, true);
    }

    public XMLObject loadObject(XMLObject templ) {
        Element e = this.top();
        if (e == null) {
            return null;
        }
        String s = e.getAttribute("ID");
        if (s.equals("")) {
            System.out.println("XMLHelper: Warning: ignoring Element " + e + " as it has no ID");
            return null;
        }
        String i = s;
        if (this.index2object.get(i) != null) {
            System.err.println("XMLHelper: FATAL: subobject ID=" + i + " already read in.");
            return (XMLObject)this.index2object.get(i);
        }
        this.index2object.put(i, templ);
        this.object2index.put(templ, i);
        templ.XreadObject(this);
        if (this.index2element.get(i) == null) {
            System.out.println("XMLHelper: Object " + templ + " has no DOM elements");
        }
        return templ;
    }

    public void enrichObject(XMLObject templ) {
        templ.XreadObject(this);
    }

    public void addEnumeration(String mem_name, Enumeration<?> e, boolean sub) {
        String refs = "";
        while (e.hasMoreElements()) {
            XMLObject o = (XMLObject)e.nextElement();
            String newi = this.getO2I(o);
            if (newi.length() == 0) {
                newi = this.newO2I(o);
                this.index2element.put(newi, null);
                o.XwriteObject(this);
                if (this.index2element.get(newi) == null) {
                    System.err.println("XMLHelper: Enumeration-Object has no DOM-Elements " + o.toString());
                } else if (sub) {
                    this.top().appendChild((Element)this.index2element.get(newi));
                } else {
                    this.top().getParentNode().appendChild((Element)this.index2element.get(newi));
                }
            }
            if (sub) continue;
            String s = newi;
            refs = refs.length() == 0 ? s : String.valueOf(refs) + "," + s;
        }
        if (!sub) {
            this.top().setAttribute(mem_name, refs);
        }
    }

    public void addIteration(String mem_name, Iterator<?> e, boolean sub) {
        String refs = "";
        while (e.hasNext()) {
            XMLObject o = (XMLObject)e.next();
            String newi = this.getO2I(o);
            if (newi.length() == 0) {
                newi = this.newO2I(o);
                this.index2element.put(newi, null);
                o.XwriteObject(this);
                if (this.index2element.get(newi) == null) {
                    System.err.println("XMLHelper: Enumeration-Object has no DOM-Elements " + o.toString());
                } else if (sub) {
                    this.top().appendChild((Element)this.index2element.get(newi));
                } else {
                    this.top().getParentNode().appendChild((Element)this.index2element.get(newi));
                }
            }
            if (sub) continue;
            String s = newi;
            refs = refs.length() == 0 ? s : String.valueOf(refs) + "," + s;
        }
        if (!sub) {
            this.top().setAttribute(mem_name, refs);
        }
    }

    public Enumeration<Element> getEnumeration(String mem_name, XMLObject templ, boolean sub, String tagname) {
        Element e;
        Vector<Element> v = new Vector<Element>();
        this.push(this.top());
        while ((e = this.top_child()) != null) {
            if (!e.getTagName().equals(tagname)) continue;
            v.add(e);
        }
        this.pop();
        return v.elements();
    }

    public Iterator<Element> getIteration(String mem_name, XMLObject templ, boolean sub, String tagname) {
        Element e;
        Vector<Element> v = new Vector<Element>();
        this.push(this.top());
        while ((e = this.top_child()) != null) {
            if (!e.getTagName().equals(tagname)) continue;
            v.add(e);
        }
        this.pop();
        return v.iterator();
    }

    public void addList(String mem_name, List<?> list, boolean sub) {
        String refs = "";
        for (XMLObject o : list) {
            String newi = this.getO2I(o);
            if (newi.length() == 0) {
                newi = this.newO2I(o);
                this.index2element.put(newi, null);
                o.XwriteObject(this);
                if (this.index2element.get(newi) == null) {
                    System.err.println("XMLHelper: Enumeration-Object has no DOM-Elements " + o.toString());
                } else if (sub) {
                    this.top().appendChild((Element)this.index2element.get(newi));
                } else {
                    this.top().getParentNode().appendChild((Element)this.index2element.get(newi));
                }
            }
            if (sub) continue;
            String s = newi;
            refs = refs.length() == 0 ? s : String.valueOf(refs) + "," + s;
        }
        if (!sub) {
            this.top().setAttribute(mem_name, refs);
        }
    }

    public List<Element> getList(String mem_name, XMLObject templ, boolean sub, String tagname) {
        Element e;
        Vector<Element> v = new Vector<Element>();
        this.push(this.top());
        while ((e = this.top_child()) != null) {
            if (!e.getTagName().equals(tagname)) continue;
            v.add(e);
        }
        this.pop();
        return v;
    }

    public void addTopObject(XMLObject o) {
        if (o == null) {
            return;
        }
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            this.index2element.put(newi, null);
            o.XwriteObject(this);
            if (this.index2element.get(newi) != null) {
                if (this.doc.getDocumentElement() == null) {
                    this.doc.appendChild((Element)this.index2element.get(newi));
                } else {
                    this.doc.getDocumentElement().appendChild((Element)this.index2element.get(newi));
                }
            }
        }
    }

    public boolean isTag(String tag, XMLObject th) {
        String i = this.getO2I(th);
        if (i.length() == 0) {
            System.err.println("XMLHelper: FATAL: isTag called, without caller being in order");
            return false;
        }
        Element e = (Element)this.index2element.get(i);
        if (e == null) {
            System.err.println("XMLHelper: FATAL: ID " + i + " has no DOM element");
            return false;
        }
        this.push(e);
        if (!tag.equals(this.top().getTagName())) {
            this.pop();
            return false;
        }
        return true;
    }

    public XMLObject getTopObject(XMLObject t) {
        Element e = this.next_child(0);
        if (e == null) {
            return null;
        }
        String i = "";
        String s = e.getAttribute("ID");
        if (!s.equals("")) {
            i = s;
            if (this.index2object.get(i) != null) {
                return (XMLObject)this.index2object.get(i);
            }
            this.index2object.put(i, t);
            this.object2index.put(t, i);
        } else if (!this.isAGG) {
            i = (String)this.element2index.get(e);
            this.index2object.put(i, t);
            this.object2index.put(t, i);
        }
        t.XreadObject(this);
        return t;
    }

    public void peekElement(Object o) {
        this.push((Element)o);
    }

    public void close() {
        this.pop();
    }

    public void addObject(String tagname, String mem_name, XMLObject o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            this.top().getParentNode().appendChild(e);
            this.index2element.put(newi, e);
            this.push(e);
            o.XwriteObject(this);
            this.pop();
        }
        this.top().setAttribute(mem_name, newi);
    }

    public void addTopObject(String tagname, XMLObject o) {
        String newi = this.getO2I(o);
        if (newi.length() == 0) {
            newi = this.newO2I(o);
            Element e = this.doc.createElement(tagname);
            e.setAttribute("ID", newi);
            if (this.doc.getDocumentElement() == null) {
                this.doc.appendChild(e);
            } else {
                this.doc.getDocumentElement().appendChild(e);
            }
            this.push(e);
            o.XwriteObject(this);
            this.pop();
        }
    }

    public String escapeString(String s) {
        if (s == null) {
            return null;
        }
        String r = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '.') {
                r = String.valueOf(r) + c;
            } else {
                String t = String.valueOf((int)c);
                r = String.valueOf(r) + "/" + t + "/";
            }
            ++i;
        }
        return r;
    }

    public String unescapeString(String s) {
        if (s == null) {
            return null;
        }
        String r = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '/') {
                int j = ++i;
                while (j < s.length() && s.charAt(j) != '/') {
                    ++j;
                }
                String t = s.substring(i, j);
                i = j;
                c = (char)Integer.parseInt(t);
                r = String.valueOf(r) + c;
            } else {
                r = String.valueOf(r) + c;
            }
            ++i;
        }
        return r;
    }

    public void addAttr(String name, String value) {
        this.top().setAttribute(name, value);
    }

    public void addAttr(String name, int value) {
        this.addAttr(name, Integer.toString(value));
    }

    public void addAttrValue(String typeName, Object value) {
        boolean useXMLEncoder = false;
        if (value == null) {
            this.openSubTag("string");
            Text text = this.doc.createTextNode("null");
            this.top().appendChild(text);
            this.push(text);
            this.close();
            this.close();
            return;
        }
        Class<?> cl = value.getClass();
        String className = cl.getName();
        if (typeName.equals("string")) {
            String str = (String)value;
            if (str.indexOf("\"") == -1) {
                this.openSubTag("string");
                Text text = this.doc.createTextNode(str);
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
                return;
            }
            useXMLEncoder = true;
        } else if (typeName.equals("String")) {
            useXMLEncoder = true;
        } else {
            if (typeName.equals("int") || typeName.equals("Integer")) {
                this.openSubTag("int");
                Text text = null;
                if (value instanceof Integer) {
                    text = this.doc.createTextNode(((Integer)value).toString());
                } else if (value instanceof String) {
                    try {
                        Integer I = Integer.valueOf((String)value);
                        text = this.doc.createTextNode(I.toString());
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("XMLHelper.addAttrValue:  tried to write Integer: " + value + ".  FAILED! " + ex.getMessage());
                    }
                }
                if (text != null) {
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                }
                this.close();
                return;
            }
            if (typeName.equals("boolean") || typeName.equals("Boolean")) {
                this.openSubTag("boolean");
                if (value instanceof Boolean) {
                    Text text = this.doc.createTextNode(((Boolean)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                }
                this.close();
                return;
            }
            if (typeName.equals("char") || typeName.equals("Character")) {
                this.openSubTag("char");
                Text text = this.doc.createTextNode(((Character)value).toString());
                this.top().appendChild(text);
                this.push(text);
                this.close();
                this.close();
                return;
            }
            if (typeName.equals("float") || typeName.equals("Float")) {
                if (value instanceof Float) {
                    this.openSubTag("float");
                    Text text = this.doc.createTextNode(((Float)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                    this.close();
                    return;
                }
                this.openSubTag("float");
                Text text = null;
                if (className.equals("java.lang.Double")) {
                    Float floatVal = Float.valueOf(((Double)value).floatValue());
                    text = this.doc.createTextNode(floatVal.toString());
                } else if (className.equals("java.lang.String")) {
                    try {
                        Float F = Float.valueOf((String)value);
                        text = this.doc.createTextNode(F.toString());
                    }
                    catch (NumberFormatException F) {
                        // empty catch block
                    }
                }
                if (text != null) {
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                }
                this.close();
                return;
            }
            if (typeName.equals("double") || typeName.equals("Double")) {
                if (value instanceof Double) {
                    this.openSubTag("double");
                    Text text = this.doc.createTextNode(((Double)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                    this.close();
                    return;
                }
                this.openSubTag("double");
                Text text = null;
                if (className.equals("java.lang.Double")) {
                    text = this.doc.createTextNode(((Double)value).toString());
                } else if (className.equals("java.lang.String")) {
                    try {
                        Double D = Double.valueOf((String)value);
                        text = this.doc.createTextNode(D.toString());
                    }
                    catch (NumberFormatException D) {
                        // empty catch block
                    }
                }
                if (text != null) {
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                }
                this.close();
                return;
            }
            if (typeName.equals("long") || typeName.equals("Long")) {
                if (value instanceof Long) {
                    this.openSubTag("long");
                    Text text = this.doc.createTextNode(((Long)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                    this.close();
                } else {
                    this.openSubTag("long");
                    Text text = null;
                    if (className.equals("java.lang.Float")) {
                        Long longVal = ((Float)value).longValue();
                        text = this.doc.createTextNode(longVal.toString());
                    } else if (className.equals("java.lang.Integer")) {
                        Long L = ((Integer)value).longValue();
                        text = this.doc.createTextNode(L.toString());
                    } else if (className.equals("java.lang.String")) {
                        try {
                            Long L = Long.valueOf((String)value);
                            text = this.doc.createTextNode(L.toString());
                        }
                        catch (NumberFormatException L) {
                            // empty catch block
                        }
                    }
                    if (text != null) {
                        this.top().appendChild(text);
                        this.push(text);
                        this.close();
                    }
                    this.close();
                }
                return;
            }
            if (typeName.equals("short") || typeName.equals("Short")) {
                if (value instanceof Short) {
                    this.openSubTag("short");
                    Text text = this.doc.createTextNode(((Short)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                    this.close();
                } else {
                    this.openSubTag("short");
                    Text text = null;
                    if (className.equals("java.lang.Float")) {
                        Short shortVal = ((Float)value).shortValue();
                        text = this.doc.createTextNode(shortVal.toString());
                    } else if (className.equals("java.lang.Integer")) {
                        Short Sh = ((Integer)value).shortValue();
                        text = this.doc.createTextNode(Sh.toString());
                    } else if (className.equals("java.lang.String")) {
                        try {
                            Short Sh = Short.valueOf((String)value);
                            text = this.doc.createTextNode(Sh.toString());
                        }
                        catch (NumberFormatException Sh) {
                            // empty catch block
                        }
                    }
                    if (text != null) {
                        this.top().appendChild(text);
                        this.push(text);
                        this.close();
                    }
                    this.close();
                }
                return;
            }
            if (typeName.equals("byte") || typeName.equals("Byte")) {
                if (value instanceof Byte) {
                    this.openSubTag("byte");
                    Text text = this.doc.createTextNode(((Byte)value).toString());
                    this.top().appendChild(text);
                    this.push(text);
                    this.close();
                    this.close();
                } else {
                    this.openSubTag("byte");
                    Text text = null;
                    if (value instanceof Integer) {
                        Byte B = ((Integer)value).byteValue();
                        text = this.doc.createTextNode(B.toString());
                    } else if (value instanceof String) {
                        try {
                            Byte B = Byte.valueOf((String)value);
                            text = this.doc.createTextNode(B.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (text != null) {
                        this.top().appendChild(text);
                        this.push(text);
                        this.close();
                    }
                    this.close();
                }
                return;
            }
            if (typeName.equals("Object")) {
                this.addAttrUsingXMLEncoder("Value", value);
                this.doc.getDocumentElement().normalize();
                return;
            }
            try {
                cl.newInstance();
                useXMLEncoder = true;
            }
            catch (InstantiationException ex1) {
                useXMLEncoder = false;
            }
            catch (IllegalAccessException ex2) {
                useXMLEncoder = false;
            }
        }
        if (useXMLEncoder) {
            this.addAttrUsingXMLEncoder("Value", value);
        } else if (typeName.equals("Enumeration")) {
            Vector vec = new Vector();
            while (((Enumeration)value).hasMoreElements()) {
                vec.add(((Enumeration)value).nextElement());
            }
            this.addAttrUsingXMLEncoder("Value", vec);
        } else {
            System.out.println("\tContinue with using SerializedData for saving.");
            this.addAttrUsingSerializedData("Value", typeName, value);
        }
        this.doc.getDocumentElement().normalize();
    }

    public Object getElementData(Element e) {
        if (e != null && e.hasChildNodes()) {
            Text text = (Text)e.getFirstChild();
            try {
                return text.getData();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return null;
    }

    public Object getAttrValue(String typeName) {
        Object result = null;
        boolean useXMLDecoder = false;
        if (this.readSubTag("string")) {
            Element e = this.top();
            if (e.hasChildNodes()) {
                Text text = (Text)e.getFirstChild();
                try {
                    String data = text.getData();
                    result = data;
                }
                catch (DOMException data) {
                    // empty catch block
                }
            }
            this.close();
            return result;
        }
        if (typeName.equals("int") || typeName.equals("Integer")) {
            if (this.readSubTag("int")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = Integer.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("boolean") || typeName.equals("Boolean")) {
            if (this.readSubTag("boolean")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = Boolean.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("char") || typeName.equals("Character")) {
            if (this.readSubTag("char")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = Character.valueOf(data.charAt(0));
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("float") || typeName.equals("Float")) {
            if (this.readSubTag("float")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("float") ? Float.valueOf(data) : Float.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("double") || typeName.equals("Double")) {
            if (this.readSubTag("double")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = Double.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("long") || typeName.equals("Long")) {
            if (this.readSubTag("long")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("long") ? Long.valueOf(data) : Long.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("short") || typeName.equals("Short")) {
            if (this.readSubTag("short")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("short") ? Short.valueOf(data) : Short.valueOf(data);
                    }
                    catch (DOMException data) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else if (typeName.equals("byte") || typeName.equals("Byte")) {
            if (this.readSubTag("byte")) {
                Element e = this.top();
                if (e.hasChildNodes()) {
                    Text text = (Text)e.getFirstChild();
                    try {
                        String data = text.getData();
                        result = typeName.equals("byte") ? Byte.valueOf(data) : Byte.valueOf(data);
                    }
                    catch (DOMException dOMException) {
                        // empty catch block
                    }
                }
                this.close();
                return result;
            }
        } else {
            if (typeName.equals("string")) {
                return null;
            }
            if (typeName.equals("String")) {
                useXMLDecoder = true;
            } else if (this.readSubTag("object")) {
                String s = this.readAttr("class");
                if (s.equals(typeName)) {
                    if (this.readSubTag("SerializedData")) {
                        result = this.getAttrUsingSerializedData("SerializedData");
                        this.close();
                        this.close();
                        return result;
                    }
                } else {
                    this.close();
                }
            } else {
                useXMLDecoder = true;
            }
        }
        if (useXMLDecoder) {
            result = this.getAttrUsingXMLDecoder("Value");
        }
        if (typeName.equals("Enumeration") && result instanceof Vector) {
            Vector vec = (Vector)result;
            Enumeration en = vec.elements();
            result = en;
        }
        return result;
    }

    private void addAttrUsingXMLEncoder(String tagName, Object value) {
        if (!tagName.equals("Value")) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLEncoder e1 = new XMLEncoder(new BufferedOutputStream(baos));
            e1.writeObject(value);
            e1.close();
        }
        catch (ArrayIndexOutOfBoundsException e1) {
        }
        catch (Exception ex) {
            System.out.println("agg.util.XMLHelper.addAttrUsingXMLEncoder: write attribute value FAILED!");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(bais));
            Document tmpDoc = parser.getDocument();
            tmpDoc.getDocumentElement().normalize();
            Element element = tmpDoc.getDocumentElement();
            try {
                Node n = this.doc.importNode(element, true);
                this.top().appendChild(n);
                this.push(n);
                this.close();
            }
            catch (DOMException ex2) {
                System.out.println("XMLHelper: DOMException: " + ex2.getMessage());
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Object getAttrUsingXMLDecoder(String tagName) {
        ByteArrayOutputStream baos;
        Object result;
        block17: {
            if (!tagName.equals("Value")) {
                return null;
            }
            if (this.top().getElementsByTagName("java").getLength() == 0) {
                return null;
            }
            result = null;
            Element element = this.top();
            DocumentImpl tmpDoc = new DocumentImpl();
            try {
                Node n = tmpDoc.importNode(element, true);
                tmpDoc.appendChild(n);
            }
            catch (DOMException ex2) {
                System.out.println("XMLHelper.getAttrUsingXMLDecoder : DOMException: " + ex2.getMessage());
                return null;
            }
            OutputFormat format = new OutputFormat((Document)tmpDoc, "UTF-8", true);
            baos = new ByteArrayOutputStream();
            try {
                try {
                    XMLSerializer serializer = new XMLSerializer(baos, format);
                    serializer.setOutputByteStream(baos);
                    serializer.serialize(tmpDoc);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                baos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(bais), this, this);
            result = d.readObject();
            d.close();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    private void addAttrUsingSerializedData(String tagName, String typeName, Object value) {
        if (!tagName.equals("Value")) {
            return;
        }
        Class<?> cl = value.getClass();
        if (!(value instanceof Serializable)) {
            System.out.println("XMLHelper: WARNING!  Save attribute value:  Class " + cl.getName() + "  CANNOT BE SAVED.\n\tThis class should implements interface java.io.Serializable.");
            return;
        }
        String clName = cl.getName();
        if (clName.indexOf(typeName) == -1) {
            Thread.dumpStack();
            System.out.println("XMLHelper: WARNING! Save attribute value:  Class " + cl.getName() + "  CANNOT BE SAVED.\n\tClass name and the name of the AttributeMember type are not equal.");
            return;
        }
        this.openSubTag("object");
        this.addAttr("class", typeName);
        this.openSubTag("SerializedData");
        boolean successfullySaved = true;
        try {
            ByteArrayOutputStream baOut = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(baOut);
            oOut.writeObject(value);
            oOut.flush();
            byte[] bytes = baOut.toByteArray();
            char[] conversionTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            int blockSize = 16;
            int i = 0;
            while (i < bytes.length) {
                int thisBlock = bytes.length - i;
                if (thisBlock > blockSize) {
                    thisBlock = blockSize;
                }
                String block = "";
                int k = 0;
                while (k < thisBlock) {
                    int b = bytes[i];
                    if (b < 0) {
                        b += 256;
                    }
                    block = String.valueOf(block) + String.valueOf(conversionTable[b / 16]);
                    block = String.valueOf(block) + String.valueOf(conversionTable[b % 16]);
                    ++k;
                    ++i;
                }
                Text text = this.doc.createTextNode(block);
                this.top().appendChild(text);
                this.push(text);
                this.close();
            }
        }
        catch (IOException e) {
            successfullySaved = false;
        }
        if (!successfullySaved) {
            Text text = this.doc.createTextNode("isNULL");
            this.top().appendChild(text);
            this.push(text);
            this.close();
        }
        this.close();
        this.close();
    }

    private Object getAttrUsingSerializedData(String tagName) {
        Object object = null;
        if (this.top().getNodeName().equals(tagName)) {
            int len;
            Vector<String> dataList = new Vector<String>();
            int byteCount = 0;
            String data = null;
            Element e = this.top();
            if (e.hasChildNodes()) {
                Text text = (Text)e.getFirstChild();
                try {
                    data = text.getData();
                }
                catch (DOMException dOMException) {
                    // empty catch block
                }
            }
            if (data != null && !data.equals("isNULL") && (len = data.length()) >= 2) {
                dataList.add(data);
                byteCount += len / 2;
            }
            byte[] bytes = new byte[byteCount];
            Iterator dataIt = dataList.iterator();
            String currentData = null;
            int dataIndex = 0;
            int dataLen = 0;
            int i = 0;
            while (i < byteCount) {
                if (dataIndex + 1 >= dataLen) {
                    currentData = (String)dataIt.next();
                    dataIndex = 0;
                    dataLen = currentData.length();
                }
                int b = 0;
                int d = 0;
                while (d < 2) {
                    b *= 16;
                    if (currentData != null) {
                        switch (currentData.charAt(dataIndex)) {
                            case '0': {
                                b += 0;
                                break;
                            }
                            case '1': {
                                ++b;
                                break;
                            }
                            case '2': {
                                b += 2;
                                break;
                            }
                            case '3': {
                                b += 3;
                                break;
                            }
                            case '4': {
                                b += 4;
                                break;
                            }
                            case '5': {
                                b += 5;
                                break;
                            }
                            case '6': {
                                b += 6;
                                break;
                            }
                            case '7': {
                                b += 7;
                                break;
                            }
                            case '8': {
                                b += 8;
                                break;
                            }
                            case '9': {
                                b += 9;
                                break;
                            }
                            case 'a': {
                                b += 10;
                                break;
                            }
                            case 'b': {
                                b += 11;
                                break;
                            }
                            case 'c': {
                                b += 12;
                                break;
                            }
                            case 'd': {
                                b += 13;
                                break;
                            }
                            case 'e': {
                                b += 14;
                                break;
                            }
                            case 'f': {
                                b += 15;
                                break;
                            }
                        }
                        ++dataIndex;
                    }
                    ++d;
                }
                if (b > 127) {
                    b -= 256;
                }
                bytes[i] = (byte)b;
                ++i;
            }
            try {
                ByteArrayInputStream baIn = new ByteArrayInputStream(bytes);
                ObjectInputStream oOut = new ObjectInputStream(baIn);
                object = oOut.readObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public void addAttrToObject(Object obj, String name, String value) {
        String indx = this.getO2I(obj);
        if (!indx.equals("")) {
            Element elem = (Element)this.index2element.get(indx);
            elem.setAttribute(name, value);
        }
    }

    public String readAttr(String name) {
        String r = this.top().getAttribute(name);
        if (r == null) {
            r = "";
        }
        return r;
    }

    public int readIAttr(String name) {
        String s = this.readAttr(name);
        if (s == "") {
            return 0;
        }
        return Integer.valueOf(s);
    }

    public void addSubObject(String tagname, XMLObject o) {
        Element e = this.doc.createElement(tagname);
        this.push(e);
        o.XwriteObject(this);
        this.pop();
        this.top().appendChild(e);
    }

    public Object getObject(String tagname) {
        return null;
    }

    @Override
    public void exceptionThrown(Exception e) {
    }

    public static String checkNameDueToSpecialCharacters(String nameStr) {
        if (nameStr.indexOf(38) != -1 || nameStr.indexOf(124) != -1 || nameStr.indexOf(95) != -1 || nameStr.indexOf(46) != -1 || nameStr.indexOf(40) != -1 || nameStr.indexOf(41) != -1 || nameStr.indexOf(94) != -1) {
            String test = "";
            int i = 0;
            while (i < nameStr.length()) {
                Character ch = Character.valueOf(nameStr.charAt(i));
                if (Character.getNumericValue(nameStr.charAt(i)) == -1) {
                    if (ch.charValue() == '&' || ch.charValue() == '|' || ch.charValue() == '_' || ch.charValue() == '.' || ch.charValue() == '(' || ch.charValue() == ')' || ch.charValue() == '^') {
                        test = test.concat(String.valueOf(ch));
                    }
                } else {
                    test = test.concat(String.valueOf(ch));
                }
                ++i;
            }
            return test;
        }
        return nameStr;
    }
}

