/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.LayerFunction;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.parser.SimpleParser;
import agg.parser.TripleData;
import agg.util.IntComparator;
import agg.util.OrderedSet;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;

public class LayeredSimpleParser
extends SimpleParser {
    protected RuleLayer layer;

    public LayeredSimpleParser(GraGra grammar, Graph hostGraph, Graph stopGraph, LayerFunction layer) {
        super(grammar, hostGraph, stopGraph);
    }

    public LayeredSimpleParser(GraGra grammar, Graph hostGraph, Graph stopGraph, RuleLayer layer) {
        super(grammar, hostGraph, stopGraph);
        this.layer = layer;
    }

    @Override
    public boolean parse() {
        this.fireParserEvent(new ParserMessageEvent(this, "Starting layered simple parser ..."));
        Stack<TripleData> stack = new Stack<TripleData>();
        this.correct = true;
        Hashtable<Integer, HashSet<Rule>> invertedRuleLayer = this.layer.invertLayer();
        OrderedSet<Integer> ruleLayer = new OrderedSet<Integer>(new IntComparator());
        Enumeration<Integer> en = invertedRuleLayer.keys();
        while (en.hasMoreElements()) {
            ruleLayer.add(en.nextElement());
        }
        Integer currentLayer = this.layer.getStartLayer();
        int i = 0;
        RuleInstances eri = new RuleInstances();
        boolean ruleApplied = false;
        while (!this.getHostGraph().isIsomorphicTo(this.stopGraph) && this.correct && currentLayer != null && !this.stop) {
            TripleData tmpTriple;
            OrdinaryMorphism copyMorph;
            ruleApplied = false;
            this.fireParserEvent(new ParserMessageEvent(this, "Searching for match"));
            HashSet<Rule> rulesForLayer = invertedRuleLayer.get(currentLayer);
            Match m = this.findMatch(this.getHostGraph(), rulesForLayer.iterator(), eri);
            if (m != null && (copyMorph = this.getHostGraph().isomorphicCopy()) != null) {
                this.fireParserEvent(new ParserMessageEvent(copyMorph, "IsoCopy"));
                eri.add(m);
                tmpTriple = new TripleData(this.getHostGraph(), eri, currentLayer);
                stack.push(tmpTriple);
                eri = new RuleInstances();
                this.setHostGraph(copyMorph.getImage());
                OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                Match n = tmpMorph.makeMatch(m.getRule());
                n.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                boolean found = true;
                while (!this.stop && !n.isValid() && found) {
                    if (n.nextCompletion()) continue;
                    found = false;
                }
                if (found && this.applyRule(n)) {
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (m != null && ruleApplied) continue;
            boolean nextLayerExists = true;
            if (++i < ruleLayer.size()) {
                currentLayer = (Integer)ruleLayer.get(i);
            } else {
                nextLayerExists = false;
            }
            if (nextLayerExists) continue;
            try {
                tmpTriple = (TripleData)stack.pop();
                this.setHostGraph(tmpTriple.getHostGraph());
                eri = tmpTriple.getRuleInstance();
                currentLayer = tmpTriple.getLayer();
            }
            catch (EmptyStackException ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!stack.empty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                TripleData tmpTriple = (TripleData)stack.pop();
                Graph g = tmpTriple.getHostGraph();
                BaseFactory.theFactory().destroyGraph(g);
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        System.out.println("### LayeredSimpleParser ... Stopping parser. Result is " + this.correct + ".");
        return this.correct;
    }
}

