/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.parser.ComputingThread;
import agg.parser.CriticalPairData;
import agg.parser.CriticalPairEvent;
import agg.parser.CriticalPairOption;
import agg.parser.CriticalRulePairAtGraph;
import agg.parser.ExcludePair;
import agg.parser.ExcludePairHelper;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayerFunction;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.parser.SimpleExcludePair;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TestStep;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class ExcludePairContainer
implements PairContainer,
Runnable {
    protected Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeContainer = null;
    protected boolean calculateParallel = false;
    protected Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFreeContainer = null;
    public Hashtable<Rule, Hashtable<Rule, Entry>> commonContainer = new Hashtable();
    protected int conflictKind = 0;
    protected GraGra grammar;
    protected List<Rule> rules;
    protected List<Rule> rules2;
    protected boolean asymmetrical;
    protected boolean isComputed;
    protected boolean isComputedLocal;
    protected final Vector<ParserEventListener> listener = new Vector(2);
    protected boolean stop;
    protected boolean isAlive;
    protected ExcludePair excludePair;
    protected boolean notCompleteComputable;
    protected boolean complete;
    protected boolean reduce;
    protected boolean reduceSameMatch;
    protected boolean withNACs;
    protected boolean withPACs;
    protected boolean consistent;
    protected boolean directStrctCnfl;
    protected boolean directStrctCnflUpToIso;
    protected boolean strongAttrCheck;
    protected boolean namedObjectOnly;
    protected int maxBoundOfCriticKind = 0;
    protected boolean equalVariableNameOfAttrMapping;
    protected boolean useHostGraph;
    protected final Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> excludeContainerForTestGraph = new Hashtable();
    protected Graph testGraph;
    protected MorphCompletionStrategy strategy;
    protected boolean isEmpty = true;
    protected boolean ignoreIdenticalRules = false;
    protected Hashtable<ValueMember, Pair<String, String>> storeMap;
    long freeM;
    long usedM;

    public ExcludePairContainer(GraGra gragra) {
        this.initAllContainer();
        this.isComputed = false;
        this.stop = false;
        this.isAlive = false;
        this.complete = true;
        this.withNACs = true;
        this.consistent = true;
        this.setGrammar(gragra);
    }

    @Override
    public ExcludePair getActiveExcludePair() {
        return this.excludePair;
    }

    @Override
    public void run() {
        Runtime.getRuntime().gc();
        long time0 = System.currentTimeMillis();
        this.freeM = 0L;
        this.stop = false;
        this.isAlive = true;
        if (this.useHostGraph) {
            this.firePairEvent(new ParserMessageEvent(this, "Thread  -  Checking Host Graph  -  started."));
        }
        this.firePairEvent(new ParserMessageEvent(this, "Thread  - Critical pairs -  runs ..."));
        this.fillContainers();
        if (this.stop) {
            System.out.println("Critical pairs - Used time: " + (System.currentTimeMillis() - time0) + "ms");
            System.out.println("Critical pairs - Used memory: " + this.usedM / 1024L + "k");
            this.firePairEvent(new ParserMessageEvent(this, "Thread  -  Critical pairs  -  was stopped."));
            this.stop = false;
        } else {
            System.out.println("Critical pairs - Used time: " + (System.currentTimeMillis() - time0) + "ms");
            System.out.println("Critical pairs - Used memory: " + this.usedM / 1024L + "k");
            this.firePairEvent(new ParserMessageEvent(this, -2, "Thread  -  Critical pairs  -  finished."));
            if (this.useHostGraph) {
                this.firePairEvent(new ParserMessageEvent(this, -2, "Thread  -  Checking Host Graph  -  finished."));
            }
        }
        this.isAlive = false;
    }

    @Override
    public void stop() {
        this.stop = true;
        if (this.excludePair != null) {
            this.isComputed = false;
            this.excludePair.stop = true;
        }
    }

    @Override
    public void setStop(boolean b) {
        this.stop = b;
        if (this.stop) {
            this.stop();
        }
    }

    @Override
    public boolean wasStopped() {
        return this.stop;
    }

    public void enableIgnoreIdenticalRules(boolean b) {
        this.ignoreIdenticalRules = b;
    }

    @Override
    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalPair(Rule r1, Rule r2, int kind) throws InvalidAlgorithmException {
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    @Override
    public CriticalPairData getCriticalPairData(Rule r1, Rule r2) {
        Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p;
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
        if (secondPart != null && (p = secondPart.get(r2)) != null && ((Boolean)p.first).booleanValue()) {
            return new CriticalPairData(r1, r2, (List)p.second);
        }
        return null;
    }

    @Override
    public List<CriticalPairData> getCriticalPairDataOfKind(String kind) {
        Vector<CriticalPairData> list = new Vector<CriticalPairData>();
        Enumeration<Rule> r1Iter = this.excludeContainer.keys();
        while (r1Iter.hasMoreElements()) {
            Rule r1 = r1Iter.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
            if (secondPart == null) continue;
            Enumeration<Rule> r2Iter = secondPart.keys();
            while (r2Iter.hasMoreElements()) {
                Rule r2 = r2Iter.nextElement();
                Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = secondPart.get(r2);
                if (p == null || !((Boolean)p.first).booleanValue()) continue;
                Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> kindList = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                int i = 0;
                while (i < ((Vector)p.second).size()) {
                    Pair cp = (Pair)((Vector)p.second).get(i);
                    if (kind.indexOf("deliver-delete-dependency") != -1) {
                        if (((OrdinaryMorphism)((Pair)cp.first).first).getTarget().getName().indexOf("produce-use-dependency") != -1 && this.isProduceUseDelete(((OrdinaryMorphism)((Pair)cp.first).first).getTarget(), (Pair)cp.first, r2)) {
                            kindList.add(cp);
                        }
                    } else if (kind.indexOf("deliver-change-dependency") != -1) {
                        if (((OrdinaryMorphism)((Pair)cp.first).first).getTarget().getName().indexOf("produce-use-dependency") != -1 && this.isProduceUseChange(((OrdinaryMorphism)((Pair)cp.first).first).getTarget(), (Pair)cp.first, r2)) {
                            kindList.add(cp);
                        }
                    } else if (((OrdinaryMorphism)((Pair)cp.first).first).getTarget().getName().indexOf(kind) != -1) {
                        kindList.add(cp);
                    }
                    ++i;
                }
                if (kindList.size() > 0) {
                    CriticalPairData data = new CriticalPairData(r1, r2, kindList);
                    list.add(data);
                    continue;
                }
                kindList = null;
            }
        }
        return list;
    }

    private boolean isProduceUseDelete(Graph overlapGraph, Pair<OrdinaryMorphism, OrdinaryMorphism> cpair, Rule r2) {
        Enumeration<GraphObject> dom2 = ((OrdinaryMorphism)cpair.second).getDomain();
        while (dom2.hasMoreElements()) {
            GraphObject go2 = dom2.nextElement();
            GraphObject go = ((OrdinaryMorphism)cpair.second).getImage(go2);
            if (!go.isCritical() || r2.getImage(go2) != null) continue;
            return true;
        }
        return false;
    }

    private boolean isProduceUseChange(Graph overlapGraph, Pair<OrdinaryMorphism, OrdinaryMorphism> cpair, Rule r2) {
        Enumeration<GraphObject> dom2 = ((OrdinaryMorphism)cpair.second).getDomain();
        while (dom2.hasMoreElements()) {
            GraphObject go;
            GraphObject go2 = dom2.nextElement();
            GraphObject img2 = r2.getImage(go2);
            if (img2 == null || !(go = ((OrdinaryMorphism)cpair.second).getImage(go2)).isCritical() || go2.getAttribute() == null || img2.getAttribute() == null || !go2.isAttrMemValDifferent(img2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getCritical(Rule r1, Rule r2, int kind) throws InvalidAlgorithmException {
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    public Object getCritical(Rule r1, Rule r2, int kind, boolean local) throws InvalidAlgorithmException {
        if (local) {
            return this.getCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
        }
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    @Override
    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalPair(Rule r1, Rule r2, int kind, boolean local) throws InvalidAlgorithmException {
        if (local) {
            return this.getCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
        }
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> continueComputeCriticalPair(Rule r1, Rule r2, int kind, boolean local) throws InvalidAlgorithmException {
        if (local) {
            Entry e = this.getEntry(r1, r2);
            if (e.isProgressIndexSet()) {
                return this.continueComputeCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
            }
            return this.getCriticalPair(r1, r2, this.getContainer(kind, r1, r2));
        }
        return this.getCriticalPair(r1, r2, this.getContainer(kind));
    }

    public Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> getCriticalForGraph(Rule r1, Rule r2, Graph g) {
        if (!r1.isEnabled() || !r2.isEnabled()) {
            this.getEntry((Rule)r1, (Rule)r2).state = 5;
            Entry entry = this.addEntry(r1, r2, false, null);
            entry.status = 6;
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
            return null;
        }
        if (!r1.isApplicable(g, this.strategy) || !r2.isApplicable(g, this.strategy)) {
            this.getEntry((Rule)r1, (Rule)r2).state = 3;
            Entry entry = this.addEntry(r1, r2, false, null);
            entry.status = 6;
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, true, null);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
            return null;
        }
        try {
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalObj = this.getCriticalPair(r1, r2, 0, true);
            if (criticalObj != null && this.checkCritical(r1, r2, g)) {
                int i = 0;
                while (i < criticalObj.size()) {
                    Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = criticalObj.get(i);
                    Pair p1 = (Pair)pi.first;
                    Pair p2 = (Pair)pi.second;
                    OrdinaryMorphism m1 = (OrdinaryMorphism)p1.first;
                    Graph overlapG = m1.getTarget();
                    if (this.excludeContainerForTestGraph.get(overlapG) == null) {
                        if (p2 != null) {
                            m1 = (OrdinaryMorphism)p2.first;
                            overlapG = m1.getTarget();
                            if (this.excludeContainerForTestGraph.get(overlapG) == null) {
                                criticalObj.remove(i);
                                --i;
                            }
                        } else {
                            criticalObj.remove(i);
                            --i;
                        }
                    }
                    ++i;
                }
                Entry entry = this.getEntry(r1, r2, true);
                if (criticalObj.isEmpty()) {
                    entry.status = 6;
                }
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
        return this.excludeContainerForTestGraph;
    }

    public Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> getCriticalPairAtGraph(Rule r1, Rule r2) {
        CriticalRulePairAtGraph test = new CriticalRulePairAtGraph(r1, r2, this.testGraph);
        test.setMorphismCompletionStrategy(this.strategy);
        Vector<Pair<Hashtable<GraphObject, GraphObject>, Hashtable<GraphObject, GraphObject>>> result = test.isCriticalAtGraph();
        return result;
    }

    public Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> getCriticalForGraph(Rule r1, Rule r2) {
        if (this.useHostGraph && this.testGraph != null) {
            return this.getCriticalForGraph(r1, r2, this.testGraph);
        }
        return null;
    }

    protected synchronized Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalPair(Rule r1, Rule r2, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container) {
        if (this.stop) {
            return null;
        }
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = container.get(r1);
        if (secondPart != null) {
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = secondPart.get(r2);
            if (p != null) {
                if (((Boolean)p.first).booleanValue()) {
                    this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
                    return (Vector)p.second;
                }
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
                return null;
            }
            this.computeCritical(r1, r2);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
            return this.getCriticalPair(r1, r2, container);
        }
        this.computeCritical(r1, r2);
        this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
        return this.getCriticalPair(r1, r2, container);
    }

    public synchronized Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> getLHSoverlappings(Rule r1, Rule r2, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalPairs) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> matches = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>(5);
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> cps = criticalPairs;
        if (cps == null || cps.isEmpty()) {
            cps = this.getCriticalPair(r1, r2, this.excludeContainer);
        }
        if (cps != null && !cps.isEmpty()) {
            int i = 0;
            while (i < cps.size()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> overlapPair;
                Pair<OrdinaryMorphism, OrdinaryMorphism> isoPair;
                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = cps.get(i);
                Vector<OrdinaryMorphism> triple = this.getValidMatch1Match2(r1, r2, pi);
                if (triple != null && !triple.isEmpty() && (isoPair = this.getIsomorphicOverlapping(matches, overlapPair = new Pair<OrdinaryMorphism, OrdinaryMorphism>(triple.get(0), triple.get(1)))) == null) {
                    matches.add(overlapPair);
                }
                ++i;
            }
        }
        return matches;
    }

    private synchronized Hashtable<String, Pair<OrdinaryMorphism, OrdinaryMorphism>> getLHSoverlappings(Rule r1, Rule r2, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalPairs, Hashtable<String, OrdinaryMorphism> overlapGraphIso) {
        Hashtable<String, Pair<OrdinaryMorphism, OrdinaryMorphism>> result = new Hashtable<String, Pair<OrdinaryMorphism, OrdinaryMorphism>>(5);
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> matches = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>(5);
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> cps = criticalPairs;
        if (cps == null || cps.isEmpty()) {
            cps = this.getCriticalPair(r1, r2, this.excludeContainer);
        }
        if (cps != null && !cps.isEmpty()) {
            int i = 0;
            while (i < cps.size()) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> overlapPair;
                Pair<OrdinaryMorphism, OrdinaryMorphism> isoPair;
                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pi = cps.get(i);
                Vector<OrdinaryMorphism> triple = this.getValidMatch1Match2(r1, r2, pi);
                if (triple != null && !triple.isEmpty() && (isoPair = this.getIsomorphicOverlapping(matches, overlapPair = new Pair<OrdinaryMorphism, OrdinaryMorphism>(triple.get(0), triple.get(1)))) == null) {
                    matches.add(overlapPair);
                    result.put(String.valueOf(pi.hashCode()), overlapPair);
                    if (triple.get(2) != null) {
                        overlapGraphIso.put(String.valueOf(pi.hashCode()), triple.get(2));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private Vector<OrdinaryMorphism> getValidMatch1Match2(Rule r1, Rule r2, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> criticalPair) {
        BaseFactory bf = BaseFactory.theFactory();
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>(3);
        Pair p1 = (Pair)criticalPair.first;
        Pair p2 = (Pair)criticalPair.second;
        if (p2 == null) {
            result.add((OrdinaryMorphism)p1.first);
            result.add((OrdinaryMorphism)p1.second);
            result.add(null);
            return result;
        }
        OrdinaryMorphism overlapMorph1prime = (OrdinaryMorphism)p1.first;
        OrdinaryMorphism overlapMorph2prime = (OrdinaryMorphism)p1.second;
        OrdinaryMorphism L2iso = (OrdinaryMorphism)p2.first;
        if (overlapMorph1prime.getSource() == r1.getRight()) {
            Pair<Pair<Rule, Boolean>, Pair<OrdinaryMorphism, OrdinaryMorphism>> inverseR1pair = bf.reverseRule(r1);
            if (inverseR1pair == null) {
                return null;
            }
            Rule inverseR1 = (Rule)((Pair)inverseR1pair.first).first;
            OrdinaryMorphism isoLeftR1 = (OrdinaryMorphism)((Pair)inverseR1pair.second).first;
            OrdinaryMorphism isoRightR1 = (OrdinaryMorphism)((Pair)inverseR1pair.second).second;
            OrdinaryMorphism morph1prime = overlapMorph1prime.completeDiagram(isoRightR1);
            OrdinaryMorphism targetIso = morph1prime.getTarget().isomorphicCopy();
            if (targetIso == null) {
                morph1prime.dispose();
                return null;
            }
            OrdinaryMorphism morph1primeTest = morph1prime.compose(targetIso);
            ((ContextView)morph1primeTest.getAttrContext()).setVariableContext(true);
            Match m1primeTest = bf.makeMatch(inverseR1, morph1primeTest);
            if (m1primeTest == null) {
                morph1primeTest.dispose();
                morph1primeTest = null;
                return null;
            }
            m1primeTest.setCompletionStrategy(new Completion_InjCSP());
            OrdinaryMorphism ms = null;
            try {
                ms = (OrdinaryMorphism)TestStep.execute(m1primeTest, true, this.equalVariableNameOfAttrMapping);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            if (ms == null) {
                bf.destroyMorphism(m1primeTest);
                m1primeTest = null;
                bf.destroyMorphism(morph1primeTest);
                morph1primeTest = null;
                return null;
            }
            OrdinaryMorphism morph1test = isoLeftR1.compose(ms);
            ms.dispose();
            Match m1test = bf.makeMatch(r1, morph1test);
            OrdinaryMorphism morph2primeTest = overlapMorph2prime.compose(targetIso);
            OrdinaryMorphism morph2test = L2iso.compose(morph2primeTest);
            Match m2test = bf.makeMatch(r2, morph2test);
            overlapMorph2prime.getTarget().unsetTransientAttrValues();
            result.add(m1test);
            result.add(m2test);
            result.add(targetIso);
            return result;
        }
        OrdinaryMorphism morph2primeTest = L2iso.compose(overlapMorph2prime);
        Match m2test = bf.makeMatch(r2, morph2primeTest);
        overlapMorph2prime.getTarget().unsetTransientAttrValues();
        result.add(overlapMorph1prime);
        result.add(m2test);
        result.add(null);
        return result;
    }

    private Pair<OrdinaryMorphism, OrdinaryMorphism> getIsomorphicOverlapping(Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapPairs, Pair<OrdinaryMorphism, OrdinaryMorphism> overlapPair) {
        Graph overlapGraph = ((OrdinaryMorphism)overlapPair.first).getTarget();
        int j = 0;
        while (j < overlapPairs.size() && !this.stop) {
            Hashtable<GraphObject, GraphObject> partialMap;
            Pair<OrdinaryMorphism, OrdinaryMorphism> p1 = overlapPairs.elementAt(j);
            Graph g = ((OrdinaryMorphism)p1.first).getTarget();
            Vector<OrdinaryMorphism> overlapIsos = g.getIsomorphicWith(overlapGraph, partialMap = this.getMorphismMap((OrdinaryMorphism)p1.first, (OrdinaryMorphism)overlapPair.first));
            if (overlapIsos != null) {
                int i = 0;
                while (i < overlapIsos.size()) {
                    OrdinaryMorphism overlapIso = overlapIsos.get(i);
                    if (overlapIso != null && ((OrdinaryMorphism)p1.first).isIsomorphicTo((OrdinaryMorphism)overlapPair.first, overlapIso) && ((OrdinaryMorphism)p1.second).isIsomorphicTo((OrdinaryMorphism)overlapPair.second, overlapIso)) {
                        return p1;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return null;
    }

    private Hashtable<GraphObject, GraphObject> getMorphismMap(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>(m1.getSize());
        Enumeration<GraphObject> e = m1.getDomain();
        while (e.hasMoreElements()) {
            GraphObject o1 = e.nextElement();
            GraphObject o = m1.getImage(o1);
            GraphObject i = m2.getImage(o1);
            if (o == null || i == null) continue;
            map.put(o, i);
        }
        return map;
    }

    @Override
    public int getNumberOfContainers() {
        return 2;
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getExcludeContainer() {
        return this.excludeContainer;
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getConflictContainer() {
        return this.excludeContainer;
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getConflictFreeContainer() {
        return this.conflictFreeContainer;
    }

    @Override
    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getContainer(int kind) throws InvalidAlgorithmException {
        if (!this.isComputed && !this.stop) {
            this.fillContainers();
        }
        if (kind == 0) {
            return this.excludeContainer;
        }
        if (kind == 3) {
            return this.conflictFreeContainer;
        }
        throw new InvalidAlgorithmException("No such algorithm", kind);
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getContainer(int kind, List<Rule> ruleList, boolean asymmetrical) throws InvalidAlgorithmException {
        if (!this.isComputed) {
            this.fillContainers(ruleList, asymmetrical);
        }
        if (kind == 0) {
            return this.excludeContainer;
        }
        if (kind == 3) {
            return this.conflictFreeContainer;
        }
        throw new InvalidAlgorithmException("No such algorithm", kind);
    }

    public Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> getContainer(int kind, Rule r1, Rule r2) throws InvalidAlgorithmException {
        this.isComputedLocal = this.isComputed;
        if (!this.isComputedLocal) {
            if (kind == 3 && this.conflictFreeContainer != null && this.conflictFreeContainer.containsKey(r1)) {
                this.isComputedLocal = true;
            } else if ((kind == 0 || kind == 0) && this.excludeContainer != null && this.excludeContainer.containsKey(r1)) {
                this.isComputedLocal = true;
            }
        }
        if (!this.isComputedLocal && !this.stop) {
            this.fillContainers(r1, r2);
        }
        if (kind == 0) {
            return this.excludeContainer;
        }
        if (kind == 3) {
            return this.conflictFreeContainer;
        }
        throw new InvalidAlgorithmException("No such algorithm", kind);
    }

    @Override
    public Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalSet(int kind, Rule rule) throws InvalidAlgorithmException {
        return this.getCriticalSet(this.getContainer(kind), rule);
    }

    private Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getCriticalSet(Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container, Rule rule) {
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> resultVector = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
        Vector<Vector> tmpVector = new Vector<Vector>();
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> value = container.get(rule);
        Enumeration<Rule> keys = value.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = value.get(key);
            if (!((Boolean)p.first).booleanValue()) continue;
            tmpVector.addElement((Vector)p.second);
        }
        int i = 0;
        while (i < tmpVector.size()) {
            Vector element = (Vector)tmpVector.elementAt(i);
            int j = 0;
            while (j < element.size()) {
                resultVector.addElement((Pair)element.elementAt(j));
                ++j;
            }
            ++i;
        }
        return resultVector;
    }

    @Override
    public void setGrammar(GraGra gragra) {
        this.grammar = gragra;
        if (this.grammar != null) {
            if (this.grammar.getMorphismCompletionStrategy() != null) {
                this.strategy = (MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone();
            }
            this.setRules(this.grammar.getRulesWithIntegratedRulesOfRuleScheme());
        }
    }

    @Override
    public GraGra getGrammar() {
        return this.grammar;
    }

    @Override
    public void setRules(List<Rule> ruleList) {
        if (this.storeMap == null) {
            this.storeMap = new Hashtable();
        } else {
            this.storeMap.clear();
        }
        BaseFactory.theFactory().replaceExprByVarInApplConds(ruleList, this.storeMap);
        this.rules = ruleList;
        this.rules2 = new Vector<Rule>(ruleList);
    }

    @Override
    public void setRules(List<Rule> ruleList, List<Rule> ruleList2) {
        if (this.storeMap == null) {
            this.storeMap = new Hashtable();
        } else {
            this.storeMap.clear();
        }
        this.rules = ruleList;
        this.rules2 = ruleList2;
        BaseFactory.theFactory().replaceExprByVarInApplConds(this.rules, this.storeMap);
        if (this.rules != this.rules2) {
            int i = 0;
            while (i < this.rules2.size()) {
                Rule r = this.rules2.get(i);
                if (!this.rules.contains(r)) {
                    BaseFactory.theFactory().replaceExprByVarInApplConds(r, this.storeMap);
                }
                ++i;
            }
        }
    }

    @Override
    public void restoreExprReplacedByVarInApplConds() {
        BaseFactory.theFactory().restoreExprByVarInApplConds(this.rules, this.storeMap);
        if (this.rules != this.rules2) {
            int i = 0;
            while (i < this.rules2.size()) {
                Rule r = this.rules2.get(i);
                if (!this.rules.contains(r)) {
                    BaseFactory.theFactory().restoreExprByVarInApplConds(r, this.storeMap);
                }
                ++i;
            }
        }
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    @Override
    public List<Rule> getRules2() {
        return this.rules2;
    }

    @Override
    public void setComputeAsymmetrical(boolean b) {
        this.asymmetrical = b;
    }

    @Override
    public void setMorphCompletionStrategy(MorphCompletionStrategy strat) {
        this.strategy = strat;
    }

    @Override
    public MorphCompletionStrategy getMorphCompletionStrategy() {
        return this.strategy;
    }

    @Override
    public void initAllContainer() {
        this.conflictFreeContainer = new Hashtable();
        this.excludeContainer = new Hashtable();
        this.commonContainer = new Hashtable();
    }

    protected void fillContainers() {
        if (this.useHostGraph && this.grammar != null) {
            this.grammar.getApplicableRules(this.testGraph, this.strategy);
        }
        if (!this.useHostGraph) {
            this.isComputed = false;
        }
        if ((this.rules == null || this.rules.isEmpty() || this.rules2 == null || this.rules2.isEmpty()) && this.grammar != null) {
            this.rules = new Vector<Rule>(this.grammar.getListOfRules());
            this.rules2 = new Vector<Rule>(this.grammar.getListOfRules());
        }
        boolean asymmetric = this.asymmetrical && this.rules.equals(this.rules2);
        int indx = 0;
        int j = 0;
        while (j < this.rules2.size() && !this.stop) {
            Rule r1 = this.rules2.get(j);
            if (asymmetric) {
                indx = j;
            }
            int i = indx;
            while (i < this.rules.size() && !this.stop) {
                Rule r2 = this.rules.get(i);
                this.scheduleForComputing(r1, r2);
                ++i;
            }
            ++j;
        }
        if (!this.useHostGraph && !this.stop) {
            this.isComputed = true;
        }
    }

    protected void fillContainers(List<Rule> ruleList, boolean asymmetric) {
        if (!this.useHostGraph) {
            this.isComputed = false;
        }
        Vector<Rule> ruleList2 = new Vector<Rule>();
        ruleList2.addAll(ruleList);
        int indx = 0;
        int j = 0;
        while (j < ruleList2.size() && !this.stop) {
            Rule r1 = (Rule)ruleList2.get(j);
            if (asymmetric) {
                indx = j;
            }
            int i = indx;
            while (i < ruleList.size() && !this.stop) {
                Rule r2 = ruleList.get(i);
                this.scheduleForComputing(r1, r2);
                ++i;
            }
            ++j;
        }
        if (!this.useHostGraph && !this.stop) {
            this.isComputed = true;
        }
    }

    protected void scheduleForComputing(Rule r1, Rule r2) {
        if (this.useHostGraph) {
            Entry entry = this.getEntry(r1, r2);
            int state = entry.state;
            if (state == 3 || state == 31 || state == 32) {
                if (r1.isApplicable() && r2.isApplicable()) {
                    if (this.computeCritical(r1, r2, this.testGraph)) {
                        this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1));
                    } else {
                        entry.status = 6;
                        this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0));
                    }
                } else {
                    entry.status = 6;
                    this.firePairEvent(new CriticalPairEvent(this, r1, r2, 2));
                }
            } else {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 2));
            }
            return;
        }
        if (this.ignoreIdenticalRules && r1 == r2) {
            this.addEntry(r1, r2, false, null);
            this.getEntry((Rule)r1, (Rule)r2).state = 4;
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, true, null);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            this.getEntry((Rule)r1, (Rule)r2).state = 1;
        }
        if (this.calculateParallel) {
            new ComputingThread(this, r1, r2);
        } else {
            this.computeCritical(r1, r2);
        }
    }

    protected void fillContainers(Rule r1, Rule r2) {
        this.isComputedLocal = false;
        if (this.getEntry((Rule)r1, (Rule)r2).state == 0) {
            this.getEntry((Rule)r1, (Rule)r2).state = 1;
        }
        this.computeCritical(r1, r2);
        this.isComputedLocal = true;
    }

    protected synchronized void computeCritical(Rule r1, Rule r2) {
        Entry e = this.getEntry(r1, r2);
        if (!r1.isEnabled() || !r2.isEnabled()) {
            e.state = 5;
            this.addEntry(r1, r2, false, null);
            this.addQuadruple(this.excludeContainer, r1, r2, false, null);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, false, null);
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  should not be computed."));
            return;
        }
        if (e.state == 1 || e.state == 0) {
            e.state = 2;
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            this.excludePair = !this.complete ? new SimpleExcludePair() : new ExcludePair();
            this.setOptionsOfExcludePair();
            Object overlapping = null;
            try {
                overlapping = this.excludePair.isCritical(0, r1, r2);
                e = this.getEntry(r1, r2, true);
                e.setProgressIndx(this.excludePair);
            }
            catch (InvalidAlgorithmException invalidAlgorithmException) {
                // empty catch block
            }
            this.usedM += this.excludePair.usedM;
            this.excludePair.dispose();
            this.excludePair = null;
            boolean critic = overlapping != null;
            this.addEntry(r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            this.addQuadruple(this.excludeContainer, r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
            this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
            if (overlapping != null) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
            } else {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
            }
        }
    }

    protected synchronized Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> continueComputeCriticalPair(Rule r1, Rule r2, Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container) {
        Entry e = this.getEntry(r1, r2, true);
        if (!e.isProgressIndexSet()) {
            return null;
        }
        e.state = 2;
        this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
        this.excludePair = !this.complete ? new SimpleExcludePair() : new ExcludePair();
        this.excludePair.setProgressIndx(e);
        this.setOptionsOfExcludePair();
        Object overlapping = null;
        try {
            overlapping = this.excludePair.isCritical(0, r1, r2);
            e = this.getEntry(r1, r2, true);
            e.setProgressIndx(this.excludePair);
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
        this.excludePair.dispose();
        this.excludePair = null;
        boolean critic = overlapping != null;
        this.addEntry(r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
        this.addQuadruple(this.excludeContainer, r1, r2, critic, (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)overlapping);
        this.addQuadruple(this.conflictFreeContainer, r1, r2, !critic, null);
        if (overlapping != null) {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 1, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have critical pairs"));
        } else {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, 0, "<" + r1.getName() + ">  and  <" + r2.getName() + ">  have not any critical pairs"));
        }
        this.firePairEvent(new CriticalPairEvent(this, r1, r2, "rule pair  [ " + r1.getName() + " , " + r2.getName() + " ]  done"));
        return this.getCriticalPair(r1, r2, container);
    }

    protected void setOptionsOfExcludePair() {
        this.excludePair.enableNACs(this.withNACs);
        this.excludePair.enablePACs(this.withPACs);
        this.excludePair.enableIgnoreIdenticalRules(this.ignoreIdenticalRules);
        this.excludePair.enableReduceSameMatch(this.reduceSameMatch);
        this.excludePair.enableConsistent(this.consistent, this.grammar);
        this.excludePair.enableStrongAttrCheck(this.strongAttrCheck);
        this.excludePair.enableEqualVariableNameOfAttrMapping(this.equalVariableNameOfAttrMapping);
        this.excludePair.enableReduce(this.reduce);
        this.excludePair.enableDirectlyStrictConfluent(this.directStrctCnfl);
        this.excludePair.enableDirectlyStrictConfluentUpToIso(this.directStrctCnflUpToIso);
        this.excludePair.setMorphismCompletionStrategy(this.grammar.getMorphismCompletionStrategy());
        this.excludePair.enableNamedObjectOnly(this.namedObjectOnly);
        this.excludePair.setMaxBoundOfCriticKind(this.maxBoundOfCriticKind);
    }

    @Override
    public void refreshOptions(CriticalPairOption op) {
        this.withNACs = op.nacsEnabled();
        this.withPACs = op.pacsEnabled();
        this.ignoreIdenticalRules = op.ignoreIdenticalRulesEnabled();
        this.reduceSameMatch = op.reduceSameMatchEnabled();
        this.consistent = op.consistentEnabled();
        this.strongAttrCheck = op.strongAttrCheckEnabled();
        this.equalVariableNameOfAttrMapping = op.equalVariableNameOfAttrMappingEnabled();
        this.reduce = op.reduceEnabled();
        this.directStrctCnfl = op.directlyStrictConflEnabled();
        this.directStrctCnflUpToIso = op.directlyStrictConflUpToIsoEnabled();
        this.namedObjectOnly = op.namedObjectEnabled();
        this.maxBoundOfCriticKind = op.getMaxBoundOfCriticKind();
    }

    protected synchronized boolean computeCritical(Rule r1, Rule r2, Graph g) {
        int state = this.getEntry((Rule)r1, (Rule)r2).state;
        if (state == 3 || state == 31 || state == 32) {
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "Computing critical rule pair  [  " + r1.getName() + "  ,  " + r2.getName() + "  ]"));
            if (this.checkCritical(r1, r2, g)) {
                this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + "> are critical on the host graph"));
                return true;
            }
            this.firePairEvent(new CriticalPairEvent(this, r1, r2, "<" + r1.getName() + ">  and  <" + r2.getName() + "> are not critical on the host graph"));
            return false;
        }
        return false;
    }

    protected synchronized void addQuadruple(Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> container, Rule r1, Rule r2, boolean critic, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlapping) {
        Hashtable<Object, Object> secondPart;
        if (container.containsKey(r1)) {
            secondPart = container.get(r1);
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = new Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>(critic, overlapping);
            secondPart.put(r2, p);
        } else {
            secondPart = new Hashtable();
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = new Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>(critic, overlapping);
            secondPart.put(r2, p);
            container.put(r1, secondPart);
        }
        Entry entry = this.getEntry(r1, r2, true);
        if (entry == null) {
            entry = this.addEntry(r1, r2, critic, overlapping);
            if (critic) {
                if (this.excludePair != null) {
                    if (!this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                        entry.setState(31);
                    } else if (this.excludePair.dependencyCond1 && this.excludePair.dependencyCond2) {
                        entry.setState(32);
                    }
                } else if (entry.state == 3 && entry.overlapping != null) {
                    entry.setState(this.getEntryState(overlapping));
                }
            }
        }
        if (r1.hasEnabledACs(false) || r2.hasEnabledACs(false)) {
            this.notCompleteComputable = true;
            System.out.println("( " + r1.getName() + "  ,  " + r2.getName() + " )" + "  CPA for rules with GACs is not yet supported.");
            entry.status = 8;
        }
    }

    private int getEntryState(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlapping) {
        int entryState = 3;
        boolean dependCond1 = false;
        boolean dependCond2 = false;
        int i = 0;
        while (i < overlapping.size()) {
            if (overlapping.get(i) != null) {
                String overlapGraphName = ((OrdinaryMorphism)((Pair)overlapping.get((int)i).first).first).getTarget().getName();
                if (overlapGraphName.indexOf("-switch-dependency") >= 0 || overlapGraphName.indexOf("deliver-delete-dependency") >= 0 || overlapGraphName.indexOf("forbid-produce-dependency") >= 0 || overlapGraphName.indexOf("deliver-change-dependency") >= 0 || overlapGraphName.indexOf("change-change-dependency") >= 0) {
                    dependCond2 = true;
                } else if (overlapGraphName.indexOf("-dependency") >= 0) {
                    dependCond1 = true;
                }
            } else {
                overlapping.remove(i);
                --i;
            }
            ++i;
        }
        if (!dependCond1 && dependCond2) {
            entryState = 31;
        } else if (dependCond1 && dependCond2) {
            entryState = 32;
        }
        return entryState;
    }

    protected synchronized Entry addEntry(Rule r1, Rule r2, boolean critical, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlapping) {
        Entry entry = this.getEntry(r1, r2);
        if (entry.state != 5 && entry.state != 4) {
            entry.state = 3;
        }
        entry.isCritical = critical;
        entry.overlapping = overlapping;
        this.isEmpty = false;
        return entry;
    }

    public synchronized Entry getEntry(Rule r1, Rule r2) {
        Entry entry;
        Hashtable<Rule, Entry> secondPart = this.commonContainer.get(r1);
        if (secondPart == null) {
            secondPart = new Hashtable();
            this.commonContainer.put(r1, secondPart);
        }
        if ((entry = secondPart.get(r2)) == null) {
            entry = new Entry();
            secondPart.put(r2, entry);
        }
        return entry;
    }

    public synchronized Entry getEntry(Rule r1, Rule r2, boolean alreadyExists) {
        Hashtable<Rule, Entry> secondPart = this.commonContainer.get(r1);
        if (secondPart == null) {
            if (alreadyExists) {
                return null;
            }
            secondPart = new Hashtable();
            this.commonContainer.put(r1, secondPart);
            Entry entry = new Entry();
            secondPart.put(r2, entry);
        }
        return secondPart.get(r2);
    }

    public synchronized Entry getEntryCopy(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        if (entry != null) {
            Entry entry1 = new Entry();
            entry1.isCritical = entry.isCritical;
            entry1.isRelationVisible = entry.isRelationVisible;
            entry1.isRuleVisible = entry.isRelationVisible;
            entry1.state = entry.state;
            entry1.status = entry.status;
            entry1.overlapping.addAll(entry.overlapping);
            return entry1;
        }
        return null;
    }

    public synchronized void clearEntry(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        if (entry != null) {
            if (this.excludeContainer.get(r1) != null) {
                Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p = this.excludeContainer.get(r1).get(r2);
                if (((Boolean)p.first).booleanValue()) {
                    Vector v = (Vector)p.second;
                    int i = 0;
                    while (i < v.size()) {
                        Pair cpi = (Pair)v.elementAt(i);
                        Pair cp = (Pair)cpi.first;
                        OrdinaryMorphism m1 = (OrdinaryMorphism)cp.first;
                        OrdinaryMorphism m2 = (OrdinaryMorphism)cp.second;
                        m1.dispose();
                        m2.dispose();
                        m1 = null;
                        m2 = null;
                        cp = null;
                        v.removeElementAt(i);
                        --i;
                        ++i;
                    }
                }
                this.excludeContainer.get(r1).remove(r2);
            }
            if (this.conflictFreeContainer != null && this.conflictFreeContainer.get(r1) != null) {
                this.conflictFreeContainer.get(r1).remove(r2);
            }
            if (this.commonContainer.get(r1) != null) {
                this.commonContainer.get(r1).remove(r2);
            }
            entry.clear();
        }
    }

    public synchronized void setEntryRelationVisible(Rule rule1, Rule rule2, boolean vis, boolean local) {
        Entry entry = this.getEntry(rule1, rule2, true);
        if (entry != null && entry.isCritical()) {
            entry.isRelationVisible = vis;
            if (!local) {
                if (vis) {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                } else {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                }
            }
        }
    }

    public synchronized void setEntryRuleVisible(Rule rule1, Rule rule2, boolean vis, boolean local, boolean context) {
        if (rule1 != rule2) {
            return;
        }
        Entry entry = this.getEntry(rule1, rule2, true);
        if (entry != null) {
            entry.isRuleVisible = vis;
            if (context) {
                Enumeration<Rule> keys = this.excludeContainer.keys();
                while (keys.hasMoreElements()) {
                    Entry entry1;
                    Rule r2;
                    Rule r1 = keys.nextElement();
                    if (r1 != rule1) continue;
                    Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
                    Enumeration<Rule> k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = k2.nextElement();
                        entry1 = this.getEntry(r1, r2);
                        entry1.isRelationVisible = vis;
                        if (vis) {
                            this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                            continue;
                        }
                        this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                    }
                    k2 = secondPart.keys();
                    while (k2.hasMoreElements()) {
                        r2 = k2.nextElement();
                        if (r2 == rule1) continue;
                        entry1 = this.getEntry(r2, r1);
                        entry1.isRelationVisible = vis;
                        if (vis) {
                            this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                            continue;
                        }
                        this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                    }
                    break block0;
                }
            }
            if (!local) {
                if (vis) {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 3));
                } else {
                    this.firePairEvent(new CriticalPairEvent(this, rule1, rule2, 4));
                }
            }
        }
    }

    public int getState(Rule r1, Rule r2) {
        return this.getEntry((Rule)r1, (Rule)r2).state;
    }

    public boolean reduceCriticalPairs() {
        boolean reduced = false;
        Enumeration<Rule> keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = keys.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
            Enumeration<Rule> k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                Rule r2 = k2.nextElement();
                Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
                Boolean b = (Boolean)pair.first;
                if (!b.booleanValue()) continue;
                Vector v = (Vector)pair.second;
                int size = v.size();
                boolean found = true;
                while (size > 0 && found) {
                    found = false;
                    int i = 0;
                    while (i < size) {
                        Pair p1i = (Pair)v.elementAt(i);
                        Pair p1 = (Pair)p1i.first;
                        int j = i + 1;
                        while (j < size) {
                            Pair p2i = (Pair)v.elementAt(j);
                            Pair p2 = (Pair)p2i.first;
                            Pair<OrdinaryMorphism, OrdinaryMorphism> p = this.checkIfSimilar(p1, p2);
                            if (p != null) {
                                boolean first = false;
                                if (p == p1) {
                                    first = true;
                                    --i;
                                }
                                --j;
                                found = true;
                                v.removeElement(p2i);
                                BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                                BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                                p = null;
                                p2i = null;
                                reduced = true;
                                size = v.size();
                                if (first) break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
        if (reduced) {
            this.firePairEvent(new ParserMessageEvent(this, "Reduction of critical pairs is done.  Please select a rule pair to see results."));
        } else {
            this.firePairEvent(new ParserMessageEvent(this, "Nothings to reduce."));
        }
        return reduced;
    }

    /*
     * WARNING - void declaration
     */
    private Pair<OrdinaryMorphism, OrdinaryMorphism> checkIfSimilar(Pair<OrdinaryMorphism, OrdinaryMorphism> p1, Pair<OrdinaryMorphism, OrdinaryMorphism> p2) {
        void var8_17;
        Graph overlap1 = ((OrdinaryMorphism)p1.first).getImage();
        int n1 = 0;
        for (GraphObject graphObject : overlap1.getNodesSet()) {
            if (!((OrdinaryMorphism)p1.first).getInverseImage(graphObject).hasMoreElements() && !((OrdinaryMorphism)p1.second).getInverseImage(graphObject).hasMoreElements()) continue;
            ++n1;
        }
        for (GraphObject graphObject : overlap1.getArcsSet()) {
            if (!((OrdinaryMorphism)p1.first).getInverseImage(graphObject).hasMoreElements() && !((OrdinaryMorphism)p1.second).getInverseImage(graphObject).hasMoreElements()) continue;
            ++n1;
        }
        Graph graph = ((OrdinaryMorphism)p2.first).getImage();
        int n2 = 0;
        for (GraphObject graphObject : graph.getNodesSet()) {
            if (!((OrdinaryMorphism)p2.first).getInverseImage(graphObject).hasMoreElements() && !((OrdinaryMorphism)p2.second).getInverseImage(graphObject).hasMoreElements()) continue;
            ++n2;
        }
        for (GraphObject graphObject : graph.getArcsSet()) {
            if (!((OrdinaryMorphism)p2.first).getInverseImage(graphObject).hasMoreElements() && !((OrdinaryMorphism)p2.second).getInverseImage(graphObject).hasMoreElements()) continue;
            ++n2;
        }
        if (n1 != n2) {
            return null;
        }
        Object var8_14 = null;
        OrdinaryMorphism first1 = (OrdinaryMorphism)p1.first;
        OrdinaryMorphism first2 = (OrdinaryMorphism)p2.first;
        OrdinaryMorphism second1 = (OrdinaryMorphism)p1.second;
        OrdinaryMorphism second2 = (OrdinaryMorphism)p2.second;
        if (overlap1.getSize() <= graph.getSize()) {
            if (ExcludePairHelper.checkIfMorphSimilar(overlap1, graph, first1, first2, second1, second2)) {
                Pair<OrdinaryMorphism, OrdinaryMorphism> pair = p2;
            }
        } else if (ExcludePairHelper.checkIfMorphSimilar(graph, overlap1, first2, first1, second2, second1)) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> pair = p1;
        }
        return var8_17;
    }

    public void checkConsistency() {
        boolean inconsistent = false;
        boolean cpExists = false;
        Enumeration<Rule> keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            Rule r1 = keys.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
            Enumeration<Rule> k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                Rule r2 = k2.nextElement();
                Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
                Boolean b = (Boolean)pair.first;
                if (!b.booleanValue()) continue;
                cpExists = true;
                Vector v = (Vector)pair.second;
                int size = v.size();
                int i = 0;
                while (i < size) {
                    Pair pi = (Pair)v.elementAt(i);
                    Pair p = (Pair)pi.first;
                    Graph g = ((OrdinaryMorphism)p.first).getImage();
                    if (!this.grammar.checkGraphConsistency(g)) {
                        inconsistent = true;
                        v.removeElement(pi);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                        BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                        p = null;
                        pi = null;
                        --i;
                        size = v.size();
                    }
                    ++i;
                }
                if (v.size() != 0) continue;
                this.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
            }
        }
        if (inconsistent) {
            this.firePairEvent(new ParserMessageEvent(this, "Consistency check of critical pairs is done.  Please select a rule pair to see results."));
        } else if (cpExists) {
            this.firePairEvent(new ParserMessageEvent(this, "All critical pairs were consistent."));
        } else {
            this.firePairEvent(new ParserMessageEvent(this, "There are no critical pairs."));
        }
    }

    protected void moveEntryFromExcludeToConflictFreeContainer(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        entry.isCritical = false;
        entry.overlapping = null;
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
        if (secondPart != null) {
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
            pair.first = false;
            pair.second = null;
            if (this.conflictFreeContainer != null) {
                this.conflictFreeContainer.put(r1, secondPart);
            }
        }
    }

    protected void removeEntryFromExcludeContainer(Rule r1, Rule r2) {
        Entry entry = this.getEntry(r1, r2, true);
        entry.isCritical = false;
        entry.overlapping = null;
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = this.excludeContainer.get(r1);
        if (secondPart != null) {
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
            pair.first = false;
            pair.second = null;
        }
    }

    protected boolean checkCritical(Rule r1, Rule r2, Graph testgraph) {
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> criticalOverlappings;
        if (this.strategy == null) {
            this.strategy = (MorphCompletionStrategy)CompletionStrategySelector.getDefault().clone();
        }
        if ((criticalOverlappings = this.getCriticalPair(r1, r2, this.excludeContainer)) == null) {
            return false;
        }
        boolean critical = false;
        Hashtable<String, OrdinaryMorphism> overlapGraphIsos = new Hashtable<String, OrdinaryMorphism>(5);
        Hashtable<String, Pair<OrdinaryMorphism, OrdinaryMorphism>> criticalMatches = this.getLHSoverlappings(r1, r2, criticalOverlappings, overlapGraphIsos);
        int j = 0;
        while (j < criticalOverlappings.size()) {
            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> criticalOverlap = criticalOverlappings.elementAt(j);
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = criticalMatches.get(String.valueOf(criticalOverlap.hashCode()));
            if (p != null) {
                Graph overlapG = ((OrdinaryMorphism)p.first).getImage();
                Pair p1 = (Pair)criticalOverlap.first;
                Pair p2 = (Pair)criticalOverlap.second;
                Vector mvec = new Vector();
                OrdinaryMorphism m = BaseFactory.theFactory().createMorphism(overlapG, testgraph);
                OrdinaryMorphism overlapGraphIsom = overlapGraphIsos.get(String.valueOf(criticalOverlap.hashCode()));
                m.setCompletionStrategy(this.strategy);
                boolean hasCompletion = false;
                while (m.nextCompletionWithConstantsChecking()) {
                    Match m2test;
                    Match m1test;
                    hasCompletion = true;
                    boolean match2Critical = false;
                    if (((OrdinaryMorphism)p1.first).getSource() == r1.getLeft()) {
                        m1test = this.isCriticalMatchValidAtGraph(r1, (OrdinaryMorphism)p1.first, m);
                        if (m1test != null && ((OrdinaryMorphism)p1.second).getSource() == r2.getLeft() && (m2test = this.isCriticalMatchValidAtGraph(r2, (OrdinaryMorphism)p1.second, m)) != null) {
                            if (((OrdinaryMorphism)p1.first).getTarget().getName().indexOf("-attr-conflict") >= 0) {
                                if (!this.applyRule1Match1CheckMatch2(r1, m1test, r2, m2test)) {
                                    match2Critical = true;
                                }
                            } else {
                                match2Critical = true;
                            }
                        }
                    } else if (((OrdinaryMorphism)p1.first).getSource() == r1.getRight() && (m1test = this.isCriticalMatchValidAtGraph(r1, (OrdinaryMorphism)p.first, m)) != null && (m2test = this.isCriticalMatchValidAtGraph(r2, (OrdinaryMorphism)p.second, m)) != null && !this.applyRule1Match1CheckMatch2NACs(r1, m1test, r2, m2test)) {
                        match2Critical = true;
                    }
                    if (!match2Critical) continue;
                    critical = true;
                    Hashtable<GraphObject, GraphObject> objs = new Hashtable<GraphObject, GraphObject>();
                    Enumeration<GraphObject> e = m.getDomain();
                    while (e.hasMoreElements()) {
                        GraphObject o = e.nextElement();
                        GraphObject img = m.getImage(o);
                        if (overlapGraphIsom != null) {
                            Enumeration<GraphObject> invs = overlapGraphIsom.getInverseImage(o);
                            if (invs.hasMoreElements()) {
                                GraphObject objN2;
                                Enumeration<GraphObject> lhs2;
                                GraphObject or1;
                                Enumeration<GraphObject> lhs1;
                                GraphObject orig = invs.nextElement();
                                if (orig == null || img == null || ((OrdinaryMorphism)p1.first).getSource() != r1.getRight()) continue;
                                boolean added = false;
                                Enumeration<GraphObject> rhs1 = ((OrdinaryMorphism)p1.first).getInverseImage(orig);
                                if (rhs1.hasMoreElements() && (lhs1 = r1.getInverseImage(or1 = rhs1.nextElement())).hasMoreElements()) {
                                    objs.put(orig, img);
                                    added = true;
                                }
                                if (added || p2 == null || p2.first == null) continue;
                                OrdinaryMorphism isoL2 = (OrdinaryMorphism)p2.first;
                                Enumeration<GraphObject> objsN2 = ((OrdinaryMorphism)p1.second).getInverseImage(orig);
                                if (!objsN2.hasMoreElements() || !(lhs2 = isoL2.getInverseImage(objN2 = objsN2.nextElement())).hasMoreElements()) continue;
                                objs.put(orig, img);
                                continue;
                            }
                            objs.put(o, img);
                            continue;
                        }
                        if (o == null || img == null) continue;
                        objs.put(o, img);
                    }
                    if (objs.isEmpty() && !m.getSource().isEmpty()) continue;
                    mvec.add(objs);
                }
                if (!mvec.isEmpty()) {
                    if (p2 != null && overlapGraphIsos.get(String.valueOf(criticalOverlap.hashCode())) != null) {
                        overlapG = overlapGraphIsos.get(String.valueOf(criticalOverlap.hashCode())).getOriginal();
                        this.excludeContainerForTestGraph.put(overlapG, mvec);
                    } else {
                        this.excludeContainerForTestGraph.put(overlapG, mvec);
                    }
                }
                if (!hasCompletion) {
                    BaseFactory.theFactory().destroyMorphism(m);
                    m = null;
                }
            }
            ++j;
        }
        return critical;
    }

    private boolean applyRule1Match1CheckMatch2(Rule r1, Match m1test, Rule r2, Match m2test) {
        if (!m1test.getTarget().isAttributed()) {
            return true;
        }
        boolean attrsOK = true;
        OrdinaryMorphism isoG = m1test.getTarget().isomorphicCopy();
        if (isoG == null) {
            return false;
        }
        Match m1 = BaseFactory.theFactory().createMatch(r1, isoG.getTarget());
        if (m1.doCompose(m1test, isoG)) {
            m1.setCompletionStrategy(this.strategy, true);
            OrdinaryMorphism com1 = null;
            try {
                com1 = (OrdinaryMorphism)TestStep.execute(m1);
            }
            catch (TypeException ex) {
                m1.dispose();
                m1 = null;
                return true;
            }
            if (com1 != null) {
                Enumeration<GraphObject> dom2 = m2test.getDomain();
                while (dom2.hasMoreElements()) {
                    GraphObject img2;
                    GraphObject o = dom2.nextElement();
                    GraphObject img1 = m2test.getImage(o);
                    if (img1.compareTo(img2 = isoG.getImage(img1))) continue;
                    attrsOK = false;
                    break;
                }
                if (attrsOK) {
                    Match m2 = BaseFactory.theFactory().createMatch(r2, isoG.getTarget());
                    if (m2.doCompose(m2test, isoG) && m2.areTotalIdentDanglSatisfied()) {
                        List<OrdinaryMorphism> nacs2 = r2.getNACsList();
                        int l = 0;
                        while (l < nacs2.size()) {
                            OrdinaryMorphism nac2 = nacs2.get(l);
                            OrdinaryMorphism nac2Star = (OrdinaryMorphism)m2.checkNAC(nac2);
                            if (nac2Star != null) {
                                attrsOK = false;
                                nac2Star.dispose();
                                break;
                            }
                            ++l;
                        }
                    }
                    m2.dispose();
                }
                com1.dispose();
            }
        }
        m1.dispose();
        isoG.dispose();
        return attrsOK;
    }

    private boolean applyRule1Match1CheckMatch2NACs(Rule r1, Match m1test, Rule r2, Match m2test) {
        if (!m1test.getTarget().isAttributed()) {
            return true;
        }
        OrdinaryMorphism isoG = m1test.getTarget().isomorphicCopy();
        if (isoG == null) {
            return false;
        }
        Match m1 = BaseFactory.theFactory().createMatch(r1, isoG.getTarget());
        if (m1.doCompose(m1test, isoG)) {
            m1.setCompletionStrategy(this.strategy, true);
            OrdinaryMorphism com1 = null;
            try {
                com1 = (OrdinaryMorphism)TestStep.execute(m1);
            }
            catch (TypeException ex) {
                m1.dispose();
                m1 = null;
                return true;
            }
            if (com1 != null) {
                Match m2 = BaseFactory.theFactory().createMatch(r2, isoG.getTarget());
                if (m2.doCompose(m2test, isoG) && m2.areTotalIdentDanglSatisfied()) {
                    List<OrdinaryMorphism> nacs2 = r2.getNACsList();
                    int l = 0;
                    while (l < nacs2.size()) {
                        OrdinaryMorphism nac2 = nacs2.get(l);
                        OrdinaryMorphism nac2Star = (OrdinaryMorphism)m2.checkNAC(nac2);
                        if (nac2Star != null) {
                            Enumeration<GraphObject> nac2StarCodom = nac2Star.getCodomain();
                            while (nac2StarCodom.hasMoreElements()) {
                                GraphObject preimg;
                                GraphObject o = nac2StarCodom.nextElement();
                                Enumeration<GraphObject> preimgR1 = com1.getInverseImage(o);
                                if (!preimgR1.hasMoreElements() || r1.getInverseImage(preimg = preimgR1.nextElement()).hasMoreElements()) continue;
                                nac2Star.dispose();
                                com1.dispose();
                                m1.dispose();
                                m2.dispose();
                                isoG.dispose();
                                return false;
                            }
                        }
                        ++l;
                    }
                }
                com1.dispose();
                m2.dispose();
            }
        }
        m1.dispose();
        isoG.dispose();
        return true;
    }

    private Match isCriticalMatchValidAtGraph(Rule r, OrdinaryMorphism criticalMorph, OrdinaryMorphism testMorph) {
        boolean result = true;
        Match testMatch = BaseFactory.theFactory().createMatch(r, testMorph.getTarget());
        Iterator<Node> rLHSnodes = r.getLeft().getNodesSet().iterator();
        while (result && rLHSnodes.hasNext()) {
            Node orig = rLHSnodes.next();
            Node img = (Node)testMorph.getImage(criticalMorph.getImage(orig));
            if (img == null) continue;
            try {
                testMatch.addMapping(orig, img);
            }
            catch (BadMappingException ex) {
                result = false;
            }
        }
        for (Arc orig : r.getLeft().getArcsSet()) {
            Arc img = (Arc)testMorph.getImage(criticalMorph.getImage(orig));
            if (img == null) continue;
            try {
                testMatch.addMapping(orig, img);
            }
            catch (BadMappingException ex) {
                result = false;
            }
        }
        if (!(!result || testMatch.nextCompletion() && testMatch.isValid())) {
            result = false;
        }
        if (!result) {
            testMatch.dispose();
            testMatch = null;
        }
        return testMatch;
    }

    public Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> getExcludeContainerForTestGraph() {
        return this.excludeContainerForTestGraph;
    }

    @Override
    public void clear() {
        Rule r1 = null;
        Enumeration<Rule> keys1 = this.excludeContainer.keys();
        while (keys1.hasMoreElements()) {
            r1 = keys1.nextElement();
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> table2 = this.excludeContainer.get(r1);
            Enumeration<Rule> keys2 = table2.keys();
            while (keys2.hasMoreElements()) {
                Rule r2 = keys2.nextElement();
                this.clearEntry(r1, r2);
            }
        }
        this.excludeContainerForTestGraph.clear();
        this.useHostGraph = false;
        this.testGraph = null;
        this.isComputed = false;
        this.isComputedLocal = false;
        this.isEmpty = true;
        this.firePairEvent(new CriticalPairEvent(this, null, null, 71));
    }

    protected void writeOverlapMorphisms(XMLHelper h, Rule r1, Rule r2, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> overlapping) {
        Pair p1 = (Pair)overlapping.first;
        OrdinaryMorphism first = (OrdinaryMorphism)p1.first;
        h.openSubTag("Morphism");
        h.addAttr("name", first.getName());
        if (first.getSource() == r1.getLeft()) {
            h.addAttr("source", "LHS");
        } else if (first.getSource() == r1.getRight()) {
            h.addAttr("source", "RHS");
        }
        Enumeration<GraphObject> e = first.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", first.getImage(s), false);
            h.close();
        }
        h.close();
        OrdinaryMorphism second = (OrdinaryMorphism)p1.second;
        Pair p2 = (Pair)overlapping.second;
        if (p2 == null) {
            if (second.getSource() == r2.getLeft()) {
                h.openSubTag("Morphism");
                h.addAttr("name", second.getName());
                h.addAttr("source", "LHS");
                e = second.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject s = e.nextElement();
                    h.openSubTag("Mapping");
                    h.addObject("orig", s, false);
                    h.addObject("image", second.getImage(s), false);
                    h.close();
                }
            }
        } else {
            OrdinaryMorphism morphL2iso = (OrdinaryMorphism)p2.first;
            OrdinaryMorphism morphNAC2iso = (OrdinaryMorphism)p2.second;
            h.openSubTag("Morphism");
            h.addAttr("name", second.getName());
            h.addAttr("source", "NAC+LHS");
            e = second.getDomain();
            while (e.hasMoreElements()) {
                GraphObject src = e.nextElement();
                GraphObject t = second.getImage(src);
                GraphObject s = null;
                if (morphL2iso.getInverseImage(src).hasMoreElements()) {
                    s = morphL2iso.getInverseImage(src).nextElement();
                } else if (morphNAC2iso.getInverseImage(src).hasMoreElements()) {
                    s = morphNAC2iso.getInverseImage(src).nextElement();
                }
                if (s == null) continue;
                h.openSubTag("Mapping");
                h.addObject("orig", s, false);
                h.addObject("image", t, false);
                h.close();
            }
        }
        h.close();
    }

    protected Pair<OrdinaryMorphism, OrdinaryMorphism> readOldOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, String firstName, Graph overlapGraph) {
        OrdinaryMorphism first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
        OrdinaryMorphism second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
        first.setName(firstName.replaceAll(" ", ""));
        while (h.readSubTag("Mapping")) {
            GraphObject o = (GraphObject)h.getObject("orig", null, false);
            GraphObject i = (GraphObject)h.getObject("image", null, false);
            if (o != null && i != null) {
                first.addMapping(o, i);
            }
            h.close();
        }
        h.close();
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            second.setName(name.replaceAll(" ", ""));
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    second.addMapping(o, i);
                }
                h.close();
            }
            h.close();
        }
        return new Pair<OrdinaryMorphism, OrdinaryMorphism>(first, second);
    }

    protected Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> readOverlappingMorphisms(XMLHelper h, Rule r1, Rule r2, Graph overlapGraph) {
        Pair<Pair<Object, Object>, Object> result = null;
        OrdinaryMorphism first = null;
        OrdinaryMorphism second = null;
        Pair<OrdinaryMorphism, OrdinaryMorphism> p = null;
        Pair<Object, Object> p1 = null;
        Pair<OrdinaryMorphism, Object> p2 = null;
        if (h.readSubTag("Morphism")) {
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("")) {
                p = this.readOldOverlappingMorphisms(h, r1, r2, name, overlapGraph);
                return new Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Object>(p, null);
            }
            if (source.equals("LHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getLeft(), overlapGraph);
            } else if (source.equals("RHS")) {
                first = BaseFactory.theFactory().createMorphism(r1.getRight(), overlapGraph);
            }
            if (first != null) {
                first.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        first.addMapping(o, i);
                    }
                    h.close();
                }
            }
            h.close();
        }
        if (h.readSubTag("Morphism")) {
            OrdinaryMorphism morphL2iso = null;
            OrdinaryMorphism morphNAC2iso = null;
            String name = h.readAttr("name");
            String source = h.readAttr("source");
            if (source.equals("LHS")) {
                second = BaseFactory.theFactory().createMorphism(r2.getLeft(), overlapGraph);
            } else if (source.equals("NAC+LHS")) {
                OrdinaryMorphism nac = null;
                List<OrdinaryMorphism> nacs = r2.getNACsList();
                int l = 0;
                while (l < nacs.size()) {
                    OrdinaryMorphism n = nacs.get(l);
                    if (overlapGraph.getHelpInfoAboutNAC().indexOf(n.getName()) != -1) {
                        nac = n;
                        break;
                    }
                    ++l;
                }
                morphL2iso = r2.getLeft().isomorphicCopy();
                if (morphL2iso != null) {
                    morphNAC2iso = this.extendLeftGraph(morphL2iso, nac);
                }
                Graph N2 = morphL2iso.getTarget();
                second = BaseFactory.theFactory().createMorphism(N2, overlapGraph);
            }
            if (second != null) {
                second.setName(name.replaceAll(" ", ""));
                while (h.readSubTag("Mapping")) {
                    GraphObject o = (GraphObject)h.getObject("orig", null, false);
                    GraphObject i = (GraphObject)h.getObject("image", null, false);
                    if (o != null && i != null) {
                        if (source.equals("LHS")) {
                            second.addMapping(o, i);
                        } else if (source.equals("NAC+LHS")) {
                            GraphObject s = null;
                            if (morphL2iso != null) {
                                s = morphL2iso.getImage(o);
                            }
                            if (s == null && morphNAC2iso != null) {
                                s = morphNAC2iso.getImage(o);
                            }
                            if (s != null) {
                                second.addMapping(s, i);
                            }
                        }
                    }
                    h.close();
                }
                if (source.equals("NAC+LHS")) {
                    p2 = new Pair<OrdinaryMorphism, Object>(morphL2iso, morphNAC2iso);
                }
            }
            h.close();
        }
        if (first != null && second != null) {
            p1 = new Pair<Object, Object>(first, second);
            result = new Pair<Pair<Object, Object>, Object>(p1, p2);
        }
        return result;
    }

    private OrdinaryMorphism extendLeftGraph(OrdinaryMorphism isoLeft, OrdinaryMorphism nac) {
        if (isoLeft == null || nac == null) {
            return null;
        }
        Graph extLeft = isoLeft.getTarget();
        OrdinaryMorphism isoNAC = BaseFactory.theFactory().createMorphism(nac.getTarget(), extLeft);
        Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
        for (GraphObject graphObject : nac.getTarget().getNodesSet()) {
            if (!nac.getInverseImage(graphObject).hasMoreElements()) {
                try {
                    Node n = extLeft.copyNode((Node)graphObject);
                    tmp.put((Node)graphObject, n);
                    isoNAC.addMapping(graphObject, n);
                }
                catch (TypeException n) {}
                continue;
            }
            isoNAC.addMapping(graphObject, isoLeft.getImage(nac.getInverseImage(graphObject).nextElement()));
        }
        for (GraphObject graphObject : nac.getTarget().getArcsSet()) {
            if (!nac.getInverseImage(graphObject).hasMoreElements()) {
                Node tar;
                Node src = (Node)tmp.get(((Arc)graphObject).getSource());
                if (src == null) {
                    src = (Node)isoLeft.getImage(nac.getInverseImage(((Arc)graphObject).getSource()).nextElement());
                }
                if ((tar = (Node)tmp.get(((Arc)graphObject).getTarget())) == null) {
                    tar = (Node)isoLeft.getImage(nac.getInverseImage(((Arc)graphObject).getTarget()).nextElement());
                }
                try {
                    Arc a = extLeft.copyArc((Arc)graphObject, src, tar);
                    isoNAC.addMapping(graphObject, a);
                }
                catch (TypeException typeException) {}
                continue;
            }
            isoNAC.addMapping(graphObject, isoLeft.getImage(nac.getInverseImage(graphObject).nextElement()));
        }
        return isoNAC;
    }

    protected void resetRules(List<Rule> list, List<Rule> list2) {
        if (list != null && !list.isEmpty()) {
            if (this.rules == null) {
                this.rules = new Vector<Rule>();
            } else {
                this.rules.clear();
            }
            this.rules.addAll(list);
        }
        if (list2 != null && !list2.isEmpty()) {
            if (this.rules2 == null) {
                this.rules2 = new Vector<Rule>();
            } else {
                this.rules2.clear();
            }
            this.rules2.addAll(list2);
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        Boolean b;
        Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p;
        Rule r2;
        Enumeration<Rule> k2;
        Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart;
        Rule r1;
        h.openNewElem("CriticalPairs", this);
        h.addObject("GraGra", this.getGrammar(), true);
        h.openSubTag("conflictsContainer");
        h.addAttr("kind", "exclude");
        Enumeration<Rule> keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = this.excludeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                if (b.booleanValue()) {
                    Vector v = (Vector)p.second;
                    int i = 0;
                    while (i < v.size()) {
                        h.openSubTag("Overlapping_Pair");
                        Pair p2i = (Pair)v.elementAt(i);
                        Pair p2 = (Pair)p2i.first;
                        OrdinaryMorphism first = (OrdinaryMorphism)p2.first;
                        Graph overlapping = first.getImage();
                        h.addObject("", overlapping, true);
                        for (GraphObject graphObject : overlapping.getNodesSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        for (GraphObject graphObject : overlapping.getArcsSet()) {
                            if (!graphObject.isCritical()) continue;
                            h.openSubTag("Critical");
                            h.addObject("object", graphObject, false);
                            h.close();
                        }
                        this.writeOverlapMorphisms(h, r1, r2, p2i);
                        h.close();
                        ++i;
                    }
                }
                h.close();
            }
            h.close();
        }
        h.close();
        h.openSubTag("conflictFreeContainer");
        keys = this.excludeContainer.keys();
        while (keys.hasMoreElements()) {
            r1 = keys.nextElement();
            h.openSubTag("Rule");
            h.addObject("R1", r1, false);
            secondPart = this.conflictFreeContainer.get(r1);
            k2 = secondPart.keys();
            while (k2.hasMoreElements()) {
                r2 = k2.nextElement();
                h.openSubTag("Rule");
                h.addObject("R2", r2, false);
                p = secondPart.get(r2);
                b = (Boolean)p.first;
                h.addAttr("bool", b.toString());
                h.close();
            }
            h.close();
        }
        h.close();
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("CriticalPairs", this)) {
            String bool;
            Enumeration<Element> r2s;
            Enumeration<Element> r1s;
            Rule r1 = null;
            Rule r2 = null;
            boolean b = false;
            Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> allOverlappings = null;
            Vector<String> tagnames = new Vector<String>(1);
            Vector<String> tagnames2 = new Vector<String>(1);
            this.grammar = BaseFactory.theFactory().createGraGra();
            h.getObject("", this.grammar, true);
            tagnames.add("conflictContainer");
            tagnames.add("conflictsContainer");
            tagnames.add("excludeContainer");
            tagnames2.add("dependencyContainer");
            tagnames2.add("dependenciesContainer");
            if (h.readSubTag(tagnames)) {
                String kind = h.readAttr("kind");
                this.conflictKind = 0;
            } else if (h.readSubTag(tagnames2)) {
                this.conflictKind = 1;
                if (h.readAttr("kind").equals("trigger_switch_dependency")) {
                    this.conflictKind = 2;
                }
            }
            if (this.conflictKind == 0 || this.conflictKind == 1 || this.conflictKind == 2) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        allOverlappings = null;
                        if (bool.equals("true")) {
                            b = true;
                            allOverlappings = new Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>();
                            Enumeration<Element> overlappings = h.getEnumeration("", null, true, "Overlapping_Pair");
                            while (overlappings.hasMoreElements()) {
                                h.peekElement(overlappings.nextElement());
                                Graph g = (Graph)h.getObject("", BaseFactory.theFactory().createGraph(this.grammar.getTypeSet()), true);
                                while (h.readSubTag("Critical")) {
                                    GraphObject o = (GraphObject)h.getObject("object", null, false);
                                    if (o != null) {
                                        o.setCritical(true);
                                    }
                                    h.close();
                                }
                                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = this.readOverlappingMorphisms(h, r1, r2, g);
                                allOverlappings.addElement(p);
                                h.close();
                            }
                        }
                        this.addQuadruple(this.excludeContainer, r1, r2, b, allOverlappings);
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("conflictFreeContainer")) {
                r1s = h.getEnumeration("", null, true, "Rule");
                if (!r1s.hasMoreElements()) {
                    r1s = h.getEnumeration("", null, true, "Regel");
                }
                while (r1s.hasMoreElements()) {
                    h.peekElement(r1s.nextElement());
                    r1 = (Rule)h.getObject("R1", null, false);
                    r2s = h.getEnumeration("", null, true, "Rule");
                    if (!r2s.hasMoreElements()) {
                        r2s = h.getEnumeration("", null, true, "Regel");
                    }
                    while (r2s.hasMoreElements()) {
                        h.peekElement(r2s.nextElement());
                        r2 = (Rule)h.getObject("R2", null, false);
                        bool = h.readAttr("bool");
                        b = false;
                        if (bool.equals("true")) {
                            b = true;
                        }
                        this.addQuadruple(this.conflictFreeContainer, r1, r2, b, null);
                        if (!r1.isEnabled()) {
                            this.getEntry((Rule)r1, (Rule)r2).state = 5;
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
        }
        h.close();
    }

    public String toString() {
        String result = String.valueOf(super.toString()) + "\n" + this.getGrammar().toString() + "\n";
        result = String.valueOf(result) + "ConflictsContainer " + this.excludeContainer + "\n\n";
        result = String.valueOf(result) + "conflictFreeContainer " + this.conflictFreeContainer + "\n";
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public boolean isComputed() {
        return this.isComputed;
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    @Override
    public void addPairEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.addElement(l);
        }
    }

    public void removePairEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    protected synchronized void firePairEvent(ParserEvent event) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).parserEventOccured(event);
            ++i;
        }
    }

    public void enableComplete(boolean enable) {
        this.complete = enable;
        if (this.excludePair != null) {
            this.excludePair.enableComplete(enable);
        }
    }

    public void enableReduce(boolean enable) {
        this.reduce = enable;
    }

    public void enableReduceSameMatch(boolean enable) {
        this.reduceSameMatch = enable;
    }

    public void enableDirectlyStrictConfluent(boolean enable) {
        this.directStrctCnfl = enable;
    }

    public void enableDirectlyStrictConfluentUpToIso(boolean enable) {
        this.directStrctCnflUpToIso = enable;
    }

    public void enableNACs(boolean enable) {
        this.withNACs = enable;
    }

    public void enablePACs(boolean enable) {
        this.withPACs = enable;
    }

    public void enableConsistent(boolean enable) {
        this.consistent = enable;
    }

    public void enableStrongAttrCheck(boolean enable) {
        this.strongAttrCheck = enable;
    }

    public void enableNamedObjectOnly(boolean enable) {
        this.namedObjectOnly = enable;
    }

    public void enableMaxBoundOfCriticKind(int bound) {
        this.maxBoundOfCriticKind = bound;
    }

    public void enableEqualVariableNameOfAttrMapping(boolean enable) {
        this.equalVariableNameOfAttrMapping = enable;
    }

    public void enableUseHostGraph(boolean enable, Graph g, MorphCompletionStrategy strat) {
        this.useHostGraph = enable;
        this.excludeContainerForTestGraph.clear();
        if (this.useHostGraph) {
            this.testGraph = g;
            this.strategy = (MorphCompletionStrategy)strat.clone();
        } else {
            this.testGraph = null;
        }
    }

    @Override
    public void enableUseHostGraph(boolean enable, Graph g) {
        this.useHostGraph = enable;
        this.excludeContainerForTestGraph.clear();
        this.testGraph = this.useHostGraph ? g : null;
    }

    @Override
    public boolean useHostGraphEnabled() {
        return this.useHostGraph;
    }

    @Override
    public int getKindOfConflict() {
        return this.conflictKind;
    }

    @Override
    public LayerFunction getLayer() {
        return null;
    }

    public class Entry {
        public static final int NOT_SET = 0;
        public static final int SCHEDULED_FOR_COMPUTING = 1;
        public static final int COMPUTING_IS_RUNNING = 2;
        public static final int COMPUTED = 3;
        public static final int COMPUTED2 = 31;
        public static final int COMPUTED12 = 32;
        public static final int NOT_RELATED = 4;
        public static final int DISABLED = 5;
        public static final int NON_RELEVANT = 6;
        public static final int NOT_COMPUTABLE = 7;
        public static final int NOT_COMPLETE_COMPUTABLE = 8;
        boolean isCritical = false;
        boolean isRelationVisible = true;
        boolean isRuleVisible = true;
        int state = 0;
        int status = 0;
        int duIndx = -1;
        int pfIndx = -1;
        int caIndx = -1;
        String duIndxStr = "-1:";
        String pfIndxStr = "-1:-1:";
        String caIndxStr = "-1:";
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlapping;

        public boolean isCritical() {
            return this.isCritical;
        }

        public void setState(int s) {
            this.state = s == 1 || s == 2 || s == 3 || s == 31 || s == 32 ? s : 0;
        }

        public int getState() {
            return this.state;
        }

        public void setStatus(int s) {
            this.status = s;
        }

        public int getStatus() {
            return this.status;
        }

        public Vector<?> getOverlapping() {
            return this.overlapping;
        }

        public void setOverlapping(Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> v) {
            this.overlapping.addAll(v);
        }

        public boolean isRuleVisible() {
            return this.isRuleVisible;
        }

        public boolean isRelationVisible() {
            return this.isRelationVisible;
        }

        public void setProgressIndx(ExcludePair p) {
            this.duIndxStr = p.duIndxStr;
            this.pfIndxStr = p.pfIndxStr;
            this.caIndxStr = p.caIndxStr;
            try {
                this.duIndx = Integer.valueOf(this.duIndxStr.split(":")[0]);
                this.pfIndx = Integer.valueOf(this.pfIndxStr.split(":")[0]);
                this.caIndx = Integer.valueOf(this.caIndxStr.split(":")[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void unsetProgressIndx() {
            this.duIndx = -1;
            this.pfIndx = -1;
            this.caIndx = -1;
            this.duIndxStr = "-1:";
            this.pfIndxStr = "-1:-1:";
            this.caIndxStr = "-1:";
        }

        public void setIndexOfDelUseProgress(String indxStr) {
            try {
                this.duIndx = Integer.valueOf(indxStr.split(":")[0]);
                this.duIndxStr = indxStr;
            }
            catch (NumberFormatException ex) {
                this.duIndxStr = "-1:";
                this.duIndx = -1;
            }
            catch (ArrayIndexOutOfBoundsException ex1) {
                this.duIndxStr = "-1:";
                this.duIndx = -1;
            }
        }

        public void setIndexOfProdForbidProgress(String indxStr) {
            this.pfIndxStr = indxStr;
            try {
                this.pfIndx = Integer.valueOf(this.pfIndxStr.split(":")[0]);
                this.pfIndxStr = indxStr;
            }
            catch (NumberFormatException ex) {
                this.pfIndxStr = "-1:-1";
                this.pfIndx = -1;
            }
            catch (ArrayIndexOutOfBoundsException ex1) {
                this.pfIndxStr = "-1:-1";
                this.pfIndx = -1;
            }
        }

        public void setIndexOfChangeAttrProgress(String indxStr) {
            try {
                this.caIndx = Integer.valueOf(this.caIndxStr.split(":")[0]);
                this.caIndxStr = indxStr;
            }
            catch (NumberFormatException ex) {
                this.caIndxStr = "-1:";
                this.caIndx = -1;
            }
            catch (ArrayIndexOutOfBoundsException ex1) {
                this.caIndxStr = "-1:";
                this.caIndx = -1;
            }
        }

        public boolean isProgressIndexSet() {
            return this.duIndx != -1 || this.pfIndx != -1 || this.caIndx != -1;
        }

        public void clear() {
            this.isCritical = false;
            if (this.overlapping != null) {
                this.overlapping.clear();
            }
            this.overlapping = null;
            this.state = 0;
            this.status = 0;
            this.duIndx = -1;
            this.pfIndx = -1;
            this.caIndx = -1;
            this.duIndxStr = "-1:";
            this.pfIndxStr = "-1:-1:";
            this.caIndxStr = "-1:";
        }
    }
}

