/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.saveload;

import agg.gui.saveload.AGGFileFilter;
import agg.gui.saveload.ExtensionFileFilter;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class GraphicsExportJPEG {
    private JFileChooser folderchooser;
    private ExtensionFileFilter filterJPG;
    private String jpgPath = "";
    private Component parent;
    private float quality = 1.0f;
    private boolean cancelled = false;

    public GraphicsExportJPEG(Component parent) {
        this.parent = parent;
        this.folderchooser = new JFileChooser(System.getProperty("user.dir"));
        this.filterJPG = new AGGFileFilter("jpg", "JPEG Files (.jpg)");
        this.folderchooser.addChoosableFileFilter(this.filterJPG);
        this.folderchooser.setFileFilter(this.filterJPG);
    }

    public void setDirectory(String directory) {
        this.jpgPath = directory;
        if (!this.jpgPath.equals("")) {
            this.folderchooser = new JFileChooser(this.jpgPath);
            this.folderchooser.addChoosableFileFilter(this.filterJPG);
            this.folderchooser.setFileFilter(this.filterJPG);
        }
    }

    public String getDirectory() {
        return this.jpgPath;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getDirectoryForJPEGs(Component parentComp) {
        this.cancelled = false;
        this.folderchooser.setFileSelectionMode(1);
        int retval = this.folderchooser.showSaveDialog(parentComp);
        if (retval == 1) {
            this.cancelled = true;
            return null;
        }
        if (retval == 0) {
            this.jpgPath = this.folderchooser.getSelectedFile().getAbsolutePath();
        }
        return this.jpgPath;
    }

    public void setQuality(float q) {
        this.quality = q;
    }

    public boolean save(JComponent graphPanel) {
        String filename;
        int retval = this.folderchooser.showSaveDialog(this.parent);
        if (retval == 0) {
            this.jpgPath = this.folderchooser.getSelectedFile().isDirectory() ? this.folderchooser.getSelectedFile().getName() : (this.folderchooser.getSelectedFile().isFile() ? this.folderchooser.getSelectedFile().getParent() : this.folderchooser.getSelectedFile().getParent());
        } else {
            this.jpgPath = null;
            return false;
        }
        if (this.jpgPath.equals("")) {
            this.jpgPath = ".";
        }
        if (!(filename = this.folderchooser.getSelectedFile().getName()).endsWith(".jpg")) {
            filename = filename.concat(".jpg");
        }
        String name = String.valueOf(this.jpgPath) + File.separator + filename;
        return this.paintToJpg(graphPanel, name);
    }

    public boolean save(JComponent graphPanel, String filename) {
        if (!filename.endsWith(".jpg")) {
            return this.paintToJpg(graphPanel, filename.concat(".jpg"));
        }
        return this.paintToJpg(graphPanel, filename);
    }

    private boolean paintToJpg(JComponent graphPanel, String filename) {
        FileOutputStream fos;
        block3: {
            JComponent graphpanel = graphPanel;
            BufferedImage image = new BufferedImage(graphpanel.getWidth(), graphpanel.getHeight(), 1);
            Graphics2D imageg = image.createGraphics();
            graphpanel.paint(imageg);
            fos = new FileOutputStream(new File(filename));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fos);
            if (encoder == null) break block3;
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(this.quality, false);
            encoder.setJPEGEncodeParam(param);
            encoder.encode(image);
            fos.flush();
            fos.close();
            return true;
        }
        try {
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

