/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.saveload;

import agg.cons.AtomConstraint;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.IconResource;
import agg.gui.icons.NestedACIcon;
import agg.gui.icons.NewConclusionIcon;
import agg.gui.treeview.GraGraTreeView;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GraGraElementsStore
implements MouseListener {
    protected final Hashtable<EdGraGra, Hashtable<String, Vector<Object>>> storeGraGra;
    protected final Hashtable<EdRuleScheme, Vector<Object>> storeRuleScheme;
    protected final Hashtable<EdRule, Vector<Vector<Object>>> storeRule;
    protected final Hashtable<EdNestedApplCond, Vector<Object>> storeNestedAC;
    protected final Hashtable<EdAtomic, Vector<Object>> storeAtomConstraint;
    protected JPanel palette;
    private JScrollPane scrollPane;
    protected final Vector<JPanel> paletteElems;
    private JPanel panel;
    private final Hashtable<Object, JPanel> obj2panel;
    private final Hashtable<JLabel, Object> buttons;
    private JLabel label;
    private Object current;
    private boolean currentValid = false;
    protected JDialog d;
    private static final Color SelectedBackgroundColor = new Color(153, 153, 255);
    int x = -1;
    int y = -1;
    int lWeidth;
    private JButton trash;
    private GraGraTreeView treeView;

    public GraGraElementsStore(GraGraTreeView tree) {
        this.treeView = tree;
        this.storeGraGra = new Hashtable(5);
        this.storeRuleScheme = new Hashtable(5, 2.0f);
        this.storeRule = new Hashtable(5, 2.0f);
        this.storeNestedAC = new Hashtable(5, 2.0f);
        this.storeAtomConstraint = new Hashtable(5, 2.0f);
        this.paletteElems = new Vector(5);
        this.buttons = new Hashtable(5);
        this.obj2panel = new Hashtable(5);
    }

    public void setTrash(JButton aTrash) {
        this.trash = aTrash;
    }

    public boolean isEmpty() {
        return this.paletteElems.isEmpty();
    }

    public void storeGraph(EdGraGra parent, EdGraph g) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("GRAPH")) == null) {
            v = new Vector(1);
        }
        v.add(g);
        ht.put("GRAPH", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(g.getBasisGraph().getName(), g.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLGraph()));
        this.buttons.put(b, g);
        this.obj2panel.put(g, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeTypeGraph(EdGraGra parent, EdGraph g) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("TG")) == null) {
            v = new Vector(1);
        }
        v.add(g);
        ht.put("TG", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(g.getBasisGraph().getName(), g.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLTypeGraph()));
        this.buttons.put(b, g);
        this.obj2panel.put(g, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeRuleScheme(EdGraGra parent, EdRuleScheme rs) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("RULESCHEME")) == null) {
            v = new Vector(1);
        }
        v.add(rs);
        ht.put("RULESCHEME", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(rs.getBasisRuleScheme().getSchemeName(), rs.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLRuleScheme()));
        this.buttons.put(b, rs);
        this.obj2panel.put(rs, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeMultiRule(EdRuleScheme parent, EdRule mr) {
        Vector<Object> v = this.storeRuleScheme.get(parent);
        if (v == null) {
            v = new Vector(5);
        }
        v.add(mr);
        this.storeRuleScheme.put(parent, v);
        String name = this.makeName(mr.getBasisRule().getName(), parent.getBasisRuleScheme().getSchemeName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLRule()));
        this.buttons.put(b, mr);
        this.obj2panel.put(mr, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeRule(EdGraGra parent, EdRule r) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("RULE")) == null) {
            v = new Vector(1);
        }
        v.add(r);
        ht.put("RULE", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(r.getBasisRule().getName(), r.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLRule()));
        this.buttons.put(b, r);
        this.obj2panel.put(r, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeAtomConstraint(EdGraGra parent, EdAtomic c) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("ATOMIC")) == null) {
            v = new Vector(1);
        }
        v.add(c);
        ht.put("ATOMIC", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(c.getBasisAtomic().getAtomicName(), c.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLAtomic()));
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeConstraint(EdGraGra parent, EdConstraint c) {
        Vector<Object> v;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht == null) {
            ht = new Hashtable(5);
        }
        if ((v = ht.get("FORMULA")) == null) {
            v = new Vector(1);
        }
        v.add(c);
        ht.put("FORMULA", v);
        this.storeGraGra.put(parent, ht);
        String name = this.makeName(c.getBasisConstraint().getName(), c.getGraGra().getName(), "");
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLConstraint()));
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeNAC(EdRule parent, EdNAC nac) {
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v == null) {
            v = new Vector(3);
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
        }
        v.get(0).add(nac);
        this.storeRule.put(parent, v);
        String name = this.makeName(nac.getName(), nac.getRule().getBasisRule().getName(), nac.getRule().getGraGra().getName());
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLNAC()));
        this.buttons.put(b, nac);
        this.obj2panel.put(nac, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storePAC(EdRule parent, EdPAC pac) {
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v == null) {
            v = new Vector(3);
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
        }
        v.get(1).add(pac);
        this.storeRule.put(parent, v);
        String name = this.makeName(pac.getName(), pac.getRule().getBasisRule().getName(), pac.getRule().getGraGra().getName());
        int w = this.getNameLength(name);
        JLabel b = this.createButton(name, IconResource.getIconFromURL(IconResource.getURLPAC()));
        this.buttons.put(b, pac);
        this.obj2panel.put(pac, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeNestedAC(EdRule parent, EdNestedApplCond ac) {
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v == null) {
            v = new Vector(3);
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
            v.add(new Vector(2, 2));
        }
        v.get(2).add(ac);
        this.storeRule.put(parent, v);
        String name = this.makeName(ac.getName(), ac.getRule().getBasisRule().getName(), ac.getRule().getGraGra().getName());
        int w = this.getNameLength(name);
        NestedACIcon icon = new NestedACIcon(Color.blue);
        JLabel b = this.createButton(name, icon);
        this.buttons.put(b, ac);
        this.obj2panel.put(ac, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeNestedAC(EdNestedApplCond parent, EdNestedApplCond ac) {
        Vector<Object> v = this.storeNestedAC.get(parent);
        if (v == null) {
            v = new Vector(2, 2);
        }
        v.add(ac);
        this.storeNestedAC.put(parent, v);
        Vector<String> parNames = new Vector<String>(3);
        parNames.add(parent.getName());
        parNames.add(ac.getRule().getBasisRule().getName());
        parNames.add(ac.getRule().getGraGra().getName());
        String name = this.makeName(ac.getName(), parNames);
        int w = this.getNameLength(name);
        NestedACIcon icon = new NestedACIcon(Color.blue);
        JLabel b = this.createButton(name, icon);
        this.buttons.put(b, ac);
        this.obj2panel.put(ac, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public void storeAtomConclusion(EdAtomic parent, EdAtomic c) {
        Vector<Object> v = this.storeAtomConstraint.get(parent);
        if (v == null) {
            v = new Vector(5);
        }
        v.add(c);
        this.storeAtomConstraint.put(parent, v);
        String name = this.makeName(c.getBasisAtomic().getName(), c.getBasisAtomic().getAtomicName(), c.getGraGra().getName());
        int w = this.getNameLength(name);
        NewConclusionIcon icon = new NewConclusionIcon(Color.blue);
        icon.setEnabled(true);
        JLabel b = this.createButton(name, icon);
        this.buttons.put(b, c);
        this.obj2panel.put(c, this.paletteElems.lastElement());
        if (!this.trash.isEnabled()) {
            this.trash.setEnabled(true);
        }
        if (this.lWeidth < w) {
            this.lWeidth = w;
        }
        this.refreshStorePalette();
    }

    public EdGraph getTypeGraph(EdGraGra parent) {
        EdGraph g = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("TG");
            if (v != null && !v.isEmpty()) {
                g = (EdGraph)v.lastElement();
                v.remove(g);
                if (v.isEmpty()) {
                    ht.remove("TG");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return g;
    }

    public EdGraph getGraph(EdGraGra parent) {
        EdGraph g = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("GRAPH");
            if (v != null && !v.isEmpty()) {
                g = (EdGraph)v.lastElement();
                v.remove(g);
                if (v.isEmpty()) {
                    ht.remove("GRAPH");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return g;
    }

    public EdRule getRule(EdGraGra parent) {
        EdRule r = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("RULE");
            if (v != null && !v.isEmpty()) {
                r = (EdRule)v.lastElement();
                v.remove(r);
                if (v.isEmpty()) {
                    ht.remove("RULE");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return r;
    }

    public EdRuleScheme getRuleScheme(EdGraGra parent) {
        EdRuleScheme r = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("RULESCHEME");
            if (v != null && !v.isEmpty()) {
                r = (EdRuleScheme)v.lastElement();
                v.remove(r);
                if (v.isEmpty()) {
                    ht.remove("RULESCHEME");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return r;
    }

    public EdNAC getNAC(EdRule parent) {
        EdNAC n = null;
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v != null && !v.isEmpty()) {
            Vector<Object> vNAC = v.get(0);
            if (!vNAC.isEmpty()) {
                n = (EdNAC)vNAC.lastElement();
                vNAC.remove(n);
            }
            if (v.get(0).isEmpty() && v.get(1).isEmpty() && v.get(2).isEmpty()) {
                this.storeRule.remove(parent);
            }
            this.updateTrash();
        }
        return n;
    }

    public EdPAC getPAC(EdRule parent) {
        EdPAC p = null;
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v != null && !v.isEmpty()) {
            Vector<Object> vPAC = v.get(1);
            if (!vPAC.isEmpty()) {
                p = (EdPAC)vPAC.lastElement();
                vPAC.remove(p);
            }
            if (v.get(0).isEmpty() && v.get(1).isEmpty() && v.get(2).isEmpty()) {
                this.storeRule.remove(parent);
            }
            this.updateTrash();
        }
        return p;
    }

    public EdNestedApplCond getNestedAC(EdRule parent) {
        EdNestedApplCond p = null;
        Vector<Vector<Object>> v = this.storeRule.get(parent);
        if (v != null && !v.isEmpty()) {
            Vector<Object> nestedACs = v.lastElement();
            if (!nestedACs.isEmpty()) {
                p = (EdNestedApplCond)nestedACs.lastElement();
                nestedACs.remove(p);
            }
            if (v.get(0).isEmpty() && v.get(1).isEmpty() && v.get(2).isEmpty()) {
                this.storeRule.remove(parent);
            }
            this.updateTrash();
        }
        return p;
    }

    public EdNestedApplCond getNestedAC(EdNestedApplCond parent) {
        EdNestedApplCond p = null;
        Vector<Object> v = this.storeNestedAC.get(parent);
        if (v != null && !v.isEmpty()) {
            p = (EdNestedApplCond)v.lastElement();
            v.remove(v.size() - 1);
            if (v.isEmpty()) {
                this.storeNestedAC.remove(parent);
            }
            this.updateTrash();
        }
        return p;
    }

    public EdAtomic getAtomConstraint(EdGraGra parent) {
        EdAtomic a = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("ATOMIC");
            if (v != null && !v.isEmpty()) {
                a = (EdAtomic)v.lastElement();
                v.remove(a);
                if (v.isEmpty()) {
                    ht.remove("ATOMIC");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return a;
    }

    public EdAtomic getAtomConclusion(EdAtomic parent) {
        EdAtomic a = null;
        Vector<Object> v = this.storeAtomConstraint.get(parent);
        if (v != null && !v.isEmpty()) {
            a = (EdAtomic)v.lastElement();
            v.remove(a);
            if (v.isEmpty()) {
                this.storeAtomConstraint.remove(parent);
            }
            this.updateTrash();
        }
        return a;
    }

    public EdConstraint getConstraint(EdGraGra parent) {
        EdConstraint c = null;
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(parent);
        if (ht != null) {
            Vector<Object> v = ht.get("FORMULA");
            if (v != null && !v.isEmpty()) {
                c = (EdConstraint)v.lastElement();
                v.remove(c);
                if (v.isEmpty()) {
                    ht.remove("FORMULA");
                }
            }
            if (ht.isEmpty()) {
                this.storeGraGra.remove(parent);
            }
            this.updateTrash();
        }
        return c;
    }

    public void removeGraGra(EdGraGra gra) {
        EdAtomic a;
        Vector<Object> v;
        Enumeration<EdRule> e = this.storeRule.keys();
        while (e.hasMoreElements()) {
            EdRule r = e.nextElement();
            if (r.getGraGra() != gra) continue;
            v = this.storeRule.get(r);
            Vector<Object> nacs = v.firstElement();
            int i = 0;
            while (i < nacs.size()) {
                EdNAC nac = (EdNAC)nacs.get(i);
                this.removeFromTrashPalette(nac);
                OrdinaryMorphism nacMorph = nac.getMorphism();
                nac.dispose();
                nacMorph.dispose(false, true);
                ++i;
            }
            Vector pacs = (Vector)v.lastElement();
            int i2 = 0;
            while (i2 < pacs.size()) {
                EdPAC pac = (EdPAC)pacs.get(i2);
                this.removeFromTrashPalette(pac);
                OrdinaryMorphism pacMorph = pac.getMorphism();
                pac.dispose();
                pacMorph.dispose(false, true);
                ++i2;
            }
            v.clear();
            this.storeRule.remove(r);
            e = this.storeRule.keys();
        }
        e = this.storeAtomConstraint.keys();
        while (e.hasMoreElements()) {
            EdAtomic c = (EdAtomic)e.nextElement();
            if (c.getGraGra() != gra) continue;
            v = this.storeAtomConstraint.get(c);
            int i = 0;
            while (i < v.size()) {
                a = (EdAtomic)v.get(i);
                this.removeFromTrashPalette(a);
                AtomConstraint ba = a.getBasisAtomic();
                a.dispose();
                if (ba != null) {
                    ba.dispose();
                }
                ++i;
            }
            v.clear();
            this.storeAtomConstraint.remove(c);
            e = this.storeAtomConstraint.keys();
        }
        Hashtable<String, Vector<Object>> ht = this.storeGraGra.get(gra);
        if (ht != null) {
            v = ht.get("GRAPH");
            if (v != null) {
                int i = 0;
                while (i < v.size()) {
                    EdGraph g = (EdGraph)v.get(i);
                    this.removeFromTrashPalette(g);
                    Graph bg = g.getBasisGraph();
                    g.dispose();
                    if (bg != null) {
                        bg.dispose();
                    }
                    ++i;
                }
                v.clear();
            }
            if ((v = ht.get("RULE")) != null) {
                int i = 0;
                while (i < v.size()) {
                    EdRule r = (EdRule)v.get(i);
                    this.removeFromTrashPalette(r);
                    Rule br = r.getBasisRule();
                    r.dispose();
                    if (br != null) {
                        br.dispose();
                    }
                    ++i;
                }
                v.clear();
            }
            if ((v = ht.get("ATOMIC")) != null) {
                int i = 0;
                while (i < v.size()) {
                    a = (EdAtomic)v.get(i);
                    this.removeFromTrashPalette(a);
                    AtomConstraint ba = a.getBasisAtomic();
                    a.dispose();
                    if (ba != null) {
                        ba.dispose();
                    }
                    ++i;
                }
                v.clear();
            }
            if ((v = ht.get("FORMULA")) != null) {
                int i = 0;
                while (i < v.size()) {
                    EdConstraint c = (EdConstraint)v.get(i);
                    this.removeFromTrashPalette(c);
                    ++i;
                }
                v.clear();
            }
            if ((v = ht.get("TG")) != null) {
                int i = 0;
                while (i < v.size()) {
                    EdGraph tg = (EdGraph)v.get(i);
                    this.removeFromTrashPalette(tg);
                    Graph btg = tg.getBasisGraph();
                    tg.dispose();
                    if (btg != null) {
                        ((TypeGraph)btg).dispose();
                    }
                    ++i;
                }
                v.clear();
            }
            ht.clear();
        }
        this.storeGraGra.remove(gra);
        this.current = null;
        this.currentValid = false;
        this.updateTrash();
    }

    void updateTrash() {
        if (this.paletteElems.isEmpty()) {
            this.trash.setEnabled(false);
        } else {
            this.trash.setEnabled(true);
        }
    }

    private String makeName(String elem, String parent1, String parent2) {
        String res = "";
        if (elem.length() > 0) {
            if (parent1.length() > 0) {
                res = String.valueOf(elem) + " [" + parent1 + "]" + "  ";
            }
            if (parent2.length() > 0) {
                res = String.valueOf(elem) + " [" + parent1 + "]" + " [" + parent2 + "]" + "  ";
            }
        }
        return res;
    }

    private String makeName(String elem, List<String> parents) {
        String res = "";
        if (elem.length() > 0) {
            int i = 0;
            while (i < parents.size()) {
                String par = parents.get(i);
                res = String.valueOf(elem) + " [" + par + "]" + "  ";
                ++i;
            }
        }
        return res;
    }

    private int getNameLength(String name) {
        if (name.length() < 40) {
            return name.length() * 8 + 20;
        }
        return name.length() * 8;
    }

    private void propagateSelection(Object obj) {
        if (obj instanceof EdNAC) {
            this.getNAC(((EdNAC)obj).getRule());
        } else if (obj instanceof EdPAC) {
            this.getPAC(((EdPAC)obj).getRule());
        } else if (obj instanceof EdNestedApplCond) {
            if (((EdNestedApplCond)obj).getParent() == null) {
                this.getNestedAC(((EdNestedApplCond)obj).getRule());
            } else {
                this.getNestedAC(((EdNestedApplCond)obj).getParent());
            }
        } else if (obj instanceof EdGraph) {
            if (((EdGraph)obj).isTypeGraph()) {
                this.getTypeGraph(((EdGraph)obj).getGraGra());
            } else {
                this.getGraph(((EdGraph)obj).getGraGra());
            }
        } else if (obj instanceof EdAtomic) {
            if (((EdAtomic)obj).getParent() == (EdAtomic)obj) {
                this.getAtomConstraint(((EdAtomic)obj).getGraGra());
            } else {
                this.getAtomConclusion(((EdAtomic)obj).getParent());
            }
        } else if (obj instanceof EdRuleScheme) {
            this.getRuleScheme(((EdRuleScheme)obj).getGraGra());
        } else if (obj instanceof EdRule) {
            this.getRule(((EdRule)obj).getGraGra());
        } else if (obj instanceof EdConstraint) {
            this.getConstraint(((EdConstraint)obj).getGraGra());
        }
    }

    private JLabel createButton(String name, Icon icon) {
        JLabel l = new JLabel(name);
        l.setIcon(icon);
        JPanel p = new JPanel(new GridLayout(1, 0));
        p.addMouseListener(this);
        p.add(l);
        p.setToolTipText("Double click to add this element to its parent.");
        this.paletteElems.add(p);
        return l;
    }

    public void setLocation(int X, int Y) {
        if (this.x <= 0) {
            this.x = X;
        }
        if (this.y <= 0) {
            this.y = Y;
        }
    }

    public void showStorePalette() {
        if (this.paletteElems.isEmpty()) {
            this.current = null;
            this.currentValid = false;
            return;
        }
        if (this.d == null || !this.d.isVisible()) {
            int hght;
            int size = this.paletteElems.size();
            if (size == 0) {
                return;
            }
            this.palette = new JPanel(new GridLayout(size, 0));
            int i = 0;
            while (i < this.paletteElems.size()) {
                this.palette.add(this.paletteElems.get(i));
                ++i;
            }
            this.scrollPane = new JScrollPane(this.palette);
            int wdth = this.lWeidth;
            if (wdth < 300) {
                wdth = 300;
            }
            if ((hght = (this.paletteElems.size() + 1) * 30 + 50) > 300) {
                hght = 300;
            }
            this.scrollPane.setPreferredSize(new Dimension(wdth, hght));
            JPanel buttonp = new JPanel();
            JButton restore = new JButton("Restore");
            restore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    if (GraGraElementsStore.this.current != null) {
                        GraGraElementsStore.this.paletteElems.remove(GraGraElementsStore.this.panel);
                        GraGraElementsStore.this.buttons.remove(GraGraElementsStore.this.label);
                        GraGraElementsStore.this.propagateSelection(GraGraElementsStore.this.current);
                        if (GraGraElementsStore.this.treeView != null && GraGraElementsStore.this.current != null) {
                            GraGraElementsStore.this.treeView.undoDelete(GraGraElementsStore.this.current);
                        }
                        GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                        GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                        GraGraElementsStore.this.currentValid = false;
                        GraGraElementsStore.this.exitForm();
                    }
                }
            });
            JButton close = new JButton(" Close ");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                    GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                    GraGraElementsStore.this.exitForm();
                }
            });
            JButton empty = new JButton(" Clear ");
            empty.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent a) {
                    GraGraElementsStore.this.palette.removeAll();
                    GraGraElementsStore.this.storeGraGra.clear();
                    GraGraElementsStore.this.storeRule.clear();
                    GraGraElementsStore.this.storeAtomConstraint.clear();
                    GraGraElementsStore.this.paletteElems.clear();
                    GraGraElementsStore.this.lWeidth = 0;
                    GraGraElementsStore.this.updateTrash();
                    GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                    GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                    GraGraElementsStore.this.exitForm();
                }
            });
            buttonp.add(restore);
            buttonp.add(empty);
            buttonp.add(close);
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.scrollPane, "Center");
            p.add((Component)buttonp, "South");
            this.d = new JDialog();
            this.d.setModal(false);
            this.d.setTitle("Trash");
            this.d.getContentPane().add(p);
            this.d.setSize(wdth, hght + 25);
            this.d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    GraGraElementsStore.this.x = GraGraElementsStore.this.d.getX();
                    GraGraElementsStore.this.y = GraGraElementsStore.this.d.getY();
                    GraGraElementsStore.this.exitForm();
                }
            });
            this.d.setLocation(this.x, this.y);
            this.d.setVisible(true);
        } else if (this.d.isVisible()) {
            this.d.toFront();
        }
    }

    private void refreshStorePalette() {
        if (this.d != null && this.d.isVisible()) {
            ((GridLayout)this.palette.getLayout()).setRows(this.paletteElems.size());
            this.palette.add(this.paletteElems.get(this.paletteElems.size() - 1));
            int wdth = this.lWeidth;
            int hght = (this.paletteElems.size() + 1) * 30;
            if (hght > 300) {
                hght = 300;
            }
            this.scrollPane.setPreferredSize(new Dimension(wdth, hght));
            this.scrollPane.setSize(new Dimension(wdth, hght));
            this.scrollPane.validate();
            this.d.setSize(wdth, hght + 25);
            this.d.validate();
        }
    }

    void exitForm() {
        this.d.setVisible(false);
        this.d.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object source = e.getSource();
        if (e.getClickCount() == 1) {
            if (source instanceof JPanel) {
                this.panel = (JPanel)source;
                this.label = (JLabel)this.panel.getComponent(0);
                this.current = this.buttons.get(this.label);
                this.currentValid = true;
                Color col = this.label.getForeground();
                if (!col.equals(SelectedBackgroundColor)) {
                    int i = 0;
                    while (i < this.palette.getComponentCount()) {
                        JPanel pi = (JPanel)this.palette.getComponent(i);
                        JLabel li = (JLabel)pi.getComponent(0);
                        li.setForeground(col);
                        ++i;
                    }
                    this.label.setForeground(SelectedBackgroundColor);
                }
            }
        } else if (e.getClickCount() == 2 && source instanceof JPanel) {
            this.panel = (JPanel)source;
            this.label = (JLabel)this.panel.getComponent(0);
            this.current = this.buttons.get(this.label);
            this.paletteElems.remove(this.panel);
            this.buttons.remove(this.label);
            this.propagateSelection(this.current);
            if (this.treeView != null && this.current != null) {
                this.treeView.undoDelete(this.current);
            }
            this.x = this.d.getX();
            this.y = this.d.getY();
            this.currentValid = false;
            this.exitForm();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void removeFromTrashPalette(Object obj) {
        JPanel p = this.obj2panel.get(obj);
        this.paletteElems.remove(p);
        this.obj2panel.remove(obj);
    }

    public Object getSelection() {
        if (this.currentValid) {
            this.currentValid = false;
            return this.current;
        }
        return null;
    }
}

