/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.attribute.impl.AttrTupleManager;
import agg.editor.impl.EdGraGra;
import agg.gui.AGGAppl;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.options.ParserGUIOption;
import agg.gui.options.ParserOptionGUI;
import agg.gui.parser.GUIExchange;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.LayerOptionGUI;
import agg.gui.parser.ParserDesktop;
import agg.gui.parser.ParserDialog;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.gui.treeview.GraGraTreeView;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.LayerOption;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.PairContainer;
import agg.parser.Parser;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserMessageEvent;
import agg.parser.ParserOption;
import agg.parser.SimpleParser;
import agg.util.Pair;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.RuleLayer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class AGGParser
implements ParserEventListener,
OptionListener,
EditEventListener {
    private final GUIExchange changer;
    private final ParserGUIOption option;
    private final ParserOptionGUI pOptionGUI;
    private final ParserOption pOption;
    private final LayerOptionGUI lOptionGUI;
    private final LayerOption lOption;
    private CriticalPairOption cpOption;
    private final ParserDesktop parserDesktop;
    private ParserDialog parserStartDialog;
    private Parser excludeParser;
    private PairContainer tmpPairs;
    private final JMenu menu;
    private final JMenuItem openP;
    private final JMenuItem startP;
    private final JMenuItem stopP;
    private final JMenuItem backP;
    private final JMenuItem options;
    private final Vector<ParserEventListener> listener;
    private final Vector<StatusMessageListener> pmlistener;
    private boolean activeParser;
    private boolean generateCP;
    private final AGGAppl parent;
    private EdGraGra pairsGraGra;
    private EdGraGra hostGraphGrammar;
    private EdGraGra stopGraphGrammar;
    private RuleLayer ruleLayer;
    private final GraGraTreeView treeView;
    private final Vector<JMenu> menus;

    public AGGParser(AGGAppl appl, GraGraTreeView treeView) {
        this.parent = appl;
        this.treeView = treeView;
        this.listener = new Vector();
        this.pmlistener = new Vector();
        this.option = new ParserGUIOption();
        this.lOption = new LayerOption();
        this.lOptionGUI = new LayerOptionGUI(this.lOption);
        this.lOption.addOptionListener(this.lOptionGUI);
        this.pOption = new ParserOption();
        this.pOptionGUI = new ParserOptionGUI(this.option, this.pOption, this.cpOption);
        this.parserDesktop = new ParserDesktop(this, this.option, null, null, null);
        this.menus = new Vector(2);
        this.menu = new JMenu("Parser", true);
        this.openP = new JMenuItem("Open        Shift+Alt+P");
        this.openP.setMnemonic('O');
        this.startP = new JMenuItem("Start         Shift+Alt+S");
        this.startP.setMnemonic('S');
        this.stopP = new JMenuItem("Stop         Shift+Alt+Q");
        this.stopP.setMnemonic('p');
        this.backP = new JMenuItem("back         Shift+Alt+Z");
        this.backP.setMnemonic('b');
        this.options = new JMenuItem("Options...");
        this.createParserMenu();
        this.addParserEventListener(this);
        this.changer = new GUIExchange(this.parent);
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10) {
            if (e.getMessage().equals("Parser")) {
                this.menu.doClick();
            } else if (e.getMessage().equals("Parser Open")) {
                this.openParserDialog();
            }
        }
    }

    protected void showOptionGUI() {
        if (this.parent != null) {
            this.parent.getPreferences().showOptionGUI(2);
        }
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public ParserGUIOption getParserGUIOption() {
        return this.option;
    }

    public LayerOption getLayerOption() {
        return this.lOption;
    }

    public LayerOptionGUI getLayerOptionGUI() {
        return this.lOptionGUI;
    }

    public ParserOption getParserOption() {
        return this.pOption;
    }

    public ParserOptionGUI getParserOptionGUI() {
        return this.pOptionGUI;
    }

    public void setCriticalPairOption(CriticalPairOption cpOption) {
        this.cpOption = cpOption;
        this.pOptionGUI.setCriticalPairOption(cpOption);
        cpOption.addOptionListener(this.pOptionGUI);
    }

    @Override
    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            if (this.activeParser && this.generateCP) {
                this.generateCP = false;
                this.fireParserEvent(new ParserMessageEvent(this, " Please choice menu  - Parser / Start -  to start parsing"));
            }
        } else if (e.getMessage().indexOf("Result") != -1) {
            this.startP.setEnabled(false);
            this.stopP.setEnabled(false);
            this.pairsGraGra.setChanged(false);
            this.hostGraphGrammar.setChanged(false);
            this.stopGraphGrammar.setChanged(false);
        }
    }

    @Override
    public void optionEventOccurred(OptionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.getText().equals("NACs")) {
                this.cpOption.enableNacs(cb.isSelected());
            } else if (cb.getText().equals("PACs")) {
                this.cpOption.enablePacs(cb.isSelected());
            }
        }
    }

    protected void createParserMenu() {
        this.openP.setEnabled(true);
        this.menu.add(this.openP);
        this.openP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGParser.this.openParserDialog();
            }
        });
        this.startP.setEnabled(false);
        this.menu.add(this.startP);
        this.startP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGParser.this.startParser();
            }
        });
        this.stopP.setEnabled(false);
        this.menu.add(this.stopP);
        this.stopP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGParser.this.stopParser();
            }
        });
        this.backP.setEnabled(false);
        this.menu.add(this.backP);
        this.backP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGParser.this.backToGUI();
            }
        });
        this.menu.addSeparator();
        this.menu.add(this.options);
        this.options.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AGGParser.this.showOptionGUI();
            }
        });
        this.menus.addElement(this.menu);
    }

    public void openParserDialog() {
        this.parserStartDialog = new ParserDialog(this.parent, this.treeView, this.pOption, this.cpOption, this.lOption);
        this.parserStartDialog.showDialog();
        if (this.parserStartDialog.isReadyToParse()) {
            this.hostGraphGrammar = this.parserStartDialog.getHostGraphGrammar();
            this.stopGraphGrammar = this.parserStartDialog.getStopGraphGrammar();
            this.tmpPairs = this.parserStartDialog.getCriticalPairs();
            this.pairsGraGra = this.stopGraphGrammar;
            if (this.pairsGraGra.getBasisGraGra() == null) {
                JOptionPane.showMessageDialog(null, "Parsing grammar does not exist.", "Warning", 0);
                this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                return;
            }
            this.ruleLayer = null;
            if (this.tmpPairs == null) {
                if (!this.checkIfReadyToTransform(this.pairsGraGra)) {
                    return;
                }
                if (this.pOption.getSelectedParser() != 0) {
                    if (this.pOption.layerEnabled()) {
                        RuleLayer rlayer = new RuleLayer(this.pairsGraGra.getBasisGraGra().getEnabledRules());
                        LayerGUI lg = new LayerGUI(this.parent, rlayer);
                        lg.showGUI();
                        if (lg.isCancelled()) {
                            this.pOption.enableLayer(false);
                            this.pOptionGUI.update();
                        } else {
                            this.ruleLayer = rlayer;
                            this.pOption.enableLayer(true);
                            this.pOptionGUI.update();
                        }
                    }
                    this.tmpPairs = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), this.cpOption);
                    if (this.tmpPairs == null) {
                        JOptionPane.showMessageDialog(null, "Generating of critical pairs is failed.", "Warning", 0);
                        this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                        return;
                    }
                    this.generateCP = true;
                    int i = 0;
                    while (i < this.listener.size()) {
                        if (this.tmpPairs instanceof LayeredExcludePairContainer) {
                            ((LayeredExcludePairContainer)this.tmpPairs).addPairEventListener(this.listener.elementAt(i));
                        } else if (this.tmpPairs instanceof ExcludePairContainer) {
                            ((ExcludePairContainer)this.tmpPairs).addPairEventListener(this.listener.elementAt(i));
                        }
                        ++i;
                    }
                    this.activeParser = true;
                    this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs. Please wait ..."));
                    ParserFactory.generateCriticalPairs(this.tmpPairs);
                } else {
                    this.generateCP = false;
                    if (this.pOption.layerEnabled()) {
                        this.ruleLayer = new RuleLayer(this.pairsGraGra.getBasisGraGra().getListOfRules());
                        LayerGUI lg = new LayerGUI(this.parent, this.ruleLayer);
                        lg.showGUI();
                        if (lg.isCancelled()) {
                            this.pOption.enableLayer(false);
                            this.pOptionGUI.update();
                        } else {
                            this.pOption.enableLayer(true);
                            this.pOptionGUI.update();
                        }
                    }
                }
                if (this.option.getParserDisplay() != 0 && !this.changer.isSet()) {
                    this.changer.changeWith(this.parserDesktop.getComponent());
                }
            } else {
                this.generateCP = false;
                if (this.tmpPairs instanceof LayeredExcludePairContainer) {
                    this.ruleLayer = new RuleLayer(this.tmpPairs.getGrammar().getListOfRules());
                    this.pOption.enableLayer(true);
                    this.pOptionGUI.update();
                }
                if (this.option.getParserDisplay() != 0 && !this.changer.isSet()) {
                    this.changer.changeWith(this.parserDesktop.getComponent());
                }
                if (this.pairsGraGra == null) {
                    this.pairsGraGra = new EdGraGra(this.tmpPairs.getGrammar());
                } else if (!this.pairsGraGra.getBasisGraGra().compareTo(this.tmpPairs.getGrammar())) {
                    this.pairsGraGra = new EdGraGra(this.tmpPairs.getGrammar());
                    System.out.println("WARNING! The grammar loaded with critical pairs has some differences to the loaded stop grammar with parsing rules. The critical pairs grammar will be used for parsing.");
                }
                if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
                    JOptionPane.showMessageDialog(null, "Parsing rules are not exist.", "Warning", 0);
                    this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parser -  was stopped."));
                    return;
                }
            }
            if (!this.checkIfReadyToTransform(this.hostGraphGrammar)) {
                return;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            OrdinaryMorphism om = this.hostGraphGrammar.getBasisGraGra().getGraph().isomorphicCopy();
            if (om != null) {
                this.excludeParser = ParserFactory.createParser(this.pairsGraGra.getBasisGraGra(), om.getImage(), this.stopGraphGrammar.getBasisGraGra().getGraph(), this.tmpPairs, this.pOption, this.ruleLayer);
            }
            if (this.excludeParser == null) {
                JOptionPane.showMessageDialog(null, "Creating parser is failed.", "Warning", 0);
                this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
                return;
            }
            this.excludeParser.setDelayAfterApplyRule(this.option.getDelayAfterApplyRule());
            int i = 0;
            while (i < this.listener.size()) {
                if (this.excludeParser instanceof ExcludeParser) {
                    ((ExcludeParser)this.excludeParser).addParserEventListener(this.listener.elementAt(i));
                } else if (this.excludeParser instanceof SimpleParser) {
                    ((SimpleParser)this.excludeParser).addParserEventListener(this.listener.elementAt(i));
                }
                ++i;
            }
            this.parserDesktop.setLayout(this.hostGraphGrammar);
            this.parserDesktop.setStopLayout(this.stopGraphGrammar.getGraph());
            this.parserDesktop.setParser(this.excludeParser, om);
            this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
            if (!this.generateCP) {
                this.fireParserEvent(new ParserMessageEvent(this, "Please choice menu  - Parser / Start -  to start parsing"));
            }
            this.activeParser = true;
            this.openP.setEnabled(false);
            this.startP.setEnabled(true);
            this.stopP.setEnabled(false);
            this.backP.setEnabled(true);
        }
    }

    public void startParser() {
        if (this.generateCP) {
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ...  Please wait."));
            return;
        }
        this.openP.setEnabled(false);
        this.startP.setEnabled(false);
        this.stopP.setEnabled(true);
        this.backP.setEnabled(true);
        this.parserDesktop.hostFrameSetAnimationIcon();
        this.fireParserEvent(new ParserMessageEvent(this, "Starting parser ..."));
        Thread t = new Thread((Runnable)((Object)this.excludeParser));
        t.start();
    }

    public void stopParser() {
        if (this.tmpPairs != null) {
            ((ExcludePairContainer)this.tmpPairs).stop();
        }
        if (this.excludeParser instanceof ExcludeParser) {
            ((ExcludeParser)this.excludeParser).stop();
        } else if (this.excludeParser instanceof SimpleParser) {
            ((SimpleParser)this.excludeParser).stop();
        }
        this.startP.setEnabled(true);
        this.stopP.setEnabled(false);
    }

    public void backToGUI() {
        if (this.changer.isSet()) {
            this.changer.restore();
            int i = 0;
            while (i < this.listener.size()) {
                if (this.tmpPairs instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)this.tmpPairs).stop();
                    ((LayeredExcludePairContainer)this.tmpPairs).removePairEventListener(this.listener.elementAt(i));
                } else if (this.tmpPairs instanceof ExcludePairContainer) {
                    ((ExcludePairContainer)this.tmpPairs).stop();
                    ((ExcludePairContainer)this.tmpPairs).removePairEventListener(this.listener.elementAt(i));
                }
                ++i;
            }
            i = 0;
            while (i < this.listener.size()) {
                if (this.excludeParser instanceof ExcludeParser) {
                    ((ExcludeParser)this.excludeParser).stop();
                    ((ExcludeParser)this.excludeParser).removeParserEventListener(this.listener.elementAt(i));
                } else if (this.excludeParser instanceof SimpleParser) {
                    ((SimpleParser)this.excludeParser).stop();
                    ((SimpleParser)this.excludeParser).removeParserEventListener(this.listener.elementAt(i));
                }
                ++i;
            }
            this.parserDesktop.disposeTestHostGraph(this.hostGraphGrammar);
            this.activeParser = false;
            this.openP.setEnabled(true);
            this.startP.setEnabled(false);
            this.stopP.setEnabled(false);
            this.backP.setEnabled(false);
            this.fireParserEvent(new ParserMessageEvent(this, "back to AGG editor"));
        }
    }

    private boolean checkIfReadyToTransform(EdGraGra gra) {
        Object test;
        Pair<Object, String> pair = gra.getBasisGraGra().isReadyToTransform(true);
        if (pair != null && (test = pair.first) != null) {
            JOptionPane.showMessageDialog(null, "Parsing failed!  \nGrammar  \"" + gra.getName() + "\"  is not OK.\n" + (String)pair.second, "Warning", 0);
            this.fireParserEvent(new ParserMessageEvent(this, "Thread - Parsing -  was stopped."));
            return false;
        }
        return true;
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.pmlistener.contains(l)) {
            this.pmlistener.add(0, l);
        }
        this.parserDesktop.addStatusMessageListener(l);
    }

    private void fireStatusMessageEvent(StatusMessageEvent e) {
        int i = 0;
        while (i < this.pmlistener.size()) {
            this.pmlistener.elementAt(i).newMessage(e);
            ++i;
        }
    }

    public void addParserEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(0, l);
        }
    }

    public void removeParserEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    private synchronized void fireParserEvent(ParserEvent e) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).parserEventOccured(e);
            ++i;
        }
    }
}

