/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.options;

import agg.gui.IconResource;
import agg.gui.cpa.CriticalPairAnalysis;
import agg.gui.options.AbstractOptionGUI;
import agg.gui.options.GraTraOptionGUI;
import agg.gui.options.ParserGUIOption;
import agg.parser.CriticalPairOption;
import agg.parser.ExcludePairContainer;
import agg.parser.OptionEventListener;
import agg.parser.ParserOption;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CriticalPairOptionGUI
extends AbstractOptionGUI
implements ItemListener,
ActionListener,
ChangeListener,
OptionEventListener {
    private CriticalPairOption cpOption;
    CriticalPairAnalysis cpa;
    JButton displaySwitch;
    JButton generalSwitch;
    private static final int MAX = 20;
    JSlider numberCriticalPairs;
    JInternalFrame virtualGraph;
    JSlider verticalSize;
    JSlider horizontalSize;
    JComboBox algorithms;
    JComboBox layers;
    JCheckBox layered;
    JCheckBox complete;
    JCheckBox reduce;
    JCheckBox consistent;
    JCheckBox attrCheck;
    JCheckBox equalVariableNameOfAttrMapping;
    JCheckBox ignoreIdentical;
    JCheckBox reduceSameMatch;
    JCheckBox directStrctCnfl;
    JCheckBox directStrctCnflUpToIso;
    JCheckBox criticalStyleGreen;
    JCheckBox criticalStyleBlackBold;
    JCheckBox namedObject;
    JTextField maxBoundOfCriticKind;
    JButton moreAboutConsist;
    Color bgc;
    JPanel firstPriorityOption;
    JPanel secondPriorityOption;
    ParserGUIOption guiOption;
    ParserOption pOption;
    CriticalPairOptionGUI dialog;

    public CriticalPairOptionGUI(CriticalPairAnalysis cpa, CriticalPairOption cpOption, ParserGUIOption guiOption, ParserOption pOption) {
        this.cpa = cpa;
        this.cpOption = cpOption;
        this.guiOption = guiOption;
        this.pOption = pOption;
        this.firstPriorityOption = this.makeFirstPriorityOption();
        this.secondPriorityOption = this.makeSecondPriorityOption();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.anchor = 18;
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.add((Component)this.firstPriorityOption, c);
        this.validate();
        this.dialog = this;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(400, 690);
    }

    public void setGUIOption(ParserGUIOption pguiOption) {
        this.guiOption = pguiOption;
    }

    public void setParserOption(ParserOption pOption) {
        this.pOption = pOption;
    }

    private JPanel makeFirstPriorityOption() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel algorithmP = this.makeCriticalPairAlgorithm();
        optionPanel.add((Component)algorithmP, c);
        JPanel completeP = this.makeComplete();
        optionPanel.add((Component)completeP, c);
        JPanel consistentP = this.makeConsistent();
        optionPanel.add((Component)consistentP, c);
        JPanel attrCheckP = this.makeAttrCheck();
        optionPanel.add((Component)attrCheckP, c);
        JPanel ignoreIdenticalRulesP = this.makeIgnoreCriticalPairs();
        optionPanel.add((Component)ignoreIdenticalRulesP, c);
        JPanel namedObjP = this.makeCriticalPairsByNamedObject();
        optionPanel.add((Component)namedObjP, c);
        JPanel maxBoundP = this.makeMaxBoundOfCriticKind();
        optionPanel.add((Component)maxBoundP, c);
        JPanel reduceP = this.makeEssential();
        optionPanel.add((Component)reduceP, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        JPanel placeHolder2 = new JPanel();
        placeHolder2.setPreferredSize(new Dimension(200, 20));
        optionPanel.add((Component)placeHolder2, c);
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.insets = new Insets(10, 0, 10, 20);
        this.displaySwitch = new JButton("Display Settings...");
        this.displaySwitch.addActionListener(this);
        optionPanel.add((Component)this.displaySwitch, c);
        return optionPanel;
    }

    private JPanel makeSecondPriorityOption() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 18;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        c.weightx = 1.0;
        c.weighty = 0.01;
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(5, 0, 5, 0);
        c.weighty = 0.0;
        JPanel pairOption = this.makeCriticalPairDisplay();
        optionPanel.add((Component)pairOption, c);
        c.weighty = 1.0;
        JPanel pairSize = this.makePairSize();
        optionPanel.add((Component)pairSize, c);
        c.weighty = 0.0;
        JPanel criticalObjStyle = this.makeCriticalDrawingStyle();
        optionPanel.add((Component)criticalObjStyle, c);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        JPanel placeHolder2 = new JPanel();
        placeHolder2.setPreferredSize(new Dimension(200, 20));
        optionPanel.add((Component)placeHolder2, c);
        c.gridwidth = 0;
        c.weightx = 0.0;
        c.insets = new Insets(5, 0, 5, 20);
        this.generalSwitch = new JButton(" General Settings...");
        this.generalSwitch.addActionListener(this);
        optionPanel.add((Component)this.generalSwitch, c);
        return optionPanel;
    }

    private JPanel makeCriticalPairDisplay() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Number of displayed critical pairs "));
        c.anchor = 17;
        JSlider slider = new JSlider(0, 0, 20, 5);
        optionPanel.add((Component)slider, c);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setPaintTrack(true);
        slider.setMajorTickSpacing(slider.getMinorTickSpacing() * 5);
        slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int i = slider.getMinimum();
        while (i < slider.getMaximum()) {
            if (i % 5 == 0) {
                ((Dictionary)labelTable).put(i, new JLabel("" + i));
            }
            ++i;
        }
        JLabel all = new JLabel("All");
        ((Dictionary)labelTable).put(slider.getMaximum(), all);
        slider.setLabelTable(labelTable);
        JLabel invisible = new JLabel("None");
        ((Dictionary)labelTable).put(slider.getMinimum(), invisible);
        slider.setLabelTable(labelTable);
        this.numberCriticalPairs = slider;
        this.numberCriticalPairs.addChangeListener(this);
        return optionPanel;
    }

    private JPanel makeCriticalDrawingStyle() {
        JPanel optionPanel = this.makeInitialOptionPanel("");
        optionPanel.setBorder(new TitledBorder(" Set style how to draw critical objects "));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JPanel p = new JPanel(new GridLayout(2, 0));
        this.criticalStyleGreen = new JCheckBox("bold green", true);
        this.criticalStyleGreen.addActionListener(this);
        this.criticalStyleBlackBold = new JCheckBox("bold black", false);
        this.criticalStyleBlackBold.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.criticalStyleGreen);
        group.add(this.criticalStyleBlackBold);
        p.add(this.criticalStyleGreen);
        p.add(this.criticalStyleBlackBold);
        optionPanel.add((Component)p, c);
        return optionPanel;
    }

    private JPanel makePairSize() {
        JPanel optionPanel = this.makeInitialOptionPanel("");
        optionPanel.setBorder(new TitledBorder(" Set initial critical pair window size "));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JDesktopPane virtualDesktop = new JDesktopPane();
        this.virtualGraph = new JInternalFrame("Virtual Overlapping Graph", false, false, false, false);
        this.virtualGraph.setVisible(true);
        ImageIcon internalFrameIcon = IconResource.getIconFromURL(IconResource.getURLOverlapGraph());
        this.virtualGraph.setFrameIcon(internalFrameIcon);
        virtualDesktop.add(this.virtualGraph);
        try {
            this.virtualGraph.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        optionPanel.add((Component)virtualDesktop, c);
        this.verticalSize = new JSlider(1, 80, 500, 200);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        this.verticalSize.addChangeListener(this);
        this.verticalSize.setInverted(true);
        optionPanel.add((Component)this.verticalSize, c);
        this.horizontalSize = new JSlider(0, 120, 800, 200);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.horizontalSize.addChangeListener(this);
        optionPanel.add((Component)this.horizontalSize, c);
        this.virtualGraph.setSize(this.horizontalSize.getValue() / 2, this.verticalSize.getValue() / 2);
        optionPanel.add((Component)new JLabel("Scale: 1:2"), c);
        return optionPanel;
    }

    private JPanel makeCriticalPairAlgorithm() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Select the kind of critical pairs   &   layer to compute "));
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        this.algorithms = new JComboBox();
        this.algorithms.addItemListener(this);
        optionPanel.add((Component)this.algorithms, c);
        this.algorithms.addItem(" conflicts ");
        this.algorithms.addItem(" trigger dependency ");
        this.algorithms.addItem(" trigger & switch dependencies ");
        c.insets = new Insets(0, 10, 0, 0);
        this.layered = new JCheckBox("layered", false);
        this.layered.addActionListener(this);
        optionPanel.add((Component)this.layered, c);
        c.insets = new Insets(0, 10, 0, 0);
        this.layers = new JComboBox();
        this.layers.addActionListener(this);
        this.layers.addItem("All");
        this.layers.setEnabled(false);
        optionPanel.add((Component)this.layers, c);
        c.insets = new Insets(0, 5, 0, 0);
        JLabel lLayers = new JLabel("Layer");
        optionPanel.add((Component)lLayers, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        optionPanel.add((Component)new JPanel(), c);
        return optionPanel;
    }

    private JPanel makeComplete() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Select completeness of critical pairs "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 20);
        this.complete = new JCheckBox("complete", this.cpOption.completeEnabled());
        this.complete.addActionListener(this);
        optionPanel.add((Component)this.complete, c);
        JButton moreAbout = new JButton("More about");
        moreAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>If not selected, search up to first critical match.</BODY></HTML>", "  complete  ", 1);
            }
        });
        optionPanel.add(moreAbout);
        return optionPanel;
    }

    private JPanel makeEssential() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Compute essential critical pairs "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 20);
        this.reduce = new JCheckBox("essential", this.cpOption.reduceEnabled());
        this.reduce.addActionListener(this);
        optionPanel.add((Component)this.reduce, c);
        JButton moreAbout = new JButton("More about");
        moreAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>An essential critical pair exists for each conflict reason.<br>It expresses the conflict caused by exactly this conflict<br>reason in a minimal context. Essential critical pairs<br>is a subset of critical pairs.<br><br>Please note:<ul><li> <font color=\"#FF0000\">Multiplicity constraints of types </font> </li><li> <font color=\"#FF0000\">NACs</font> </li><li> <font color=\"#FF0000\">Graph consistency constraints</font> </li></ul>are not taken into account during computing essential critical pairs.<br>Therefore <font color=\"#FF0000\">delete-use</font>  and <font color=\"#FF0000\">attribute-change</font> conflicts would be detected only.</BODY></HTML>", "  essential  ", 1);
            }
        });
        optionPanel.add(moreAbout);
        return optionPanel;
    }

    private JPanel makeConsistent() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Select consistency check of critical pairs "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 20);
        this.consistent = new JCheckBox("consistent", this.cpOption.consistentEnabled());
        this.consistent.addActionListener(this);
        optionPanel.add((Component)this.consistent, c);
        this.moreAboutConsist = new JButton("More about");
        this.moreAboutConsist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairOptionGUI.this.moreAboutConsist.setBackground(CriticalPairOptionGUI.this.bgc);
                CriticalPairOptionGUI.this.moreAboutConsist.setText("More about");
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>If selected, each critical graph will be checked<br>due to enabled graph consistency constraints of the grammar.<br><br>Please note, because of a critical graph is the minimal graph <br>of a conflict situation, it is not always possible to check all <br>used atomic graph constraints and to evaluate formulae.<br><br>Furthermore, attribute conditions, constant values of attributes,<br>multiple usage of a variable to detect duplication of objects -<br>such things cannot be evaluated at critical graphs in which <br>the attributes are not set or rather set by variables.<br><br>It is advisable to use for CPA such consistency constraints which aim<br>to forbid some graph structures but do not deal with attribute values.<br><br></BODY></HTML>", " CPA : Graph Consistency Constraints ", 1);
                CriticalPairOptionGUI.this.dialog.setVisible(true);
            }
        });
        optionPanel.add(this.moreAboutConsist);
        return optionPanel;
    }

    void highlightMoreAboutConsist(boolean sel) {
        boolean warn = false;
        if (warn) {
            if (sel) {
                this.bgc = this.moreAboutConsist.getBackground();
                this.moreAboutConsist.setBackground(Color.magenta);
                this.moreAboutConsist.setText("Read More");
            } else {
                this.moreAboutConsist.setBackground(this.bgc);
                this.moreAboutConsist.setText("More about");
            }
        }
    }

    private JPanel makeAttrCheck() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Select attribute check of critical pairs "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 20);
        this.attrCheck = new JCheckBox("strong", this.cpOption.strongAttrCheckEnabled());
        this.attrCheck.addActionListener(this);
        optionPanel.add((Component)this.attrCheck, c);
        this.cpOption.enableEqualVariableNameOfAttrMapping(this.cpOption.equalVariableNameOfAttrMappingEnabled());
        JButton moreAbout = new JButton("More about");
        moreAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>If - strong - is selected, extended attribute checking will take place<br>when the first rule does change an attribute value of a graph<br>object and the second rule uses this attribute value<br>- as a target value of an input parameter, <br>- as a target value of a variable which is a part of an attribute condition.<br>The number of critical pairs may decrease.<br><br>Please note: An overview list with variables and variable equalities<br>of an overlapping graph is available by using background pop-up <br>menu of the graph panel.<br></BODY></HTML>", "  strong ", 1);
                CriticalPairOptionGUI.this.dialog.setVisible(true);
            }
        });
        optionPanel.add(moreAbout);
        return optionPanel;
    }

    private JPanel makeIgnoreCriticalPairs() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Ignore critical pairs "));
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.ignoreIdentical = new JCheckBox("of same rules", this.cpOption.ignoreIdenticalRulesEnabled());
        this.ignoreIdentical.addActionListener(this);
        optionPanel.add((Component)this.ignoreIdentical, c);
        c.insets = new Insets(0, 0, 0, 0);
        this.reduceSameMatch = new JCheckBox("of same rules and same matches", this.cpOption.reduceSameMatchEnabled());
        this.ignoreIdentical.setEnabled(!this.reduceSameMatch.isSelected());
        this.reduceSameMatch.addActionListener(this);
        optionPanel.add((Component)this.reduceSameMatch, c);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 1;
        c1.gridwidth = -1;
        c1.gridheight = 1;
        c1.weightx = 0.0;
        c1.anchor = 17;
        JPanel optionPanel1 = this.makeInitialOptionPanel(false, "", c1);
        c1.weightx = 1.0;
        c1.insets = new Insets(0, 0, 5, 0);
        this.directStrctCnfl = new JCheckBox("directly strict confluent", this.cpOption.directlyStrictConflEnabled());
        this.directStrctCnfl.addActionListener(this);
        optionPanel1.add((Component)this.directStrctCnfl, c1);
        JButton moreAbout1 = new JButton("More about");
        moreAbout1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>If a critical pair is directly strict confluent <br>via only one step direct transformations <b>t1</b> and <b>t2</b>, <br>we say that <b>(t1, t2)</b> is a strict solution of the critical pair. <br><br>Such a critical pair can be ignored. <br><br></BODY></HTML>", "  directly strict confluent  ", 1);
            }
        });
        optionPanel1.add(moreAbout1);
        c.insets = new Insets(0, 0, 0, 0);
        optionPanel.add((Component)optionPanel1, c);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.gridwidth = -1;
        c2.gridheight = 1;
        c2.weightx = 0.0;
        c2.anchor = 17;
        JPanel optionPanel2 = this.makeInitialOptionPanel(false, "", c2);
        c2.weightx = 1.0;
        c2.insets = new Insets(0, 0, 5, 0);
        this.directStrctCnflUpToIso = new JCheckBox("directly strict confluent up to isomorphism", this.cpOption.directlyStrictConflUpToIsoEnabled());
        this.directStrctCnflUpToIso.addActionListener(this);
        optionPanel2.add((Component)this.directStrctCnflUpToIso, c2);
        JButton moreAbout2 = new JButton("More about");
        moreAbout2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>If a critical pair is directly strict confluent up to isomorphism <br>via only one step direct transformations <b>t1</b> and <b>t2</b>, <br>we say that <b>(t1, t2)</b> is a strict solution of the critical pair. <br><br>Such a critical pair can be ignored. <br><br></BODY></HTML>", "  directly strict confluent up to isomorphism  ", 1);
            }
        });
        optionPanel2.add(moreAbout2);
        c.insets = new Insets(0, 0, 0, 0);
        optionPanel.add((Component)optionPanel2, c);
        return optionPanel;
    }

    private JPanel makeCriticalPairsByNamedObject() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Critical pairs due to named objects "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.namedObject = new JCheckBox("equal object names of overlapping objects", this.cpOption.namedObjectEnabled());
        this.namedObject.addActionListener(this);
        optionPanel.add((Component)this.namedObject, c);
        JButton moreAbout = new JButton("More about");
        moreAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>This option means that the overlappings of two graphs  <br>of the involved rules are generated above nodes with <br>equal object names only.<br><br>(The nodes of the same graph of the same rule must have <br>different object names. But the object names between two <br>rules should be equal.)<br><br>The number of critical pairs may decrease drastically.<br><br></BODY></HTML>", "  equal object names of overlapping objects  ", 1);
                CriticalPairOptionGUI.this.dialog.setVisible(true);
            }
        });
        optionPanel.add(moreAbout);
        return optionPanel;
    }

    private JPanel makeMaxBoundOfCriticKind() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = -1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.anchor = 17;
        JPanel optionPanel = this.makeInitialOptionPanel(true, "", c);
        optionPanel.setBorder(new TitledBorder(" Maximal amount of results per rule pair and conflict kind "));
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        JLabel l = new JLabel("                    ");
        String maxbound = String.valueOf(this.cpOption.getMaxBoundOfCriticKind());
        String txt = maxbound.isEmpty() || maxbound.equals("0") ? "unbound" : maxbound;
        this.maxBoundOfCriticKind = new JTextField(txt, 5);
        this.maxBoundOfCriticKind.setFont(new Font("SansSerif", 1, 12));
        this.maxBoundOfCriticKind.setEditable(true);
        p.add(this.maxBoundOfCriticKind);
        p.add(l);
        this.maxBoundOfCriticKind.addActionListener(this.cpa);
        this.maxBoundOfCriticKind.addActionListener(this);
        this.maxBoundOfCriticKind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairOptionGUI.this.setMaxBoundOfCP(((JTextField)e.getSource()).getText());
            }
        });
        optionPanel.add((Component)p, c);
        JButton moreAbout = new JButton("More about");
        moreAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(CriticalPairOptionGUI.this.dialog, "<HTML><BODY>This option is only helpful when a rule pair may have a lot of critical graphs<br>and therefore the need of memory and time to generate and check they is very high.<br>To avoid out of memory or boring waiting of the total results one can use this option.<br>The analysis process of a critical kind of a rule pair will terminate after <br>the number of critical graphs reaches the given maximal amount.<br><br>The default value is 0 (\"unbound\"). It can be reset by an integer value > 0.<br><br></BODY></HTML>", "  Maximal amount of results per rule pair and conflict kind", 1);
                CriticalPairOptionGUI.this.dialog.setVisible(true);
            }
        });
        optionPanel.add(moreAbout);
        return optionPanel;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTabTitle() {
        return "Critical Pairs";
    }

    @Override
    public String getTabTip() {
        return "Options of Critical Pair Analysis";
    }

    public void initLayers(Vector<String> v) {
        this.layers.removeAllItems();
        this.layers.addItem("All");
        int i = 0;
        while (i < v.size()) {
            this.layers.addItem(v.get(i));
            ++i;
        }
    }

    @Override
    public void update() {
        if (this.guiOption == null) {
            this.numberCriticalPairs.setValue(this.numberCriticalPairs.getMaximum());
        } else if (this.guiOption.getNumberOfCriticalPair() == Integer.MAX_VALUE) {
            this.numberCriticalPairs.setValue(this.numberCriticalPairs.getMaximum());
        } else {
            this.numberCriticalPairs.setValue(this.guiOption.getNumberOfCriticalPair());
        }
        if (this.guiOption == null) {
            this.verticalSize.setValue(200);
            this.horizontalSize.setValue(200);
        } else {
            this.verticalSize.setValue((int)this.guiOption.getCriticalPairWindowSize().getHeight());
            this.horizontalSize.setValue((int)this.guiOption.getCriticalPairWindowSize().getWidth());
        }
        if (this.cpOption == null) {
            return;
        }
        if (this.cpOption.getCriticalPairAlgorithm() == 0) {
            this.algorithms.setSelectedItem(" conflicts ");
        } else if (this.cpOption.getCriticalPairAlgorithm() == 1) {
            this.algorithms.setSelectedItem(" trigger dependency ");
        } else if (this.cpOption.getCriticalPairAlgorithm() == 2) {
            this.algorithms.setSelectedItem(" trigger & switch dependencies ");
        }
        this.layered.setSelected(this.cpOption.layeredEnabled());
        if (this.layered.isSelected()) {
            this.layers.setEnabled(true);
        } else {
            this.layers.setEnabled(false);
        }
        this.complete.setSelected(this.cpOption.completeEnabled());
        this.consistent.setSelected(this.cpOption.consistentEnabled());
        this.attrCheck.setSelected(this.cpOption.strongAttrCheckEnabled());
        this.reduceSameMatch.setSelected(this.cpOption.reduceSameMatchEnabled());
        this.ignoreIdentical.setSelected(this.cpOption.ignoreIdenticalRulesEnabled());
        this.reduce.setSelected(this.cpOption.reduceEnabled());
        this.directStrctCnfl.setSelected(this.cpOption.directlyStrictConflEnabled());
        this.directStrctCnflUpToIso.setSelected(this.cpOption.directlyStrictConflUpToIsoEnabled());
        this.namedObject.setSelected(this.cpOption.namedObjectEnabled());
        this.setMaxBoundOfCP(String.valueOf(this.cpOption.getMaxBoundOfCriticKind()));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.algorithms) {
            if (this.algorithms.getSelectedItem().equals(" conflicts ")) {
                this.cpOption.setCriticalPairAlgorithm(0);
            } else if (this.algorithms.getSelectedItem().equals(" trigger dependency ")) {
                this.cpOption.setCriticalPairAlgorithm(1);
            } else if (this.algorithms.getSelectedItem().equals(" trigger & switch dependencies ")) {
                this.cpOption.setCriticalPairAlgorithm(2);
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (l instanceof GraTraOptionGUI) {
            this.layered.addActionListener(l);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.displaySwitch) || source.equals(this.generalSwitch)) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.anchor = 18;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.weightx = 1.0;
            if (source.equals(this.displaySwitch)) {
                this.remove(this.firstPriorityOption);
                this.add((Component)this.secondPriorityOption, c);
            } else if (source.equals(this.generalSwitch)) {
                this.remove(this.secondPriorityOption);
                this.add((Component)this.firstPriorityOption, c);
            }
            this.revalidate();
            this.secondPriorityOption.repaint();
            this.firstPriorityOption.repaint();
        } else if (source.equals(this.layered)) {
            this.cpOption.enableLayered(this.layered.isSelected());
            if (this.layered.isSelected()) {
                this.layers.setEnabled(true);
            } else {
                this.layers.setEnabled(false);
            }
        } else if (source.equals(this.layers)) {
            if (this.layers.getSelectedItem() != null) {
                String l = this.layers.getSelectedItem().toString();
                if (l.equals("All")) {
                    l = "-1";
                }
                this.cpOption.setLayer(Integer.valueOf(l));
            }
        } else if (source.equals(this.complete)) {
            this.cpOption.enableComplete(this.complete.isSelected());
        } else if (source.equals(this.ignoreIdentical)) {
            if (this.ignoreIdentical.isSelected()) {
                this.reduceSameMatch.setSelected(false);
                this.reduceSameMatch.setEnabled(false);
            } else {
                this.reduceSameMatch.setEnabled(true);
            }
            this.cpOption.enableIgnoreIdenticalRules(this.ignoreIdentical.isSelected());
        } else if (source.equals(this.reduceSameMatch)) {
            if (this.reduceSameMatch.isSelected()) {
                this.ignoreIdentical.setSelected(false);
                this.ignoreIdentical.setEnabled(false);
            } else {
                this.ignoreIdentical.setEnabled(true);
            }
            this.cpOption.enableReduceSameMatch(this.reduceSameMatch.isSelected());
        } else if (source.equals(this.reduce)) {
            this.cpOption.enableReduce(this.reduce.isSelected());
        } else if (source.equals(this.directStrctCnfl)) {
            this.cpOption.enableDirectlyStrictConfl(this.directStrctCnfl.isSelected());
        } else if (source.equals(this.directStrctCnflUpToIso)) {
            this.cpOption.enableDirectlyStrictConflUpToIso(this.directStrctCnflUpToIso.isSelected());
        } else if (source.equals(this.consistent)) {
            this.highlightMoreAboutConsist(this.consistent.isSelected());
            this.cpOption.enableConsistent(this.consistent.isSelected());
        } else if (source.equals(this.attrCheck)) {
            this.cpOption.enableStrongAttrCheck(this.attrCheck.isSelected());
        } else if (source.equals(this.equalVariableNameOfAttrMapping)) {
            this.cpOption.enableEqualVariableNameOfAttrMapping(this.equalVariableNameOfAttrMapping.isSelected());
        } else if (source.equals(this.namedObject)) {
            this.cpOption.enableNamedObject(this.namedObject.isSelected());
        } else if (source.equals(this.maxBoundOfCriticKind)) {
            this.setMaxBoundOfCP(this.maxBoundOfCriticKind.getText());
            this.grabFocus();
        } else if (source.equals(this.criticalStyleGreen)) {
            this.guiOption.setDrawingStyleOfCriticalObjects(0);
        } else if (source.equals(this.criticalStyleBlackBold)) {
            this.guiOption.setDrawingStyleOfCriticalObjects(1);
        } else if (source instanceof JRadioButton) {
            if (((JRadioButton)source).getActionCommand().equals("layered")) {
                this.layered.setSelected(true);
                this.cpOption.enableLayered(this.layered.isSelected());
            } else if (((JRadioButton)source).getActionCommand().equals("priority")) {
                this.cpOption.enablePriority(true);
                this.layered.setSelected(false);
                this.cpOption.enableLayered(false);
            } else {
                this.layered.setSelected(false);
                this.cpOption.enableLayered(false);
                this.cpOption.enablePriority(false);
            }
        }
    }

    protected void setMaxBoundOfCP(String val) {
        int maxOpVal = this.cpOption.getMaxBoundOfCriticKind();
        int maxbound = 0;
        try {
            maxbound = Integer.valueOf(val);
            if (maxbound <= 0) {
                maxbound = 0;
            }
            if (maxbound == 0) {
                this.maxBoundOfCriticKind.setText("unbound");
            } else {
                this.maxBoundOfCriticKind.setText(val);
            }
        }
        catch (Exception ex) {
            maxbound = 0;
            this.maxBoundOfCriticKind.setText("unbound");
        }
        if (maxbound >= 0 && maxbound != maxOpVal) {
            this.cpOption.setMaxBoundOfCriticKind(maxbound);
            if (this.cpa.getConflictPairContainer() != null) {
                ((ExcludePairContainer)this.cpa.getConflictPairContainer()).enableMaxBoundOfCriticKind(maxbound);
            }
            if (this.cpa.getDependencyPairContainer() != null) {
                ((ExcludePairContainer)this.cpa.getDependencyPairContainer()).enableMaxBoundOfCriticKind(maxbound);
            }
        }
    }

    protected void refreshMaxBoundOfCP() {
        boolean ok = false;
        int maxOpVal = this.cpOption.getMaxBoundOfCriticKind();
        int maxbound = 0;
        String val = this.maxBoundOfCriticKind.getText();
        if (val.equals("unbound")) {
            maxbound = 0;
            ok = true;
        } else {
            try {
                maxbound = Integer.valueOf(val);
                if (maxbound == 0) {
                    ok = true;
                } else if (maxbound > 0) {
                    ok = true;
                } else {
                    this.maxBoundOfCriticKind.setText(String.valueOf(maxOpVal));
                }
            }
            catch (Exception ex) {
                this.maxBoundOfCriticKind.setText(String.valueOf(maxOpVal));
            }
        }
        if (ok && maxbound >= 0 && maxbound != maxOpVal) {
            this.cpOption.setMaxBoundOfCriticKind(maxbound);
            if (this.cpa.getConflictPairContainer() != null) {
                ((ExcludePairContainer)this.cpa.getConflictPairContainer()).enableMaxBoundOfCriticKind(maxbound);
            }
            if (this.cpa.getDependencyPairContainer() != null) {
                ((ExcludePairContainer)this.cpa.getDependencyPairContainer()).enableMaxBoundOfCriticKind(maxbound);
            }
        }
    }

    public JComponent getComponentMaxBoundOfCriticKind() {
        return this.maxBoundOfCriticKind;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source.equals(this.verticalSize) || source.equals(this.horizontalSize)) {
            this.virtualGraph.setSize(this.horizontalSize.getValue() / 2, this.verticalSize.getValue() / 2);
            if (this.guiOption == null) {
                this.guiOption.setCriticalPairWindowSize(200, 200);
            } else {
                this.guiOption.setCriticalPairWindowSize(this.horizontalSize.getValue(), this.verticalSize.getValue());
            }
        } else if (source.equals(this.numberCriticalPairs)) {
            int op = this.numberCriticalPairs.getValue();
            if (this.guiOption != null) {
                if (op == 20) {
                    this.guiOption.setNumberOfCriticalPair(Integer.MAX_VALUE);
                } else {
                    this.guiOption.setNumberOfCriticalPair(op);
                }
            }
        }
    }

    @Override
    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof JRadioButton) {
            JRadioButton cb = (JRadioButton)e.getSource();
            if (cb.getActionCommand().equals("layered")) {
                this.cpOption.enableLayered(cb.isSelected());
                this.layered.doClick();
            }
        } else if (e.getSource() instanceof ParserOption) {
            boolean b = ((ParserOption)e.getSource()).layerEnabled();
            this.cpOption.enableLayered(b);
            if (b && !this.layered.isSelected()) {
                this.layered.doClick();
            } else if (!b && this.layered.isSelected()) {
                this.layered.doClick();
            }
            if (this.layered.isSelected()) {
                this.layers.setEnabled(true);
            }
        }
    }

    @Override
    public void executeOnClose() {
        this.refreshMaxBoundOfCP();
    }
}

