/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class EdNestedApplCond
extends EdPAC {
    EdNestedApplCond itsParent;
    EdGraph itsSource;
    List<EdNestedApplCond> itsACs = new Vector<EdNestedApplCond>(0, 1);
    boolean badMapping = false;
    String errMsg = "";

    public EdNestedApplCond(EdNestedApplCond parent) {
        this.itsParent = parent;
    }

    public EdNestedApplCond(EdNestedApplCond parent, EdTypeSet types) {
        super(types);
        this.itsParent = parent;
    }

    public EdNestedApplCond(EdNestedApplCond parent, OrdinaryMorphism m) {
        super(m);
        this.itsParent = parent;
    }

    public EdNestedApplCond(EdNestedApplCond parent, OrdinaryMorphism m, EdTypeSet types) {
        super(m, types);
        this.itsParent = parent;
        List<NestedApplCond> list = ((NestedApplCond)m).getNestedACs();
        int i = 0;
        while (i < list.size()) {
            this.createNestedAC(list.get(i));
            ++i;
        }
    }

    @Override
    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
        int j = 0;
        while (j < this.getNestedACs().size()) {
            this.getNestedACs().get(j).setUndoManager(this.undoManager);
            ++j;
        }
    }

    void addEdit(EdGraphObject src, EdGraphObject tar, String kind, String presentation) {
        Vector<String> v = new Vector<String>();
        v.add(String.valueOf(src.hashCode()));
        v.add(String.valueOf(tar.hashCode()));
        this.undoObj = new Pair(kind, v);
        this.undoManagerAddEdit(presentation);
    }

    public void addCreatedMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        EdGraphObject go;
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.isEditable() || this.morphism == null) {
            return;
        }
        GraphObject oldImg = this.morphism.getImage(src.getBasisObject());
        if (oldImg != null && (go = this.findGraphObject(oldImg)) != null) {
            this.addDeletedMappingToUndo(src, go);
        }
        this.addEdit(src, tar, "AC_MAPPING_CREATE_DELETE", "Undo Create AC Mapping");
    }

    public void addDeletedMappingToUndo(EdGraphObject src, EdGraphObject tar) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.isEditable() || this.morphism == null) {
            return;
        }
        if (tar.isNode()) {
            this.addDeletedMappingOfInOutEdgesToUndo((EdNode)src, (EdNode)tar, src.getContext(), tar.getContext(), this.morphism, "AC_MAPPING_DELETE_CREATE", "Undo Delete AC Mapping");
        }
        this.addEdit(src, tar, "AC_MAPPING_DELETE_CREATE", "Undo Delete AC Mapping");
    }

    private void addDeletedMappingOfInOutEdgesToUndo(EdNode orig, EdNode img, EdGraph origG, EdGraph imgG, OrdinaryMorphism morph, String kind, String msg) {
        Vector<EdArc> inArcs = origG.getIncomingArcs(orig);
        int i = 0;
        while (i < inArcs.size()) {
            Arc imgArc;
            EdArc imgEdArc;
            EdArc origEdArc = inArcs.get(i);
            GraphObject obj = morph.getImage(origEdArc.getBasisArc());
            if (obj != null && (imgEdArc = imgG.findArc(imgArc = (Arc)obj)) != null) {
                this.addEdit(origEdArc, imgEdArc, kind, msg);
            }
            ++i;
        }
        Vector<EdArc> outArcs = origG.getOutgoingArcs(orig);
        int i2 = 0;
        while (i2 < outArcs.size()) {
            Arc imgArc;
            EdArc imgEdArc;
            GraphObject obj;
            EdArc origEdArc = outArcs.get(i2);
            if (!inArcs.contains(origEdArc) && (obj = morph.getImage(origEdArc.getBasisArc())) != null && (imgEdArc = imgG.findArc(imgArc = (Arc)obj)) != null) {
                this.addEdit(origEdArc, imgEdArc, kind, msg);
            }
            ++i2;
        }
    }

    @Override
    public void setEditable(boolean b) {
        this.editable = b;
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).setEditable(b);
            ++i;
        }
    }

    @Override
    public void setRule(EdRule er) {
        super.setRule(er);
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).setRule(er);
            ++i;
        }
    }

    @Override
    public void setGraGra(EdGraGra egra) {
        if (egra == null) {
            return;
        }
        super.setGraGra(egra);
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).setGraGra(egra);
            ++i;
        }
    }

    public void setSourceGraph(EdGraph g) {
        if (this.morphism.getSource() == g.getBasisGraph()) {
            this.itsSource = g;
        }
    }

    public EdGraph getSource() {
        return this.itsSource;
    }

    public NestedApplCond getNestedMorphism() {
        return (NestedApplCond)this.morphism;
    }

    public void removeNestedAC(EdNestedApplCond cond) {
        if (this.itsACs.contains(cond)) {
            this.getNestedMorphism().removeNestedAC(cond.getNestedMorphism());
            this.itsACs.remove(cond);
        }
    }

    public boolean removeNestedACMapping(EdGraphObject leftObj, EdNestedApplCond ac) {
        if (!this.editable) {
            return false;
        }
        if (ac.getMorphism().getImage(leftObj.getBasisObject()) != null) {
            ac.getMorphism().removeMapping(leftObj.getBasisObject());
            this.updateNestedAC(ac);
            return true;
        }
        return false;
    }

    public List<EdNestedApplCond> getNestedACs() {
        return this.itsACs;
    }

    public List<EdNestedApplCond> getEnabledNestedACs() {
        Vector<EdNestedApplCond> list = new Vector<EdNestedApplCond>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            if (ac.getMorphism().isEnabled()) {
                list.add(ac);
            }
            list.addAll(ac.getEnabledNestedACs());
            ++i;
        }
        return list;
    }

    public List<EdNestedApplCond> getEnabledACs() {
        Vector<EdNestedApplCond> list = new Vector<EdNestedApplCond>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            if (ac.getMorphism().isEnabled()) {
                list.add(ac);
            }
            ++i;
        }
        return list;
    }

    public EdNestedApplCond getNestedAC(String acname) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            if (ac.getName().equals(acname)) {
                return ac;
            }
            EdNestedApplCond ac1 = ac.getNestedAC(acname);
            if (ac1 != null) {
                return ac1;
            }
            ++i;
        }
        return null;
    }

    public EdNestedApplCond getNestedAC(int indx) {
        if (indx >= 0 && indx < this.itsACs.size()) {
            return this.itsACs.get(indx);
        }
        return null;
    }

    public EdNestedApplCond getApplCondByImageGraph(Graph g) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond cond = this.itsACs.get(i);
            if (cond.getMorphism().getImage() == g) {
                return cond;
            }
            ++i;
        }
        return null;
    }

    public int getSizeOfNestedACs() {
        return this.itsACs.size();
    }

    public EdNestedApplCond createNestedAC(String nameStr, boolean isIdentic) {
        if (this.morphism == null || !this.editable) {
            return null;
        }
        EdNestedApplCond eAC = new EdNestedApplCond(this, ((NestedApplCond)this.morphism).createNestedAC(), this.typeSet);
        eAC.setName(nameStr);
        eAC.setRule(this.getRule());
        eAC.setGraGra(this.eGra);
        eAC.setEditable(this.isEditable());
        eAC.getBasisGraph().setKind("AC");
        eAC.setUndoManager(this.undoManager);
        eAC.setSourceGraph(this);
        if (isIdentic && eAC.isEditable()) {
            this.identicNestedAC(eAC);
        }
        this.itsACs.add(eAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eAC;
    }

    public EdPAC createNestedAC(OrdinaryMorphism ac) {
        if (this.morphism == null || !this.editable) {
            return null;
        }
        EdNestedApplCond eAC = new EdNestedApplCond(this, ac, this.typeSet);
        eAC.getBasisGraph().setName(ac.getName());
        eAC.getBasisGraph().setKind("AC");
        eAC.setName(ac.getName());
        eAC.setRule(this.getRule());
        eAC.setGraGra(this.eGra);
        eAC.setUndoManager(this.undoManager);
        eAC.setSourceGraph(this);
        this.itsACs.add(eAC);
        if (this.eGra != null) {
            this.eGra.setChanged(true);
        }
        return eAC;
    }

    public boolean addNestedAC(EdNestedApplCond ac) {
        if (this.morphism == null) {
            return false;
        }
        if (ac.getTypeSet().getBasisTypeSet().compareTo(this.typeSet.getBasisTypeSet())) {
            if (((NestedApplCond)this.morphism).addNestedAC((NestedApplCond)ac.getMorphism())) {
                Vector<Type> v = ac.getMorphism().getUsedTypes();
                this.morphism.getSource().getTypeSet().adaptTypes(v.elements(), false);
                this.typeSet.refreshTypes();
                ac.getBasisGraph().setKind("AC");
                ac.setRule(this.getRule());
                ac.setGraGra(this.eGra);
                ac.setUndoManager(this.undoManager);
                ac.setSourceGraph((EdGraph)this.getRule().getApplCondByImageGraph(ac.getMorphism().getSource()));
                ac.itsParent = this;
                this.itsACs.add(ac);
                if (this.eGra != null) {
                    this.eGra.setChanged(true);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public EdNestedApplCond getParent() {
        return this.itsParent;
    }

    public void identicNestedAC(EdNestedApplCond ac) {
        OrdinaryMorphism morph = ac.getMorphism();
        morph.clear();
        morph.getImage().clear();
        ac.clear();
        int i = 0;
        while (i < this.getNodes().size()) {
            EdNode en = this.getNodes().elementAt(i);
            this.identicNode(en, ac, morph);
            ++i;
        }
        int j = 0;
        while (j < this.getArcs().size()) {
            EdArc ea = this.getArcs().elementAt(j);
            this.identicArc(ea, ac, morph);
            ++j;
        }
        this.updateNestedAC(ac);
    }

    @Override
    public void setLayoutByIndex(EdGraph layout, boolean ofNodesOnly) {
        if (layout instanceof EdNestedApplCond) {
            super.setLayoutByIndex(layout, ofNodesOnly);
            if (this.itsACs.size() == ((EdNestedApplCond)layout).getNestedACs().size()) {
                int i = 0;
                while (i < this.itsACs.size()) {
                    EdNestedApplCond c = this.itsACs.get(i);
                    EdNestedApplCond c1 = ((EdNestedApplCond)layout).getNestedACs().get(i);
                    if (c1 != null) {
                        c.setLayoutByIndex(c1, ofNodesOnly);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.itsACs.size()) {
                    EdNestedApplCond c = this.itsACs.get(i);
                    if (c.getParent() == null) {
                        c.setLayoutByIndex(c.getRule().getLeft(), ofNodesOnly);
                    } else {
                        c.setLayoutByIndex(c.getParent(), ofNodesOnly);
                    }
                    ++i;
                }
            }
        } else {
            super.setLayoutByIndex(layout, ofNodesOnly);
        }
    }

    public void updateNestedAC(EdNestedApplCond ac) {
        EdNode enL = null;
        EdNode enAC = null;
        EdArc eaL = null;
        EdArc eaAC = null;
        ac.clearMarks();
        Enumeration<GraphObject> domain = ac.getMorphism().getDomain();
        while (domain.hasMoreElements()) {
            GraphObject bOrig = domain.nextElement();
            GraphObject bImage = ac.getMorphism().getImage(bOrig);
            enL = this.findNode(bOrig);
            if (enL != null) {
                if (enL.isMorphismMarkEmpty()) {
                    enL.addMorphismMark(enL.getMyKey());
                }
                if ((enAC = ac.findNode(bImage)) != null) {
                    enAC.addMorphismMark(enL.getMorphismMark());
                }
            }
            if ((eaL = this.findArc(bOrig)) == null) continue;
            if (eaL.isMorphismMarkEmpty()) {
                eaL.addMorphismMark(eaL.getMyKey());
            }
            if ((eaAC = ac.findArc(bImage)) == null) continue;
            eaAC.addMorphismMark(eaL.getMorphismMark());
        }
    }

    public void updateNestedACs() {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            this.updateNestedAC(ac);
            ac.updateNestedACs();
            ++i;
        }
    }

    private EdNode identicNode(EdNode en, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdNode cn = null;
        Node bn = null;
        try {
            bn = eg.getBasisGraph().copyNode(en.getBasisNode());
        }
        catch (TypeException typeException) {
            // empty catch block
        }
        if (bn != null) {
            cn = eg.addNode(bn, en.getType());
            cn.setReps(en.getX(), en.getY(), en.isVisible(), false);
            cn.getLNode().setFrozenByDefault(true);
            eg.addCreatedToUndo(cn);
            eg.undoManagerEndEdit();
            try {
                this.addCreatedMappingToUndo(en, cn);
                morph.addMapping(en.getBasisNode(), bn);
                this.undoManagerEndEdit();
            }
            catch (BadMappingException ex) {
                this.badMapping = true;
                this.errMsg = ex.getMessage();
            }
        }
        return cn;
    }

    private EdArc identicArc(EdArc ea, EdGraph eg, OrdinaryMorphism morph) {
        this.badMapping = false;
        this.errMsg = "";
        EdArc ca = null;
        Arc ba = null;
        GraphObject bSrc = morph.getImage(ea.getBasisArc().getSource());
        GraphObject bTar = morph.getImage(ea.getBasisArc().getTarget());
        try {
            ba = eg.getBasisGraph().copyArc(ea.getBasisArc(), (Node)bSrc, (Node)bTar);
        }
        catch (TypeException e) {
            e.printStackTrace();
        }
        if (ba != null) {
            try {
                ca = eg.addArc(ba, ea.getType());
                ca.setReps(ea.isDirected(), ea.isVisible(), false);
                ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
                if (ea.isLine()) {
                    if (ea.hasAnchor()) {
                        ca.setAnchor(ea.getAnchor());
                        ca.getLArc().setFrozenByDefault(true);
                    }
                } else if (ea.hasAnchor()) {
                    ca.setXY(ea.getX(), ea.getY());
                    ca.setWidth(ea.getWidth());
                    ca.setHeight(ea.getHeight());
                }
                eg.addCreatedToUndo(ca);
                eg.undoManagerEndEdit();
                this.errMsg = "";
                try {
                    this.addCreatedMappingToUndo(ea, ca);
                    morph.addMapping(ea.getBasisArc(), ba);
                    this.undoManagerEndEdit();
                }
                catch (BadMappingException ex) {
                    this.badMapping = true;
                    this.errMsg = ex.getMessage();
                }
            }
            catch (TypeException tex) {
                this.badMapping = true;
                this.errMsg = tex.getMessage();
            }
        }
        return ca;
    }

    @Override
    public Vector<EdGraphObject> getOriginal(EdGraphObject image) {
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(2);
        Enumeration<GraphObject> en = this.morphism.getInverseImage(image.getBasisObject());
        while (en.hasMoreElements()) {
            GraphObject obj = en.nextElement();
            EdGraphObject go = null;
            go = this.itsParent == null ? this.itsRule.getLeft().findGraphObject(obj) : this.itsParent.findGraphObject(obj);
            if (go == null) continue;
            vec.add(go);
        }
        return vec;
    }

    public boolean deleteGraphObjectsOfType(EdType t, boolean addToUndo) {
        boolean alldone = true;
        int n = 0;
        while (n < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(n);
            alldone = alldone && ac.deleteGraphObjectsOfType(t, addToUndo);
            ++n;
        }
        alldone = alldone && this.deleteGraphObjectsOfTypeFromGraph(t, addToUndo);
        return alldone;
    }

    public boolean deleteGraphObjectsOfType(EdGraphObject tgo, boolean addToUndo) {
        boolean alldone = true;
        int n = 0;
        while (n < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(n);
            alldone = alldone && ac.deleteGraphObjectsOfType(tgo, addToUndo);
            ++n;
        }
        alldone = alldone && this.deleteGraphObjectsOfTypeFromGraph(tgo, addToUndo);
        return alldone;
    }

    protected List<EdGraphObject> getGraphObjectsOfType(EdGraphObject tgo, EdGraph g) {
        Vector<EdGraphObject> list = new Vector<EdGraphObject>();
        if (tgo.isArc()) {
            int i = 0;
            while (i < g.arcs.size()) {
                EdArc go = g.arcs.get(i);
                if (tgo.getType() == go.getType() && ((EdArc)tgo).getSource().getType().isParentOf(go.getSource().getType()) && ((EdArc)tgo).getTarget().getType().isParentOf(go.getTarget().getType())) {
                    list.add(go);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < g.nodes.size()) {
                EdNode go = g.nodes.get(i);
                if (tgo.getType() == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    protected List<EdGraphObject> getGraphObjectsOfType(EdType t, EdGraph g) {
        Vector<EdGraphObject> list = new Vector<EdGraphObject>();
        if (t.isArcType()) {
            int i = 0;
            while (i < g.arcs.size()) {
                EdArc go = g.arcs.get(i);
                if (t == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < g.nodes.size()) {
                EdNode go = g.nodes.get(i);
                if (t == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    protected void storeMappingOfGraphObjectsOfType(EdGraphObject tgo, EdGraph src) {
        List<EdGraphObject> list = this.getGraphObjectsOfType(tgo, src);
        int n = 0;
        while (n < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(n);
            int i = 0;
            while (i < list.size()) {
                EdGraphObject go = list.get(i);
                EdGraphObject rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                if (rgo != null) {
                    ac.itsRule.addDeletedACMappingToUndo(go, rgo);
                    ac.itsRule.undoManagerEndEdit();
                }
                ++i;
            }
            ac.storeMappingOfGraphObjectsOfType(tgo, (EdGraph)ac);
            ++n;
        }
    }

    protected void storeMappingOfGraphObjectsOfType(EdType t, EdGraph src) {
        List<EdGraphObject> list = this.getGraphObjectsOfType(t, src);
        int n = 0;
        while (n < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(n);
            int i = 0;
            while (i < list.size()) {
                EdGraphObject go = list.get(i);
                EdGraphObject rgo = ac.findGraphObject(ac.getMorphism().getImage(go.getBasisObject()));
                if (rgo != null) {
                    ac.itsRule.addDeletedACMappingToUndo(go, rgo);
                    ac.itsRule.undoManagerEndEdit();
                }
                ++i;
            }
            ac.storeMappingOfGraphObjectsOfType(t, (EdGraph)ac);
            ++n;
        }
    }

    protected EdGraphObject findRestoredObjectOfAC(EdGraphObject go) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            EdGraphObject obj = ac.findRestoredObject(go);
            if (obj != null) {
                return obj;
            }
            obj = ac.findRestoredObjectOfAC(go);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findGraphObjectOfAC(String goHashCode) {
        int i = 0;
        while (i < this.itsACs.size()) {
            EdNestedApplCond ac = this.itsACs.get(i);
            EdGraphObject obj = ac.findGraphObject(goHashCode);
            if (obj != null) {
                return obj;
            }
            obj = ac.findGraphObjectOfAC(goHashCode);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void XreadObject(XMLHelper h) {
        super.XreadObject(h);
        h.peekObject(this.bGraph, this);
        int j = 0;
        while (j < this.itsACs.size()) {
            EdPAC ac = this.itsACs.get(j);
            h.enrichObject(ac);
            ++j;
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        super.XwriteObject(h);
        if (h.openObject(this.bGraph, this)) {
            int j = 0;
            while (j < this.itsACs.size()) {
                h.addObject("", this.itsACs.get(j), true);
                ++j;
            }
        }
    }
}

