/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrInstance;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.view.AttrViewEvent;
import agg.attribute.view.AttrViewObserver;
import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.ArcReprData;
import agg.editor.impl.Arrow;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.editor.impl.Line;
import agg.editor.impl.Loop;
import agg.gui.editor.EditorConstants;
import agg.gui.editor.GraphPanel;
import agg.layout.evolutionary.LayoutArc;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.TypeException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.StateEditable;

public class EdArc
extends EdGraphObject
implements AttrViewObserver,
XMLObject,
StateEditable {
    private Arc bArc;
    private EdGraphObject from;
    private EdGraphObject to;
    private boolean directed = true;
    private Point anchor;
    private transient int anchorID = 0;
    private transient boolean hasDefaultAnchor;
    private transient Point arrowPoint;
    private transient Point tailPoint;
    private transient Point textLocation;
    protected Point textOffset;
    protected Point origTextOffset;
    private transient Dimension textSize;
    private transient Point srcMultiplicityLocation;
    private transient Dimension srcMultiplicitySize;
    private transient Point srcMultiplicityOffset;
    private transient Point trgMultiplicityLocation;
    private transient Dimension trgMultiplicitySize;
    private transient Point trgMultiplicityOffset;
    private transient int partOfText;
    private LayoutArc lArc;
    int in_offset = 10;

    public EdArc(Arc bArc, EdType eType, EdGraphObject from, EdGraphObject to) throws TypeException {
        super(eType);
        if (bArc == null || bArc.getSource() == null || bArc.getTarget() == null) {
            throw new TypeException("Basic node is null");
        }
        this.bArc = bArc;
        this.from = from;
        this.to = to;
        this.directed = bArc.isDirected();
        this.anchor = null;
        this.hasDefaultAnchor = true;
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
        this.textOffset = new Point(0, -22);
        this.textLocation = new Point();
        this.textSize = new Dimension();
        if (this.bArc != null) {
            this.contextUsage = String.valueOf(this.hashCode());
            if (this.bArc.getAttribute() != null) {
                this.addToAttributeViewObserver();
            }
        }
        this.lArc = new LayoutArc(this);
    }

    public EdArc(Graph bGraph, EdType eType, EdGraphObject from, EdGraphObject to) throws TypeException {
        this(bGraph, eType, from, to, null);
    }

    public EdArc(Graph bGraph, EdType eType, EdGraphObject from, EdGraphObject to, Point anchor) throws TypeException {
        this(bGraph != null ? bGraph.createArc(eType.bType, (Node)from.getBasisObject(), (Node)to.getBasisObject()) : null, eType, from, to);
        this.setAnchor(anchor);
    }

    @Override
    public void markElementOfTypeGraph(boolean val) {
        this.elemOfTG = val;
        if (this.elemOfTG && !this.getContext().isInheritanceType(this.eType)) {
            this.createMultiplicityVars();
        }
    }

    private void createMultiplicityVars() {
        if (this.srcMultiplicityLocation == null) {
            this.srcMultiplicityLocation = new Point();
        }
        if (this.srcMultiplicitySize == null) {
            this.srcMultiplicitySize = new Dimension();
        }
        if (this.srcMultiplicityOffset == null) {
            this.srcMultiplicityOffset = new Point();
        }
        if (this.trgMultiplicityLocation == null) {
            this.trgMultiplicityLocation = new Point();
        }
        if (this.trgMultiplicitySize == null) {
            this.trgMultiplicitySize = new Dimension();
        }
        if (this.trgMultiplicityOffset == null) {
            this.trgMultiplicityOffset = new Point();
        }
    }

    @Override
    public void dispose() {
        if (this.attrObserver) {
            this.removeFromAttributeViewObserver();
        }
        this.view = null;
        if (this.lArc != null) {
            this.lArc.dispose();
        }
        this.lArc = null;
        this.eGraph = null;
        this.eType = null;
        this.from = null;
        this.to = null;
        this.bArc = null;
        this.myGraphPanel = null;
    }

    public void finalize() {
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        ArcReprData data = new ArcReprData(this);
        state.put(this.hashCode(), data);
        state.put(data.hashCode(), data);
        this.itsUndoReprDataHC = data.hashCode();
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        ArcReprData data = (ArcReprData)state.get(this.hashCode());
        if (data == null) {
            data = (ArcReprData)state.get(this.itsUndoReprDataHC);
        }
        if (data != null) {
            data.restoreArcFromArcRepr(this);
            this.attrChanged = false;
        }
    }

    public void restoreState(Hashtable<?, ?> state, String hashCode) {
        ArcReprData data = (ArcReprData)state.get(Integer.valueOf(hashCode));
        if (data == null) {
            data = (ArcReprData)state.get(this.itsUndoReprDataHC);
        }
        if (data == null) {
            data = (ArcReprData)state.get(this.hashCode());
        }
        if (data != null) {
            data.restoreArcFromArcRepr(this);
            this.attrChanged = false;
        }
    }

    public void restoreState(ArcReprData data) {
        data.restoreArcFromArcRepr(this);
        this.attrChanged = false;
    }

    @Override
    protected AttrViewSetting getView() {
        if (!this.init || this.view == null) {
            this.view = ((AttrTupleManager)AttrTupleManager.getDefaultManager()).getDefaultOpenView();
            this.view.setAllVisible(this.bArc.getAttribute(), true);
            this.init = true;
        }
        return this.view;
    }

    @Override
    public void setAttrViewSetting(AttrViewSetting aView) {
        this.view = aView;
        if (!this.attrObserver) {
            this.view.addObserver(this, this.bArc.getAttribute());
            this.attrObserver = true;
        }
        this.init = true;
    }

    public void addToAttributeViewObserver() {
        this.getView().addObserver(this, this.bArc.getAttribute());
        this.attrObserver = true;
    }

    @Override
    public void removeFromAttributeViewObserver() {
        if (this.bArc != null && this.bArc.getAttribute() != null && this.view != null) {
            this.view.removeObserver(this, this.bArc.getAttribute());
            this.view.getMaskedView().removeObserver(this, this.bArc.getAttribute());
        }
    }

    public void createAttributeInstance() {
        if (this.bArc != null && this.bArc.getAttribute() == null) {
            this.bArc.createAttributeInstance();
            this.addToAttributeViewObserver();
        }
    }

    @Override
    public void refreshAttributeInstance() {
        if (this.bArc != null && this.bArc.getAttribute() != null) {
            ((ValueTuple)this.bArc.getAttribute()).getTupleType().refreshParents();
            this.addToAttributeViewObserver();
        }
    }

    public LayoutArc getLArc() {
        return this.lArc;
    }

    public final Arc getBasisArc() {
        return this.bArc;
    }

    @Override
    public final GraphObject getBasisObject() {
        return this.bArc;
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public final boolean isArc() {
        return true;
    }

    @Override
    public final EdNode getNode() {
        return null;
    }

    @Override
    public final EdArc getArc() {
        return this;
    }

    @Override
    public void setCritical(boolean b) {
        this.bArc.setCritical(b);
    }

    @Override
    public boolean isCritical() {
        return this.bArc.isCritical();
    }

    @Override
    public void setDrawingStyleOfCriticalObject(int criticalStyle) {
        this.criticalStyle = criticalStyle;
    }

    public final boolean isLine() {
        return !this.from.equals(this.to);
    }

    public boolean hasAnchor() {
        return this.anchor != null && !this.hasDefaultAnchor;
    }

    public Point getAnchor() {
        if (this.anchor != null) {
            return this.anchor;
        }
        if (this.isLine()) {
            return new Point(this.getX(), this.getY());
        }
        return null;
    }

    public Point getAnchor(int id) {
        if (this.anchor != null) {
            return this.anchor;
        }
        if (!this.isLine()) {
            Loop loop = this.toLoop();
            return loop.getAnchor(id);
        }
        return null;
    }

    public int getAnchorID() {
        return this.anchorID;
    }

    public boolean isDirected() {
        if (this.bArc != null) {
            this.directed = this.bArc.isDirected();
        }
        return this.directed;
    }

    @Override
    public boolean isVisible() {
        if (this.bArc != null) {
            boolean bl = this.visible = this.bArc.isVisible() && this.from.isVisible() && this.to.isVisible();
            if (this.getContext().getBasisGraph().isCompleteGraph()) {
                this.visible = this.visible && this.getType().getBasisType().isObjectOfTypeGraphArcVisible(this.getSource().getType().getBasisType(), this.getTarget().getType().getBasisType());
            }
        }
        return this.visible;
    }

    @Override
    public Vector<Vector<String>> getAttributes() {
        Vector<Vector<String>> attrs = new Vector<Vector<String>>();
        if (this.bArc != null && this.bArc.getAttribute() != null) {
            AttrInstance attributes = this.bArc.getAttribute();
            if (attributes != null && this.getView() != null) {
                AttrViewSetting mvs = this.view.getMaskedView();
                int number = mvs.getSize(attributes);
                int i = 0;
                while (i < number) {
                    Vector<String> tmpAttrVector = new Vector<String>();
                    int index = mvs.convertSlotToIndex(attributes, i);
                    tmpAttrVector.addElement(attributes.getTypeAsString(index));
                    tmpAttrVector.addElement(attributes.getNameAsString(index));
                    tmpAttrVector.addElement(attributes.getValueAsString(index));
                    attrs.addElement(tmpAttrVector);
                    ++i;
                }
            } else {
                attrs = this.setAttributes(this.bArc);
            }
        }
        return attrs;
    }

    public Vector<Vector<String>> setAttributes(Arc bArc) {
        Vector<Vector<String>> attrs = new Vector<Vector<String>>();
        if (bArc == null) {
            return attrs;
        }
        if (bArc.getAttribute() == null) {
            return attrs;
        }
        int nattrs = bArc.getAttribute().getNumberOfEntries();
        if (nattrs != 0) {
            int i = 0;
            while (i < nattrs) {
                Vector<String> attr = new Vector<String>();
                attr.addElement(bArc.getAttribute().getTypeAsString(i));
                attr.addElement(bArc.getAttribute().getNameAsString(i));
                attr.addElement(bArc.getAttribute().getValueAsString(i));
                attrs.addElement(attr);
                ++i;
            }
        }
        return attrs;
    }

    @Override
    public Vector<Vector<String>> setAttributes(GraphObject obj) {
        return this.setAttributes((Arc)obj);
    }

    public void setBasisArc(Arc bArc) {
        this.bArc = bArc;
    }

    public EdGraphObject getSource() {
        return this.from;
    }

    public void setSource(EdGraphObject en) {
        this.from = en;
    }

    public EdGraphObject getTarget() {
        return this.to;
    }

    public void setTarget(EdGraphObject en) {
        this.to = en;
    }

    public void setDirected(boolean direct) {
        this.directed = direct;
        if (this.bArc != null) {
            this.bArc.setDirected(direct);
        }
    }

    public void setAnchor(Point newAnchor) {
        this.anchor = newAnchor;
        if (this.anchor == null) {
            this.hasDefaultAnchor = true;
        } else if (this.isLine()) {
            this.setXY(this.anchor.x, this.anchor.y);
            this.hasDefaultAnchor = false;
        } else {
            this.setAnchor(1, newAnchor);
        }
    }

    public void setAnchor(int id, Point newAnchor) {
        this.anchor = newAnchor;
        if (this.anchor == null) {
            this.hasDefaultAnchor = true;
        } else if (!this.isLine() && id == 1) {
            this.setXY(this.anchor.x, this.anchor.y);
            this.hasDefaultAnchor = false;
        }
    }

    public void setReps(boolean direct, boolean vis, boolean sel) {
        this.setDirected(direct);
        this.setVisible(vis);
        this.setSelected(sel);
    }

    public EdArc copy() {
        try {
            EdArc newArc = new EdArc(this.bArc, this.eType, this.from, this.to);
            newArc.setAnchor(this.getAnchor());
            return newArc;
        }
        catch (TypeException ex) {
            return null;
        }
    }

    public final Line toLine() {
        Line line = new Line(this.from.getX(), this.from.getY(), this.to.getX(), this.to.getY());
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
        }
        return line;
    }

    public final Loop toLoop() {
        Loop loop = new Loop(this.x, this.y, this.w, this.h);
        return loop;
    }

    public Dimension getTextSize(FontMetrics fm) {
        this.textSize.setSize(new Dimension(super.getTextWidth(fm), super.getTextHeight(fm)));
        return this.textSize;
    }

    public void updateTextSize(FontMetrics fm) {
        this.textSize.setSize(new Dimension(super.getTextWidth(fm), super.getTextHeight(fm)));
    }

    public Point getTextOffset() {
        return this.textOffset;
    }

    public void setTextOffset(int xOffset, int yOffset) {
        this.textOffset.x = xOffset;
        this.textOffset.y = yOffset;
    }

    public void translateTextOffset(int dx, int dy) {
        if (this.partOfText == 0) {
            this.textOffset.translate(dx, dy);
        } else if (this.partOfText == 1) {
            this.srcMultiplicityOffset.translate(dx, dy);
        } else if (this.partOfText == 2) {
            this.trgMultiplicityOffset.translate(dx, dy);
        }
    }

    @Override
    public boolean inside(int X, int Y) {
        this.anchorID = 0;
        Rectangle r = null;
        if (this.isLine()) {
            r = new Rectangle(this.x - this.w / 2 - this.in_offset, this.y - this.h / 2 - this.in_offset, this.w + this.in_offset * 2, this.h + this.in_offset * 2);
            if (r.contains(X, Y)) {
                return true;
            }
            Point p = new Point(this.x, this.y);
            if (this.anchor != null) {
                p = this.anchor;
            }
            if (this.arrowPoint != null && Line.inside(X, Y, p, this.arrowPoint, this.w + this.in_offset * 2)) {
                return true;
            }
            return this.tailPoint != null && Line.inside(X, Y, this.tailPoint, p, this.w + this.in_offset * 2);
        }
        Loop loop = this.toLoop();
        if (loop.contains(new Point(X, Y))) {
            if (loop.anchorID == 1) {
                this.anchor = loop.anchor;
                this.anchorID = loop.anchorID;
            }
            return true;
        }
        return false;
    }

    public boolean insideTextOfArc(int X, int Y, FontMetrics fm) {
        Rectangle r = this.getTextRectangle(fm);
        if (r != null && r.contains(X, Y)) {
            this.partOfText = 0;
            return true;
        }
        if (this.elemOfTG && !this.getContext().isInheritanceType(this.eType)) {
            if (this.insideTextOfMultiplicity(X, Y, "source")) {
                this.partOfText = 1;
                return true;
            }
            if (this.insideTextOfMultiplicity(X, Y, "target")) {
                this.partOfText = 2;
                return true;
            }
            return false;
        }
        return false;
    }

    private Rectangle getTextRectangle(FontMetrics fm) {
        Dimension d = this.getTextSize(fm);
        int tw = (int)d.getWidth();
        int th = (int)d.getHeight();
        if (this.isLine()) {
            int tx = 0;
            int ty = 0;
            if (this.anchor != null) {
                tx = this.anchor.x;
                ty = this.anchor.y;
            } else {
                tx = this.x;
                ty = this.y;
            }
            this.textLocation.x = (tx -= tw / 2) + this.textOffset.x;
            this.textLocation.y = ty + this.textOffset.y;
            return new Rectangle(this.textLocation.x, this.textLocation.y, tw, th);
        }
        this.textLocation.x = this.x + this.textOffset.x;
        this.textLocation.y = this.y + this.textOffset.y;
        return new Rectangle(this.textLocation.x, this.textLocation.y, tw, th);
    }

    private boolean insideTextOfMultiplicity(int X, int Y, String key) {
        if (key.equals("target")) {
            Rectangle r = new Rectangle(this.trgMultiplicityLocation.x + this.trgMultiplicityOffset.x, this.trgMultiplicityLocation.y + this.trgMultiplicityOffset.y - (int)this.trgMultiplicitySize.getHeight(), (int)this.trgMultiplicitySize.getWidth(), (int)this.trgMultiplicitySize.getHeight());
            return r.contains(X, Y);
        }
        if (key.equals("source")) {
            Rectangle r = new Rectangle(this.srcMultiplicityLocation.x + this.srcMultiplicityOffset.x, this.srcMultiplicityLocation.y + this.srcMultiplicityOffset.y - (int)this.srcMultiplicitySize.getHeight(), (int)this.srcMultiplicitySize.getWidth(), (int)this.srcMultiplicitySize.getHeight());
            return r.contains(X, Y);
        }
        return false;
    }

    public void applyScale(double scale) {
        if (scale != this.itsScale) {
            this.setX((int)((double)this.x * (scale / this.itsScale)));
            this.setY((int)((double)this.x * (scale / this.itsScale)));
            if (this.anchor != null) {
                this.anchor.x = (int)((double)this.anchor.x * (scale / this.itsScale));
                this.anchor.y = (int)((double)this.anchor.y * (scale / this.itsScale));
            }
            if (this.textOffset != null) {
                this.textOffset.x = (int)((double)this.textOffset.x * (scale / this.itsScale));
                this.textOffset.y = (int)((double)this.textOffset.y * (scale / this.itsScale));
            }
            if (!this.isLine()) {
                this.w = (int)((double)this.w * (scale / this.itsScale));
                this.h = (int)((double)this.h * (scale / this.itsScale));
            }
            this.itsScale = scale;
        }
    }

    public void drawShadowGraphic(Graphics grs) {
        if (this.visible) {
            Graphics2D g = (Graphics2D)grs;
            Color lastColor = g.getColor();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(Color.LIGHT_GRAY);
            g.setStroke(EditorConstants.defaultStroke);
            if (this.isLine()) {
                g.draw(new Rectangle2D.Double(this.anchor.x - 10, this.anchor.y - 10, 20.0, 20.0));
            } else {
                g.draw(new Rectangle2D.Double(this.anchor.x - 10, this.anchor.y - 10, 20.0, 20.0));
            }
            g.setFont(EditorConstants.defaultFont);
            g.setPaint(lastColor);
        }
    }

    public void drawTextShadowGraphic(Graphics grs, int px, int py) {
        if (this.visible) {
            Graphics2D g = (Graphics2D)grs;
            Color lastColor = g.getColor();
            int fontstyle = g.getFont().getStyle();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(Color.LIGHT_GRAY);
            g.setStroke(EditorConstants.defaultStroke);
            g.draw(new Rectangle2D.Double(px - 10, py - 10, 20.0, 20.0));
            g.setFont(new Font("Dialog", fontstyle, g.getFont().getSize()));
            g.setPaint(lastColor);
        }
    }

    @Override
    public void drawGraphic(Graphics grs) {
        boolean hiddenObjOfType;
        if (!this.visible) {
            return;
        }
        this.criticalStyle = this.eGraph.criticalStyle;
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.eType.filled) {
            g.setStroke(EditorConstants.boldStroke);
        } else {
            g.setStroke(EditorConstants.defaultStroke);
        }
        Color lastColor = g.getColor();
        if (this.backgroundColor != null && this.backgroundColor != Color.white) {
            g.setPaint(this.backgroundColor);
            if (this.from != this.to) {
                this.drawBackgroundLine(g);
            } else {
                this.drawBackgroundLoop(g);
            }
        }
        boolean bl = hiddenObjOfType = this.eGraph.isTypeGraph() && !this.eType.getBasisType().isObjectOfTypeGraphArcVisible(this.from.getType().getBasisType(), this.to.getType().getBasisType());
        if (this.selected) {
            g.setPaint(EditorConstants.selectColor);
        } else if (hiddenObjOfType) {
            g.setPaint(EditorConstants.hideColor);
        } else if (this.isCritical()) {
            if (this.criticalStyle == 0) {
                g.setStroke(EditorConstants.criticalColorStroke);
                g.setFont(EditorConstants.criticalFont);
                g.setPaint(EditorConstants.criticalColor);
            } else {
                g.setStroke(EditorConstants.criticalStroke);
                g.setPaint(Color.BLACK);
            }
        } else {
            g.setPaint(this.getColor());
        }
        if (this.from != this.to) {
            this.drawArcAsLine(g, true);
        } else {
            this.drawArcAsLoop(g, true);
        }
        if (this.errorMode) {
            this.showErrorAnchor(g);
        }
        g.setStroke(EditorConstants.defaultStroke);
        g.setFont(EditorConstants.defaultFont);
        g.setPaint(lastColor);
    }

    public void drawText(Graphics grs, double scale) {
        Graphics2D g = (Graphics2D)grs;
        g.setPaint(this.getColor());
        if (this.isLine()) {
            int ty;
            int tx;
            int tw = (int)this.getTextSize(g.getFontMetrics()).getWidth();
            if (this.anchor != null) {
                tx = this.anchor.x;
                ty = this.anchor.y;
            } else {
                tx = this.getX();
                ty = this.getY();
            }
            this.textLocation.x = (tx -= tw / 2) + this.textOffset.x;
            this.textLocation.y = ty + this.textOffset.y;
        } else {
            this.textLocation.x = this.x + this.textOffset.x;
            this.textLocation.y = this.y + this.textOffset.y;
        }
        this.drawText(g, this.textLocation.x, this.textLocation.y);
    }

    public void eraseText(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        g.setPaint(Color.white);
        if (this.isLine()) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    public void eraseGraphic(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(Color.white);
        this.eraseMoveAnchor(g);
        if (this.isLine()) {
            this.eraseArcAsLine(g, true);
        } else {
            this.eraseArcAsLoop(g, true);
        }
    }

    public int getWidthOfLoop() {
        if (this.getWidth() == 0) {
            return 20;
        }
        return this.getWidth();
    }

    public int getHeightOfLoop() {
        if (this.getHeight() == 0) {
            return 20;
        }
        return this.getHeight();
    }

    public void showMoveAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.showMoveAnchorOfLine(g);
        } else {
            this.showMoveAnchorOfLoop(g);
        }
    }

    public void eraseMoveAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.eraseMoveAnchorOfLine(g);
        } else {
            this.eraseMoveAnchorOfLoop(g);
        }
    }

    @Override
    public void attributeChanged(AttrViewEvent ev) {
        if (ev.getID() == 0 || ev.getID() == 20 || ev.getID() == 60 || ev.getID() == 50 || ev.getID() == 220 || ev.getID() == 210) {
            if (ev.getSource().getTupleType().isValid()) {
                this.attrChanged = true;
            }
        } else if (ev.getID() == 80 || ev.getID() == 70) {
            if (ev.getSource().isValid()) {
                ValueMember val;
                this.attrChanged = true;
                if (this.myGraphPanel != null && this.myGraphPanel.isAttrEditorActivated() && this.bArc.getContext().getAttrContext() != null && (val = ((ValueTuple)this.bArc.getAttribute()).getValueMemberAt(ev.getIndex())).isSet() && val.getExpr().isVariable()) {
                    ContextView viewContext = (ContextView)((ValueTuple)val.getHoldingTuple()).getContext();
                    VarTuple variable = (VarTuple)viewContext.getVariables();
                    VarMember var = variable.getVarMemberAt(val.getExprAsText());
                    if (var == null) {
                        return;
                    }
                    if (this.bArc.getContext().isNacGraph()) {
                        var.setMark(2);
                    } else if (this.bArc.getContext().isPacGraph()) {
                        var.setMark(3);
                    } else if (viewContext.doesAllowComplexExpressions()) {
                        var.setMark(1);
                    } else {
                        var.setMark(0);
                    }
                }
            } else {
                ValueTuple attr = (ValueTuple)this.bArc.getAttribute();
                int i = 0;
                while (i < attr.getSize()) {
                    ValueMember am = (ValueMember)attr.getMemberAt(i);
                    if (!am.isValid()) break;
                    ++i;
                }
            }
        }
    }

    @Override
    public void setGraphPanel(GraphPanel gp) {
        this.myGraphPanel = gp;
    }

    private void showMoveAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Line.MOVE_ANCHOR_COLOR);
        g.fillRect(this.x - 10, this.y - 10, 20, 20);
        g.setPaint(lastColor);
    }

    private void showMoveAnchorOfLoop(Graphics grs) {
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        loop.drawMoveAnchor(grs, this.anchorID);
    }

    protected void showErrorAnchor(Graphics g) {
        if (!this.from.equals(this.to)) {
            this.showErrorAnchorOfLine(g);
        } else {
            this.showErrorAnchorOfLoop(g);
        }
    }

    private void showErrorAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.green);
        g.fill(new Rectangle2D.Double(this.x - 6, this.y - 6, 12.0, 12.0));
        g.setPaint(lastColor);
    }

    private void showErrorAnchorOfLoop(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.green);
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.anchorID == 1) {
            g.fill(new Rectangle2D.Double(loop.anch1.x - 6, loop.anch1.y - 6, 12.0, 12.0));
        }
        g.setPaint(lastColor);
    }

    private void eraseMoveAnchorOfLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.white);
        g.fill(new Rectangle2D.Double(this.x - 5, this.y - 5, 10.0, 10.0));
        g.setPaint(lastColor);
    }

    private void eraseMoveAnchorOfLoop(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        Color lastColor = g.getColor();
        g.setPaint(Color.white);
        Loop loop = new Loop(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.anchorID == 1) {
            g.fill(new Rectangle2D.Double(loop.anch1.x - 5, loop.anch1.y - 5, 10.0, 10.0));
        }
        g.setPaint(lastColor);
    }

    private void drawArcAsLine(Graphics grs, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        boolean needAnchorTuning = true;
        int x1 = this.from.getX();
        int y1 = this.from.getY();
        int x2 = this.to.getX();
        int y2 = this.to.getY();
        int srcW = this.to.getWidth();
        int srcH = this.to.getHeight();
        int tarW = this.from.getWidth();
        int tarH = this.from.getHeight();
        Line line = this.toLine();
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
            needAnchorTuning = false;
        }
        this.setXY(line.getAnchor().x, line.getAnchor().y);
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            this.setWidth(14);
            this.setHeight(14);
        }
        line.setColor(g.getColor());
        int sh = this.getShape();
        switch (sh) {
            case 61: {
                line.drawColorSolidLine(g);
                break;
            }
            case 63: {
                line.drawColorDotLine(g);
                break;
            }
            case 62: {
                line.drawColorDashLine(g);
                break;
            }
        }
        if (this.weakselected) {
            line.drawWeakselectedLine(g);
            g.setColor(this.getColor());
        }
        if (this.elemOfTG) {
            Arrow arrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x2, y2, srcW, srcH, 0);
            this.arrowPoint = arrow.getHeadEnd();
            if (this.bArc.isInheritance()) {
                arrow.draw(g, false);
            } else if (this.directed) {
                arrow.draw(g);
            }
            Arrow backArrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x1, y1, tarW, tarH, 0);
            this.tailPoint = backArrow.getHeadEnd();
            if (this.directed && needAnchorTuning) {
                Point beg = backArrow.getHeadEnd();
                Point end = arrow.getHeadEnd();
                if (beg != null && end != null) {
                    int anchX = beg.x + (end.x - beg.x) / 2;
                    int anchY = beg.y + (end.y - beg.y) / 2;
                    line.setAnchor(new Point(anchX, anchY));
                    this.setXY(anchX, anchY);
                }
            }
            if (!this.bArc.isInheritance()) {
                Point p = new Point();
                if (arrow.getRightEnd() != null && y2 > line.getAnchor().y) {
                    p.y = arrow.getRightEnd().y - 5;
                    p.x = arrow.getRightEnd().x;
                } else if (arrow.getLeftEnd() != null) {
                    p.y = arrow.getLeftEnd().y + 5;
                    p.x = arrow.getLeftEnd().x;
                }
                this.drawMultiplicity(g, "target", p, this.eType.getBasisType().getTargetMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getTargetMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
                if (backArrow.getRightEnd() != null && y1 > line.getAnchor().y) {
                    p.y = backArrow.getRightEnd().y - 5;
                    p.x = backArrow.getRightEnd().x;
                } else if (backArrow.getLeftEnd() != null) {
                    p.y = backArrow.getLeftEnd().y + 5;
                    p.x = backArrow.getLeftEnd().x;
                }
                this.drawMultiplicity(g, "source", p, this.eType.getBasisType().getSourceMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getSourceMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
        } else if (this.directed) {
            int headsize = this.isCritical() && this.criticalStyle == 1 ? 17 : 0;
            Arrow arrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x2, y2, srcW, srcH, headsize);
            this.arrowPoint = arrow.getHeadEnd();
            arrow.draw(g);
            if (needAnchorTuning) {
                Arrow backArrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x1, y1, tarW, tarH, headsize);
                this.tailPoint = backArrow.getHeadEnd();
                Point beg = backArrow.getHeadEnd();
                Point end = arrow.getHeadEnd();
                if (beg != null && end != null) {
                    int anchX = beg.x + (end.x - beg.x) / 2;
                    int anchY = beg.y + (end.y - beg.y) / 2;
                    line.setAnchor(new Point(anchX, anchY));
                    this.setXY(anchX, anchY);
                }
            }
        }
        if (withText) {
            g.setStroke(EditorConstants.defaultStroke);
            this.textLocation.x = this.getX() + this.textOffset.x;
            this.textLocation.y = this.getY() + this.textOffset.y;
            this.drawText(g, this.textLocation.x, this.textLocation.y);
        }
    }

    public void refreshTextLocation() {
        Line line = this.toLine();
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
        }
        this.setXY(line.getAnchor().x, line.getAnchor().y);
        this.textLocation.x = this.getX() + this.textOffset.x;
        this.textLocation.y = this.getY() + this.textOffset.y;
    }

    private void drawBackgroundLine(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(new BasicStroke(5.0f));
        Line line = this.toLine();
        if (this.anchor != null) {
            line.setAnchor(new Point(this.anchor.x, this.anchor.y));
        }
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            this.setWidth(14);
            this.setHeight(14);
        }
        line.setColor(g.getColor());
        line.drawColorSolidLine(g);
        g.setStroke(EditorConstants.defaultStroke);
    }

    private void eraseArcAsLine(Graphics grs, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        int[] nX = new int[6];
        int[] nY = new int[6];
        int n = 5;
        int n1 = 5;
        nX[0] = this.from.getX();
        nY[0] = this.from.getY() - n;
        nX[1] = this.getX();
        nY[1] = this.getY() - n;
        nX[2] = this.to.getX();
        nY[2] = this.to.getY() - (n + n1);
        nX[3] = this.to.getX();
        nY[3] = this.to.getY() + (n + n1);
        nX[4] = this.getX();
        nY[4] = this.getY() + n;
        nX[5] = this.from.getX();
        nY[5] = this.from.getY() + n;
        int nP = 6;
        g.fillPolygon(nX, nY, nP);
        if (withText) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void drawArcAsLoop(Graphics grs, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        int fromX = this.from.getX();
        int fromY = this.from.getY();
        int fromW = this.from.getWidth();
        int fromH = this.from.getHeight();
        if (((EdNode)this.from).getShape() == 52) {
            fromH = fromW = (int)(Math.acos(0.0) * (double)(this.from.getWidth() / 2));
        } else if (((EdNode)this.from).getShape() == 53) {
            int nn = 0;
            nn = fromW < fromH ? fromW - (fromH - fromW) / 2 : fromH - (fromW - fromH) / 2;
            fromW = nn;
            fromH = nn;
        }
        int w1 = 0;
        int h1 = 0;
        int x1 = 0;
        int y1 = 0;
        int offsetX = 0;
        int offsetY = 0;
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            h1 = w1 = this.getWidthOfLoop();
            offsetX = fromW / 2 + w1 / 2 + w1 / 4;
            offsetY = fromH / 2 + h1 / 2 + h1 / 4;
            x1 = fromX - offsetX;
            y1 = fromY - offsetY;
            this.setXY(x1, y1);
            this.setWidth(w1);
            this.setHeight(h1);
        } else {
            w1 = this.getWidth();
            h1 = this.getHeight();
            offsetX = fromW / 2 + w1 / 2 + w1 / 4;
            offsetY = fromH / 2 + h1 / 2 + h1 / 4;
            x1 = fromX - offsetX;
            y1 = fromY - offsetY;
            int difX = 0;
            int difY = 0;
            if (x1 + w1 <= fromX - fromW / 2) {
                difX = fromX - fromW / 2 - (x1 + w1);
                x1 = x1 + difX + 5;
            } else if (x1 >= fromX + fromW / 2) {
                difX = x1 - (fromX + fromW / 2);
                x1 = x1 - difX - 5;
            }
            if (y1 + h1 <= fromY - fromH / 2) {
                difY = fromY - fromH / 2 - (y1 + h1);
                y1 = y1 + difY + 5;
            } else if (y1 >= fromY + fromH / 2) {
                difY = y1 - (fromY + fromH / 2);
                y1 = y1 - difY - 5;
            }
            Loop tLoop = new Loop(x1, y1, w1, h1);
            if (!tLoop.outside(((EdNode)this.from).toRectangle(), tLoop.anch1, tLoop.anch2, tLoop.anch3, tLoop.anch4)) {
                x1 = fromX - fromW / 2 - w1 / 2 - w1 / 4;
                y1 = fromY - fromH / 2 - h1 / 2 - h1 / 4;
            }
        }
        Loop loop = new Loop(x1, y1, w1, h1);
        this.setXY(x1, y1);
        this.setWidth(w1);
        this.setHeight(h1);
        loop.setColor(g.getColor());
        int sh = this.getShape();
        switch (sh) {
            case 61: {
                loop.drawColorSolidLoop(g);
                break;
            }
            case 63: {
                loop.drawColorDotLoop(g);
                break;
            }
            case 62: {
                loop.drawColorDashLoop(g);
                break;
            }
        }
        if (this.weakselected) {
            loop.drawWeakselectedLoop(g);
            g.setColor(this.getColor());
        }
        if (this.elemOfTG) {
            Arrow backArrow;
            Arrow arrow = new Arrow(this.itsScale, loop.anch4.x, loop.anch4.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (fromX - fromW / 2)) * 2, (loop.anch3.y - (fromY - fromH / 2)) * 2, 0);
            if (this.directed) {
                arrow.draw(g);
            }
            if (arrow.getRightEnd() != null) {
                this.drawMultiplicity(g, "target", arrow.getRightEnd(), this.eType.getBasisType().getTargetMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getTargetMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
            if ((backArrow = new Arrow(this.itsScale, loop.anch2.x, loop.anch2.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (fromX - fromW / 2)) * 2, (loop.anch3.y - (fromY - fromH / 2)) * 2, 0)).getLeftEnd() != null) {
                Point p = new Point(backArrow.getLeftEnd().x, backArrow.getLeftEnd().y - 10);
                this.drawMultiplicity(g, "source", p, this.eType.getBasisType().getSourceMin(this.bArc.getSource().getType(), this.bArc.getTarget().getType()), this.eType.getBasisType().getSourceMax(this.bArc.getSource().getType(), this.bArc.getTarget().getType()));
            }
        } else if (this.directed) {
            int headsize = this.isCritical() && this.criticalStyle == 1 ? 17 : 0;
            Arrow arrow = new Arrow(this.itsScale, loop.anch4.x, loop.anch4.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (fromX - fromW / 2)) * 2, (loop.anch3.y - (fromY - fromH / 2)) * 2, headsize);
            arrow.draw(g);
        }
        if (withText) {
            g.setStroke(EditorConstants.defaultStroke);
            this.textLocation.x = x1 + this.textOffset.x;
            this.textLocation.y = y1 + this.textOffset.y;
            this.drawText(g, this.textLocation.x, this.textLocation.y);
        }
    }

    private void drawBackgroundLoop(Graphics grs) {
        Graphics2D g = (Graphics2D)grs;
        g.setStroke(new BasicStroke(5.0f));
        int fromWidth = this.from.getWidth();
        int fromHeight = this.from.getHeight();
        int w1 = 0;
        int h1 = 0;
        int x1 = 0;
        int y1 = 0;
        if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
            h1 = w1 = this.getWidthOfLoop();
            x1 = this.from.getX() - (fromWidth / 2 + w1);
            y1 = this.from.getY() - (fromHeight / 2 + h1);
        } else {
            w1 = this.getWidth();
            h1 = this.getHeight();
            x1 = this.from.getX() - (fromWidth / 2 + w1);
            y1 = this.from.getY() - (fromHeight / 2 + h1);
        }
        Loop loop = new Loop(x1, y1, w1, h1);
        loop.setColor(g.getColor());
        loop.drawColorSolidLoop(g);
        g.setStroke(EditorConstants.defaultStroke);
    }

    private void eraseArcAsLoop(Graphics grs, boolean withText) {
        Graphics2D g = (Graphics2D)grs;
        g.fillRect(this.getX(), this.getY(), this.getWidth() + 2, this.getHeight() + 5);
        if (withText) {
            Rectangle r = this.getTextRectangle(g.getFontMetrics());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private void drawText(Graphics grs, int X, int Y) {
        if (X > 0 && Y > 0) {
            Graphics2D g = (Graphics2D)grs;
            boolean underlined = false;
            int tx = X;
            int ty = Y;
            FontMetrics fm = g.getFontMetrics();
            int tw = this.getTextWidth(fm);
            String typeStr = this.getTypeString();
            int ty1 = ty + fm.getAscent();
            g.drawString(typeStr, tx, ty1);
            if (g.getFont().getSize() < 8 || !this.attrVisible) {
                return;
            }
            Vector<Vector<String>> attrs = this.getAttributes();
            if (attrs != null && !attrs.isEmpty()) {
                int i = 0;
                while (i < attrs.size()) {
                    String attrStr;
                    Vector<String> attr = attrs.elementAt(i);
                    if (!this.elemOfTG && attr.elementAt(2).length() != 0) {
                        attrStr = attr.elementAt(1);
                        attrStr = String.valueOf(attr.elementAt(1)) + "=";
                        attrStr = String.valueOf(attrStr) + attr.elementAt(2);
                        if (!underlined) {
                            g.drawLine(tx, ty += fm.getHeight(), tx + tw, ty);
                            ty += 2;
                            underlined = true;
                        }
                        ty1 = ty + fm.getAscent();
                        g.drawString(attrStr, tx, ty1);
                        ty += fm.getHeight();
                    } else if (this.elemOfTG && attr.elementAt(1) != null) {
                        attrStr = attr.elementAt(0);
                        attrStr = String.valueOf(attrStr) + "  ";
                        attrStr = String.valueOf(attrStr) + attr.elementAt(1);
                        if (attr.elementAt(2).length() != 0) {
                            attrStr = String.valueOf(attrStr) + "=" + attr.elementAt(2);
                        }
                        if (!underlined) {
                            g.drawLine(tx, ty += fm.getHeight(), tx + tw, ty);
                            ty += 2;
                            underlined = true;
                        }
                        ty1 = ty + fm.getAscent();
                        g.drawString(attrStr, tx, ty1);
                        ty += fm.getHeight();
                    }
                    ++i;
                }
            }
        }
    }

    private void drawMultiplicity(Graphics grs, String key, Point p, int min, int max) {
        Graphics2D g = (Graphics2D)grs;
        String s = "";
        if (min != -1) {
            s = s.concat(String.valueOf(min));
            s = s.concat("..");
            if (max == -1) {
                s = s.concat("*");
            }
        } else {
            s = max != -1 ? s.concat("0..") : "*";
        }
        if (max != -1) {
            s = min != max ? s.concat(String.valueOf(max)) : String.valueOf(max);
        }
        int w1 = g.getFontMetrics().stringWidth(s);
        int h1 = g.getFontMetrics().getHeight();
        if (key.equals("source")) {
            if (this.srcMultiplicityOffset.x == 0 && this.srcMultiplicityOffset.y == 0) {
                this.srcMultiplicityOffset.x = this.isLine() ? -w1 : 5;
                this.srcMultiplicityOffset.y = h1;
            }
            this.srcMultiplicityLocation.x = p.x;
            this.srcMultiplicityLocation.y = p.y;
            this.srcMultiplicitySize.setSize(new Dimension(w1, h1));
            g.drawString(s, this.srcMultiplicityLocation.x + this.srcMultiplicityOffset.x, this.srcMultiplicityLocation.y + this.srcMultiplicityOffset.y);
        } else if (key.equals("target")) {
            if (this.trgMultiplicityOffset.x == 0 && this.trgMultiplicityOffset.y == 0) {
                this.trgMultiplicityOffset.x = -w1;
                this.trgMultiplicityOffset.y = h1 / 2;
            }
            this.trgMultiplicityLocation.x = p.x;
            this.trgMultiplicityLocation.y = p.y;
            this.trgMultiplicitySize.setSize(new Dimension(w1, h1));
            g.drawString(s, this.trgMultiplicityLocation.x + this.trgMultiplicityOffset.x, this.trgMultiplicityLocation.y + this.trgMultiplicityOffset.y);
        }
    }

    public void drawNameAttrOnly(Graphics grs) {
        if (!this.visible) {
            return;
        }
        this.criticalStyle = this.eGraph.criticalStyle;
        Graphics2D g = (Graphics2D)grs;
        if (this.eType.filled) {
            g.setStroke(EditorConstants.boldStroke);
        } else {
            g.setStroke(EditorConstants.defaultStroke);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(this.getColor());
        if (!this.from.equals(this.to)) {
            boolean needAnchorTuning = true;
            int x1 = this.from.getX();
            int y1 = this.from.getY();
            int x2 = this.to.getX();
            int y2 = this.to.getY();
            Line line = this.toLine();
            if (this.anchor != null) {
                line.setAnchor(new Point(this.anchor.x, this.anchor.y));
                needAnchorTuning = false;
            }
            this.setXY(line.getAnchor().x, line.getAnchor().y);
            if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
                this.setWidth(14);
                this.setHeight(14);
            }
            line.setColor(this.getColor());
            int sh = this.getShape();
            switch (sh) {
                case 61: {
                    line.drawColorSolidLine(g);
                    break;
                }
                case 63: {
                    line.drawColorDotLine(g);
                    break;
                }
                case 62: {
                    line.drawColorDashLine(g);
                    break;
                }
            }
            int headsize = this.isCritical() && this.criticalStyle == 1 ? 17 : 0;
            Arrow arrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x2, y2, this.to.getWidth(), this.to.getHeight(), headsize);
            if (this.isDirected()) {
                arrow.draw(g);
            }
            Arrow tmpBackArrow = new Arrow(this.itsScale, line.getAnchor().x, line.getAnchor().y, x1, y1, this.from.getWidth(), this.from.getHeight(), headsize);
            if (needAnchorTuning) {
                Point beg = tmpBackArrow.getHeadEnd();
                Point end = arrow.getHeadEnd();
                if (beg != null && end != null) {
                    int anchX = beg.x + (end.x - beg.x) / 2;
                    int anchY = beg.y + (end.y - beg.y) / 2;
                    line.setAnchor(new Point(anchX, anchY));
                    this.setXY(anchX, anchY);
                }
            }
            this.textLocation.x = this.getX() + this.textOffset.x;
            this.textLocation.y = this.getY() + this.textOffset.y;
            this.showNameAttrOnly(g, this.textLocation.x, this.textLocation.y);
        } else {
            int fromWidth = this.from.getWidth();
            int fromHeight = this.from.getHeight();
            int w1 = 0;
            int h1 = 0;
            int x1 = 0;
            int y1 = 0;
            int offsetX = 0;
            int offsetY = 0;
            if (this.getWidth() == this.getHeight() && this.getHeight() == 0) {
                h1 = w1 = this.getWidthOfLoop();
                offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
                offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
                x1 = this.from.getX() - offsetX;
                y1 = this.from.getY() - offsetY;
                this.setXY(x1, y1);
                this.setWidth(w1);
                this.setHeight(h1);
            } else {
                w1 = this.getWidth();
                h1 = this.getHeight();
                offsetX = fromWidth / 2 + w1 / 2 + w1 / 4;
                offsetY = fromHeight / 2 + h1 / 2 + h1 / 4;
                x1 = this.from.getX() - offsetX;
                y1 = this.from.getY() - offsetY;
                int difX = 0;
                int difY = 0;
                if (x1 + w1 <= this.from.getX() - fromWidth / 2) {
                    difX = this.from.getX() - fromWidth / 2 - (x1 + w1);
                    x1 = x1 + difX + 5;
                } else if (x1 >= this.from.getX() + fromWidth / 2) {
                    difX = x1 - (this.from.getX() + fromWidth / 2);
                    x1 = x1 - difX - 5;
                }
                if (y1 + h1 <= this.from.getY() - fromHeight / 2) {
                    difY = this.from.getY() - fromHeight / 2 - (y1 + h1);
                    y1 = y1 + difY + 5;
                } else if (y1 >= this.from.getY() + fromHeight / 2) {
                    difY = y1 - (this.from.getY() + fromHeight / 2);
                    y1 = y1 - difY - 5;
                }
                Loop tLoop = new Loop(x1, y1, w1, h1);
                if (!tLoop.outside(((EdNode)this.from).toRectangle(), tLoop.anch1, tLoop.anch2, tLoop.anch3, tLoop.anch4)) {
                    x1 = this.from.getX() - fromWidth / 2 - w1 / 2 - w1 / 4;
                    y1 = this.from.getY() - fromHeight / 2 - h1 / 2 - h1 / 4;
                }
            }
            Loop loop = new Loop(x1, y1, w1, h1);
            this.setXY(x1, y1);
            this.setWidth(w1);
            this.setHeight(h1);
            loop.setColor(this.getColor());
            int sh = this.getShape();
            switch (sh) {
                case 61: {
                    loop.drawColorSolidLoop(g);
                    break;
                }
                case 63: {
                    loop.drawColorDotLoop(g);
                    break;
                }
                case 62: {
                    loop.drawColorDashLoop(g);
                    break;
                }
            }
            int headsize = this.isCritical() && this.criticalStyle == 1 ? 17 : 0;
            Arrow arrow = new Arrow(this.itsScale, loop.anch4.x, loop.anch4.y, loop.anch3.x, loop.anch3.y, (loop.anch3.x - (this.from.getX() - fromWidth / 2)) * 2, (loop.anch3.y - (this.from.getY() - fromHeight / 2)) * 2, headsize);
            arrow.draw(g);
            this.textLocation.x = x1 + this.textOffset.x;
            this.textLocation.y = y1 + this.textOffset.y;
            this.showNameAttrOnly(g, this.textLocation.x, this.textLocation.y);
        }
        g.setPaint(this.getColor());
        g.setStroke(EditorConstants.defaultStroke);
    }

    private void showNameAttrOnly(Graphics grs, int X, int Y) {
        int ty;
        Graphics2D g = (Graphics2D)grs;
        int tx = X;
        if (tx <= 0) {
            tx = 2;
        }
        if ((ty = Y) <= 0) {
            ty = 2;
        }
        FontMetrics fm = g.getFontMetrics();
        Vector<Vector<String>> attrs = this.getAttributes();
        if (attrs != null && !attrs.isEmpty()) {
            int i = 0;
            while (i < attrs.size()) {
                Vector<String> attr = attrs.elementAt(i);
                if (attr.elementAt(2).length() != 0 && attr.elementAt(1).equals("name")) {
                    String attrStr = attr.elementAt(2);
                    if (!attrStr.equals("\"\"")) {
                        int ty1 = ty + fm.getAscent();
                        g.drawString(attrStr, tx, ty1);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void XwriteObject(XMLHelper xmlh) {
        if (xmlh.openObject(this.bArc, this)) {
            xmlh.openSubTag("EdgeLayout");
            int outX = (int)((double)this.textOffset.x / this.itsScale);
            int outY = (int)((double)this.textOffset.y / this.itsScale);
            xmlh.addAttr("textOffsetX", outX);
            xmlh.addAttr("textOffsetY", outY);
            if (this.isLine()) {
                if (this.hasDefaultAnchor) {
                    xmlh.addAttr("bendX", 0);
                    xmlh.addAttr("bendY", 0);
                } else {
                    outX = (int)((double)this.x / this.itsScale);
                    outY = (int)((double)this.y / this.itsScale);
                    xmlh.addAttr("bendX", outX);
                    xmlh.addAttr("bendY", outY);
                }
            } else {
                outX = (int)((double)this.x / this.itsScale);
                outY = (int)((double)this.y / this.itsScale);
                xmlh.addAttr("bendX", outX);
                xmlh.addAttr("bendY", outY);
                outX = (int)((double)this.w / this.itsScale);
                outY = (int)((double)this.h / this.itsScale);
                xmlh.addAttr("loopW", outX);
                xmlh.addAttr("loopH", outY);
            }
            if (this.isElementOfTypeGraph()) {
                outX = (int)((double)this.srcMultiplicityOffset.x / this.itsScale);
                outY = (int)((double)this.srcMultiplicityOffset.y / this.itsScale);
                xmlh.addAttr("sourceMultiplicityOffsetX", outX);
                xmlh.addAttr("sourceMultiplicityOffsetY", outY);
                outX = (int)((double)this.trgMultiplicityOffset.x / this.itsScale);
                outY = (int)((double)this.trgMultiplicityOffset.y / this.itsScale);
                xmlh.addAttr("targetMultiplicityOffsetX", outX);
                xmlh.addAttr("targetMultiplicityOffsetY", outY);
            }
            xmlh.close();
            if (this.lArc != null) {
                xmlh.addObject("", this.lArc, true);
            }
            xmlh.close();
        }
    }

    @Override
    public void XreadObject(XMLHelper xmlh) {
        int loopW = 0;
        int loopH = 0;
        xmlh.peekObject(this.bArc, this);
        if (xmlh.readSubTag("EdgeLayout")) {
            this.textOffset = new Point();
            String s = xmlh.readAttr("textOffsetX");
            this.textOffset.x = s.length() == 0 ? 0 : new Integer(s);
            s = xmlh.readAttr("textOffsetY");
            this.textOffset.y = s.length() == 0 ? 0 : new Integer(s);
            s = xmlh.readAttr("bendX");
            if (s.length() == 0 || s.equals("0")) {
                this.x = 0;
            } else {
                this.x = new Integer(s);
                if (this.x < 0) {
                    this.x = 0;
                }
            }
            s = xmlh.readAttr("bendY");
            if (s.length() == 0 || s.equals("0")) {
                this.y = 0;
            } else {
                this.y = new Integer(s);
                if (this.y < 0) {
                    this.y = 0;
                }
            }
            if (!this.isLine()) {
                s = xmlh.readAttr("loopW");
                loopW = s.length() == 0 ? 0 : new Integer(s);
                s = xmlh.readAttr("loopH");
                loopH = s.length() == 0 ? 0 : new Integer(s);
            }
            if (this.elemOfTG) {
                this.createMultiplicityVars();
                s = xmlh.readAttr("sourceMultiplicityOffsetX");
                this.srcMultiplicityOffset.x = s.length() == 0 ? 0 : new Integer(s);
                s = xmlh.readAttr("sourceMultiplicityOffsetY");
                this.srcMultiplicityOffset.y = s.length() == 0 ? 0 : new Integer(s);
                s = xmlh.readAttr("targetMultiplicityOffsetX");
                this.trgMultiplicityOffset.x = s.length() == 0 ? 0 : new Integer(s);
                s = xmlh.readAttr("targetMultiplicityOffsetY");
                this.trgMultiplicityOffset.y = s.length() == 0 ? 0 : new Integer(s);
            }
            xmlh.close();
            if (this.isLine()) {
                Line line = this.toLine();
                Point p = line.getAnchor();
                if (this.x == 0 && this.y == 0 || p.x == this.x && p.y == this.y) {
                    this.hasDefaultAnchor = true;
                } else {
                    this.hasDefaultAnchor = false;
                    this.setAnchor(new Point(this.x, this.y));
                }
            } else if (xmlh.getDocumentVersion().equals("1.0")) {
                if (loopW != 0 && loopH != 0) {
                    this.anchor = new Point(this.x, this.y);
                    this.anchorID = 1;
                    this.hasDefaultAnchor = false;
                    this.setXY(this.x, this.y);
                    this.setWidth(loopW);
                    this.setHeight(loopH);
                } else {
                    this.setAnchor(new Point(this.x, this.y));
                    this.hasDefaultAnchor = true;
                }
            } else {
                this.setAnchor(new Point(this.x, this.y));
                this.hasDefaultAnchor = true;
            }
        }
        xmlh.enrichObject(this.lArc);
        xmlh.close();
        this.attrVisible = true;
        this.attrChanged = false;
    }
}

