/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ModelSelector {
    protected Collection<ModelSelectorListener> listeners = new ArrayList<ModelSelectorListener>();
    protected static int CONTROL_OFFSET = 5;
    protected Group container;
    protected Button checkResourceButton;
    protected Button browseWorkspaceButton;
    protected Button browseFileSystemButton;
    protected Button newFileButton;
    protected Combo uriField;

    public ModelSelector(Composite parent, final IResource baseDir) {
        this.container = new Group(parent, 0);
        this.container.setText(HenshinInterpreterUIPlugin.LL("_UI_SelectModel"));
        this.container.setLayout((Layout)new FormLayout());
        Composite buttonComp = new Composite((Composite)this.container, 0);
        buttonComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, CONTROL_OFFSET);
        data.left = new FormAttachment(0, CONTROL_OFFSET);
        data.right = new FormAttachment(100, -CONTROL_OFFSET);
        buttonComp.setLayoutData((Object)data);
        this.browseWorkspaceButton = new Button(buttonComp, 8);
        this.browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
        data = new FormData();
        data.top = new FormAttachment(0, CONTROL_OFFSET);
        data.right = new FormAttachment(100, -CONTROL_OFFSET);
        this.browseWorkspaceButton.setLayoutData((Object)data);
        this.browseFileSystemButton = new Button(buttonComp, 8);
        this.browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
        data = new FormData();
        data.top = new FormAttachment(0, CONTROL_OFFSET);
        data.right = new FormAttachment((Control)this.browseWorkspaceButton, -CONTROL_OFFSET);
        this.browseFileSystemButton.setLayoutData((Object)data);
        Composite fieldComp = new Composite((Composite)this.container, 0);
        fieldComp.setLayout((Layout)new FormLayout());
        FormData data2 = new FormData();
        data2.top = new FormAttachment((Control)buttonComp, CONTROL_OFFSET);
        data2.left = new FormAttachment(0, CONTROL_OFFSET);
        data2.right = new FormAttachment(100, -CONTROL_OFFSET);
        fieldComp.setLayoutData((Object)data2);
        this.checkResourceButton = new Button(fieldComp, 8);
        this.checkResourceButton.setText(HenshinInterpreterUIPlugin.LL("_UI_CheckResource"));
        this.checkResourceButton.setEnabled(false);
        data2 = new FormData();
        data2.top = new FormAttachment(0, CONTROL_OFFSET);
        data2.right = new FormAttachment(100, -CONTROL_OFFSET);
        this.checkResourceButton.setLayoutData((Object)data2);
        this.uriField = new Combo(fieldComp, 2048);
        data2 = new FormData();
        data2.top = new FormAttachment(0, CONTROL_OFFSET);
        data2.left = new FormAttachment(0, CONTROL_OFFSET);
        data2.right = new FormAttachment((Control)this.checkResourceButton, -CONTROL_OFFSET);
        this.uriField.setLayoutData((Object)data2);
        this.uriField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ModelSelector.this.checkResourceButton.setEnabled(true);
                ModelSelector.this.fireURIFieldDirty();
            }
        });
        this.uriField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelector.this.fireURIChanged();
            }
        });
        Composite newFileComp = new Composite((Composite)this.container, 0);
        newFileComp.setLayout((Layout)new FormLayout());
        FormData data3 = new FormData();
        data3.top = new FormAttachment((Control)fieldComp, CONTROL_OFFSET);
        data3.left = new FormAttachment((Control)buttonComp, 0, 16384);
        data3.right = new FormAttachment((Control)buttonComp, 0, 131072);
        newFileComp.setLayoutData((Object)data3);
        this.newFileButton = new Button(newFileComp, 32);
        this.newFileButton.setAlignment(0x1000000);
        this.newFileButton.setText(HenshinInterpreterUIPlugin.LL("_UI_CreateNewFile"));
        this.newFileButton.setSelection(HenshinInterpreterUIPlugin.getPlugin().getPreferenceStore().getBoolean("createNewFile"));
        data3 = new FormData();
        data3.top = new FormAttachment(0, 5);
        data3.right = new FormAttachment(100, -CONTROL_OFFSET);
        this.newFileButton.setLayoutData((Object)data3);
        this.checkResourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelector.this.fireURIChanged();
            }
        });
        this.browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] objectArray;
                if (baseDir == null) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = baseDir;
                }
                Object[] selection = objectArray;
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HenshinInterpreterUIPlugin.LL("_UI_BrowseWorkspace_Title"), (String)HenshinInterpreterUIPlugin.LL("_UI_BrowseWorkspace_Message"), (boolean)false, (Object[])selection, null);
                if (files.length != 1) {
                    return;
                }
                IFile file = files[0];
                if (file != null) {
                    URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    ModelSelector.this.uriField.setText(uri.toString());
                    ModelSelector.this.fireURIChanged();
                }
            }
        });
        this.browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                fileDialog.open();
                String path = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName != null) {
                    URI uri = URI.createFileURI((String)(String.valueOf(path) + File.separator + fileName));
                    ModelSelector.this.uriField.setText(uri.toString());
                    ModelSelector.this.fireURIChanged();
                }
            }
        });
        this.newFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HenshinInterpreterUIPlugin.getPlugin().getPreferenceStore().setValue("createNewFile", ModelSelector.this.newFileButton.getSelection());
            }
        });
    }

    protected void fireURIChanged() {
        this.checkResourceButton.setEnabled(false);
        for (ModelSelectorListener l : this.listeners) {
            l.modelURIChanged(URI.createURI((String)this.uriField.getText()));
        }
    }

    protected void fireURIFieldDirty() {
        for (ModelSelectorListener l : this.listeners) {
            l.uriFieldDirty();
        }
    }

    public void setLastUsedModels(String[] models) {
        this.uriField.setItems(models);
        this.uriField.select(0);
    }

    public Control getControl() {
        return this.container;
    }

    public void addModelSelectorListener(ModelSelectorListener listener) {
        this.listeners.add(listener);
    }

    public static interface ModelSelectorListener {
        public boolean modelURIChanged(URI var1);

        public void uriFieldDirty();
    }
}

