/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.util.Stack;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.Interpreter;
import org.eclipse.emf.henshin.interpreter.impl.RuleApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class Debugger
extends Interpreter {
    private Stack<UnitApplication> done = new Stack();
    private Stack<UnitApplication> undone = new Stack();

    public Debugger(String resourcePath) {
        super(resourcePath);
    }

    @Override
    public EGraph executeUnit(EGraph graph, Module mod, String unitName, Object ... parameterValues) {
        EGraph res = super.executeUnit(graph, mod, unitName, parameterValues);
        this.done.push(this.app);
        this.undone.clear();
        return res;
    }

    public EGraph undo() {
        if (this.done.isEmpty()) {
            throw new RuntimeException("No undoable Units exist");
        }
        UnitApplication u = this.done.pop();
        if (u.undo(this.getApplicationMonitor())) {
            this.undone.push(u);
            return u.getEGraph();
        }
        throw new RuntimeException("Failed to undo transformation");
    }

    public EGraph redo() {
        if (this.undone.isEmpty()) {
            throw new RuntimeException("No redoable Units exist");
        }
        UnitApplication u = this.undone.pop();
        if (u.redo(this.getApplicationMonitor())) {
            this.done.push(u);
            return u.getEGraph();
        }
        throw new RuntimeException("Failed to redo transformation");
    }

    public EGraph executeRuleOnMatch(EGraph graph, Module mod, String ruleName, Match match, Object ... parameterValues) {
        Rule r;
        try {
            r = (Rule)mod.getUnit(ruleName);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("Specified Unit is not a Rule");
        }
        if (r == null) {
            throw new RuntimeException("Specified Rule does not exist");
        }
        this.app = new RuleApplicationImpl(this.getEngine());
        this.app.setEGraph(graph);
        this.app.setUnit((Unit)r);
        if (match != null && match.isComplete()) {
            ((RuleApplication)this.app).setCompleteMatch(match);
            this.assignParameters(match, parameterValues);
        } else if (match != null) {
            ((RuleApplication)this.app).setPartialMatch(match);
            this.assignParameters(match, parameterValues);
        } else if (match == null) {
            ((RuleApplication)this.app).setPartialMatch(InterpreterFactory.INSTANCE.createMatch((Rule)this.app.getUnit(), false));
            this.assignParameters(((RuleApplication)this.app).getPartialMatch(), parameterValues);
        }
        if (((RuleApplication)this.app).execute(this.getApplicationMonitor())) {
            this.done.push(this.app);
            this.undone.clear();
            return graph;
        }
        throw new RuntimeException("Failed to apply transformation");
    }

    public EGraph executeRuleOnMatch(String inputModelPath, Module mod, String ruleName, Match match, Object ... parameterValues) {
        return this.executeRuleOnMatch(this.loadGraphFromFile(inputModelPath), mod, ruleName, match, parameterValues);
    }

    public EGraph executeRuleOnMatch(EGraph graph, String modulePath, String ruleName, Match match, Object ... parameterValues) {
        return this.executeRuleOnMatch(graph, this.loadModuleFromFile(modulePath), ruleName, match, parameterValues);
    }

    public EGraph executeRuleOnMatch(String inputModelPath, String modulePath, String ruleName, Match match, Object ... parameterValues) {
        return this.executeRuleOnMatch(this.loadGraphFromFile(inputModelPath), this.loadModuleFromFile(modulePath), ruleName, match, parameterValues);
    }
}

