/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.giraph;

import java.util.Collection;
import org.eclipse.emf.henshin.giraph.GiraphUtil;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;

public class GiraphConfig {
    protected String projectName = "giraph-henshin-examples";
    protected String packageName = "org.apache.giraph.henshin.examples";
    protected String className = "Main";
    protected String inputName = "Input";
    protected Unit mainUnit;
    protected Graph inputGraph;
    protected boolean masterLogging = true;
    protected boolean testEnvironment = false;
    protected boolean useUUIDs = false;
    protected boolean vertexLogging = false;

    public String getClassName() {
        return this.className;
    }

    public Graph getInputGraph() {
        return this.inputGraph;
    }

    public String getInputName() {
        return this.inputName;
    }

    public Unit getMainUnit() {
        return this.mainUnit;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isMasterLogging() {
        return this.masterLogging;
    }

    public boolean isTestEnvironment() {
        return this.testEnvironment;
    }

    public boolean isUseUUIDs() {
        return this.useUUIDs;
    }

    public boolean isVertexLogging() {
        return this.vertexLogging;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setInputGraph(Graph inputGraph) {
        this.inputGraph = inputGraph;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public void setMainUnit(Unit mainUnit) {
        Collection<Rule> rules;
        this.mainUnit = mainUnit;
        if (this.inputGraph == null && !(rules = GiraphUtil.collectRules(mainUnit)).isEmpty()) {
            Rule rule = rules.iterator().next();
            this.inputGraph = rule.getLhs();
            if (this.inputGraph.getNodes().isEmpty() && !rule.getMultiRules().isEmpty()) {
                this.inputGraph = ((Rule)rule.getMultiRules().get(0)).getLhs();
            }
        }
        if (mainUnit.getName() != null && !mainUnit.getName().trim().isEmpty()) {
            this.className = mainUnit.getName().trim();
            this.inputName = this.className = String.valueOf(this.className.substring(0, 1).toUpperCase()) + this.className.substring(1);
        }
    }

    public void setMasterLogging(boolean masterLogging) {
        this.masterLogging = masterLogging;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTestEnvironment(boolean setupTestEnvironment) {
        this.testEnvironment = setupTestEnvironment;
    }

    public void setUseUUIDs(boolean useUUIDs) {
        this.useUUIDs = useUUIDs;
    }

    public void setVertexLogging(boolean vertexLogging) {
        this.vertexLogging = vertexLogging;
    }
}

