/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public class StateSpaceShortestPath {
    private Set<State> settledStates;
    private Set<State> unsettledStates;
    private Map<State, State> predecessors;
    private Map<State, Integer> distances;

    public void computeShortestPaths(List<State> startStates) {
        this.settledStates = new HashSet<State>();
        this.unsettledStates = new HashSet<State>();
        this.distances = new HashMap<State, Integer>();
        this.predecessors = new HashMap<State, State>();
        this.unsettledStates.addAll(startStates);
        for (State start : startStates) {
            this.distances.put(start, 0);
        }
        while (!this.unsettledStates.isEmpty()) {
            State state = this.getMinimum(this.unsettledStates);
            this.settledStates.add(state);
            this.unsettledStates.remove(state);
            this.findSmallestDistances(state);
        }
    }

    private void findSmallestDistances(State state) {
        ArrayList<State> unsettledNeighbors = new ArrayList<State>();
        for (Transition t : state.getOutgoing()) {
            if (this.settledStates.contains(t.getTarget())) continue;
            unsettledNeighbors.add(t.getTarget());
        }
        for (State target : unsettledNeighbors) {
            if (this.getShortestDistance(target) <= this.getShortestDistance(state) + 1) continue;
            this.distances.put(target, this.getShortestDistance(state) + 1);
            this.predecessors.put(target, state);
            this.unsettledStates.add(target);
        }
    }

    private State getMinimum(Set<State> vertexes) {
        State minimum = null;
        for (State vertex : vertexes) {
            if (minimum == null) {
                minimum = vertex;
                continue;
            }
            if (this.getShortestDistance(vertex) >= this.getShortestDistance(minimum)) continue;
            minimum = vertex;
        }
        return minimum;
    }

    private int getShortestDistance(State destination) {
        Integer d = this.distances.get(destination);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }

    public Path getShortestPath(State target) {
        LinkedList<State> path = new LinkedList<State>();
        State step = target;
        if (this.predecessors.get(step) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return StateSpaceSearch.findPath(path);
    }
}

