/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.info.StateInfo;
import org.eclipse.emf.henshin.statespace.info.TransitionInfo;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;
import org.eclipse.emf.henshin.statespace.util.StateSpaceTypesHelper;

public class StateSpaceTimeInfo {
    private final boolean timed;
    private final List<EClass> identityTypes;
    private final Map<EClass, List<String>> clockDeclarations;
    private final Set<String> usedClocks;
    private final Map<EClass, Integer> maxObjectIds;
    private final Map<Rule, Vector<String>> ruleGuards;
    private final Map<Rule, Vector<String>> ruleResets;
    private final Map<Rule, Vector<String>> ruleInvariants;

    public StateSpaceTimeInfo(StateSpaceIndex index) throws StateSpaceException {
        EClass type;
        int i;
        int[] objectKeys;
        StateSpace stateSpace = index.getStateSpace();
        String useClocks = (String)stateSpace.getProperties().get((Object)"useClocks");
        this.timed = "yes".equalsIgnoreCase(useClocks) || "true".equalsIgnoreCase(useClocks);
        this.clockDeclarations = new LinkedHashMap<EClass, List<String>>();
        this.identityTypes = index.getStateSpace().getEqualityHelper().getIdentityTypes();
        for (EClass type2 : this.identityTypes) {
            this.clockDeclarations.put(type2, new Vector());
        }
        String prop = (String)stateSpace.getProperties().get((Object)"clockDeclarations");
        if (prop != null) {
            Map<String, EClass> typeNameMap = StateSpaceTypesHelper.getTypesNameMap(index.getStateSpace());
            String[] stringArray = prop.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                EClass type3;
                String decl = stringArray[n2];
                String[] split = decl.split("\\.");
                if (split.length == 2 && (type3 = typeNameMap.get(split[0])) != null && this.identityTypes.contains(type3)) {
                    this.clockDeclarations.get(type3).add(split[1]);
                }
                ++n2;
            }
        }
        this.maxObjectIds = new LinkedHashMap<EClass, Integer>();
        for (EClass type4 : this.identityTypes) {
            this.maxObjectIds.put(type4, 0);
        }
        for (State state : stateSpace.getStates()) {
            objectKeys = state.getObjectKeys();
            i = 0;
            while (i < objectKeys.length) {
                type = ObjectKeyHelper.getObjectType(objectKeys[i], this.identityTypes);
                List<String> dec = this.clockDeclarations.get(type);
                if (dec != null && !dec.isEmpty()) {
                    int id = ObjectKeyHelper.getObjectID(objectKeys[i]);
                    if (this.maxObjectIds.get(type) < id) {
                        this.maxObjectIds.put(type, id);
                    }
                }
                ++i;
            }
        }
        this.usedClocks = new LinkedHashSet<String>();
        for (State state : stateSpace.getStates()) {
            objectKeys = state.getObjectKeys();
            i = 0;
            while (i < objectKeys.length) {
                type = ObjectKeyHelper.getObjectType(objectKeys[i], this.identityTypes);
                int objectId = ObjectKeyHelper.getObjectID(objectKeys[i]);
                List<String> dec = this.clockDeclarations.get(type);
                if (dec != null) {
                    for (String clockName : dec) {
                        this.usedClocks.add(this.getClock(type, objectId, clockName));
                    }
                }
                ++i;
            }
        }
        this.ruleGuards = StateSpaceTimeInfo.getRuleProperties(stateSpace, "guard");
        this.ruleResets = StateSpaceTimeInfo.getRuleProperties(stateSpace, "resets");
        this.ruleInvariants = StateSpaceTimeInfo.getRuleProperties(stateSpace, "invariant");
    }

    private static Map<Rule, Vector<String>> getRuleProperties(StateSpace stateSpace, String prefix) {
        LinkedHashMap<Rule, Vector<String>> result = new LinkedHashMap<Rule, Vector<String>>();
        for (Rule rule : stateSpace.getRules()) {
            String value;
            int index = 1;
            for (Rule rule2 : stateSpace.getRules()) {
                if (rule2 == rule) break;
                if (!rule2.getName().equals(rule.getName())) continue;
                ++index;
            }
            String property = String.valueOf(prefix) + StateSpaceTimeInfo.capitalize(rule.getName()) + index;
            if (!stateSpace.getProperties().containsKey((Object)property)) {
                property = String.valueOf(prefix) + StateSpaceTimeInfo.capitalize(rule.getName());
            }
            if ((value = (String)stateSpace.getProperties().get((Object)property)) == null || (value = value.trim()).length() <= 0) continue;
            Vector<String> vals = new Vector<String>();
            String[] stringArray = value.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                vals.add(s);
                ++n2;
            }
            result.put(rule, vals);
        }
        return result;
    }

    public Map<EClass, List<String>> getClockDeclarations() {
        return this.clockDeclarations;
    }

    public boolean isTimed() {
        return this.timed;
    }

    public int getClockCount() {
        return this.usedClocks.size();
    }

    public String getClock(EClass type, int objectId, String clockName) {
        if (objectId < 1) {
            throw new IllegalArgumentException("Class '" + type.getName() + "' must be an identity type to have clocks.");
        }
        int clock = 0;
        for (EClass t : this.identityTypes) {
            if (t == type) {
                clock += objectId;
                break;
            }
            clock += this.maxObjectIds.get(type) * this.clockDeclarations.get(type).size();
        }
        return "c" + clock;
    }

    public String getClock(Model model, EObject object, String clockName) {
        int objectId = ObjectKeyHelper.getObjectID((Integer)model.getObjectKeysMap().get((Object)object));
        return this.getClock(object.eClass(), objectId, clockName);
    }

    public Iterable<String> getClocks() {
        return this.usedClocks;
    }

    public String getGuard(TransitionInfo transitionInfo) {
        return this.getNestedMatchProperty(this.ruleGuards.get(transitionInfo.getTransition().getRule()), transitionInfo);
    }

    public String getResets(TransitionInfo transitionInfo) {
        return this.getNestedMatchProperty(this.ruleResets.get(transitionInfo.getTransition().getRule()), transitionInfo);
    }

    public String getInvariant(StateInfo stateInfo) {
        int index = 0;
        Vector<String> atoms = new Vector<String>();
        for (Transition t : stateInfo.getState().getOutgoing()) {
            String s = this.getNestedMatchProperty(this.ruleInvariants.get(t.getRule()), stateInfo.getOutgoing().get(index++));
            if (s == null || atoms.contains(s)) continue;
            atoms.add(s);
        }
        if (atoms.isEmpty()) {
            return null;
        }
        Collections.sort(atoms);
        String r = "";
        int i = 0;
        while (i < atoms.size()) {
            if (i > 0) {
                r = String.valueOf(r) + "&";
            }
            r = String.valueOf(r) + (String)atoms.get(i);
            ++i;
        }
        return r;
    }

    private String getNestedMatchProperty(Vector<String> properties, TransitionInfo transitionInfo) {
        if (properties != null) {
            Vector<String> original = new Vector<String>(properties);
            properties = new Vector<String>(properties);
            HashMap<String, List<String>> replacements = new HashMap<String, List<String>>();
            this.computePropertyReplacements(this.getAllNodes(transitionInfo.getTransition().getRule()), transitionInfo.getTransition(), transitionInfo.getSourceModel(), transitionInfo.getTargetModel(), transitionInfo.getMatch(), transitionInfo.getResultMatch(), replacements);
            for (String key : replacements.keySet()) {
                List details = (List)replacements.get(key);
                int i = 0;
                while (i < details.size()) {
                    int j = 0;
                    while (j < properties.size()) {
                        properties.set(j, properties.get(j).replaceAll(key, (String)details.get(i)));
                        ++j;
                    }
                    if (i < details.size() - 1) {
                        properties.addAll(original);
                    }
                    ++i;
                }
            }
            properties.removeAll(original);
            Set<String> missingClockVariables = this.getMissingClockVariables(replacements.keySet(), transitionInfo.getMatch().getRule());
            String result = "";
            int count = properties.size();
            int j = 0;
            while (j < count) {
                String prop = properties.get(j);
                boolean use = true;
                int k = 0;
                while (k < j) {
                    if (properties.get(k).equals(prop)) {
                        use = false;
                        break;
                    }
                    ++k;
                }
                if (use) {
                    for (String missing : missingClockVariables) {
                        if (prop.indexOf(missing) < 0) continue;
                        use = false;
                        break;
                    }
                }
                if (use) {
                    if (!(prop = prop.trim()).startsWith("(")) {
                        prop = "(" + prop + ")";
                    }
                    if (result.length() > 0) {
                        result = String.valueOf(result) + "&";
                    }
                    result = String.valueOf(result) + prop;
                }
                ++j;
            }
            return result.length() > 0 ? result : null;
        }
        return null;
    }

    private List<Node> getAllNodes(Rule rule) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll((Collection<Node>)rule.getLhs().getNodes());
        nodes.addAll((Collection<Node>)rule.getRhs().getNodes());
        for (Rule multiRule : rule.getMultiRules()) {
            nodes.addAll(this.getAllNodes(multiRule));
        }
        return nodes;
    }

    private void computePropertyReplacements(List<Node> nodes, Transition transition, Model sourceModel, Model targetModel, Match match, Match resultMatch, Map<String, List<String>> replacements) {
        for (Node node : nodes) {
            String nodeName = node.getName();
            if (nodeName == null || !this.identityTypes.contains(node.getType())) continue;
            Model model = sourceModel;
            EObject object = match.getNodeTarget(node);
            if (object == null && resultMatch != null) {
                model = targetModel;
                object = resultMatch.getNodeTarget(node);
            }
            if (object == null) continue;
            if (object.eResource() != model.getResource()) {
                throw new RuntimeException("Unexpected model object");
            }
            for (String clockName : this.clockDeclarations.get(node.getType())) {
                String key = String.valueOf(nodeName) + "\\." + clockName;
                if (!replacements.containsKey(key)) {
                    replacements.put(key, new Vector());
                }
                replacements.get(key).add(this.getClock(model, object, clockName));
            }
        }
        for (Rule multiRule : match.getRule().getMultiRules()) {
            int size = match.getMultiMatches(multiRule).size();
            int i = 0;
            while (i < size) {
                Match r = resultMatch != null ? (Match)resultMatch.getMultiMatches(multiRule).get(i) : null;
                this.computePropertyReplacements(nodes, transition, sourceModel, targetModel, (Match)match.getMultiMatches(multiRule).get(i), r, replacements);
                ++i;
            }
        }
    }

    private Set<String> getMissingClockVariables(Set<String> usedClockVariables, Rule rule) {
        HashSet<String> missing = new HashSet<String>();
        for (Node node : rule.getLhs().getNodes()) {
            String nodeName = node.getName();
            if (nodeName == null || !this.identityTypes.contains(node.getType())) continue;
            for (String clockName : this.clockDeclarations.get(node.getType())) {
                if (usedClockVariables.contains(String.valueOf(nodeName) + "\\." + clockName)) continue;
                missing.add(String.valueOf(nodeName) + "." + clockName);
            }
        }
        for (Rule multiRule : rule.getMultiRules()) {
            missing.addAll(this.getMissingClockVariables(usedClockVariables, multiRule));
        }
        return missing;
    }

    private static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String first = string.substring(0, 1).toUpperCase();
        if (string.length() == 1) {
            return first;
        }
        return String.valueOf(first) + string.substring(1);
    }
}

