/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.units;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.SpanMappings;
import org.eclipse.emf.henshin.multicda.cda.units.SymmetricReason;

public abstract class Span
implements Comparable<Span> {
    public final String ID;
    public final String NAME;
    protected int sortID = 0;
    protected String tag = "";
    protected boolean isForbid = false;
    protected boolean isRequire = false;
    HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    private Rule rule1;
    private Rule rule2;
    public Set<Mapping> mappingsInRule1;
    public Set<Mapping> mappingsInRule2;
    protected Graph graph;
    private EcoreUtil.Copier copierForSpanAndMappings;
    protected Set<GraphElement> deletionElementsInRule1;
    protected Set<GraphElement> deletionElementsInRule1_2;
    public static final String NODE_SEPARATOR = "_";

    public Span(Span s1, String tag, String name) {
        this.ID = tag;
        this.NAME = name;
        this.copierForSpanAndMappings = new EcoreUtil.Copier();
        Graph copiedGraph = (Graph)this.copierForSpanAndMappings.copy((EObject)s1.getGraph());
        this.copierForSpanAndMappings.copyReferences();
        this.graph = copiedGraph;
        HashSet<Mapping> mappingsInRule1 = new HashSet<Mapping>();
        for (Mapping mapping : s1.getMappingsInRule1()) {
            Mapping copiedMapping = (Mapping)this.copierForSpanAndMappings.copy((EObject)mapping);
            this.copierForSpanAndMappings.copyReferences();
            mappingsInRule1.add(copiedMapping);
        }
        this.mappingsInRule1 = mappingsInRule1;
        HashSet<Mapping> mappingsInRule2 = new HashSet<Mapping>();
        for (Mapping mapping : s1.getMappingsInRule2()) {
            Mapping copiedMapping = (Mapping)this.copierForSpanAndMappings.copy((EObject)mapping);
            this.copierForSpanAndMappings.copyReferences();
            mappingsInRule2.add(copiedMapping);
        }
        this.mappingsInRule2 = mappingsInRule2;
        this.setRule1(this.getRuleOfMappings(mappingsInRule1));
        this.setRule2(this.getRuleOfMappings(mappingsInRule2));
    }

    public Span(Span extSpan, Node origin, Node image, String tag, String name) {
        this(extSpan, tag, name);
        Node transformedOrigin = (Node)this.copierForSpanAndMappings.get((Object)origin);
        Mapping r2Mapping = this.henshinFactory.createMapping(transformedOrigin, image);
        this.mappingsInRule2.add(r2Mapping);
    }

    public Span(Set<Mapping> rule1Mappings, Graph s1, Set<Mapping> rule2Mappings, String tag, String name) {
        this.ID = tag;
        this.NAME = name;
        this.mappingsInRule1 = rule1Mappings;
        this.mappingsInRule2 = rule2Mappings;
        this.graph = s1;
        this.setRule1(this.getRuleOfMappings(rule1Mappings));
        this.setRule2(this.getRuleOfMappings(rule2Mappings));
    }

    public final boolean isForbid() {
        return this.isForbid;
    }

    public final boolean isRequire() {
        return this.isRequire;
    }

    public final String getTag() {
        return this.tag;
    }

    public final <T extends Span> T setForbid(boolean is) {
        this.isForbid = is;
        this.isRequire = this.isRequire && !this.isForbid;
        return (T)this;
    }

    public final <T extends Span> T setRequire(boolean is) {
        this.isRequire = is;
        this.isForbid = this.isForbid && !this.isRequire;
        return (T)this;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set<GraphElement> getDeletionElementsInRule1() {
        if (this.deletionElementsInRule1 == null) {
            this.setDeletionElements();
        }
        return this.deletionElementsInRule1;
    }

    public Set<GraphElement> getDeletionElementsInRule1_2() {
        if (this.deletionElementsInRule1_2 == null) {
            this.setDeletionElements();
        }
        return this.deletionElementsInRule1_2;
    }

    public Rule getRule1() {
        return this.rule1;
    }

    public Rule getRule2() {
        return this.rule2;
    }

    public void setRule1(Rule rule1) {
        this.rule1 = rule1;
    }

    public void setRule2(Rule rule2) {
        this.rule2 = rule2;
    }

    public Set<Mapping> getMappingsInRule1() {
        return this.mappingsInRule1;
    }

    public Set<Mapping> getMappingsInRule2() {
        return this.mappingsInRule2;
    }

    public Mapping getMappingFromGraphToRule2(Node imageNode) {
        for (Mapping mappingInRule2 : this.mappingsInRule2) {
            if (mappingInRule2.getImage() != imageNode) continue;
            return mappingInRule2;
        }
        return null;
    }

    public Mapping getMappingFromGraphToRule1(Node imageNode) {
        for (Mapping mappingInRule1 : this.mappingsInRule1) {
            if (mappingInRule1.getImage() != imageNode) continue;
            return mappingInRule1;
        }
        return null;
    }

    public Mapping getMappingIntoRule1(Node originNode) {
        for (Mapping mapping : this.mappingsInRule1) {
            if (!mapping.getOrigin().equals(originNode)) continue;
            return mapping;
        }
        return null;
    }

    public Mapping getMappingIntoRule2(Node originNode) {
        for (Mapping mapping : this.mappingsInRule2) {
            if (!mapping.getOrigin().equals(originNode)) continue;
            return mapping;
        }
        return null;
    }

    protected void setDeletionElements() {
        Pair<Set<GraphElement>, Set<GraphElement>> result = this.getActionElements(new Action(Action.Type.DELETE));
        this.deletionElementsInRule1 = (Set)result.first;
        this.deletionElementsInRule1_2 = (Set)result.second;
    }

    public Pair<Set<GraphElement>, Set<GraphElement>> getActionElements(Action action) {
        Pair<Set<GraphElement>, Set<GraphElement>> result = new Pair<Set<GraphElement>, Set<GraphElement>>(new HashSet(), new HashSet());
        Set<Mapping> mappingsOfSpanInRule1 = this.getMappingsInRule1();
        this.getMappingsInRule2();
        for (Mapping mapping : mappingsOfSpanInRule1) {
            if (!mapping.getImage().getAction().getType().equals((Object)Action.Type.DELETE) && !(this instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason) && !(this instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason)) continue;
            ((Set)result.first).add(mapping.getImage());
            ((Set)result.second).add(mapping.getOrigin());
        }
        for (Mapping mapping : mappingsOfSpanInRule1) {
            Pair<Node, Set<Pair<Attribute, Attribute>>> attributed = Utils.getAttributeChanges(mapping.getImage());
            if (((Set)attributed.second).isEmpty()) continue;
            ((Set)result.first).add(mapping.getImage());
            ((Set)result.second).add(mapping.getOrigin());
        }
        for (Edge egdeInS : this.graph.getEdges()) {
            Node sourceNodeInS = egdeInS.getSource();
            Node targetNodeInS = egdeInS.getTarget();
            Mapping mappingOfSourceInR1 = this.getMappingIntoRule(mappingsOfSpanInRule1, sourceNodeInS);
            Node sourceNodeInR1 = mappingOfSourceInR1.getOrigin();
            Node sourceNodeInR1Image = mappingOfSourceInR1.getImage();
            Mapping mappingOfTargetInR1 = this.getMappingIntoRule(mappingsOfSpanInRule1, targetNodeInS);
            Node targetNodeInR1 = mappingOfTargetInR1.getOrigin();
            Node targetNodeInR1Image = mappingOfTargetInR1.getImage();
            Edge associatedEdgeInR1Image = sourceNodeInR1Image.getOutgoing(egdeInS.getType(), targetNodeInR1Image);
            Edge associatedEdgeInR1 = sourceNodeInR1.getOutgoing(egdeInS.getType(), targetNodeInR1);
            if (associatedEdgeInR1 == null || !associatedEdgeInR1Image.getAction().getType().equals((Object)Action.Type.DELETE)) continue;
            ((Set)result.first).add(associatedEdgeInR1Image);
            ((Set)result.second).add(associatedEdgeInR1);
        }
        return result;
    }

    private Mapping getMappingIntoRule(Set<Mapping> mappingsFromSpanInRule, Node originNode) {
        for (Mapping mapping : mappingsFromSpanInRule) {
            if (mapping.getOrigin() != originNode) continue;
            return mapping;
        }
        return null;
    }

    public boolean validate(Graph lhs1, Graph lhs2) {
        if (this.mappingsInRule1.size() != this.graph.getNodes().size() || this.mappingsInRule2.size() != this.graph.getNodes().size()) {
            return false;
        }
        for (Node node : this.graph.getNodes()) {
            Mapping mappingIntoRule1 = this.getMappingIntoRule1(node);
            if (mappingIntoRule1.getImage() == null) {
                return false;
            }
            Node imageInRule1 = mappingIntoRule1.getImage();
            if (imageInRule1.eContainer() != lhs1) {
                return false;
            }
            Mapping mappingIntoRule2 = this.getMappingIntoRule2(node);
            if (mappingIntoRule2.getImage() == null) {
                return false;
            }
            Node imageInRule2 = mappingIntoRule2.getImage();
            if (imageInRule2.eContainer() == lhs2) continue;
            return false;
        }
        return true;
    }

    private Rule getRuleOfMappings(Set<Mapping> mappings) {
        try {
            return mappings.iterator().next().getImage().getGraph().getRule();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<Node, Node> getPairedNodes(Span conflictReason, SpanMappings spanMap) {
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        for (Node n1 : spanMap.s1ToRule1.keySet()) {
            result.put(spanMap.s1ToRule1.get(n1), spanMap.s1ToRule2.get(n1));
        }
        return result;
    }

    private Object shortStringInfoOfGraphEdge(Edge edge) {
        StringBuilder sB = new StringBuilder();
        Node src = edge.getSource();
        Node tgt = edge.getTarget();
        sB.append(this.getMappingIntoRule1(src).getImage().getName());
        sB.append(",");
        sB.append(this.getMappingIntoRule2(src).getImage().getName());
        sB.append("->");
        sB.append(this.getMappingIntoRule1(tgt).getImage().getName());
        sB.append(",");
        sB.append(this.getMappingIntoRule2(tgt).getImage().getName());
        sB.append(":");
        sB.append(edge.getType().getName());
        return sB.toString();
    }

    private String shortStringInfoOfGraphNode(Node node) {
        StringBuilder sB = new StringBuilder();
        Mapping mappingIntoRule1 = this.getMappingIntoRule1(node);
        Mapping mappingIntoRule2 = this.getMappingIntoRule2(node);
        sB.append(mappingIntoRule1.getImage().getName());
        sB.append(",");
        sB.append(mappingIntoRule2.getImage().getName());
        sB.append(":");
        sB.append(node.getType().getName());
        return sB.toString();
    }

    public String toString() {
        EList edges = this.getGraph().getEdges();
        EList nodes = this.getGraph().getNodes();
        String newID = this.getFullID();
        return String.valueOf(newID) + ": " + (edges.isEmpty() ? "" : edges) + (!edges.isEmpty() && !nodes.isEmpty() ? " | " : "") + (nodes.isEmpty() ? "" : nodes);
    }

    public String getFullID() {
        String tag = "";
        if (this.isForbid) {
            tag = "F";
        } else if (this.isRequire) {
            tag = "Req";
        }
        return String.valueOf(this.ID.substring(0, this.ID.length() / 2)) + tag + this.ID.substring(this.ID.length() / 2);
    }

    public String getFullName() {
        String result = this.NAME;
        String tag = "";
        if (this.isForbid) {
            tag = " forbid";
        } else if (this.isRequire) {
            tag = " require";
        }
        String[] parts = result.split(" ");
        result = String.valueOf(parts[0]) + tag + result.substring(parts[0].length());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Span s = (Span)obj;
        if (this.isRequire() != s.isRequire() || this.isForbid() != s.isForbid()) {
            return false;
        }
        if (!this.getFullID().equals(s.getFullID())) {
            return false;
        }
        Rule r1 = this.getRule1();
        Rule r2 = this.getRule2();
        Rule r1o = ((Span)obj).getRule1();
        Rule r2o = ((Span)obj).getRule2();
        if (r1 != r1o || r2 != r2o) {
            return false;
        }
        return this.equalElements(s);
    }

    public boolean equalElements(Span span) {
        Set<GraphElement> ge = this.getDeletionElementsInRule1_2();
        Set<GraphElement> geO = span.getDeletionElementsInRule1_2();
        if (ge.size() != geO.size()) {
            return false;
        }
        for (GraphElement element1 : ge) {
            boolean found = false;
            for (GraphElement element2 : geO) {
                found = element1.getClass() == element2.getClass() && element1.toString().equals(element2.toString());
                if (found) break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashN = 0;
        int hashE = 0;
        for (Node n : this.graph.getNodes()) {
            hashN += this.getHash((GraphElement)n);
        }
        for (Edge e : this.graph.getEdges()) {
            hashE += this.getHash((GraphElement)e);
        }
        return this.ID.hashCode() + hashN + hashE + (this.getRule1() != null ? this.getRule1().hashCode() : 0) * 3 + (this.getRule2() != null ? this.getRule2().hashCode() : 0);
    }

    private int getHash(GraphElement n) {
        if (n instanceof Node) {
            if (((Node)n).getType() == null) {
                return String.valueOf(((Node)n).getName()).hashCode();
            }
            int result = 0;
            String[] names = ((Node)n).getName().split(NODE_SEPARATOR);
            if (names.length == 2) {
                result = names[0].hashCode() * 2 + names[1].hashCode();
            }
            return (String.valueOf(result) + ":" + ((Node)n).getType().getName()).hashCode();
        }
        if (n instanceof Edge) {
            Edge e = (Edge)n;
            if (e.getSource() == null || e.getTarget() == null || e.getType() == null) {
                return super.hashCode();
            }
            return this.getHash((GraphElement)e.getSource()) * 11 + this.getHash((GraphElement)e.getTarget()) + e.getType().getName().hashCode();
        }
        return 0;
    }

    public void print() {
        System.out.println(this);
    }

    protected int sortID() {
        return this.sortID + (this.isForbid ? 8 : 0) + (this.isRequire ? 16 : 0);
    }

    @Override
    public int compareTo(Span o) {
        if (o == null) {
            return -1;
        }
        int value = 0;
        if (!this.getRule1().getName().equals(o.getRule1().getName()) && (value = this.getRule1().hashCode() - o.getRule1().hashCode()) != 0) {
            return value < 0 ? -1 : 1;
        }
        if (!this.getRule2().getName().equals(o.getRule2().getName()) && (value = this.getRule2().hashCode() - o.getRule2().hashCode()) != 0) {
            return value < 0 ? -1 : 1;
        }
        if (this.sortID() - o.sortID() != 0) {
            return this.sortID() - o.sortID();
        }
        value = this.getFullID().compareTo(o.getFullID());
        if (value != 0) {
            return value < 0 ? -1 : 1;
        }
        String ed1 = this.graph.getEdges().toString();
        String ed2 = o.graph.getEdges().toString();
        value = ed1.length() - ed2.length();
        if (value != 0) {
            return value < 0 ? -1 : 1;
        }
        String no1 = this.graph.getNodes().toString();
        String no2 = o.graph.getNodes().toString();
        value = no1.length() - no2.length();
        if (value != 0) {
            return value < 0 ? -1 : 1;
        }
        value = this.toString().compareTo(o.toString());
        return value < 0 ? -1 : (value > 0 ? 1 : 0);
    }

    public final boolean is(String string) {
        return this.ID.equals(string);
    }

    public final boolean isDependency() {
        if (this instanceof SymmetricReason) {
            return ((SymmetricReason)this).getS1().isDependency();
        }
        return this instanceof Atom.CreateDependencyAtom || this instanceof DependencyReason.CreateDependencyReason || this instanceof Atom.DeleteDependencyAtom || this instanceof DependencyReason.DeleteDependencyReason || this instanceof Atom.ChangeDependencyAtom || this instanceof DependencyReason.ChangeDependencyReason || this instanceof Atom.DeleteEdgeDeleteNodeDependencyAtom || this instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason;
    }
}

