/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Pushout;
import org.eclipse.emf.henshin.multicda.cda.conflict.EssentialConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cpa.result.Conflict;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;

public class CpaCdaComparator {
    public CompareResult compare(Set<CriticalPair> essentialCPs, Set<Reason> conflictReasons) {
        CompareResult compareResult = new CompareResult(essentialCPs, conflictReasons);
        return compareResult;
    }

    public class CompareResult {
        Engine engine = new EngineImpl(new String[0]);
        HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
        Set<CriticalPair> unassignedCPs;
        Set<Reason> unassignedCRs;
        Map<CriticalPair, Set<Reason>> CpaToCda = new HashMap<CriticalPair, Set<Reason>>();
        Map<Reason, Set<CriticalPair>> CdaToCpa = new HashMap<Reason, Set<CriticalPair>>();

        public CompareResult(Set<CriticalPair> essentialCPs, Set<Reason> conflictReasons) {
            this.unassignedCPs = new HashSet<CriticalPair>(essentialCPs);
            this.unassignedCRs = new HashSet<Reason>(conflictReasons);
            for (CriticalPair cp : essentialCPs) {
                for (Reason cr : conflictReasons) {
                    boolean numberOfEdgesAreEqual;
                    Pushout pr = new Pushout(cr.getRule1(), cr, cr.getRule2());
                    Rule dummyPO_rule = this.henshinFactory.createRule();
                    dummyPO_rule.setLhs(pr.getResultGraph());
                    Module module = (Module)EcoreUtil.copy((EObject)cr.getRule1().getModule());
                    module.getUnits().clear();
                    module.getImports().get(0);
                    ((Conflict)cp).getMatch1().getNodeTargets();
                    Conflict conflict = (Conflict)cp;
                    EGraphImpl graph = new EGraphImpl(conflict.getMinimalModel());
                    module.getUnits().add((Object)dummyPO_rule);
                    Iterable matches = this.engine.findMatches(dummyPO_rule, (EGraph)graph, null);
                    boolean matchesFound = false;
                    Iterator iterator = matches.iterator();
                    while (iterator.hasNext()) {
                        Match cfr_ignored_0 = (Match)iterator.next();
                        matchesFound = true;
                    }
                    boolean numberOfNodesAreEqual = pr.getResultGraph().getNodes().size() == graph.size();
                    boolean bl = numberOfEdgesAreEqual = pr.getResultGraph().getEdges().size() == InterpreterUtil.countEdges((EGraph)graph);
                    if (!matchesFound || !numberOfNodesAreEqual || !numberOfEdgesAreEqual) continue;
                    this.unassignedCPs.remove(cp);
                    this.unassignedCRs.remove(cr);
                    Set<Reason> crs = this.CpaToCda.get(cp);
                    if (crs == null) {
                        crs = new HashSet<Reason>();
                        this.CpaToCda.put(cp, crs);
                    }
                    crs.add(cr);
                    Set<CriticalPair> cps = this.CdaToCpa.get(cr);
                    if (cps == null) {
                        cps = new HashSet<CriticalPair>();
                        this.CdaToCpa.put(cr, cps);
                    }
                    cps.add(cp);
                }
            }
        }

        public Set<CriticalPair> getUnassignedCPs() {
            return this.unassignedCPs;
        }

        public Set<Reason> getUnassignedCRs() {
            return this.unassignedCRs;
        }

        public Set<CriticalPair> getAssignedCPs() {
            return this.CpaToCda.keySet();
        }

        public Set<Reason> getAssignedCRs() {
            return this.CdaToCpa.keySet();
        }

        public Set<CriticalPair> getCPsOfCR(EssentialConflictReason conflictReason) {
            return this.CdaToCpa.get(conflictReason);
        }

        public Set<Reason> getCRsOfCP(CriticalPair criticalPair) {
            return this.CpaToCda.get(criticalPair);
        }
    }
}

