/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.StringJoiner;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueEObject;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueList;
import org.eclipse.emf.henshin.interpreter.debug.DebugValueObject;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugTarget;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugThread;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugValue;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugVariable;
import org.eclipse.emf.henshin.interpreter.debug.HenshinStackFrame;
import org.eclipse.emf.henshin.interpreter.info.RuleInfo;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ApplicationCondition;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConstraintInstanceBreakpoint;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ConstraintTypeBreakpoint;
import org.eclipse.emf.henshin.interpreter.matching.conditions.HenshinBreakpoint;
import org.eclipse.emf.henshin.interpreter.matching.conditions.IFormula;
import org.eclipse.emf.henshin.interpreter.matching.conditions.ValueBreakpoint;
import org.eclipse.emf.henshin.interpreter.matching.conditions.VariableBreakpoint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.PathConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Solution;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;
import org.eclipse.emf.henshin.model.Node;

public class DebugApplicationCondition
extends ApplicationCondition {
    private HenshinDebugTarget debugTarget;
    private DebugState currentDebugState;
    private DebugLevel currentDebugLevel;
    private int currentVariableIndex;
    private ConstraintType currentConstraintType = ConstraintType.NONE;
    private int currentConstraintIndex;
    private Variable currentVariable;
    private DomainSlot currentSlot;
    private IStackFrame[] stackFrames;
    private Observer matchObserver;
    private RuleInfo ruleInfo;
    private static DebugApplicationCondition instance;
    private EGraph graph;
    private static final String MARKER_TYPE = "org.eclipse.emf.henshin.diagram.diagnostic";

    public EGraph getGraph() {
        return this.graph;
    }

    public DebugApplicationCondition(HenshinDebugTarget debugTarget, List<Variable> variables, Map<Variable, DomainSlot> domainMap, EGraph graph, IFormula formula, Observer matchObserver, RuleInfo ruleInfo) {
        super(graph, domainMap, null);
        this.debugTarget = debugTarget;
        this.variables = variables;
        this.formula = formula;
        this.matchObserver = matchObserver;
        this.ruleInfo = ruleInfo;
        this.currentDebugLevel = DebugLevel.NONE;
        this.currentVariableIndex = -1;
        this.currentConstraintType = ConstraintType.NONE;
        this.currentConstraintIndex = -1;
        this.currentDebugState = DebugState.SUSPENDED;
        instance = this;
        this.graph = graph;
    }

    public static DebugApplicationCondition getInstance() {
        return instance;
    }

    public void initNextVariable() {
        if (this.currentVariableIndex == -1) {
            this.updateDebugState(DebugLevel.VARIABLE, 0, ConstraintType.NONE, -1);
            if (this.debugTarget != null) {
                this.debugTarget.fireCreationEvent();
            }
        }
        if (this.currentVariableIndex == this.variables.size()) {
            for (Variable variable : this.variables) {
                DomainSlot slot;
                if (!variable.requiresFinalCheck || (slot = (DomainSlot)this.domainMap.get(variable)).recheck(variable, this.domainMap)) continue;
                this.updateDebugState(DebugLevel.VARIABLE, this.currentVariableIndex - 1, ConstraintType.NONE, -1);
                this.tryNextValue();
                return;
            }
            if (this.formula.eval()) {
                this.updateDebugState(DebugLevel.VARIABLE, this.currentVariableIndex - 1, ConstraintType.NONE, -1);
                this.setCurrentDebugState(DebugState.TERMINATED_TRUE);
                Solution solution = new Solution(this.variables, this.domainMap, this.currentSlot.getConditionHandler());
                if (this.matchObserver != null) {
                    this.matchObserver.update(null, solution);
                }
                if (this.debugTarget != null) {
                    this.debugTarget.fireTerminateEvent();
                }
                return;
            }
            this.updateDebugState(DebugLevel.VARIABLE, this.currentVariableIndex - 1, ConstraintType.NONE, -1);
            this.tryNextValue();
            return;
        }
        this.currentVariable = (Variable)this.variables.get(this.currentVariableIndex);
        this.currentSlot = (DomainSlot)this.domainMap.get(this.currentVariable);
        this.currentSlot.initialize(this.currentVariable, this.graph);
        if (this.debugTarget != null) {
            this.debugTarget.fireChangeEvent(512);
            this.debugTarget.fireSuspendEvent(8);
        }
    }

    private boolean checkCurrentConstraint() {
        switch (this.currentConstraintType) {
            case TYPE: {
                return this.currentSlot.checkTypeConstraint(this.currentVariable);
            }
            case DANGLING: {
                DanglingConstraint danglingConstraint = this.currentVariable.danglingConstraints.get(this.currentConstraintIndex);
                return this.currentSlot.checkDanglingConstraint(danglingConstraint, this.graph);
            }
            case ATTRIBUTE: {
                AttributeConstraint attributeConstraint = this.currentVariable.attributeConstraints.get(this.currentConstraintIndex);
                UnaryConstraint unaryUserConstraint = this.currentVariable.attributeUserConstraints.get(attributeConstraint);
                return this.currentSlot.checkAttributeConstraint(attributeConstraint, unaryUserConstraint);
            }
            case CONTAINMENT: {
                ContainmentConstraint containmentConstraint = this.currentVariable.containmentConstraints.get(this.currentConstraintIndex);
                return this.currentSlot.checkContainmentConstraint(containmentConstraint, this.domainMap);
            }
            case REFERENCE: {
                ReferenceConstraint referenceConstraint = this.currentVariable.referenceConstraints.get(this.currentConstraintIndex);
                BinaryConstraint binaryUserConstraint = this.currentVariable.binaryUserConstraints.get(referenceConstraint);
                return this.currentSlot.checkReferenceConstraint(referenceConstraint, binaryUserConstraint, this.domainMap);
            }
            case PATH: {
                PathConstraint pathConstraint = this.currentVariable.pathConstraints.get(this.currentConstraintIndex);
                return this.currentSlot.checkPathConstraint(pathConstraint, this.domainMap);
            }
            case USER: {
                return this.currentSlot.checkUserConstraint(this.currentVariable.userConstraints.get(this.currentConstraintIndex));
            }
            case NONE: {
                throw new IllegalStateException("trying to check the current constraint with currentConstraintType NONE");
            }
        }
        throw new IllegalStateException("currentConstraintType is \"" + (Object)((Object)this.currentConstraintType) + "\", but has to be of the enum type ConstraintType");
    }

    private synchronized void tryNextConstraintType() {
        do {
            this.currentConstraintType = this.currentConstraintType.next();
            if (!this.currentTypeHasConstraints()) continue;
            this.updateDebugState(DebugLevel.CONSTRAINT_TYPE, this.currentVariableIndex, this.currentConstraintType, -1);
            return;
        } while (!this.currentConstraintType.isLast());
        this.updateDebugState(DebugLevel.VARIABLE, this.currentVariableIndex + 1, ConstraintType.NONE, -1);
        this.initNextVariable();
    }

    private void tryNextValue() {
        this.currentSlot.unlock(this.currentVariable);
        if (this.currentSlot.instantiationPossible()) {
            this.currentSlot.setValueAndLock();
            this.updateDebugState(DebugLevel.VALUE, this.currentVariableIndex, ConstraintType.NONE, -1);
            if (this.debugTarget != null) {
                this.debugTarget.fireSuspendEvent(8);
            }
        } else {
            this.tryLowerIndexVariable();
        }
    }

    private boolean hasNextValue() {
        this.currentSlot.unlock(this.currentVariable);
        return this.currentSlot.instantiationPossible();
    }

    private void tryLowerIndexVariable() {
        this.currentSlot.clear(this.currentVariable);
        if (this.currentVariableIndex > 0) {
            this.updateDebugState(DebugLevel.VARIABLE, this.currentVariableIndex - 1, ConstraintType.NONE, -1);
            this.initNextVariable();
            return;
        }
        this.updateDebugState(DebugLevel.NONE, -1, ConstraintType.NONE, -1);
        this.setCurrentDebugState(DebugState.TERMINATED_FALSE);
        if (this.debugTarget != null) {
            this.debugTarget.fireTerminateEvent();
        }
    }

    private int maxCurrentConstraintIndex() {
        switch (this.currentConstraintType) {
            case TYPE: {
                return 0;
            }
            case DANGLING: {
                return this.currentVariable.danglingConstraints.size() - 1;
            }
            case ATTRIBUTE: {
                return this.currentVariable.attributeConstraints.size() - 1;
            }
            case CONTAINMENT: {
                return this.currentVariable.containmentConstraints.size() - 1;
            }
            case REFERENCE: {
                return this.currentVariable.referenceConstraints.size() - 1;
            }
            case PATH: {
                return this.currentVariable.pathConstraints.size() - 1;
            }
            case USER: {
                return this.currentVariable.userConstraints.size() - 1;
            }
            case NONE: {
                throw new IllegalStateException("trying to get number of constraints with currentConstraintType NONE");
            }
        }
        throw new IllegalStateException("currentConstraintType is \"" + (Object)((Object)this.currentConstraintType) + "\", but has to be of the enum type ConstraintType");
    }

    private boolean currentTypeHasConstraints() {
        return this.maxCurrentConstraintIndex() >= 0;
    }

    private synchronized void updateDebugState(DebugLevel newDebugLevel, int newVariableIndex, ConstraintType newConstraintType, int newConstraintIndex) {
        this.currentDebugLevel = newDebugLevel;
        this.currentVariableIndex = newVariableIndex;
        this.currentConstraintType = newConstraintType;
        this.currentConstraintIndex = newConstraintIndex;
    }

    private void setCurrentDebugState(DebugState debugState) {
        if (!this.isTerminated()) {
            this.currentDebugState = debugState;
        }
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getCurrentDebugState() == DebugState.SUSPENDED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws DebugException {
        DebugApplicationCondition debugApplicationCondition = this;
        synchronized (debugApplicationCondition) {
            if (this.getCurrentDebugState() == DebugState.SUSPENDED) {
                this.setCurrentDebugState(DebugState.RUNNING);
            }
            while (!this.isTerminated() && this.getCurrentDebugState() != DebugState.SUSPENDED) {
                this.step();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws DebugException {
        DebugApplicationCondition debugApplicationCondition = this;
        synchronized (debugApplicationCondition) {
            this.setCurrentDebugState(DebugState.SUSPENDED);
        }
    }

    public boolean canStep() {
        return this.isSuspended();
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return this.isSuspended() && this.currentDebugLevel != DebugLevel.VARIABLE;
    }

    public boolean isStepping() {
        return this.getCurrentDebugState() == DebugState.STEPPING;
    }

    public void step() throws DebugException {
        ArrayList<ConstraintInstanceBreakpoint> constraintInstanceBreakpoints;
        ArrayList<ConstraintTypeBreakpoint> constraintTypeBreakpoints;
        if (this.currentVariable == null) {
            throw new IllegalStateException("currentVariable is null - variableInitNext() has to be called before");
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireResumeEvent(1);
        }
        switch (this.currentDebugLevel) {
            case VARIABLE: {
                if (this.currentSlot.getValue() != null) {
                    this.currentSlot.unlock(this.currentVariable);
                }
                if (!this.currentSlot.setValueAndLock()) {
                    this.tryLowerIndexVariable();
                    break;
                }
                this.updateDebugState(DebugLevel.VALUE, this.currentVariableIndex, ConstraintType.NONE, -1);
                break;
            }
            case VALUE: {
                this.updateDebugState(DebugLevel.CONSTRAINT_TYPE, this.currentVariableIndex, ConstraintType.TYPE, -1);
                break;
            }
            case CONSTRAINT_TYPE: {
                if (!this.currentTypeHasConstraints()) {
                    throw new IllegalStateException("called stepInto for constraint type \"" + (Object)((Object)this.currentConstraintType) + "\", but this type has no constraint to step into");
                }
                this.updateDebugState(DebugLevel.CONSTRAINT, this.currentVariableIndex, this.currentConstraintType, 0);
                break;
            }
            case CONSTRAINT: {
                if (this.currentConstraintIndex > this.maxCurrentConstraintIndex()) {
                    throw new IllegalStateException("called stepOver for constraint type \"" + (Object)((Object)this.currentConstraintType) + "\", but this type has no unchecked constraint left and should have been skipped");
                }
                boolean constraintIsValid = this.checkCurrentConstraint();
                if (constraintIsValid) {
                    if (this.currentConstraintIndex < this.maxCurrentConstraintIndex()) {
                        this.updateDebugState(DebugLevel.CONSTRAINT, this.currentVariableIndex, this.currentConstraintType, this.currentConstraintIndex + 1);
                        break;
                    }
                    this.tryNextConstraintType();
                    break;
                }
                if (constraintIsValid) break;
                this.tryNextValue();
                break;
            }
            default: {
                this.throwExceptionInvalidDebugLevel();
            }
        }
        ArrayList<HenshinBreakpoint> henshinBreakpoints = this.getHenshinBreakpoints();
        Node currentNode = this.ruleInfo.getVariableInfo().getVariableForNode(this.currentVariable);
        String currentNodePath = EcoreUtil.getRelativeURIFragmentPath(null, (EObject)currentNode);
        String currentTypeName = this.currentVariable.typeConstraint.type.getName();
        ArrayList<VariableBreakpoint> variableBreakpoints = this.filterVariableBreakpoints(henshinBreakpoints);
        if (variableBreakpoints.size() > 0 && this.currentDebugLevel == DebugLevel.VARIABLE) {
            for (VariableBreakpoint variableBreakpoint : variableBreakpoints) {
                if (!this.shouldStopAtVariableBreakpoint(variableBreakpoint, currentTypeName, currentNodePath)) continue;
                this.suspendApplication();
            }
        }
        if (this.currentSlot.getValue() != null) {
            List<EObject> domain = this.graph.getDomain(this.currentSlot.getValue().eClass(), false);
            EObject currentValue = this.currentSlot.getValue();
            int index = domain.indexOf(currentValue);
            ArrayList<ValueBreakpoint> valueBreakpoints = this.filterValueBreakpoints(henshinBreakpoints);
            if (valueBreakpoints.size() > 0 && this.currentDebugLevel == DebugLevel.VALUE) {
                for (ValueBreakpoint valueBreakpoint : valueBreakpoints) {
                    if (!this.shouldStopAtValueBreakpoint(valueBreakpoint, currentValue, index)) continue;
                    this.suspendApplication();
                }
            }
        }
        if ((constraintTypeBreakpoints = this.filterConstraintTypeBreakpoints(henshinBreakpoints)).size() > 0 && this.currentDebugLevel == DebugLevel.CONSTRAINT_TYPE) {
            for (ConstraintTypeBreakpoint constraintTypeBreakpoint : constraintTypeBreakpoints) {
                if (!this.shouldStopAtConstraintTypeBreakpoint(constraintTypeBreakpoint)) continue;
                this.suspendApplication();
            }
        }
        if ((constraintInstanceBreakpoints = this.filterConstraintInstanceBreakpoints(henshinBreakpoints)).size() > 0 && this.currentDebugLevel == DebugLevel.CONSTRAINT) {
            for (ConstraintInstanceBreakpoint constraintInstanceBreakpoint : constraintInstanceBreakpoints) {
                if (!this.shouldStopAtConstraintInstanceBreakpoint(constraintInstanceBreakpoint)) continue;
                this.suspendApplication();
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireSuspendEvent(8);
        }
    }

    public void stepInto() throws DebugException {
        if (this.currentVariable == null) {
            throw new IllegalStateException("currentVariable is null - variableInitNext() has to be called before");
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireResumeEvent(1);
        }
        switch (this.currentDebugLevel) {
            case VARIABLE: {
                if (this.currentSlot.getValue() != null) {
                    this.currentSlot.unlock(this.currentVariable);
                }
                if (!this.currentSlot.setValueAndLock()) {
                    this.tryLowerIndexVariable();
                    break;
                }
                this.updateDebugState(DebugLevel.VALUE, this.currentVariableIndex, ConstraintType.NONE, -1);
                this.setCurrentDebugState(DebugState.SUSPENDED);
                break;
            }
            case VALUE: {
                this.updateDebugState(DebugLevel.CONSTRAINT_TYPE, this.currentVariableIndex, ConstraintType.TYPE, -1);
                this.setCurrentDebugState(DebugState.SUSPENDED);
                break;
            }
            case CONSTRAINT_TYPE: {
                if (!this.currentTypeHasConstraints()) {
                    throw new IllegalStateException("called stepInto for constraint type \"" + (Object)((Object)this.currentConstraintType) + "\", but this type has no constraint to step into");
                }
                this.updateDebugState(DebugLevel.CONSTRAINT, this.currentVariableIndex, this.currentConstraintType, 0);
                this.setCurrentDebugState(DebugState.SUSPENDED);
                break;
            }
            case CONSTRAINT: {
                this.step();
                this.setCurrentDebugState(DebugState.SUSPENDED);
                break;
            }
            default: {
                this.throwExceptionInvalidDebugLevel();
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireSuspendEvent(8);
        }
    }

    public void stepOver() throws DebugException {
        if (this.currentVariable == null) {
            throw new IllegalStateException("currentVariable is null - variableInitNext() has to be called before");
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireResumeEvent(2);
        }
        switch (this.currentDebugLevel) {
            case VARIABLE: {
                if (this.currentSlot.getValue() != null) {
                    this.currentSlot.unlock(this.currentVariable);
                }
                Variable tempVariable = this.currentVariable;
                while (this.checkForChange(tempVariable, this.currentVariable)) {
                    this.step();
                }
                break;
            }
            case VALUE: {
                EObject tempValue = this.currentSlot.getValue();
                while (this.checkForChange(tempValue, this.currentSlot.getValue())) {
                    this.step();
                }
                break;
            }
            case CONSTRAINT_TYPE: {
                ConstraintType tempConstraintType = this.currentConstraintType;
                while (this.checkForChange((Object)tempConstraintType, (Object)this.currentConstraintType)) {
                    this.step();
                }
                break;
            }
            case CONSTRAINT: {
                this.step();
                this.setCurrentDebugState(DebugState.SUSPENDED);
                break;
            }
            default: {
                this.throwExceptionInvalidDebugLevel();
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireChangeEvent(512);
            this.debugTarget.fireSuspendEvent(8);
        }
    }

    public void stepReturn() throws DebugException {
        if (this.currentVariable == null) {
            throw new IllegalStateException("currentVariable is null - variableInitNext() has to be called before");
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireResumeEvent(4);
        }
        switch (this.currentDebugLevel) {
            case VARIABLE: {
                this.stepOver();
                break;
            }
            case VALUE: {
                Variable tempVariable = this.currentVariable;
                while (this.checkForChange(tempVariable, this.currentVariable)) {
                    this.step();
                }
                break;
            }
            case CONSTRAINT_TYPE: {
                EObject tempValue = this.currentSlot.getValue();
                while (this.checkForChange(tempValue, this.currentSlot.getValue())) {
                    this.step();
                }
                break;
            }
            case CONSTRAINT: {
                ConstraintType tempConstraintType = this.currentConstraintType;
                while (this.checkForChange((Object)tempConstraintType, (Object)this.currentConstraintType)) {
                    this.step();
                }
                break;
            }
            default: {
                this.throwExceptionInvalidDebugLevel();
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.fireSuspendEvent(8);
        }
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getCurrentDebugState() == DebugState.TERMINATED_FALSE || this.getCurrentDebugState() == DebugState.TERMINATED_TRUE;
    }

    public void terminate() throws DebugException {
        this.updateDebugState(DebugLevel.NONE, -1, ConstraintType.NONE, -1);
        this.setCurrentDebugState(DebugState.TERMINATED_FALSE);
        if (this.debugTarget != null) {
            this.debugTarget.fireTerminateEvent();
        }
    }

    public String getName() throws DebugException {
        if (this.getCurrentDebugState() == DebugState.TERMINATED_TRUE) {
            return "[" + this.variables.size() + "/" + this.variables.size() + " variables matched]";
        }
        if (this.getCurrentDebugState() == DebugState.TERMINATED_FALSE) {
            return "[no match found]";
        }
        return String.valueOf(this.currentVariableIndex) + "/" + this.variables.size() + " variables matched";
    }

    public IBreakpointManager getManager() {
        return DebugPlugin.getDefault().getBreakpointManager();
    }

    public IBreakpoint[] getBreakpoints() {
        IBreakpointManager manager = this.getManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints();
        if (breakpoints.length > 0) {
            manager.getTypeName(breakpoints[0]);
        }
        return breakpoints;
    }

    public ArrayList<HenshinBreakpoint> getHenshinBreakpoints() {
        IBreakpoint[] breakpoints = this.getBreakpoints();
        ArrayList<HenshinBreakpoint> henshinBreakpoints = this.filterHenshinBreakpoints(breakpoints);
        return henshinBreakpoints;
    }

    public void setVariableBreakpoint(Variable variable) {
        IBreakpointManager manager = this.getManager();
        IResource moduleFile = this.debugTarget.getModuleResource();
        IMarker marker = DebugApplicationCondition.addMarker(moduleFile, "org.eclipse.emf.henshin.model", "/variable", "Sample VariableBreakpoint", 0);
        VariableBreakpoint breakpoint = new VariableBreakpoint();
        try {
            breakpoint.setMarker(marker);
            Node currentNode = this.ruleInfo.getVariableInfo().getVariableForNode(variable);
            String nodePath = EcoreUtil.getRelativeURIFragmentPath(null, (EObject)currentNode);
            String typeName = variable.typeConstraint.type.getName();
            breakpoint.setPath(nodePath);
            breakpoint.setTypeName(typeName);
            breakpoint.setEnabled(true);
            breakpoint.setDebugLevel(DebugLevel.VARIABLE);
            manager.addBreakpoint((IBreakpoint)breakpoint);
        }
        catch (CoreException e1) {
            System.out.println("Unable to create custom VariableBreakpoint.");
            e1.printStackTrace();
        }
    }

    public void setValueBreakpoint(HenshinDebugValue value, int index) {
        IBreakpointManager manager = this.getManager();
        IResource moduleFile = this.debugTarget.getModuleResource();
        IMarker marker = DebugApplicationCondition.addMarker(moduleFile, "org.eclipse.emf.henshin.model", "/value", "Sample ValueBreakpoint", 0);
        ValueBreakpoint breakpoint = new ValueBreakpoint();
        try {
            breakpoint.setMarker(marker);
            breakpoint.setEnabled(true);
            breakpoint.setType(value.getReferenceTypeName());
            breakpoint.setValueString(value.getValueString());
            breakpoint.setIndex(index);
            breakpoint.setDebugLevel(DebugLevel.VALUE);
            manager.addBreakpoint((IBreakpoint)breakpoint);
        }
        catch (CoreException e1) {
            System.out.println("Unable to create custom ValueBreakpoint.");
            e1.printStackTrace();
        }
    }

    public void setConstraintTypeBreakpoint(String constraintType) {
        IBreakpointManager manager = this.getManager();
        IResource moduleFile = this.debugTarget.getModuleResource();
        IMarker marker = DebugApplicationCondition.addMarker(moduleFile, "org.eclipse.emf.henshin.model", "/constraintType", "Sample ConstraintTypeBreakpoint", 0);
        ConstraintTypeBreakpoint breakpoint = new ConstraintTypeBreakpoint();
        try {
            breakpoint.setMarker(marker);
            breakpoint.setEnabled(true);
            breakpoint.setType(ConstraintType.valueOf(constraintType));
            breakpoint.setDebugLevel(DebugLevel.CONSTRAINT_TYPE);
            manager.addBreakpoint((IBreakpoint)breakpoint);
        }
        catch (CoreException e1) {
            System.out.println("Unable to create custom ConstraintTypeBreakpoint.");
            e1.printStackTrace();
        }
    }

    public void setConstraintInstanceBreakpoint(String constraintInstance) {
        IBreakpointManager manager = this.getManager();
        IResource moduleFile = this.debugTarget.getModuleResource();
        IMarker marker = DebugApplicationCondition.addMarker(moduleFile, "org.eclipse.emf.henshin.model", "/constraintInstance", "Sample ConstraintInstanceBreakpoint", 0);
        ConstraintInstanceBreakpoint breakpoint = new ConstraintInstanceBreakpoint();
        try {
            breakpoint.setMarker(marker);
            breakpoint.setEnabled(true);
            breakpoint.setConstraintInstance(this.removeRuntimeValuesFromConstraintInstance(constraintInstance));
            breakpoint.setDebugLevel(DebugLevel.CONSTRAINT);
            manager.addBreakpoint((IBreakpoint)breakpoint);
        }
        catch (CoreException e1) {
            System.out.println("Unable to create custom ConstraintInstanceBreakpoint.");
            e1.printStackTrace();
        }
    }

    protected String removeRuntimeValuesFromConstraintInstance(String constraintInstance) {
        int indexOfParenthesis = constraintInstance.indexOf(40);
        if (indexOfParenthesis > 0) {
            constraintInstance = constraintInstance.substring(0, indexOfParenthesis - 1);
        }
        return constraintInstance;
    }

    public ArrayList<HenshinBreakpoint> filterHenshinBreakpoints(IBreakpoint[] breakpoints) {
        ArrayList<HenshinBreakpoint> henshinBreakpoints = new ArrayList<HenshinBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (this.isHenshinBreakpoint(breakpoint)) {
                HenshinBreakpoint henshinBreakpoint = (HenshinBreakpoint)breakpoint;
                henshinBreakpoints.add(henshinBreakpoint);
            }
            ++n2;
        }
        return henshinBreakpoints;
    }

    public boolean isHenshinBreakpoint(IBreakpoint breakpoint) {
        return HenshinBreakpoint.class.isAssignableFrom(breakpoint.getClass());
    }

    public ArrayList<VariableBreakpoint> filterVariableBreakpoints(ArrayList<HenshinBreakpoint> henshinBreakpoints) {
        ArrayList<VariableBreakpoint> variableBreakpoints = new ArrayList<VariableBreakpoint>();
        for (HenshinBreakpoint henshinBreakpoint : henshinBreakpoints) {
            if (!this.isVariableBreakpoint(henshinBreakpoint)) continue;
            VariableBreakpoint variableBreakpoint = (VariableBreakpoint)henshinBreakpoint;
            variableBreakpoints.add(variableBreakpoint);
        }
        return variableBreakpoints;
    }

    public boolean isVariableBreakpoint(HenshinBreakpoint breakpoint) {
        return breakpoint instanceof VariableBreakpoint;
    }

    public ArrayList<ConstraintTypeBreakpoint> filterConstraintTypeBreakpoints(ArrayList<HenshinBreakpoint> henshinBreakpoints) {
        ArrayList<ConstraintTypeBreakpoint> constraintTypeBreakpoints = new ArrayList<ConstraintTypeBreakpoint>();
        for (HenshinBreakpoint henshinBreakpoint : henshinBreakpoints) {
            if (!this.isConstraintTypeBreakpoint(henshinBreakpoint)) continue;
            ConstraintTypeBreakpoint constraintTypeBreakpoint = (ConstraintTypeBreakpoint)henshinBreakpoint;
            constraintTypeBreakpoints.add(constraintTypeBreakpoint);
        }
        return constraintTypeBreakpoints;
    }

    public boolean isConstraintTypeBreakpoint(HenshinBreakpoint breakpoint) {
        return breakpoint instanceof ConstraintTypeBreakpoint;
    }

    public ArrayList<ConstraintInstanceBreakpoint> filterConstraintInstanceBreakpoints(ArrayList<HenshinBreakpoint> henshinBreakpoints) {
        ArrayList<ConstraintInstanceBreakpoint> constraintInstanceBreakpoints = new ArrayList<ConstraintInstanceBreakpoint>();
        for (HenshinBreakpoint henshinBreakpoint : henshinBreakpoints) {
            if (!this.isConstraintInstanceBreakpoint(henshinBreakpoint)) continue;
            ConstraintInstanceBreakpoint constraintInstanceBreakpoint = (ConstraintInstanceBreakpoint)henshinBreakpoint;
            constraintInstanceBreakpoints.add(constraintInstanceBreakpoint);
        }
        return constraintInstanceBreakpoints;
    }

    public boolean isConstraintInstanceBreakpoint(HenshinBreakpoint breakpoint) {
        return breakpoint instanceof ConstraintInstanceBreakpoint;
    }

    public boolean shouldStopAtVariableBreakpoint(VariableBreakpoint variableBreakpoint, String currentTypeName, String currentNodePath) {
        block4: {
            block6: {
                block5: {
                    try {
                        if (!variableBreakpoint.isEnabled()) break block4;
                        if (!variableBreakpoint.isGeneric()) break block5;
                        return true;
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (!variableBreakpoint.isSpecificVariable() || !currentNodePath.equals(variableBreakpoint.getPath())) break block6;
                return true;
            }
            if (!variableBreakpoint.isSpecificType() || !currentTypeName.equals(variableBreakpoint.getTypeName())) break block4;
            return true;
        }
        return false;
    }

    public boolean shouldStopAtValueBreakpoint(ValueBreakpoint valueBreakpoint, EObject value, int index) {
        try {
            if (valueBreakpoint.isEnabled()) {
                String breakpointType = valueBreakpoint.getType();
                int breakpointIndex = valueBreakpoint.getIndex();
                String currentType = value.eClass().getName();
                int currentIndex = index;
                if (breakpointType.equals(currentType) && breakpointIndex == currentIndex) {
                    return true;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean shouldStopAtConstraintTypeBreakpoint(ConstraintTypeBreakpoint constraintTypeBreakpoint) {
        return constraintTypeBreakpoint.getType() == this.currentConstraintType;
    }

    public boolean shouldStopAtConstraintInstanceBreakpoint(ConstraintInstanceBreakpoint constraintInstanceBreakpoint) {
        return this.removeRuntimeValuesFromConstraintInstance(this.retrieveConstraintLabel()).equals(constraintInstanceBreakpoint.getConstraintInstance());
    }

    public boolean isLastVariable() {
        return this.currentVariableIndex == this.variables.size() - 1;
    }

    public ArrayList<ValueBreakpoint> filterValueBreakpoints(ArrayList<HenshinBreakpoint> henshinBreakpoints) {
        ArrayList<ValueBreakpoint> valueBreakpoints = new ArrayList<ValueBreakpoint>();
        for (HenshinBreakpoint henshinBreakpoint : henshinBreakpoints) {
            if (!this.isValueBreakpoint((IBreakpoint)henshinBreakpoint)) continue;
            ValueBreakpoint valueBreakpoint = (ValueBreakpoint)henshinBreakpoint;
            valueBreakpoints.add(valueBreakpoint);
        }
        return valueBreakpoints;
    }

    public boolean isValueBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof ValueBreakpoint;
    }

    public void handleDebugState(HenshinBreakpoint henshinBreakpoint) {
        DebugLevel henshinBreakpointDebugLevel = henshinBreakpoint.getDebugLevel();
        if (this.currentDebugLevel.equals((Object)henshinBreakpointDebugLevel)) {
            try {
                this.debugTarget.suspend();
            }
            catch (DebugException e) {
                System.out.println("Application could not be suspended.");
                e.printStackTrace();
            }
        } else {
            try {
                this.debugTarget.resume();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    public void setSuspended() {
        try {
            this.debugTarget.suspend();
        }
        catch (DebugException e) {
            System.out.println("Application could not be suspended.");
            e.printStackTrace();
        }
    }

    public void setResumed() {
        try {
            this.debugTarget.resume();
        }
        catch (DebugException e) {
            System.out.println("Application could not be resumed.");
            e.printStackTrace();
        }
    }

    public boolean shouldSuspendApplication(HenshinBreakpoint henshinBreakpoint) {
        switch (this.currentDebugLevel) {
            case VARIABLE: {
                if (!(henshinBreakpoint instanceof VariableBreakpoint)) break;
                System.out.println("Matched VariableBreakpoint");
                break;
            }
            case VALUE: {
                if (!(henshinBreakpoint instanceof ValueBreakpoint)) break;
                System.out.println("Matched ValueBreakpoint");
                break;
            }
        }
        return false;
    }

    public synchronized IStackFrame[] getStackFrames(HenshinDebugThread debugThread) {
        int lines = this.currentVariableIndex + 1;
        if (this.currentDebugLevel.ordinal() > 1) {
            lines += this.currentDebugLevel.ordinal() - 1;
        }
        this.stackFrames = new IStackFrame[lines];
        StringBuilder labelBuilder = new StringBuilder();
        int i = 0;
        while (i <= this.currentVariableIndex) {
            Variable var = (Variable)this.variables.get(i);
            DomainSlot slot = (DomainSlot)this.domainMap.get(var);
            labelBuilder.append("Variable ").append(this.retrieveVariableLabel(var));
            if (!this.isTerminated() && i != this.currentVariableIndex || this.isTerminated()) {
                labelBuilder.append(" (Match: ").append(DebugApplicationCondition.retrieveValueLabel(slot.getValue(), this.graph)).append(")");
            }
            HenshinDebugVariable debugVariable = new HenshinDebugVariable((IDebugTarget)this.debugTarget, "Variable", this.retrieveVariableLabel(var), var);
            String declaredType = var.typeConstraint.type.getName();
            if (slot.getDomain() == null) {
                declaredType = String.valueOf(declaredType) + "[]";
            }
            HenshinDebugVariable debugDomain = new HenshinDebugVariable(this.debugTarget, "Domain", new DebugValueList(this.debugTarget, this.graph, declaredType, slot.getDomain() != null ? slot.getDomain() : new ArrayList()));
            IVariable[] stackVariables = new IVariable[]{debugVariable, debugDomain};
            this.stackFrames[i] = new HenshinStackFrame(debugThread, stackVariables, labelBuilder.toString(), i);
            labelBuilder.setLength(0);
            ++i;
        }
        if (this.currentDebugLevel.ordinal() > 1) {
            List<Object> domain = this.currentSlot.getValue() != null ? this.graph.getDomain(this.currentSlot.getValue().eClass(), false) : new ArrayList();
            int index = domain.indexOf(this.currentSlot.getValue());
            HenshinDebugVariable debugValue = new HenshinDebugVariable(this.debugTarget, "Value", new DebugValueEObject(this.debugTarget, this.graph, this.currentVariable.typeConstraint.type.getName(), this.currentSlot.getValue(), index));
            IVariable[] stackFrameVariables = new IVariable[]{debugValue};
            String label = "Value: '" + DebugApplicationCondition.retrieveValueLabel(this.currentSlot.getValue(), this.graph) + "'";
            this.stackFrames[this.currentVariableIndex + 1] = new HenshinStackFrame(debugThread, stackFrameVariables, label, this.currentVariableIndex + 1);
            if (this.currentDebugLevel.ordinal() > 2) {
                HenshinDebugVariable debugConstrType = new HenshinDebugVariable((IDebugTarget)this.debugTarget, "Constraint Type", this.currentConstraintType.toString(), ConstraintType.class.getSimpleName());
                label = "Constraint Type: '" + (Object)((Object)this.currentConstraintType) + "'";
                this.stackFrames[this.currentVariableIndex + 2] = new HenshinStackFrame(debugThread, new IVariable[]{debugConstrType}, label, this.currentVariableIndex + 2);
                if (this.currentDebugLevel.ordinal() > 3) {
                    HenshinDebugVariable debugConstrIndex = new HenshinDebugVariable(this.debugTarget, "Constraint Index", new DebugValueObject(this.debugTarget, this.graph, Integer.TYPE.getName(), this.currentConstraintIndex, 0));
                    label = this.retrieveConstraintLabel();
                    HenshinDebugVariable debugConstraint = new HenshinDebugVariable((IDebugTarget)this.debugTarget, "Constraint", label, String.valueOf(this.currentConstraintType.toString()) + " Constraint");
                    this.stackFrames[this.currentVariableIndex + 3] = new HenshinStackFrame(debugThread, new IVariable[]{debugConstrIndex, debugConstraint}, label, this.currentVariableIndex + 3);
                }
            }
        }
        return this.stackFrames;
    }

    private String retrieveVariableLabel(Variable var) {
        String varNamePrefix = var.name != null ? String.valueOf(var.name) + ":" : "";
        return String.valueOf(this.variables.indexOf(var)) + ": '" + varNamePrefix + var.typeConstraint.type.getName() + "'";
    }

    public static String retrieveValueLabel(EObject value, EGraph graph) {
        List<EObject> allValues;
        int valIndex;
        if (value == null) {
            return "null";
        }
        String label = String.valueOf(value.eClass().getName()) + " ";
        for (EStructuralFeature feature : value.eClass().getEAllStructuralFeatures()) {
            if (!feature.getName().equalsIgnoreCase("name") && !feature.getName().equalsIgnoreCase("id")) continue;
            label = String.valueOf(label) + value.eGet(feature);
            return label;
        }
        label = graph != null ? ((valIndex = (allValues = graph.getDomain(value.eClass(), false)).indexOf(value)) != -1 ? String.valueOf(label) + "(index=" + valIndex + ")" : String.valueOf(label) + "(hashCode=" + value.hashCode() + ")") : String.valueOf(label) + "(hashCode=" + value.hashCode() + ")";
        return label;
    }

    private synchronized String retrieveConstraintLabel() {
        String label = "";
        if (this.currentDebugLevel != DebugLevel.CONSTRAINT) {
            return "Constraint " + this.currentConstraintIndex;
        }
        switch (this.currentConstraintType) {
            case TYPE: {
                label = String.valueOf(label) + "Type = " + this.currentVariable.typeConstraint.type.getName();
                break;
            }
            case DANGLING: {
                label = String.valueOf(label) + DebugApplicationCondition.retrieveValueLabel(this.currentSlot.getValue(), this.graph);
                break;
            }
            case ATTRIBUTE: {
                AttributeConstraint attributeConstraint = this.currentVariable.attributeConstraints.get(this.currentConstraintIndex);
                String paramName = String.valueOf(attributeConstraint.getValue());
                String paramValue = String.valueOf(this.currentSlot.getConditionHandler().getParameter(paramName));
                if (!this.currentSlot.getConditionHandler().isSet(paramName)) {
                    paramValue = paramName;
                }
                String attName = attributeConstraint.getAttribute().getName();
                if (this.currentSlot.getValue() == null) break;
                String attValue = String.valueOf(this.currentSlot.getValue().eGet(this.currentSlot.getValue().eClass().getEStructuralFeature(attName)));
                label = String.valueOf(label) + attName + " = " + paramName + " (" + attValue + " = " + paramValue + ")";
                break;
            }
            case CONTAINMENT: {
                ContainmentConstraint containmentConstraint = this.currentVariable.containmentConstraints.get(this.currentConstraintIndex);
                Variable targetVariable = containmentConstraint.getTargetVariable();
                EObject targetValue = ((DomainSlot)this.domainMap.get(targetVariable)).getValue();
                if (targetValue == null) {
                    label = String.valueOf(label) + this.retrieveVariableLabel(targetVariable);
                    break;
                }
                label = String.valueOf(label) + targetValue.eClass().getName() + " " + DebugApplicationCondition.retrieveValueLabel(targetValue, this.graph);
                break;
            }
            case REFERENCE: {
                List<EObject> targetObjects;
                ReferenceConstraint referenceConstraint = this.currentVariable.referenceConstraints.get(this.currentConstraintIndex);
                EReference reference = referenceConstraint.getReference();
                label = String.valueOf(label) + reference.getName() + ": ";
                if (reference.isMany()) {
                    targetObjects = (List<EObject>)this.currentSlot.getValue().eGet((EStructuralFeature)reference);
                } else {
                    EObject obj = (EObject)this.currentSlot.getValue().eGet((EStructuralFeature)reference);
                    targetObjects = Collections.singletonList(obj);
                }
                StringJoiner listJoiner = new StringJoiner(", ", "[", "]");
                for (EObject obj : targetObjects) {
                    listJoiner.add(DebugApplicationCondition.retrieveValueLabel(obj, this.graph));
                }
                label = String.valueOf(label) + listJoiner.toString();
                break;
            }
            case PATH: {
                PathConstraint pathConstraint = this.currentVariable.pathConstraints.get(this.currentConstraintIndex);
                List<EReference> references = pathConstraint.getReferences();
                StringJoiner listJoiner = new StringJoiner(", ", "[", "]");
                for (EReference ref : references) {
                    listJoiner.add(ref.getName());
                }
                label = String.valueOf(label) + "Path to variable <" + this.retrieveVariableLabel(pathConstraint.getTargetVariable()) + "> via references " + listJoiner.toString();
                break;
            }
            case USER: {
                label = String.valueOf(label) + "User";
                break;
            }
            case NONE: {
                throw new IllegalStateException("trying to find label for constraint with currentConstraintType NONE");
            }
            default: {
                throw new IllegalStateException("missing ConstraintType in switch statement?");
            }
        }
        return label;
    }

    public DebugState getCurrentDebugState() {
        return this.currentDebugState;
    }

    public <U> boolean checkForChange(Object a, Object b) {
        if (this.currentDebugLevel == DebugLevel.NONE || a != b || this.currentDebugState == DebugState.TERMINATED_TRUE || this.currentDebugState == DebugState.TERMINATED_FALSE) {
            this.suspendApplication();
            return false;
        }
        return true;
    }

    public void suspendApplication() {
        if (!this.isTerminated()) {
            this.setCurrentDebugState(DebugState.SUSPENDED);
        }
    }

    public boolean checkDebugState(DebugLevel expectedDebugLevel, int expectedVariableIndex, EObject expectedValue, ConstraintType expectedConstraintType, int expectedConstraintIndex) {
        return expectedDebugLevel == this.currentDebugLevel && expectedVariableIndex == this.currentVariableIndex && (this.currentSlot == null ? expectedValue == null : expectedValue == this.currentSlot.getValue()) && expectedConstraintType == this.currentConstraintType && expectedConstraintIndex == this.currentConstraintIndex;
    }

    public boolean checkMatch(List<EObject> expectedValues) {
        int i = 0;
        while (i < this.variables.size()) {
            DomainSlot slot = (DomainSlot)this.domainMap.get(this.variables.get(i));
            EObject actualValue = slot.getValue();
            try {
                if (expectedValues.get(i) != actualValue) {
                    return false;
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean checkMatch(Map<Variable, EObject> expectedValues) {
        for (Variable variable : expectedValues.keySet()) {
            EObject actualValue;
            EObject expectedValue = expectedValues.get(variable);
            if (expectedValue == (actualValue = ((DomainSlot)this.domainMap.get(variable)).getValue())) continue;
            return false;
        }
        return true;
    }

    private void throwExceptionInvalidDebugLevel() {
        throw new IllegalStateException("currentDebugLevel is \"" + (Object)((Object)this.currentDebugLevel) + "\", but has to be of the enum type DebugLevel");
    }

    public String toString() {
        return "[debugLevel: " + (Object)((Object)this.currentDebugLevel) + ", variableIndex: " + this.currentVariableIndex + ", value: " + DebugApplicationCondition.retrieveValueLabel(this.currentSlot.getValue(), this.graph) + ", constraintType: " + (Object)((Object)this.currentConstraintType) + ", " + this.retrieveConstraintLabel() + "]";
    }

    private static IMarker addMarker(IResource ressource, String elementId, String location, String message, int statusSeverity) {
        IMarker marker = null;
        try {
            marker = ressource.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("location", (Object)location);
            marker.setAttribute("elementId", (Object)elementId);
            int markerSeverity = 0;
            if (statusSeverity == 2) {
                markerSeverity = 1;
            } else if (statusSeverity == 4 || statusSeverity == 8) {
                markerSeverity = 2;
            }
            marker.setAttribute("severity", markerSeverity);
        }
        catch (CoreException e) {
            HenshinModelPlugin.INSTANCE.logError("Failed to create validation marker", (Throwable)e);
        }
        return marker;
    }

    public static enum ConstraintType {
        NONE,
        TYPE,
        DANGLING,
        ATTRIBUTE,
        CONTAINMENT,
        REFERENCE,
        PATH,
        USER;


        public ConstraintType next() {
            if (this.isLast()) {
                return this;
            }
            return ConstraintType.values()[(this.ordinal() + 1) % ConstraintType.values().length];
        }

        public boolean isLast() {
            return this.ordinal() + 1 == ConstraintType.values().length;
        }

        public String toString() {
            String nameString = this.name().substring(0, 1);
            nameString = String.valueOf(nameString) + this.name().substring(1, this.name().length()).toLowerCase().replace("_", " ");
            return nameString;
        }
    }

    public static enum DebugLevel {
        NONE,
        VARIABLE,
        VALUE,
        CONSTRAINT_TYPE,
        CONSTRAINT;


        public String toString() {
            return this.name();
        }
    }

    public static enum DebugState {
        RUNNING,
        STEPPING,
        SUSPENDED,
        TERMINATED_TRUE,
        TERMINATED_FALSE;

    }
}

