/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.interpreter.ui.HenshinInterpreterUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ModelSelector {
    protected Collection<ModelSelectorListener> listeners = new ArrayList<ModelSelectorListener>();
    protected Group container;
    protected Button browseWorkspaceButton;
    protected Button browseFileSystemButton;
    protected Text uriField;

    public ModelSelector(Composite parent, final IResource baseDir, boolean output) {
        this.container = new Group(parent, 0);
        this.container.setText(HenshinInterpreterUIPlugin.LL(output ? "_UI_OutputModel" : "_UI_InputModel"));
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.uriField = new Text((Composite)this.container, 2048);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalSpan = 3;
        this.uriField.setLayoutData((Object)data);
        this.uriField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModelSelector.this.fireURIChanged();
            }
        });
        this.uriField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelector.this.fireURIChanged();
            }
        });
        if (!output) {
            Label label = new Label((Composite)this.container, 0);
            label.setText("");
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            this.browseWorkspaceButton = new Button((Composite)this.container, 8);
            this.browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            this.browseWorkspaceButton.setLayoutData((Object)new GridData(4, 4, false, false));
            this.browseFileSystemButton = new Button((Composite)this.container, 8);
            this.browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
            this.browseFileSystemButton.setLayoutData((Object)new GridData(4, 4, false, false));
            this.browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Object[] objectArray;
                    if (baseDir == null) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = baseDir;
                    }
                    Object[] selection = objectArray;
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)HenshinInterpreterUIPlugin.LL("_UI_BrowseWorkspace_Title"), (String)HenshinInterpreterUIPlugin.LL("_UI_BrowseWorkspace_Message"), (boolean)false, (Object[])selection, null);
                    if (files.length != 1) {
                        return;
                    }
                    IFile file = files[0];
                    if (file != null) {
                        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                        ModelSelector.this.uriField.setText(uri.toString());
                        ModelSelector.this.fireURIChanged();
                    }
                }
            });
            this.browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                    fileDialog.open();
                    String path = fileDialog.getFilterPath();
                    String fileName = fileDialog.getFileName();
                    if (fileName != null) {
                        URI uri = URI.createFileURI((String)(String.valueOf(path) + File.separator + fileName));
                        ModelSelector.this.uriField.setText(uri.toString());
                        ModelSelector.this.fireURIChanged();
                    }
                }
            });
        }
    }

    protected void fireURIChanged() {
        for (ModelSelectorListener l : this.listeners) {
            l.modelURIChanged(this.uriField.getText());
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void addModelSelectorListener(ModelSelectorListener listener) {
        this.listeners.add(listener);
    }

    public void setModelURI(String modelURI) {
        this.uriField.setText(modelURI);
    }

    public String getModelURI() {
        return this.uriField.getText();
    }

    public Button getBrowseWorkspaceButton() {
        return this.browseWorkspaceButton;
    }

    public Button getBrowseFileSystemButton() {
        return this.browseFileSystemButton;
    }

    public static interface ModelSelectorListener {
        public boolean modelURIChanged(String var1);
    }
}

