/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.event.TreeViewEvent;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.AmalgamatedRuleTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.MultiRuleTreeNodeData;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.Covering;
import agg.xt_basis.agt.RuleScheme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RuleSchemePopupMenu
extends JPopupMenu {
    JMenuItem mi;
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    private int locationRow;
    protected EdRuleScheme ruleScheme;
    private JMenuItem miDisabled;
    private JMenuItem miDisjointMultiMatch;
    private JMenuItem miConflictFreeMultiMatch;
    private JMenuItem miParallelKernelMatch;
    private JMenuItem miAtLeastOneMultiMatch;
    private JMenuItem miWait;

    public RuleSchemePopupMenu(GraGraTreeView tree) {
        super("RuleScheme");
        this.treeView = tree;
        this.mi = this.add(new JMenuItem("New Multi Rule"));
        this.mi.setActionCommand("newMultiRule");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.addMultiRule();
            }
        });
        this.addSeparator();
        this.miParallelKernelMatch = this.add(new JCheckBoxMenuItem("parallel Match of Kernel Rule"));
        this.miParallelKernelMatch.setActionCommand("parallelKernelMatch");
        this.miParallelKernelMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.setParallelKernelMatch(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.miDisjointMultiMatch = this.add(new JCheckBoxMenuItem("disjoint Match of Multi Rule"));
        this.miDisjointMultiMatch.setActionCommand("disjointMultiMatch");
        this.miDisjointMultiMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.setDisjointMultiMatch(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.miConflictFreeMultiMatch = new JCheckBoxMenuItem("conflict free Match of Multi Rule");
        this.add(this.miConflictFreeMultiMatch);
        this.miConflictFreeMultiMatch.setActionCommand("conflictFreeMultiMatch");
        this.miConflictFreeMultiMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.setConflictFreeMultiMatch(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.miAtLeastOneMultiMatch = this.add(new JCheckBoxMenuItem("apply at least One Multi Rule"));
        this.miAtLeastOneMultiMatch.setActionCommand("atLeastOneMultiMatch");
        this.miAtLeastOneMultiMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.setAtLeastOneMultiMatchRequired(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Create Amalgamated Rule"));
        this.mi.setActionCommand("createAmalgamatedRule");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.createAmalgamatedRule();
            }
        });
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Set Layer                                 "));
        this.mi.setActionCommand("setRuleLayer");
        this.mi.addActionListener(this.treeView.getActionAdapter());
        this.mi.setEnabled(true);
        this.mi = this.add(new JMenuItem("Set Priority                              "));
        this.mi.setActionCommand("setRulePriority");
        this.mi.addActionListener(this.treeView.getActionAdapter());
        this.mi.setEnabled(true);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Move"));
        this.mi.setActionCommand("moveRuleScheme");
        this.mi.addActionListener(this.treeView.getActionAdapter());
        this.mi.setEnabled(true);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Copy"));
        this.mi.setActionCommand("copyRuleScheme");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.copyRuleScheme();
            }
        });
        this.mi.setEnabled(true);
        this.mi = this.add(new JMenuItem("Make Inverse RuleScheme"));
        this.mi.setActionCommand("reverseRuleScheme");
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.reverseRuleScheme();
            }
        });
        this.mi.setEnabled(true);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Delete                "));
        this.mi.setActionCommand("deleteRuleScheme");
        this.mi.addActionListener(this.treeView.getActionAdapter());
        this.mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RuleSchemePopupMenu.this.treeView.hasMultipleSelection()) {
                    RuleSchemePopupMenu.this.treeView.delete("selected");
                } else {
                    RuleSchemePopupMenu.this.deleteRuleScheme();
                }
            }
        });
        this.mi.setEnabled(true);
        this.addSeparator();
        this.miDisabled = new JCheckBoxMenuItem("disabled");
        this.miDisabled.setActionCommand("disableRuleScheme");
        this.miDisabled.addActionListener(this.treeView.getActionAdapter());
        this.add(this.miDisabled);
        this.addSeparator();
        this.miWait = new JCheckBoxMenuItem("Wait Before Applying Rule");
        this.miWait.setActionCommand("waitBeforeApplyRule");
        this.miWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleSchemePopupMenu.this.ruleScheme.getBasisRule().setWaitBeforeApplyEnabled(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.add(this.miWait);
        this.addSeparator();
        this.mi = this.add(new JMenuItem("Textual Comments"));
        this.mi.setActionCommand("commentRuleScheme");
        this.mi.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        this.locationRow = this.treeView.getTree().getRowForLocation(x, y);
        if (this.locationRow != -1 && this.treeView.getTree().getPathForLocation(x, y).getPath().length == 3) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.ruleScheme = this.treeView.getRuleScheme((DefaultMutableTreeNode)this.path.getLastPathComponent());
            if (this.ruleScheme != null) {
                this.miParallelKernelMatch.setSelected(this.ruleScheme.getBasisRuleScheme().parallelKernelMatch());
                this.miDisjointMultiMatch.setSelected(this.ruleScheme.getBasisRuleScheme().disjointMultiMatches());
                this.miConflictFreeMultiMatch.setSelected(this.ruleScheme.getBasisRuleScheme().checkDeleteUseConflictRequired());
                this.miAtLeastOneMultiMatch.setSelected(this.ruleScheme.getBasisRuleScheme().atLeastOneMultiMatchRequired());
                this.miDisabled.setSelected(!this.ruleScheme.getBasisRule().isEnabled());
                this.miWait.setSelected(this.ruleScheme.getBasisRule().isWaitBeforeApplyEnabled());
                return true;
            }
        }
        return false;
    }

    protected void addMultiRule() {
        if (this.treeView.getSelectedPath() == null) {
            String s = "Bad selection.\n Please select a rule scheme.";
            JOptionPane.showMessageDialog(this.treeView.getFrame(), s, "", 2);
            return;
        }
        TreePath rsPath = this.treeView.getSelectedPath();
        DefaultMutableTreeNode rsNode = (DefaultMutableTreeNode)rsPath.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)rsNode.getUserObject();
        if (data != null && data.isRuleScheme()) {
            EdRuleScheme rs = data.getRuleScheme();
            EdRule multiRule = rs.addMultiRule("MultiRule" + String.valueOf(rs.getBasisRuleScheme().getCountOfMultiRules()));
            multiRule.update();
            MultiRuleTreeNodeData sdMultiRule = new MultiRuleTreeNodeData(multiRule);
            DefaultMutableTreeNode newMultiRuleNode = new DefaultMutableTreeNode(sdMultiRule);
            sdMultiRule.setTreeNode(newMultiRuleNode);
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.selPath.getLastPathComponent();
            int newIndex = rs.getBasisRuleScheme().getCountOfMultiRules();
            this.treeView.getTreeModel().insertNodeInto(newMultiRuleNode, parent, newIndex);
        }
    }

    protected void deleteRuleScheme() {
        TreePath graPath = null;
        TreePath rsPath = null;
        DefaultMutableTreeNode rsNode = null;
        GraGraTreeNodeData data = null;
        if (this.treeView.getSelectedPath() == null) {
            String s = "Bad selection.\n Please select a rule scheme.";
            JOptionPane.showMessageDialog(this.treeView.getFrame(), s, "", 2);
            return;
        }
        graPath = this.treeView.getSelectedPath().getParentPath();
        rsPath = this.treeView.getSelectedPath();
        rsNode = (DefaultMutableTreeNode)rsPath.getLastPathComponent();
        data = (GraGraTreeNodeData)rsNode.getUserObject();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            if (data.getRuleScheme() != this.treeView.getCurrentRuleScheme()) {
                int answer = this.treeView.removeWarning("RuleScheme");
                if (answer == 0) {
                    int row = this.treeView.getTree().getRowForPath(rsPath);
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, rsPath));
                    this.treeView.getTreeModel().removeNodeFromParent(rsNode);
                    EdRuleScheme rs = data.getRuleScheme();
                    graData.getGraGra().removeRule(rs);
                    this.treeView.setEditPath(--row);
                    this.treeView.setFlagForNew();
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.treeView.editorPath));
                }
            } else {
                int answer = this.treeView.removeCurrentObjectWarning("RuleScheme");
                if (answer == 0) {
                    int row = this.treeView.getTree().getRowForPath(rsPath);
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 7, rsPath));
                    this.treeView.getTreeModel().removeNodeFromParent(rsNode);
                    EdRule rs = data.getRule();
                    this.treeView.getGraGraStore().storeRuleScheme(rs.getGraGra(), (EdRuleScheme)rs);
                    graData.getGraGra().removeRule(rs);
                    this.treeView.setEditPath(--row);
                    this.treeView.setFlagForNew();
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.treeView.editorPath));
                    if (((GraGraTreeNodeData)((DefaultMutableTreeNode)this.treeView.selPath.getLastPathComponent()).getUserObject()).isGraph() && !this.treeView.getCurrentGraGra().getRules().isEmpty()) {
                        this.treeView.setEditPath(++row);
                        this.treeView.setFlagForNew();
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 61, this.treeView.editorPath));
                    }
                }
            }
        }
    }

    protected void createAmalgamatedRule() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.treeView.selPath.getLastPathComponent();
        EdRuleScheme rs = this.treeView.getRuleScheme(node);
        if (rs == null) {
            JOptionPane.showMessageDialog(null, "Bad selection. \nPlease select a rule scheme.");
            return;
        }
        if (rs.getGraGra().isEditable()) {
            RuleScheme baseRS = rs.getBasisRuleScheme();
            if (baseRS.getAmalgamatedRule() == null) {
                if (baseRS.isValid()) {
                    baseRS.clearMatchesOfMultiRules();
                    if (!baseRS.isInputParameterSet(true)) {
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 28, baseRS));
                        JOptionPane.showMessageDialog(null, "Please set Input Parameter of the rule scheme\nand call <Create Amalgamated Rule> again.", "Input Parameter Not Set", 2);
                        return;
                    }
                    baseRS.applyValueOfInputParameter();
                    Covering cov = new Covering(baseRS, rs.getGraGra().getBasisGraGra().getGraph(), rs.getGraGra().getBasisGraGra().getMorphismCompletionStrategy());
                    if (cov.amalgamate() && cov.getAmalgamatedRule() != null) {
                        AmalgamatedRule amalgamatedRule = cov.getAmalgamatedRule();
                        baseRS.setAmalgamatedRule(amalgamatedRule);
                        EdRule edAmalgamatedRule = new EdRule(amalgamatedRule);
                        amalgamatedRule.setName("Amalgamation");
                        edAmalgamatedRule.update();
                        rs.setAmalgamatedRule(edAmalgamatedRule);
                        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.selPath.getLastPathComponent();
                        int newIndex = parent.getChildCount();
                        AmalgamatedRuleTreeNodeData sdRule = new AmalgamatedRuleTreeNodeData(edAmalgamatedRule);
                        DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
                        sdRule.setTreeNode(newRuleNode);
                        this.treeView.getTreeModel().insertNodeInto(newRuleNode, parent, newIndex);
                        this.treeView.getTree().expandPath(this.treeView.selPath);
                        this.treeView.getTree().treeDidChange();
                        TreePath path = this.treeView.getTreePathOfGrammarElement(edAmalgamatedRule);
                        if (path != null) {
                            int row = this.treeView.getTree().getRowForPath(path);
                            this.treeView.selectPath(row);
                        }
                    } else {
                        JOptionPane.showMessageDialog(this.treeView.getFrame(), "Amalgamation failed.\n" + cov.getErrorMessage(), "Rule Scheme: " + rs.getBasisRuleScheme().getName(), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "Amalgamation is not possible.\nPlease check the rule scheme: \nembedding of the kernel rule into the multi rules,\nbut also attribute settings.", "Invalid Rule Scheme", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "An amalgamated rule does already exist.\nPlease delete it first.", "Rule Scheme: " + rs.getBasisRuleScheme().getName(), 2);
            }
        } else {
            this.treeView.lockWarning();
        }
    }

    protected void setDisjointMultiMatch(boolean b) {
        if (this.ruleScheme != null) {
            this.ruleScheme.getBasisRuleScheme().setDisjointMultiMatches(b);
        }
    }

    protected void setConflictFreeMultiMatch(boolean b) {
        if (this.ruleScheme != null) {
            this.ruleScheme.getBasisRuleScheme().setCheckDeleteUseConflictRequired(b);
        }
    }

    protected void setParallelKernelMatch(boolean b) {
        if (this.ruleScheme != null) {
            this.ruleScheme.getBasisRuleScheme().setParallelKernelMatch(b);
        }
    }

    protected void setAtLeastOneMultiMatchRequired(boolean b) {
        if (this.ruleScheme != null) {
            this.ruleScheme.getBasisRuleScheme().setAtLeastOneMultiMatchRequired(b);
        }
    }

    void copyRuleScheme() {
        GraGraTreeNodeData data = (GraGraTreeNodeData)this.node.getUserObject();
        TreePath graPath = null;
        if (this.path == null) {
            String s = "Bad selection.\n Please select a rule scheme.";
            JOptionPane.showMessageDialog(null, s, "", 2);
            return;
        }
        graPath = this.path.getParentPath();
        if (graPath != null) {
            DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
            GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
            EdRuleScheme rsClone = graData.getGraGra().cloneRuleScheme(data.getRuleScheme(), true);
            this.treeView.putRuleSchemeIntoTree(rsClone, (DefaultMutableTreeNode)this.node.getParent(), ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.node) + 1);
            this.treeView.getTree().treeDidChange();
            this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.path));
        }
    }

    void reverseRuleScheme() {
        DefaultMutableTreeNode graNode;
        GraGraTreeNodeData graData;
        EdRuleScheme invRS;
        GraGraTreeNodeData data = (GraGraTreeNodeData)this.node.getUserObject();
        TreePath graPath = null;
        if (this.path == null) {
            String s = "Bad selection.\n Please select a rule scheme.";
            JOptionPane.showMessageDialog(null, s, "", 2);
            return;
        }
        graPath = this.path.getParentPath();
        if (graPath != null && (invRS = (graData = (GraGraTreeNodeData)(graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent()).getUserObject()).getGraGra().reverseRuleScheme(data.getRuleScheme(), true)) != null) {
            this.treeView.putRuleSchemeIntoTree(invRS, (DefaultMutableTreeNode)this.node.getParent(), ((DefaultMutableTreeNode)this.node.getParent()).getIndex(this.node) + 1);
            this.treeView.getTree().treeDidChange();
            if (!invRS.getBasisRule().getErrorMsg().equals("")) {
                String warnMsg = invRS.getBasisRule().getErrorMsg().replaceAll(";", "<br>");
                warnMsg = warnMsg.replaceAll("\n", "<br>");
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>During reverting the following occurred:<br><br><font color=\"#FF0000\">" + warnMsg + "</font>" + "<br>The new inverse rule sheme:  " + invRS.getName() + "<br>is added after its original rule scheme into the rule set.<br><br>", "Inverse Rule Scheme:  " + invRS.getName(), 2);
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Reverting was successful.<br><br>The new inverse rule scheme:  " + invRS.getName() + "<br>" + "is added after its original rule scheme into the rule set.<br><br>", "Inverse Rule Scheme:  " + invRS.getName(), 1);
            }
            this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this, 73, this.path));
        }
    }
}

