/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.AGGAppl;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.dialog.FormulaGraphGUI;
import agg.gui.treeview.dialog.RuleSignatureDialog;
import agg.gui.treeview.nodedata.ApplFormulaTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.xt_basis.NestedApplCond;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RulePopupMenu
extends JPopupMenu {
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    GraGraTreeNodeData data;
    EdRule rule;
    int posX;
    int posY;
    private JMenuItem miDelete;
    private JMenuItem miDisabled;
    private JMenuItem miAC;
    private JMenuItem miAC1;
    private JMenuItem miFormula;
    private JMenuItem miNAC;
    private JMenuItem miNAC1;
    private JMenuItem miPAC;
    private JMenuItem miParallelApply;
    private JMenuItem miAnimated;
    private JMenuItem miPostAC;
    private JMenuItem miPostACdel;
    private JMenuItem miLayer;
    private JMenuItem miPriority;
    private JMenuItem miCopy;
    private JMenuItem miInverse;
    private JMenuItem miMinimal;
    private JMenuItem miMakeRS;
    private JMenuItem miMove;
    private JMenuItem miWait;
    private JMenuItem miComment;
    private JMenuItem miAttrContext;
    private JMenuItem miSignature;
    boolean enableNestedAC;

    public RulePopupMenu(GraGraTreeView tree) {
        super("Rule");
        this.treeView = tree;
        this.miAC = new JMenuItem("New GAC (General Application Condition)");
        this.add(this.miAC);
        this.miAC.setActionCommand("newNestedAC");
        this.miAC.addActionListener(this.treeView.getActionAdapter());
        this.miAC1 = new JMenuItem("Make GAC due to RHS");
        this.add(this.miAC1);
        this.miAC1.setActionCommand("makeGACFromRHS");
        this.miAC1.addActionListener(this.treeView.getActionAdapter());
        this.miFormula = new JMenuItem("Set Formula above GACs");
        this.add(this.miFormula);
        this.miFormula.setActionCommand("setFormulaAboveACs");
        this.miFormula.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.setFormula();
            }
        });
        this.addSeparator();
        this.miNAC = this.add(new JMenuItem("New NAC                                 Shift+Alt+N"));
        this.miNAC.setActionCommand("newNAC");
        this.miNAC.addActionListener(this.treeView.getActionAdapter());
        this.miNAC1 = this.add(new JMenuItem("Make NAC due to RHS               "));
        this.miNAC1.setActionCommand("makeNACFromRHS");
        this.miNAC1.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miPAC = this.add(new JMenuItem("New PAC                                 "));
        this.miPAC.setActionCommand("newPAC");
        this.miPAC.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miPostAC = this.add(new JMenuItem("Create Post Conditions"));
        this.miPostAC.setActionCommand("convertAtomicsOfRule");
        this.miPostAC.addActionListener(this.treeView.getActionAdapter());
        this.miPostACdel = this.add(new JMenuItem("Delete Post Conditions"));
        this.miPostACdel.setActionCommand("deleteRuleConstraints");
        this.miPostACdel.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miLayer = this.add(new JMenuItem("Set Layer                                 Shift+Alt+L"));
        this.miLayer.setActionCommand("setRuleLayer");
        this.miLayer.addActionListener(this.treeView.getActionAdapter());
        this.miPriority = this.add(new JMenuItem("Set Priority                              Shift+Alt+P"));
        this.miPriority.setActionCommand("setRulePriority");
        this.miPriority.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miAttrContext = this.add(new JMenuItem("Attribute Context"));
        this.miAttrContext.setActionCommand("attrContext");
        this.miAttrContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AGGAppl)RulePopupMenu.this.treeView.getFrame()).getGraGraEditor().loadRuleAttrContextInEditor(RulePopupMenu.this.rule);
            }
        });
        this.miSignature = this.add(new JMenuItem("Signature"));
        this.miSignature.setActionCommand("ruleSignature");
        this.miSignature.setToolTipText(RuleSignatureDialog.getToolTipText());
        this.miSignature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RuleSignatureDialog(RulePopupMenu.this.treeView.getFrame(), new Point(200, 200), RulePopupMenu.this.rule).setVisible(true);
            }
        });
        this.addSeparator();
        this.miParallelApply = new JCheckBoxMenuItem("Parallel Matching");
        this.miParallelApply.setActionCommand("allowParallelApply");
        this.miParallelApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    RulePopupMenu.this.rule.getBasisRule().setParallelMatchingEnabled(true);
                } else {
                    RulePopupMenu.this.rule.getBasisRule().setParallelMatchingEnabled(false);
                }
            }
        });
        this.add(this.miParallelApply);
        this.addSeparator();
        this.miMove = this.add(new JMenuItem("Move"));
        this.miMove.setActionCommand("moveRule");
        this.miMove.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miCopy = this.add(new JMenuItem("Copy                                       Shift+Alt+D"));
        this.miCopy.setActionCommand("copyRule");
        this.miCopy.addActionListener(this.treeView.getActionAdapter());
        this.miInverse = this.add(new JMenuItem("Make Inverse Rule"));
        this.miInverse.setActionCommand("reverseRule");
        this.miInverse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.reverseRule();
            }
        });
        this.miMinimal = this.add(new JMenuItem("Make Minimal Rule"));
        this.miMinimal.setActionCommand("minimalRule");
        this.miMinimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.minimalRule();
            }
        });
        this.miMakeRS = this.add(new JMenuItem("Make Rule Scheme"));
        this.miMakeRS.setActionCommand("makeRuleScheme");
        this.miMakeRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.makeRuleScheme();
            }
        });
        this.addSeparator();
        this.miDelete = this.add(new JMenuItem("Delete                                              Delete"));
        this.miDelete.setActionCommand("deleteRule");
        this.miDelete.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.miDisabled = new JCheckBoxMenuItem("disabled");
        this.miDisabled.setActionCommand("disableRule");
        this.miDisabled.addActionListener(this.treeView.getActionAdapter());
        this.add(this.miDisabled);
        this.addSeparator();
        this.miAnimated = new JCheckBoxMenuItem("animated");
        this.miAnimated.setActionCommand("animatedRule");
        this.miAnimated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.rule.setAnimated(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.add(this.miAnimated);
        this.addSeparator();
        this.miWait = new JCheckBoxMenuItem("Wait Before Applying Rule");
        this.miWait.setActionCommand("waitBeforeApplyRule");
        this.miWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulePopupMenu.this.rule.getBasisRule().setWaitBeforeApplyEnabled(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        this.add(this.miWait);
        this.addSeparator();
        this.miComment = this.add(new JMenuItem("Textual Comments"));
        this.miComment.setActionCommand("commentRule");
        this.miComment.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        int pl;
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && (pl = this.treeView.getTree().getPathForLocation(x, y).getPath().length) == 3) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (GraGraTreeNodeData)this.node.getUserObject();
            this.rule = this.treeView.getRule((DefaultMutableTreeNode)this.path.getLastPathComponent());
            if (this.rule != null) {
                GrammarTreeNode.expand(this.treeView, this.node, this.path);
                this.posX = x;
                this.posY = y;
                this.setAllEnabled(true);
                this.miDisabled.setSelected(!this.rule.getBasisRule().isEnabled());
                this.miParallelApply.setSelected(this.rule.getBasisRule().isParallelApplyEnabled());
                this.miAnimated.setEnabled(this.rule.getTypeSet().getTypeGraph() != null && !this.rule.getTypeSet().getTypeGraph().getArcs().isEmpty());
                if (this.miAnimated.isEnabled()) {
                    this.miAnimated.setSelected(this.rule.isAnimated());
                }
                this.miWait.setSelected(this.rule.getBasisRule().isWaitBeforeApplyEnabled());
                return true;
            }
        }
        return false;
    }

    private void setAllEnabled(boolean b) {
        this.miDelete.setEnabled(b);
        this.miAC.setEnabled(b);
        this.miAC1.setEnabled(b);
        this.miFormula.setEnabled(b);
        this.miNAC.setEnabled(b);
        this.miNAC1.setEnabled(b);
        this.miPAC.setEnabled(b);
        this.miDisabled.setEnabled(b);
        this.miPostAC.setEnabled(b);
        this.miPostACdel.setEnabled(b);
        this.miLayer.setEnabled(b);
        this.miPriority.setEnabled(b);
        this.miCopy.setEnabled(b);
        this.miInverse.setEnabled(b);
        this.miMakeRS.setEnabled(b);
        this.miMove.setEnabled(b);
        this.miParallelApply.setEnabled(b);
        this.miAnimated.setEnabled(b);
        this.miWait.setEnabled(b);
    }

    void setFormula() {
        block2: {
            String f;
            boolean formulaChanged;
            String ownerName = "rule : " + this.rule.getBasisRule().getName();
            FormulaGraphGUI d = new FormulaGraphGUI(this.treeView.getFrame(), ownerName, " Graph editor of Formula above General Application Conditions ", " An empty graph is the case where all nodes are connected by AND.", true);
            d.setExportJPEG(this.treeView.getGraphicsExportJPEG());
            String oldformula = this.rule.getBasisRule().getFormulaStr();
            List<EdNestedApplCond> allNestedACs = this.rule.getEnabledACs();
            List<NestedApplCond> list = this.makeFrom(allNestedACs);
            d.setVarsAsObjs(allNestedACs, oldformula);
            d.setLocation(this.posX + 20, this.posY + 20);
            while (true) {
                d.setVisible(true);
                if (d.isCanceled()) break block2;
                formulaChanged = d.isChanged();
                f = d.getFormula();
                if (this.rule.getBasisRule().setFormula(f, list)) break;
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "The formula definition failed. Please correct.", " Formula failed ", 2);
            }
            f = this.rule.getBasisRule().getFormulaStr();
            if (formulaChanged) {
                this.insertFormulaIntoRuleTreeNode(f, allNestedACs);
                this.rule.getGraGra().setChanged(true);
            }
        }
    }

    private List<NestedApplCond> makeFrom(List<EdNestedApplCond> list) {
        Vector<NestedApplCond> result = new Vector<NestedApplCond>(list.size(), 0);
        int i = 0;
        while (i < list.size()) {
            result.add(list.get(i).getNestedMorphism());
            ++i;
        }
        return result;
    }

    void insertFormulaIntoRuleTreeNode(String f, List<EdNestedApplCond> allVarsObj) {
        Object child;
        if (f.length() > 0 && (child = this.treeView.getTreeModel().getChild(this.node, 0)) != null) {
            if (((GraGraTreeNodeData)((DefaultMutableTreeNode)child).getUserObject()).isApplFormula()) {
                this.treeView.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)child);
            }
            if (!"true".equals(f)) {
                ApplFormulaTreeNodeData conddata = new ApplFormulaTreeNodeData(f, true, this.rule);
                conddata.setString(f);
                DefaultMutableTreeNode condnode = new DefaultMutableTreeNode(conddata);
                conddata.setTreeNode(condnode);
                this.treeView.getTreeModel().insertNodeInto(condnode, this.node, 0);
            }
        }
    }

    public void enableNestedApplCond(boolean b) {
        this.enableNestedAC = b;
    }

    void reverseRule() {
        if (this.path == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s, "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = this.path.getParentPath();
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
        GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
        EdRule inverseRule = graData.getGraGra().reverseRule(data.getRule(), true);
        if (inverseRule != null) {
            this.treeView.putRuleIntoTree(inverseRule, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
            if (!inverseRule.getBasisRule().getErrorMsg().equals("")) {
                String warnMsg = inverseRule.getBasisRule().getErrorMsg().replaceAll(";", "<br>");
                warnMsg = warnMsg.replaceAll("\n", "<br>");
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>During reverting the following occurred:<br><br><font color=\"#FF0000\">" + warnMsg + "</font>" + "<br>The new inverse rule:  " + inverseRule.getName() + "<br>is added after its original rule into the rule set.<br><br>", "Inverse Rule:  " + inverseRule.getName(), 2);
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Inverting was successful.<br><br>The new inverse rule:  " + inverseRule.getName() + "<br>" + "is added after its original rule into the rule set.<br><br>", "Inverse Rule:  " + inverseRule.getName(), 1);
            }
        } else {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It isn't possible to invert the rule:<br>    " + data.getRule().getName() + ".", "Inverse Rule", 0);
        }
    }

    void minimalRule() {
        if (this.path == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s, "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = this.path.getParentPath();
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
        GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
        EdRule minRule = graData.getGraGra().makeMinimalRule(data.getRule(), true);
        if (minRule != null) {
            this.treeView.putRuleIntoTree(minRule, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
            if (minRule.getBasisRule().getErrorMsg().indexOf("identical") >= 0) {
                String warnMsg = minRule.getBasisRule().getErrorMsg();
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>" + warnMsg + "<br>" + "It is added after its original rule into the rule set.<br><br>", "Minimal Rule :  " + minRule.getName(), 2);
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The minimal rule is added after its original rule.<br><br>", "Minimal Rule :  " + minRule.getName(), 1);
            }
        } else {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It isn't possible to make a minimal rule from:<br>    " + data.getRule().getName() + "." + "<br>", "Minimal Rule Failed", 0);
        }
    }

    void makeRuleScheme() {
        if (this.path == null) {
            String s = "Bad selection.\n Please select a rule.";
            JOptionPane.showMessageDialog(null, s, "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        TreePath graPath = this.path.getParentPath();
        DefaultMutableTreeNode graNode = (DefaultMutableTreeNode)graPath.getLastPathComponent();
        GraGraTreeNodeData graData = (GraGraTreeNodeData)graNode.getUserObject();
        EdRuleScheme rs = graData.getGraGra().createRuleScheme(data.getRule());
        if (rs != null) {
            this.treeView.putRuleSchemeIntoTree(rs, (DefaultMutableTreeNode)node.getParent(), ((DefaultMutableTreeNode)node.getParent()).getIndex(node) + 1);
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The new rule scheme:  " + rs.getName() + "<br>" + "is added after its original rule into the rule set.<br><br>", "Rule Scheme:  " + rs.getName(), 1);
        } else {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It isn't possible to invert the rule:<br>    " + data.getRule().getName() + ".", "Inverse Rule", 0);
        }
    }
}

