/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.attribute.impl.AttrTupleManager;
import agg.gui.editor.GraGraEditor;
import agg.gui.event.EditEvent;
import agg.gui.icons.TextIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;

public class GraGraEditorActionAdapter
implements ActionListener {
    private GraGraEditor editor;

    public GraGraEditorActionAdapter(GraGraEditor gragraeditor) {
        this.editor = gragraeditor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (!((JButton)e.getSource()).isEnabled()) {
                return;
            }
            JButton b = (JButton)e.getSource();
            if (b.equals(this.editor.getTransformationKindButton())) {
                if (((TextIcon)b.getIcon()).getText().equals("NT")) {
                    ((TextIcon)b.getIcon()).setText("LT");
                    this.editor.getGraGraTransform().getOptionGUI().doClick("layered");
                } else if (((TextIcon)b.getIcon()).getText().equals("LT")) {
                    ((TextIcon)b.getIcon()).setText("PT");
                    this.editor.getGraGraTransform().getOptionGUI().doClick("priority");
                } else if (((TextIcon)b.getIcon()).getText().equals("PT")) {
                    ((TextIcon)b.getIcon()).setText("ST");
                    this.editor.getGraGraTransform().getOptionGUI().doClick("ruleSequence");
                    this.editor.fireEditEvent(new EditEvent((Object)this, -15, ""));
                } else if (((TextIcon)b.getIcon()).getText().equals("ST")) {
                    ((TextIcon)b.getIcon()).setText("NT");
                    this.editor.fireEditEvent(new EditEvent((Object)this, -16, ""));
                    this.editor.getGraGraTransform().getOptionGUI().doClick("nondeterministically");
                }
            } else if (b.equals(this.editor.getUndoButton()) && this.editor.getUndoManager() != null && this.editor.getUndoManager().isEnabled()) {
                if (!this.editor.getUndoManager().canUndo()) {
                    this.editor.getUndoButton().setEnabled(false);
                    this.editor.setUndoStepButtonEnabled(false);
                }
                if (this.editor.getUndoManager().canRedo()) {
                    this.editor.getRedoButton().setEnabled(true);
                }
            } else if (b.equals(this.editor.getUndoStepButton()) && this.editor.getUndoManager() != null && this.editor.getUndoManager().isEnabled()) {
                if (!this.editor.getUndoManager().canUndo()) {
                    this.editor.getUndoButton().setEnabled(false);
                    this.editor.setUndoStepButtonEnabled(false);
                }
            } else if (b.equals(this.editor.getRedoButton()) && this.editor.getUndoManager() != null && this.editor.getUndoManager().isEnabled() && !this.editor.getUndoManager().canRedo()) {
                this.editor.getRedoButton().setEnabled(false);
            }
        } else if (e.getSource() instanceof JCheckBoxMenuItem) {
            String actionCommand = ((JCheckBoxMenuItem)e.getSource()).getActionCommand();
            if (actionCommand.equals("nonparallelArcs") && this.editor.getGraGra() != null) {
                this.editor.getGraGra().getBasisGraGra().getTypeSet().setArcParallel(!((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
            if (actionCommand.equals("typesOnTop")) {
                this.editor.setTypesAlwaysOn(((JCheckBoxMenuItem)e.getSource()).isSelected());
            } else if (actionCommand.equals("showAttributesOfRule")) {
                this.editor.getRuleEditor().setAttributeVisible(((JCheckBoxMenuItem)e.getSource()).isSelected());
            } else if (actionCommand.equals("showAttributesOfGraph")) {
                this.editor.getGraphEditor().setGraphAttributeVisible(((JCheckBoxMenuItem)e.getSource()).isSelected());
            } else if (actionCommand.equals("showAttributesOfTypeGraph")) {
                this.editor.getGraphEditor().setTypeGraphAttributeVisible(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        } else if (e.getSource() instanceof JMenuItem) {
            if (!((JMenuItem)e.getSource()).isEnabled()) {
                return;
            }
        } else if (e.getSource() instanceof JRadioButton) {
            if (((JRadioButton)e.getSource()).getActionCommand().equals("nondeterministically")) {
                this.editor.resetTransformationKindIcon(this.editor.getGraGraTransform().nondeterministicallyEnabled(), "NT");
            } else if (((JRadioButton)e.getSource()).getActionCommand().equals("layered")) {
                this.editor.resetTransformationKindIcon(this.editor.getGraGraTransform().layeredEnabled(), "LT");
            } else if (((JRadioButton)e.getSource()).getActionCommand().equals("priority")) {
                this.editor.resetTransformationKindIcon(this.editor.getGraGraTransform().priorityEnabled(), "PT");
            } else if (((JRadioButton)e.getSource()).getActionCommand().equals("ruleSequence")) {
                this.editor.resetTransformationKindIcon(this.editor.getGraGraTransform().ruleSequenceEnabled(), "ST");
            }
        } else if (e.getSource() instanceof JCheckBox) {
            if (((JCheckBox)e.getSource()).getActionCommand().equals("waitAfterStep")) {
                this.editor.setSleep(this.editor.getGraGraTransform().waitAfterStepEnabled());
            }
            return;
        }
        String command = e.getActionCommand();
        if (command.equals("attributes")) {
            this.editor.attrsProc();
        } else if (command.equals("delete")) {
            this.editor.deleteProc();
        } else if (command.equals("copy")) {
            this.editor.copyProc();
        } else if (command.equals("paste")) {
            this.editor.pasteProc();
        } else if (command.equals("selectAll")) {
            this.editor.selectAllProc();
        } else if (command.equals("selectNodeType")) {
            this.editor.selectNodeTypeProc();
        } else if (command.equals("selectArcType")) {
            this.editor.selectArcTypeProc();
        } else if (command.equals("deselectAll")) {
            this.editor.deselectAllProc();
        } else if (command.equals("straighten")) {
            this.editor.doStraightenArcsProc();
        } else if (command.equals("identicRule")) {
            this.editor.doIdenticRule();
        } else if (command.equals("identicNAC")) {
            this.editor.doIdenticNAC();
        } else if (command.equals("identicPAC")) {
            this.editor.doIdenticPAC();
        } else if (command.equals("identicAC")) {
            this.editor.doIdenticGAC();
        } else if (command.equals("makeNACFromRHS")) {
            this.editor.doNACDuetoRHS();
        } else if (command.equals("makeGACFromRHS")) {
            this.editor.doGACDuetoRHS();
        } else if (command.equals("bold") || command.equals("italic") || command.equals("plain") || command.equals("LARGE") || command.equals("large") || command.equals("small") || command.equals("tiny") || command.equals("0.2") || command.equals("0.3") || command.equals("0.5") || command.equals("0.7") || command.equals("1.0") || command.equals("1.5") || command.equals("2.0") || command.equals("typesON")) {
            this.editor.doPreferencesProc(command);
        } else if (command.equals("scaleGraphOnly")) {
            if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.setScalingGraphOnly(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        } else if (command.equals("drawMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Draw");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(11);
        } else if (command.equals("selectMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Select");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(12);
        } else if (command.equals("moveMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Move");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(13);
        } else if (command.equals("attributesMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Attributes");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(114);
        } else if (command.equals("mapMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Map");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(115);
        } else if (command.equals("unmapMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Unmap");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
            }
            this.editor.setEditMode(116);
        } else if (command.equals("imageMode")) {
            if (e.getSource() instanceof JButton) {
                this.editor.forwardModeCommand("Image_view");
            } else if (e.getSource() instanceof JCheckBoxMenuItem) {
                this.editor.forwardModeCommand((JCheckBoxMenuItem)e.getSource());
                this.editor.setNodeIconable(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        } else if (command.equals("start")) {
            if (this.editor.getGraGra() == null || !this.editor.isEditable() || !this.editor.isGraGraReadyToTransform(this.editor.getGraGra()) || this.editor.isTransformationRunning()) {
                return;
            }
            this.editor.resetStepCounter();
            if (this.editor.getEditMode() == 114) {
                this.editor.setEditMode(13);
                this.editor.forwardModeCommand("Move");
            }
            this.editor.getTypeEditor().setEnabled(false);
            this.editor.splitPane1.setDividerLocation(this.editor.splitPane1.getWidth());
            this.editor.selectToolBarTransformItem("start");
            if (e.getSource() instanceof JButton) {
                this.editor.resetTransformMenu("Start");
            } else if (e.getSource() instanceof JMenuItem) {
                this.editor.resetTransformMenu((JMenuItem)e.getSource());
            }
            this.editor.resetEditModeAfterMapping(this.editor.getLastEditMode());
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            this.editor.enableStopButton(true);
            this.editor.getGraGra().destroyAllMatches();
            this.editor.getGraphEditor().getGraph().adjustTypeObjectsMap();
            if (this.editor.getGraphLayouter().isEnabled()) {
                this.editor.doPrepareLayouterProc();
            } else {
                this.editor.doPrepareDefaultGraphLayout();
            }
            this.editor.getGraGra().getGraph().setTransformChangeEnabled(true);
            if (this.editor.getUndoManager() != null && this.editor.getUndoManager().isEnabled()) {
                this.editor.getUndoManager().setUndoEndOfTransformStep();
            }
            if (this.editor.getGraGraTransform().layeredEnabled()) {
                if (!this.editor.isLayeredTransformationRunning()) {
                    this.editor.doPrepareTransformProc();
                    this.editor.startLayeredTransform();
                } else if (!this.editor.isSleeping()) {
                    this.editor.fireEditEvent(new EditEvent((Object)this, -1, " Please wait. Transformation is running ... "));
                }
            } else if (this.editor.getGraGraTransform().ruleSequenceEnabled()) {
                if (!this.editor.isRuleSequencesTransformationRunning()) {
                    this.editor.doPrepareTransformProc();
                    this.editor.startRuleSequenceTransform();
                } else if (!this.editor.isSleeping()) {
                    this.editor.fireEditEvent(new EditEvent((Object)this, -1, " Please wait. Transformation is running ... "));
                }
            } else if (!this.editor.isDefaultTransformationRunning()) {
                this.editor.doPrepareTransformProc();
                this.editor.startInterpreterTransform();
            } else if (!this.editor.isSleeping()) {
                this.editor.fireEditEvent(new EditEvent((Object)this, -1, " Please wait. Transformation is running ... "));
            }
        } else if (command.equals("stop")) {
            if (this.editor.getGraGra() != null && this.editor.getGraGra().getGraph() != null) {
                if (!this.editor.getGraGra().getGraph().isEditable()) {
                    return;
                }
                if (this.editor.isAnimationRunning()) {
                    this.editor.getNodeAnimation().setStop();
                }
                if (this.editor.isLayeredTransformationRunning()) {
                    this.editor.selectToolBarTransformItem("stop");
                    if (this.editor.getGraGraTransform().breakAllLayerEnabled()) {
                        if (e.getSource() instanceof JButton) {
                            this.editor.resetTransformMenu("Stop");
                        } else if (e.getSource() instanceof JMenuItem) {
                            this.editor.resetTransformMenu((JMenuItem)e.getSource());
                        }
                    }
                    this.editor.doStopTransformLayeredProc();
                } else if (this.editor.isDefaultTransformationRunning()) {
                    this.editor.selectToolBarTransformItem("stop");
                    if (e.getSource() instanceof JButton) {
                        this.editor.resetTransformMenu("Stop");
                    } else if (e.getSource() instanceof JMenuItem) {
                        this.editor.resetTransformMenu((JMenuItem)e.getSource());
                    }
                    this.editor.doStopTransformInterpreterProc();
                } else if (this.editor.isRuleSequencesTransformationRunning()) {
                    this.editor.selectToolBarTransformItem("stop");
                    if (e.getSource() instanceof JButton) {
                        this.editor.resetTransformMenu("Stop");
                    } else if (e.getSource() instanceof JMenuItem) {
                        this.editor.resetTransformMenu((JMenuItem)e.getSource());
                    }
                    this.editor.doStopTransformRuleSequencesProc();
                }
            }
        } else if (command.equals("match")) {
            this.editor.doPrepareInteractiveMatchProc();
        } else if (command.equals("completion")) {
            this.editor.doPrepareCompletionMatchProc();
        } else if (command.equals("step")) {
            if (this.editor.getEditMode() == 114) {
                this.editor.setEditMode(13);
                this.editor.forwardModeCommand("Move");
            }
            this.editor.doExecuteStepProc();
        } else if (command.equals("options")) {
            this.editor.showOptionGUI();
        } else if (command.equals("undoStep")) {
            this.editor.undoTransformStep();
        } else if (command.equals("undo")) {
            this.editor.undoEdit();
        } else if (command.equals("redo")) {
            this.editor.redoEdit();
        } else if (command.equals("discardAllEdits")) {
            this.editor.discardAllEdits();
        } else if (command.equals("graphlayout")) {
            this.editor.doGraphLayout();
        } else if (command.equals("Default ( Spring based )") || command.equals("Spring") || command.equals("Tree (vertical)") || command.equals("Tree (horizontal)") || command.equals("Radial") || command.equals("Grid") || command.equals("Vertical") || command.equals("Horizontal")) {
            this.editor.setGraphLayoutAlgorithmName(((JMenuItem)e.getSource()).getText());
        }
    }
}

