/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.animation;

import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdType;
import agg.xt_basis.Arc;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.Graphics2D;
import java.awt.Point;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class NodeAnimation {
    public static final int JUMP = 11;
    public static final int WORM = 20;
    public static final int CROSS = 30;
    public static final int COMBI_CROSS = 31;
    private ImageIcon image;
    protected String imageFileName = "";
    private final Hashtable<EdType, ImageIcon> type2icon = new Hashtable();
    private final Hashtable<String, ImageIcon> name2icon = new Hashtable();
    protected int kind;
    protected boolean stop;
    protected int x1;
    protected int y1;
    protected int x2;
    protected int y2;
    protected int plus;
    protected EdNode nG;
    protected EdNode n1G;
    private int step;
    private int delay;
    protected EdRule r;
    protected EdGraph g;
    protected Hashtable<EdNode, Point> node2position = new Hashtable();
    protected Graphics2D grs;
    protected boolean needGraphicsToMove;
    protected boolean left;
    protected boolean right;
    protected boolean top;
    protected boolean down;
    protected int dx;
    protected int dy;
    private boolean ddone;

    public void dispose() {
        this.type2icon.clear();
        this.name2icon.clear();
        this.r = null;
        this.g = null;
        this.grs = null;
    }

    public static Vector<String> getAnimationKindsAsString() {
        Vector<String> vec = new Vector<String>();
        vec.add("JUMP");
        vec.add("WORM");
        vec.add("CROSS");
        vec.add("COMBI_CROSS");
        return vec;
    }

    public boolean prepareAnimation(EdRule rule, EdGraph graph, Graphics2D graphics, int animation) {
        this.r = rule;
        this.g = graph;
        this.grs = graphics;
        this.kind = animation;
        if (this.kind == 11) {
            this.setAnimationData();
            this.setAnimationDataOfCreation();
        } else if (this.kind == 30) {
            this.setAnimationDataOfSpan();
        } else if (this.kind == 31) {
            this.setAnimationDataOfCombiSpan();
        } else {
            this.setAnimationData();
        }
        return true;
    }

    public boolean prepareAnimation(EdRule rule, EdGraph graph, Graphics2D graphics) {
        this.r = rule;
        this.g = graph;
        this.grs = graphics;
        this.kind = this.r.getAnimationKind();
        if (this.kind == 11) {
            this.setAnimationData();
            this.setAnimationDataOfCreation();
        } else if (this.kind == 30) {
            this.setAnimationDataOfSpan();
        } else if (this.kind == 31) {
            this.setAnimationDataOfCombiSpan();
        } else {
            this.setAnimationData();
        }
        return true;
    }

    public void animate() {
        this.enableNodeAnimation();
        Enumeration<EdNode> keys = this.node2position.keys();
        while (keys.hasMoreElements()) {
            EdNode n = keys.nextElement();
            Point p = this.node2position.get(n);
            n.setX(p.x);
            n.setY(p.y);
            n.getLNode().setFrozen(true);
        }
        this.node2position.clear();
    }

    private void setAnimationData() {
        Match m = this.r.getMatch();
        if (m != null) {
            this.nG = null;
            this.n1G = null;
            Vector<GraphObject> dom = m.getDomainObjects();
            int i = 0;
            while (i < dom.size() && !this.stop) {
                EdNode nL;
                GraphObject oL = (GraphObject)dom.get(i);
                if (oL.isNode() && (nL = this.r.getLeft().findNode(oL)) != null && nL.getType().isAnimated()) {
                    Enumeration<GraphObject> inv;
                    EdNode n1R;
                    Arc arcR = null;
                    Iterator<Arc> outsL = ((Node)oL).getOutgoingArcs();
                    while (outsL.hasNext() && arcR == null) {
                        GraphObject oR;
                        Arc outL = outsL.next();
                        if (this.r.getBasisRule().getImage(outL) != null || (oR = this.r.getBasisRule().getImage(oL)) == null) continue;
                        Arc outR = null;
                        arcR = this.getTargetEdgeOfAnimation(((Node)oR).getOutgoingArcs(), nL.getType().animationParameter.targetEdgeTypeName);
                        if (arcR != null) continue;
                        Iterator<Arc> outsR = ((Node)oR).getOutgoingArcs();
                        while (outsR.hasNext()) {
                            outR = outsR.next();
                            if (this.r.getBasisRule().getInverseImage(outR).hasMoreElements()) continue;
                            arcR = outR;
                            break;
                        }
                        if (arcR != null || outR == null) continue;
                        arcR = outR;
                    }
                    if (arcR != null && (n1R = this.r.getRight().findNode(arcR.getTarget())) != null && (inv = this.r.getBasisRule().getInverseImage(n1R.getBasisObject())).hasMoreElements()) {
                        this.n1G = this.g.findNode(m.getImage(inv.nextElement()));
                        this.nG = this.g.findNode(m.getImage(oL));
                        this.setStartPosition(this.nG.getX(), this.nG.getY());
                        this.setEndPosition(this.n1G.getX(), this.n1G.getY());
                        this.setStep(this.nG.getType().animationParameter.step);
                        this.setDelay(this.nG.getType().animationParameter.delay);
                        this.setEndPlus(this.nG.getType().animationParameter.plus);
                        this.imageFileName = this.nG.getType().imageFileName;
                        this.node2position.put(this.nG, new Point(this.applyPlusToPosition(this.n1G.getX(), this.plus), this.applyPlusToPosition(this.n1G.getY(), this.plus)));
                    }
                }
                ++i;
            }
        }
    }

    private void correctAdjacentEdgesText(EdNode nG) {
        Vector<EdArc> arcs = nG.getContext().getOutgoingArcs(nG);
        for (EdArc a : arcs) {
            a.refreshTextLocation();
        }
        arcs = nG.getContext().getIncomingArcs(nG);
        for (EdArc a : arcs) {
            a.refreshTextLocation();
        }
    }

    private Arc getTargetEdgeOfAnimation(Iterator<Arc> outArcs, String targetEdgeTypeName) {
        if (targetEdgeTypeName == null) {
            return null;
        }
        String tname = "[unnamed]".equals(targetEdgeTypeName) ? "" : targetEdgeTypeName;
        while (outArcs.hasNext()) {
            Arc a = outArcs.next();
            if (!a.getType().getName().equals(tname)) continue;
            return a;
        }
        return null;
    }

    private void setAnimationDataOfSpan() {
        OrdinaryMorphism com;
        Match m = this.r.getMatch();
        if (m != null && (com = m.getCoMorphism()) != null) {
            this.nG = null;
            this.n1G = null;
            Point lastpoint = null;
            int p = 0;
            Enumeration<GraphObject> dom = com.getDomain();
            block0: while (dom.hasMoreElements() && !this.stop) {
                EdNode nR;
                GraphObject oR = dom.nextElement();
                if (!oR.isNode() || this.r.getBasisRule().getInverseImage(oR).hasMoreElements() || (nR = this.r.getRight().findNode(oR)) == null || !nR.getType().isAnimated()) continue;
                GraphObject oG = com.getImage(oR);
                this.nG = this.g.findNode(oG);
                Iterator<Arc> neighbours = this.nG.getBasisNode().getOutgoingArcs();
                while (neighbours.hasNext()) {
                    Point point;
                    Arc neighbour = neighbours.next();
                    if (neighbour.getSource() == neighbour.getTarget() || (point = this.computeCross(neighbour)) == null) continue;
                    this.setEndPosition(point.x, point.y);
                    this.setStep(this.nG.getType().animationParameter.step);
                    this.setDelay(this.nG.getType().animationParameter.delay);
                    this.setEndPlus(this.nG.getType().animationParameter.plus);
                    this.imageFileName = this.nG.getType().imageFileName;
                    if (lastpoint == null) {
                        lastpoint = point;
                        ++p;
                    } else if (Math.abs(lastpoint.x - point.x) < 5 && Math.abs(lastpoint.y - point.y) < 5) {
                        point = this.computeSimilarPosition(point, p * this.dx / 2, p * this.dy / 2, p);
                        ++p;
                    }
                    this.node2position.put(this.nG, new Point(this.applyPlusToPosition(point.x, this.plus), this.applyPlusToPosition(point.y, this.plus)));
                    continue block0;
                }
            }
        }
    }

    private void setAnimationDataOfCombiSpan() {
        OrdinaryMorphism com;
        Match m = this.r.getMatch();
        if (m != null && (com = m.getCoMorphism()) != null) {
            this.nG = null;
            this.n1G = null;
            Point lastpoint = null;
            int p = 0;
            Enumeration<GraphObject> dom = com.getDomain();
            while (dom.hasMoreElements() && !this.stop) {
                Point point;
                Point point2;
                GraphObject nbNode;
                EdNode nR;
                GraphObject oR = dom.nextElement();
                if (!oR.isNode() || this.r.getBasisRule().getInverseImage(oR).hasMoreElements() || (nR = this.r.getRight().findNode(oR)) == null || !nR.getType().isAnimated()) continue;
                GraphObject oG = com.getImage(oR);
                this.nG = this.g.findNode(oG);
                int count = this.nG.getBasisNode().getOutgoingArcsSet().size();
                Iterator<Arc> neighbours = this.nG.getBasisNode().getOutgoingArcs();
                Arc neighbour = null;
                if (count == 1 && com.getInverseImage(nbNode = (neighbour = neighbours.next()).getTarget()).hasMoreElements() && m.getInverseImage(nbNode).hasMoreElements() && (point2 = this.computeCross(neighbour)) != null) {
                    this.setEndPosition(point2.x, point2.y);
                    this.setStep(this.nG.getType().animationParameter.step);
                    this.setDelay(this.nG.getType().animationParameter.delay);
                    this.setEndPlus(this.nG.getType().animationParameter.plus);
                    this.imageFileName = this.nG.getType().imageFileName;
                    this.node2position.put(this.nG, new Point(this.applyPlusToPosition(point2.x, this.plus), this.applyPlusToPosition(point2.y, this.plus)));
                }
                if (count == 2) {
                    while (neighbours.hasNext()) {
                        neighbour = neighbours.next();
                        nbNode = neighbour.getTarget();
                        if (com.getInverseImage(nbNode).hasMoreElements() && m.getInverseImage(nbNode).hasMoreElements()) break;
                    }
                    if ((point = this.computeCross(neighbour)) == null) continue;
                    this.setEndPosition(point.x, point.y);
                    this.setStep(this.nG.getType().animationParameter.step);
                    this.setDelay(this.nG.getType().animationParameter.delay);
                    this.setEndPlus(this.nG.getType().animationParameter.plus);
                    this.imageFileName = this.nG.getType().imageFileName;
                    this.node2position.put(this.nG, new Point(this.applyPlusToPosition(point.x, this.plus), this.applyPlusToPosition(point.y, this.plus)));
                    continue;
                }
                if (count != 3) continue;
                while (neighbours.hasNext()) {
                    neighbour = neighbours.next();
                    nbNode = neighbour.getTarget();
                    if (com.getInverseImage(nbNode).hasMoreElements() && m.getInverseImage(nbNode).hasMoreElements()) break;
                }
                if ((point = this.computeCross(neighbour)) == null) continue;
                this.setEndPosition(point.x, point.y);
                this.setStep(this.nG.getType().animationParameter.step);
                this.setDelay(this.nG.getType().animationParameter.delay);
                this.setEndPlus(this.nG.getType().animationParameter.plus);
                this.imageFileName = this.nG.getType().imageFileName;
                if (lastpoint == null) {
                    lastpoint = point;
                    ++p;
                } else if (Math.abs(lastpoint.x - point.x) < 5 && Math.abs(lastpoint.y - point.y) < 5) {
                    point = this.computeSimilarPosition(point, p * this.dx / 2, p * this.dy / 2, p);
                    ++p;
                }
                this.node2position.put(this.nG, new Point(this.applyPlusToPosition(point.x, this.plus), this.applyPlusToPosition(point.y, this.plus)));
            }
        }
    }

    private void setAnimationDataOfCreation() {
        OrdinaryMorphism com;
        Match m = this.r.getMatch();
        if (m != null && (com = m.getCoMorphism()) != null) {
            this.nG = null;
            this.n1G = null;
            Enumeration<GraphObject> dom = com.getDomain();
            while (dom.hasMoreElements() && !this.stop) {
                Arc out1;
                EdNode nR;
                GraphObject oR = dom.nextElement();
                if (!oR.isNode() || this.r.getBasisRule().getInverseImage(oR).hasMoreElements() || (nR = this.r.getRight().findNode(oR)) == null || !nR.getType().isAnimated()) continue;
                GraphObject oG = com.getImage(oR);
                this.nG = this.g.findNode(oG);
                Iterator<Arc> outs = this.nG.getBasisNode().getOutgoingArcs();
                int outsSize = this.nG.getBasisNode().getOutgoingArcsSet().size();
                if (outsSize < 1) continue;
                Arc out = outs.next();
                if (outsSize > 1 && (out1 = this.getTargetEdgeOfAnimation(this.nG.getBasisNode().getOutgoingArcs(), this.nG.getType().animationParameter.targetEdgeTypeName)) != null) {
                    out = out1;
                }
                this.n1G = this.g.findNode(out.getTarget());
                if (this.n1G == null) continue;
                this.setStartPosition(this.n1G.getX(), this.n1G.getY());
                this.setEndPosition(this.n1G.getX(), this.n1G.getY());
                this.setStep(this.nG.getType().animationParameter.step);
                this.setDelay(this.nG.getType().animationParameter.delay);
                this.setEndPlus(this.nG.getType().animationParameter.plus);
                this.imageFileName = this.nG.getType().imageFileName;
                this.node2position.put(this.nG, new Point(this.applyPlusToPosition(this.n1G.getX(), this.plus), this.applyPlusToPosition(this.n1G.getY(), this.plus)));
            }
        }
    }

    private void cross() {
        if (this.image != null) {
            this.grs.drawImage(this.image.getImage(), this.x2, this.y2, null);
        }
        this.delay();
    }

    private Point computeCross(Arc outgoingArc) {
        if (outgoingArc != null) {
            Node oG = (Node)outgoingArc.getTarget();
            this.n1G = this.g.findNode(oG);
            Vector<EdNode> neighbours = new Vector<EdNode>();
            for (Arc outarc : oG.getOutgoingArcsSet()) {
                EdNode n;
                if (outarc.getSource() == outarc.getTarget() || (n = this.g.findNode(outarc.getTarget())) == null || n == this.nG) continue;
                neighbours.add(n);
            }
            this.setStartPosition(this.n1G.getX(), this.n1G.getY());
            Point point = this.computeCrossPart4(neighbours);
            return point;
        }
        return null;
    }

    private Point computeCrossPart4(Vector<EdNode> neighbours) {
        if (neighbours.size() >= 3) {
            int x0 = this.n1G.getX();
            int y0 = this.n1G.getY();
            if (!this.ddone) {
                int i = 0;
                while (i < 3) {
                    EdNode n = neighbours.get(i);
                    int xi = n.getX();
                    int yi = n.getY();
                    this.dx = Math.abs(x0 - xi) > this.dx ? Math.abs(x0 - xi) : this.dx;
                    this.dy = Math.abs(y0 - yi) > this.dy ? Math.abs(y0 - yi) : this.dy;
                    this.ddone = true;
                    ++i;
                }
            }
            this.left = false;
            this.right = false;
            this.top = false;
            this.down = false;
            int hdx = this.dx / 2;
            int hdy = this.dy / 2;
            int i = 0;
            while (i < 3) {
                EdNode n = neighbours.get(i);
                int xi = n.getX();
                int yi = n.getY();
                if (xi + hdx < x0 && !this.left) {
                    this.left = true;
                } else if (xi - hdx > x0 && !this.right) {
                    this.right = true;
                } else if (yi + hdy < y0 && !this.top) {
                    this.top = true;
                } else if (yi - hdy > y0 && !this.down) {
                    this.down = true;
                }
                ++i;
            }
            Point pos = this.computePosition(new Point(x0, y0), this.dx, this.dy);
            return pos;
        }
        return null;
    }

    private Point computePosition(Point pos0, int distx, int disty) {
        Point pos = new Point(0, 0);
        if (!this.left && !this.down) {
            pos.x = pos0.x;
            pos.y = pos0.y + disty;
        } else if (!this.left) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y;
        } else if (!this.right && !this.top) {
            pos.x = pos0.x;
            pos.y = pos0.y - disty;
        } else if (!this.right && !this.down) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y;
        } else if (!this.right) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y;
        }
        if (!this.left && !this.top) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y;
        } else if (!this.top) {
            pos.y = pos0.y - disty;
            pos.x = pos0.x;
        } else if (!this.right && !this.down) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y;
        } else if (!this.down) {
            pos.y = pos0.y + disty;
            pos.x = pos0.x;
        }
        return pos;
    }

    private Point computeSimilarPosition(Point pos0, int distx, int disty, int p) {
        Point pos = new Point(0, 0);
        if (!this.left && !this.down) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y - disty;
            if (p == 1) {
                pos.x -= distx / 2;
                pos.y += disty / 2;
            }
        } else if (!this.left && !this.top) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y - disty;
            if (p == 1) {
                pos.x -= distx / 2;
                pos.y -= disty / 2;
            }
        } else if (!this.right && !this.top) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y + disty;
            if (p == 1) {
                pos.x += distx / 2;
                pos.y -= disty / 2;
            }
        } else if (!this.right && !this.down) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y + disty;
            if (p == 1) {
                pos.x += distx / 2;
                pos.y += disty / 2;
            }
        } else if (!this.left) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y - disty;
        } else if (!this.right) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y + disty;
        } else if (!this.top) {
            pos.x = pos0.x + distx;
            pos.y = pos0.y + disty;
        } else if (!this.down) {
            pos.x = pos0.x - distx;
            pos.y = pos0.y + disty;
        }
        return pos;
    }

    public void setStop() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    public void setAnimationKind(int animKind) {
        this.kind = animKind;
    }

    public void setStartPosition(int startX, int startY) {
        this.x1 = startX;
        this.y1 = startY;
    }

    public void setEndPosition(int endX, int endY) {
        this.x2 = endX;
        this.y2 = endY;
    }

    public void setEndPlus(int d) {
        this.plus = d;
    }

    public void setStep(int s) {
        this.step = s;
    }

    public void setDelay(int ms) {
        this.delay = ms;
    }

    protected void enableNodeAnimation() {
        this.image = this.name2icon.get(this.imageFileName);
        if (this.image == null && this.kind != 30 && this.kind != 31) {
            this.getAnimationImageOfNode();
        }
        this.nodeAnimation();
    }

    public void enableNodeAnimation(Graphics2D graphics, String imageName, int animation, int startX, int startY, int endX, int endY, int s, int ms) {
        this.grs = graphics;
        this.imageFileName = imageName;
        this.kind = animation;
        this.x1 = startX;
        this.y1 = startY;
        this.x2 = endX;
        this.y2 = endY;
        this.step = s;
        this.delay = ms;
        this.image = this.name2icon.get(this.imageFileName);
        if (this.image == null) {
            this.getAnimationImageOfNode();
        }
        this.nodeAnimation();
    }

    private void getAnimationImageOfNode() {
        URL url = null;
        if (!this.imageFileName.equals("")) {
            url = ClassLoader.getSystemClassLoader().getResource(this.imageFileName);
        }
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/smile.png");
        }
        if (url != null) {
            this.image = new ImageIcon(url);
            this.name2icon.put(this.imageFileName, this.image);
        }
    }

    private void nodeAnimation() {
        switch (this.kind) {
            case 11: {
                this.jump();
                break;
            }
            case 20: {
                this.worm();
                break;
            }
            case 30: {
                this.cross();
                break;
            }
            case 31: {
                this.cross();
            }
        }
        this.stop = false;
    }

    private void jump() {
        this.delay();
    }

    private void worm() {
        Vector<Integer> data;
        if (this.image != null && !(data = this.computeWormLengthAndStep()).isEmpty()) {
            int l = data.get(0);
            int sX = data.get(1);
            int sY = data.get(2);
            int nX = this.x1 + sX;
            int nY = this.y1 + sY;
            this.grs.drawImage(this.image.getImage(), nX, nY, null);
            int s = 0;
            while (s < l && !this.stop) {
                this.delay();
                this.grs.drawImage(this.image.getImage(), nX += sX, nY += sY, null);
                s += this.step;
            }
        }
    }

    private Vector<Integer> computeWormLengthAndStep() {
        Vector<Integer> result = new Vector<Integer>(3);
        boolean hasResult = false;
        int dX = this.x2 - this.x1;
        int dY = this.y2 - this.y1;
        int lX = Math.abs(dX);
        int lY = Math.abs(dY);
        int l = lX;
        int sX = this.step;
        int sY = this.step;
        if (dX != 0 && dY != 0) {
            if (dX > 0) {
                if (lX > lY) {
                    sX = this.step;
                    sY = dY * sX / dX;
                } else {
                    sY = dY > 0 ? this.step : -this.step;
                    sX = dX * sY / dY;
                    l = lY;
                }
            } else if (lX > lY) {
                sX = -this.step;
                sY = dY * sX / dX;
            } else {
                sY = dY > 0 ? this.step : -this.step;
                sX = dX * sY / dY;
                l = lY;
            }
            hasResult = true;
        } else if (dX == 0 && dY != 0) {
            sX = 0;
            sY = dY > 0 ? this.step : -this.step;
            l = lY;
            hasResult = true;
        } else if (dY == 0 && dX != 0) {
            sX = dX > 0 ? this.step : -this.step;
            sY = 0;
            hasResult = true;
        }
        if (hasResult) {
            result.add(new Integer(l));
            result.add(new Integer(sX));
            result.add(new Integer(sY));
        }
        return result;
    }

    private void delay() {
        try {
            Thread.sleep(this.delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int applyPlusToPosition(int pos, int pl) {
        int newpos = pos + pl;
        if (newpos < 0 && pl < 0) {
            newpos = pos + Math.abs(pl);
        }
        return newpos;
    }
}

