/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Logic {
    public static final String TRUE = "true";
    private static final String TRUE_space = " true ";
    public static final String FALSE = "false";
    private static final String FALSE_space = " false ";
    private static String NOT = " not ";
    private static String AND = " and ";
    private static String OR = " or ";
    private static String LB = " ( ";
    private static String RB = " ) ";
    private static String limitForCombinations = "0123456789";

    protected static synchronized String choice(List<String> expressions, int min, int max, boolean forceFalse) {
        ArrayList<String> combinationsIndexes = new ArrayList<String>();
        if (expressions.size() > limitForCombinations.length()) {
            return TRUE_space;
        }
        String limit = limitForCombinations.substring(0, expressions.size());
        Logic.combinations(min, max, "", limit, combinationsIndexes);
        ArrayList<String> orInput = new ArrayList<String>();
        if (forceFalse) {
            int i = 0;
            while (i < combinationsIndexes.size()) {
                String comb = (String)combinationsIndexes.get(i);
                ArrayList<String> andInput = new ArrayList<String>();
                int j = 0;
                while (j < expressions.size()) {
                    String andElement = "";
                    andElement = comb.lastIndexOf(String.valueOf(j)) == -1 ? Logic.negate(expressions.get(j)) : expressions.get(j);
                    andInput.add(andElement);
                    ++j;
                }
                orInput.add(Logic.and(andInput));
                ++i;
            }
        } else {
            int i = 0;
            while (i < combinationsIndexes.size()) {
                String comb = (String)combinationsIndexes.get(i);
                ArrayList<String> andInput = new ArrayList<String>();
                int j = 0;
                while (j < comb.length()) {
                    andInput.add(expressions.get(Integer.parseInt(String.valueOf(comb.charAt(j)))));
                    ++j;
                }
                orInput.add(Logic.and(andInput));
                ++i;
            }
        }
        return Logic.or(orInput);
    }

    protected static synchronized void combinations(int min, int max, String prefix, String elements, List<String> combinationsIndexes) {
        if (prefix.length() >= min) {
            combinationsIndexes.add(prefix);
        }
        int i = 0;
        while (i < elements.length()) {
            if (prefix.length() < max) {
                Logic.combinations(min, max, String.valueOf(String.valueOf(prefix)) + elements.charAt(i), elements.substring(i + 1), combinationsIndexes);
            }
            ++i;
        }
    }

    protected static synchronized String claused(String expression) {
        if (expression == null || expression.length() == 0) {
            return "";
        }
        if (Logic.isClaused(expression)) {
            return expression;
        }
        return String.valueOf(String.valueOf(LB)) + expression + RB;
    }

    private static boolean isClaused(String expression) {
        if (!expression.startsWith("(") || !expression.endsWith(")")) {
            return false;
        }
        HashMap<Integer, Integer> openClose = new HashMap<Integer, Integer>();
        Stack<Integer> open = new Stack<Integer>();
        int index = 0;
        while (index < expression.length()) {
            char c = expression.charAt(index);
            if (c == '(') {
                open.push(index);
            } else if (c == ')') {
                openClose.put((Integer)open.pop(), index);
            }
            ++index;
        }
        return (Integer)openClose.get(0) == expression.length() - 1;
    }

    protected static synchronized String implies(String lhs, String rhs) {
        if (lhs == null || lhs.length() == 0 || rhs == null || rhs.length() == 0) {
            throw new RuntimeException();
        }
        String lhs_trimmed = lhs.trim();
        String rhs_trimmed = rhs.trim();
        if (FALSE.equals(lhs_trimmed) || TRUE.equals(rhs_trimmed) || lhs_trimmed.equals(rhs_trimmed)) {
            return TRUE_space;
        }
        if (FALSE.equals(rhs_trimmed)) {
            return Logic.negate(lhs);
        }
        if (TRUE.equals(lhs_trimmed)) {
            return rhs;
        }
        return Logic.or(Logic.negate(lhs), rhs);
    }

    public static synchronized String negate(String expression) {
        String trimmed = expression.trim();
        if (trimmed.contentEquals(TRUE)) {
            return FALSE_space;
        }
        if (trimmed.equals(FALSE)) {
            return TRUE_space;
        }
        return String.valueOf(NOT) + Logic.claused(expression);
    }

    private static synchronized String op(List<String> expressions, String op) {
        if (expressions == null || expressions.size() == 0) {
            return "";
        }
        if (expressions.size() == 1) {
            return expressions.get(0);
        }
        String expression = "";
        String part = null;
        boolean first = true;
        int i = 0;
        while (i < expressions.size()) {
            part = expressions.get(i);
            if (part != null && part.length() > 0) {
                if (first) {
                    expression = String.valueOf(String.valueOf(expression)) + Logic.claused(part);
                    first = false;
                } else {
                    expression = String.valueOf(String.valueOf(expression)) + op + Logic.claused(part);
                }
            }
            ++i;
        }
        return expression;
    }

    protected static synchronized String or(List<String> expressions) {
        ArrayList<String> reduced = new ArrayList<String>(expressions.size());
        for (String expr : expressions) {
            String trimmedExpr = expr.trim();
            if (TRUE.equals(trimmedExpr)) {
                return TRUE_space;
            }
            if (FALSE.equals(trimmedExpr)) continue;
            reduced.add(expr);
        }
        if (reduced.size() == 0) {
            return FALSE_space;
        }
        if (reduced.size() == 1) {
            return (String)reduced.get(0);
        }
        String v1 = (String)reduced.get(0);
        int i = 1;
        while (i < reduced.size()) {
            v1 = Logic.or(v1, (String)reduced.get(i));
            ++i;
        }
        return v1;
    }

    protected static synchronized String or(String s1, String s2) {
        String s1_trimmed = s1.trim();
        String s2_trimmed = s2.trim();
        if (TRUE.equals(s1_trimmed) || TRUE.equals(s2_trimmed)) {
            return TRUE_space;
        }
        if (Logic.negate(s1_trimmed).trim().equals(s2_trimmed) || Logic.negate(s2_trimmed).trim().equals(s1_trimmed)) {
            return TRUE_space;
        }
        if (s1_trimmed.equals(s2_trimmed)) {
            return s1;
        }
        if (FALSE.equals(s1_trimmed)) {
            if (FALSE.equals(s2_trimmed)) {
                return FALSE_space;
            }
            return s2;
        }
        if (FALSE.contentEquals(s2_trimmed)) {
            return s1;
        }
        return String.valueOf(Logic.claused(s1)) + OR + Logic.claused(s2);
    }

    protected static synchronized String and(List<String> expressions) {
        ArrayList<String> reduced = new ArrayList<String>(expressions.size());
        for (String expr : expressions) {
            String trimmed = expr.trim();
            if (FALSE.equals(trimmed)) {
                return FALSE_space;
            }
            if (TRUE.equals(trimmed)) continue;
            reduced.add(expr);
        }
        if (reduced.size() == 0) {
            return TRUE_space;
        }
        if (reduced.size() == 1) {
            return (String)reduced.get(0);
        }
        String v1 = (String)reduced.get(0);
        int i = 1;
        while (i < reduced.size()) {
            v1 = Logic.and(v1, (String)reduced.get(i));
            ++i;
        }
        return v1;
    }

    public static synchronized String and(String s1, String s2) {
        String s1_trimmed = s1.trim();
        String s2_trimmed = s2.trim();
        if (FALSE.equals(s1_trimmed) || FALSE.equals(s2_trimmed)) {
            return FALSE_space;
        }
        if (Logic.negate(s1_trimmed).trim().equals(s2_trimmed) || Logic.negate(s2_trimmed).trim().equals(s1_trimmed)) {
            return FALSE_space;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!"".equals(s1_trimmed) && !TRUE.equals(s1_trimmed)) {
            list.add(s1);
        }
        if (!("".equals(s2_trimmed) || TRUE.equals(s2_trimmed) || s1_trimmed.equals(s2_trimmed))) {
            list.add(s2);
        }
        if (list.size() == 0) {
            return TRUE_space;
        }
        if (list.size() == 1) {
            return (String)list.get(0);
        }
        return Logic.op(list, AND);
    }

    protected static synchronized List<String> andMerge(List<String> memberEnds, HashMap<String, String> memberEndPCs, HashMap<String, String> memberEndsTypesPCs) {
        ArrayList<String> mergedList = new ArrayList<String>();
        int i = 0;
        while (i < memberEnds.size()) {
            mergedList.add(Logic.and(memberEndPCs.get(memberEnds.get(i)), memberEndsTypesPCs.get(memberEnds.get(i))));
            ++i;
        }
        return mergedList;
    }

    protected static String simplifyDNF(String dnf, List<String> variables) {
        String expression = dnf;
        int i = 0;
        boolean delete = false;
        String newExpression = "";
        while (expression.lastIndexOf(" | ") != -1) {
            i = expression.lastIndexOf(" | ") + " | ".length();
            String clause = expression.substring(i, expression.length());
            delete = false;
            for (String variable : variables) {
                if ((!clause.contains(String.valueOf(String.valueOf(AND)) + variable) && !clause.startsWith(variable) || !clause.contains(String.valueOf(String.valueOf(NOT)) + variable)) && !clause.contains(FALSE)) continue;
                delete = true;
                break;
            }
            expression = expression.substring(0, expression.lastIndexOf(" | "));
            if (delete || newExpression.indexOf(String.valueOf(String.valueOf(LB)) + clause + RB) != -1 || clause.indexOf(FALSE) != -1) continue;
            for (String variable : variables) {
                if (clause.indexOf(variable) == clause.lastIndexOf(variable)) continue;
                clause = clause.replaceAll(String.valueOf(AND) + TRUE + AND, AND).replaceAll(String.valueOf(String.valueOf(AND)) + TRUE, "").replaceAll(TRUE + AND, "");
                String part1 = clause.substring(0, clause.indexOf(variable) + variable.length());
                String part2 = clause.substring(clause.indexOf(variable) + variable.length(), clause.length());
                part2 = part2.replaceAll(String.valueOf(String.valueOf(AND)) + NOT + variable, "");
                part2 = part2.replaceAll(String.valueOf(String.valueOf(AND)) + variable, "");
                clause = String.valueOf(String.valueOf(part1)) + part2;
            }
            if (clause.replaceAll(" ", "").length() <= 0 || newExpression.contains(String.valueOf(String.valueOf(LB)) + clause + RB) || clause.contains(FALSE_space)) continue;
            newExpression = String.valueOf(String.valueOf(newExpression)) + LB + clause + RB + OR;
        }
        newExpression = newExpression.substring(0, newExpression.lastIndexOf(OR));
        return newExpression;
    }

    public static Boolean reduce(String pc, List<String> trueFeatures, List<String> falseFeatures) throws ScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
        for (String trueFeature : trueFeatures) {
            engine.put(trueFeature, Boolean.TRUE);
        }
        for (String falseFeature : falseFeatures) {
            engine.put(falseFeature, Boolean.FALSE);
        }
        return (Boolean)engine.eval(pc);
    }
}

