/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.matcher;

import aima.core.logic.propositional.parsing.PLParser;
import aima.core.logic.propositional.parsing.ast.ComplexSentence;
import aima.core.logic.propositional.parsing.ast.Connective;
import aima.core.logic.propositional.parsing.ast.Sentence;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.henshin.variability.util.SatChecker;
import org.eclipse.emf.henshin.variability.util.XorEncoderUtil;

public class FeatureExpression {
    private static PropositionalParser parser = new PropositionalParser();
    public static final Sentence TRUE = parser.parse("true");
    static Map<Sentence, Map<Sentence, Boolean>> implies = new HashMap<Sentence, Map<Sentence, Boolean>>();
    static Map<Sentence, Map<Sentence, Boolean>> contradicts = new HashMap<Sentence, Map<Sentence, Boolean>>();
    static Map<Sentence, Map<Sentence, Sentence>> and = new HashMap<Sentence, Map<Sentence, Sentence>>();
    static Map<Sentence, Map<Sentence, Sentence>> andNot = new HashMap<Sentence, Map<Sentence, Sentence>>();

    public static boolean implies(Sentence expr1, Sentence expr2) {
        if (implies.containsKey(expr1)) {
            if (implies.get(expr1).containsKey(expr2)) {
                return implies.get(expr1).get(expr2);
            }
            boolean val = new SatChecker().isContradiction(FeatureExpression.andNot(expr1, expr2).toString());
            implies.get(expr1).put(expr2, val);
            return val;
        }
        implies.put(expr1, new HashMap());
        return FeatureExpression.implies(expr1, expr2);
    }

    public static Sentence and(Sentence expr1, Sentence expr2) {
        if (and.containsKey(expr1)) {
            if (and.get(expr1).containsKey(expr2)) {
                return and.get(expr1).get(expr2);
            }
            Sentence val = Sentence.newConjunction((Sentence[])new Sentence[]{expr1, expr2});
            and.get(expr1).put(expr2, val);
            return val;
        }
        and.put(expr1, new HashMap());
        return FeatureExpression.and(expr1, expr2);
    }

    public static Sentence andNot(Sentence expr1, Sentence expr2) {
        if (andNot.containsKey(expr1)) {
            if (andNot.get(expr1).containsKey(expr2)) {
                return andNot.get(expr1).get(expr2);
            }
            Sentence val = Sentence.newConjunction((Sentence[])new Sentence[]{expr1, new ComplexSentence(Connective.NOT, new Sentence[]{expr2})});
            andNot.get(expr1).put(expr2, val);
            return val;
        }
        andNot.put(expr1, new HashMap());
        return FeatureExpression.andNot(expr1, expr2);
    }

    public static Sentence getExpr(String condition) {
        condition = XorEncoderUtil.encodeXor(condition);
        return parser.parse(condition);
    }

    public static boolean contradicts(Sentence expr1, Sentence expr2) {
        if (contradicts.containsKey(expr1)) {
            if (contradicts.get(expr1).containsKey(expr2)) {
                return contradicts.get(expr1).get(expr2);
            }
            boolean val = new SatChecker().isContradiction(Sentence.newConjunction((Sentence[])new Sentence[]{expr1, expr2}));
            contradicts.get(expr1).put(expr2, val);
            return val;
        }
        contradicts.put(expr1, new HashMap());
        return FeatureExpression.contradicts(expr1, expr2);
    }

    private static class PropositionalParser
    extends PLParser {
        private static final String NOT = "~";
        private static final String AND = "&";
        private static final String OR = "|";
        private static HashMap<String, Sentence> exprToSentence;

        public PropositionalParser() {
            Sentence trueSentence = (Sentence)super.parse("true");
            exprToSentence = new HashMap();
            exprToSentence.put("true", trueSentence);
            exprToSentence.put("", trueSentence);
        }

        public Sentence parse(String input) {
            String trimmed = input.trim();
            if (exprToSentence.containsKey(trimmed)) {
                return exprToSentence.get(trimmed);
            }
            String resolved = PropositionalParser.resolveSynonyms(trimmed);
            Sentence sentence = (Sentence)super.parse(resolved);
            exprToSentence.put(trimmed, sentence);
            exprToSentence.put(resolved, sentence);
            return sentence;
        }

        private static String resolveSynonyms(String expression) {
            expression = expression.replaceAll("\\)", " ) ");
            expression = expression.replaceAll("\\(", " ( ");
            expression = expression.replaceAll(" (XOR) ", "xor");
            expression = expression.replaceAll(" (or|OR|\\|\\|)", " | ");
            expression = expression.replaceAll(" (and|AND|\\&\\&) ", " & ");
            expression = expression.replaceAll("!", " ~ ");
            expression = expression.replaceAll(" (not|NOT) ", " ~ ");
            return expression;
        }
    }
}

