/*
 * Decompiled with CFR 0.152.
 */
package configuration.impl;

import configuration.Configuration;
import configuration.ConfigurationFactory;
import configuration.ConfigurationPackage;
import configuration.Feature;
import configuration.FeatureBinding;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;

public class ConfigurationImpl
extends MinimalEObjectImpl.Container
implements Configuration {
    protected VariabilityRule rule;
    protected EList<Feature> features;
    protected EFeatureModelContentAdapter featuresContentAdapter;

    protected ConfigurationImpl() {
    }

    protected EClass eStaticClass() {
        return ConfigurationPackage.Literals.CONFIGURATION;
    }

    @Override
    public VariabilityRule getRule() {
        if (this.rule != null && this.rule.eIsProxy()) {
            InternalEObject oldRule = (InternalEObject)this.rule;
            this.rule = (VariabilityRule)this.eResolveProxy(oldRule);
            if (this.rule != oldRule && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 0, (Object)oldRule, (Object)this.rule));
            }
        }
        return this.rule;
    }

    public Rule basicGetRule() {
        return this.rule;
    }

    private void disableContentAdapter() {
        this.rule.eResource().getResourceSet().eAdapters().remove((Object)this.featuresContentAdapter);
    }

    private void enableContentAdapter() {
        if (this.featuresContentAdapter == null) {
            this.featuresContentAdapter = new EFeatureModelContentAdapter();
        }
        this.rule.eResource().getResourceSet().eAdapters().add((Object)this.featuresContentAdapter);
    }

    @Override
    public void setRule(Rule newRule) {
        VariabilityRule oldRule = this.rule;
        if (this.featuresContentAdapter != null) {
            oldRule.eResource().getResourceSet().eAdapters().remove((Object)this.featuresContentAdapter);
        } else {
            this.featuresContentAdapter = new EFeatureModelContentAdapter();
        }
        this.rule = VariabilityFactory.createVariabilityRule((Rule)newRule);
        this.rule.eResource().getResourceSet().eAdapters().add((Object)this.featuresContentAdapter);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldRule, (Object)this.rule));
        }
    }

    @Override
    public EList<Feature> getFeatures() {
        if (this.features == null) {
            this.features = new EObjectResolvingEList(Feature.class, (InternalEObject)this, 1);
        }
        return this.features;
    }

    private void updateAllFeatures() {
        Map<String, FeatureBinding> bindings = this.getBindings();
        List annotationFeatures = VariabilityFactory.createVariabilityRule((Rule)this.rule).getFeatures();
        EList<Feature> oldFeatures = this.getFeatures();
        this.features.clear();
        for (String featureName : annotationFeatures) {
            Feature feature = ConfigurationFactory.eINSTANCE.createFeature();
            feature.setName(featureName);
            this.features.add((Object)feature);
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldFeatures, this.features));
        }
        this.applyBindings(bindings);
    }

    @Override
    public boolean addFeature(Feature feature) {
        this.disableContentAdapter();
        List annotationFeatures = VariabilityFactory.createVariabilityRule((Rule)this.rule).getFeatures();
        String featureAnnotationValue = "";
        if (annotationFeatures != null && !annotationFeatures.isEmpty()) {
            featureAnnotationValue = String.join((CharSequence)", ", annotationFeatures);
            featureAnnotationValue = String.valueOf(featureAnnotationValue) + ", " + feature.getName();
        } else {
            featureAnnotationValue = String.valueOf(featureAnnotationValue) + feature.getName();
        }
        VariabilityTransactionHelper.setAnnotationValue((ModelElement)this.rule, (String)"features", (String)featureAnnotationValue);
        this.enableContentAdapter();
        return this.features.add((Object)feature);
    }

    @Override
    public boolean removeFeature(String featureName) {
        Feature featureToRemove = null;
        for (Feature feature : this.features) {
            if (!featureName.equals(feature.getName())) continue;
            featureToRemove = feature;
            break;
        }
        return this.removeFeature(featureToRemove);
    }

    @Override
    public boolean removeFeature(Feature feature) {
        this.disableContentAdapter();
        if (feature != null) {
            List annotationFeatures = VariabilityFactory.createVariabilityRule((Rule)this.rule).getFeatures();
            String featureAnnotationValue = "";
            for (String annotationFeature : annotationFeatures) {
                if (annotationFeature.equals(feature.getName())) continue;
                featureAnnotationValue = String.valueOf(featureAnnotationValue) + annotationFeature + ", ";
            }
            if (annotationFeatures.size() > 1) {
                featureAnnotationValue = featureAnnotationValue.substring(0, featureAnnotationValue.length() - 2);
            }
            VariabilityTransactionHelper.setAnnotationValue((ModelElement)this.rule, (String)"features", (String)featureAnnotationValue);
            this.enableContentAdapter();
            return this.features.remove((Object)feature);
        }
        return false;
    }

    private Map<String, FeatureBinding> getBindings() {
        HashMap<String, FeatureBinding> result = new HashMap<String, FeatureBinding>();
        for (Feature feature : this.features) {
            result.put(feature.getName(), feature.getBinding());
        }
        return result;
    }

    private void applyBindings(Map<String, FeatureBinding> bindings) {
        for (Feature feature : this.features) {
            if (!bindings.containsKey(feature.getName())) continue;
            feature.setBinding(bindings.get(feature.getName()));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (resolve) {
                    return this.getRule();
                }
                return this.basicGetRule();
            }
            case 1: {
                return this.getFeatures();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRule((Rule)newValue);
                return;
            }
            case 1: {
                this.getFeatures().clear();
                this.getFeatures().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRule(null);
                return;
            }
            case 1: {
                this.getFeatures().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.rule != null;
            }
            case 1: {
                return this.features != null && !this.features.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    private final class EFeatureModelContentAdapter
    extends EContentAdapter {
        private EFeatureModelContentAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 8) {
                return;
            }
            Object notifier = notification.getNotifier();
            if (notifier instanceof Annotation && ((Annotation)notifier).eContainer() instanceof Rule && ((Annotation)notifier).getKey().equals("features")) {
                ConfigurationImpl.this.updateAllFeatures();
            }
        }
    }
}

