/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class CDAUtility {
    ResourceSet commonResourceSet;

    public void persistAtomicCPAResult(String path, Rule rule1, Rule rule2, List<Span> conflictPartCandidates, List<Atom.ConflictAtom> conflictAtoms, Set<Span> minimalConflictReasons) {
        this.commonResourceSet = new ResourceSetImpl();
        this.persistRules(path, rule1, rule2);
        this.persistSpans(path, rule1, rule2, conflictPartCandidates);
        List<Span> conflictAtomSpans = this.extractSpans(conflictAtoms);
        this.persistSpans(path, rule1, rule2, conflictAtomSpans);
        this.persistSpans(path, rule1, rule2, minimalConflictReasons);
    }

    private List<Span> extractSpans(List<Atom.ConflictAtom> conflictAtoms) {
        LinkedList<Span> spans = new LinkedList<Span>();
        for (Atom.ConflictAtom conflictAtom : conflictAtoms) {
            spans.add(conflictAtom);
        }
        return spans;
    }

    private void persistSpans(String path, Rule rule1, Rule rule2, Collection<Span> spans) {
    }

    private void persistRules(String path, Rule rule1, Rule rule2) {
        this.persistRule(path, rule1, "(1)");
        this.persistRule(path, rule2, "(2)");
    }

    private void persistRule(String path, Rule rule, String prefix) {
        String fileNameRule1 = String.valueOf(prefix) + rule.getName() + ".henshin";
        String fullPathRule1 = String.valueOf(path) + fileNameRule1;
        CDAUtility.saveRuleInFileSystem(this.commonResourceSet, rule, fullPathRule1);
    }

    private static URI saveRuleInFileSystem(ResourceSet resourceSet, Rule rule, String fullFilePath) {
        URI firstRuleURI = URI.createFileURI((String)fullFilePath);
        Resource firstRuleRes = resourceSet.createResource(firstRuleURI, "henshin");
        firstRuleRes.getContents().add((Object)rule);
        try {
            firstRuleRes.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return firstRuleURI;
    }
}

