/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.ecore2uml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.LoggingApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Ecore2UML {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/ecore2uml";
    public static final String ECORE_EXAMPLE = "flowchartdsl.ecore";

    public static void run(String path, String ecore, boolean saveResult) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        if (!resourceSet.initPackageImplementation("org.eclipse.uml2.uml.UMLPackage")) {
            throw new RuntimeException("UML2 package not found. Make sure that org.eclipse.uml2.uml is in the classpath.");
        }
        resourceSet.registerXMIResourceFactories(new String[]{"uml"});
        Module module = resourceSet.getModule("ecore2uml.henshin", false);
        EGraphImpl graph = new EGraphImpl(resourceSet.getResource(ecore));
        graph.addAll((Collection)EcorePackage.eINSTANCE.getEClassifiers());
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine, (EGraph)graph, module.getUnit("main"), null);
        if (!app.execute((ApplicationMonitor)new LoggingApplicationMonitor())) {
            throw new RuntimeException("Error executing transformation");
        }
        if (saveResult) {
            ArrayList<EObject> umlPackages = new ArrayList<EObject>();
            for (EObject obj : graph.getRoots()) {
                if (!obj.eClass().getName().equals("Package")) continue;
                umlPackages.add(obj);
            }
            Resource resource = resourceSet.createResource(URI.createFileURI((String)ecore.replaceAll(".ecore", ".uml")));
            resource.getContents().addAll(umlPackages);
            try {
                resource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Ecore2UML.run(PATH, ECORE_EXAMPLE, true);
    }
}

