/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.tooling.runtime.parsers.AbstractAttributeParser;

public class EdgeTypeParser
extends AbstractAttributeParser {
    public EdgeTypeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getEdge_Index()});
    }

    public String getPrintString(IAdaptable element, int flags) {
        Edge lhsEdge;
        String lhsIndex;
        Edge edge = (Edge)element.getAdapter(EObject.class);
        Rule rule = edge.getGraph().getRule();
        String type = edge.getType() != null ? edge.getType().getName() : "?";
        String rhsIndex = lhsIndex = edge.getIndex();
        if (edge.getGraph().isLhs()) {
            Edge rhsEdge = rule.getMappings().getImage(edge, rule.getRhs());
            if (rhsEdge != null) {
                rhsIndex = rhsEdge.getIndex();
            }
        } else if (edge.getGraph().isRhs() && (lhsEdge = rule.getMappings().getOrigin(edge)) != null) {
            lhsIndex = lhsEdge.getIndex();
        }
        lhsIndex = lhsIndex == null ? "" : lhsIndex.trim();
        String string = rhsIndex = rhsIndex == null ? "" : rhsIndex.trim();
        String index = rhsIndex.length() == 0 ? lhsIndex : (lhsIndex.length() == 0 ? rhsIndex : (!lhsIndex.equals(rhsIndex) ? String.valueOf(lhsIndex) + "->" + rhsIndex : lhsIndex));
        if (index.length() > 0) {
            return String.valueOf(type) + "[" + index.trim() + "]";
        }
        return type;
    }

    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Edge edge = (Edge)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)edge);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Edge Type", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return EdgeTypeParser.this.doParsing(value, edge);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Edge edge) {
        Edge origin;
        Rule rule = edge.getGraph().getRule();
        Node source = edge.getSource();
        if (source.getType() == null) {
            return CommandResult.newErrorCommandResult((String)"Source type must be set");
        }
        String typeName = value;
        String lhsIndex = null;
        String rhsIndex = null;
        if (value.indexOf(91) >= 0) {
            typeName = value.substring(0, value.indexOf(91));
            rhsIndex = lhsIndex = value.substring(value.indexOf(91) + 1, value.indexOf(93));
        }
        if (lhsIndex != null && lhsIndex.indexOf("->") >= 0) {
            rhsIndex = lhsIndex.substring(lhsIndex.indexOf("->") + 2);
            lhsIndex = lhsIndex.substring(0, lhsIndex.indexOf("->"));
        }
        EReference type = null;
        for (EReference reference : source.getType().getEAllReferences()) {
            if (!typeName.equalsIgnoreCase(reference.getName())) continue;
            type = reference;
            break;
        }
        if (type == null) {
            return CommandResult.newErrorCommandResult((String)("Unknown reference: " + value));
        }
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.add(edge);
        Edge image = rule.getMappings().getImage(edge, rule.getRhs());
        if (image != null) {
            edges.add(image);
        }
        if ((origin = rule.getMappings().getOrigin(edge)) != null) {
            edges.add(origin);
        }
        String oldIndex = edge.getIndex();
        edge.setIndex("xyz123");
        edge.setIndex(oldIndex);
        for (Edge current : edges) {
            current.setType(type);
            if (current.getGraph().isRhs()) {
                current.setIndex(rhsIndex);
                continue;
            }
            current.setIndex(lhsIndex);
        }
        return CommandResult.newOKCommandResult();
    }

    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getEdge_Type()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getEdge_Index();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

