/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.colim;

import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.COPROD_OBJECT;
import agg.xt_basis.colim.INT_VECTOR;
import agg.xt_basis.colim.SET_DIAGRAM;

public class ALPHA_DIAGRAM
implements COLIM_DEFS {
    private SET_DIAGRAM f_diagram = new SET_DIAGRAM();
    private COLIM_VECTOR f_coprod_refs = new COLIM_VECTOR();
    private COLIM_VECTOR f_coprod_attrs = new COLIM_VECTOR();
    private COLIM_VECTOR f_colimit_refs;
    private COLIM_VECTOR f_colimit_attrs;
    private COLIM_VECTOR f_colimit_attr_sets;
    private COLIM_VECTOR f_dependent;
    private boolean f_colimit_valid;
    private boolean f_total_valid;
    private boolean f_attr_sets_valid;

    public ALPHA_DIAGRAM() {
        this.f_coprod_refs.push_back(null);
        this.f_coprod_attrs.push_back(null);
        this.f_colimit_valid = false;
        this.f_attr_sets_valid = false;
        this.f_total_valid = false;
    }

    public int insert_object(COLIM_VECTOR items, COLIM_VECTOR refs, COLIM_VECTOR attrs, String name) {
        int lower = this.f_diagram.coproduct_size();
        int node = this.f_diagram.insert_object(items, name);
        int i = 0;
        while (i < refs.size()) {
            INT_VECTOR ref = (INT_VECTOR)refs.item(i);
            INT_VECTOR coproduct_ref = new INT_VECTOR(ref.size());
            int item_ref = 0;
            while (item_ref < ref.size()) {
                coproduct_ref.push_back(ref.item(item_ref) + lower);
                ++item_ref;
            }
            this.f_coprod_refs.push_back(coproduct_ref);
            ++i;
        }
        i = 0;
        while (i < attrs.size()) {
            this.f_coprod_attrs.push_back(attrs.item(i));
            ++i;
        }
        this.f_colimit_valid = false;
        return node;
    }

    public int insert_morphism(INT_VECTOR morphism, int v, int w) {
        int edge = this.f_diagram.insert_morphism(morphism, v, w);
        this.f_colimit_valid = false;
        return edge;
    }

    public COLIM_VECTOR get_colimit_items() {
        return this.f_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_refs() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_refs;
    }

    public COLIM_VECTOR get_colimit_attrs() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
        }
        return this.f_colimit_attrs;
    }

    public COLIM_VECTOR get_colimit_attr_sets() {
        if (!this.f_colimit_valid) {
            this.compute_colimit();
            this.compute_colimit_attr_sets();
        } else if (!this.f_attr_sets_valid) {
            this.compute_colimit_attr_sets();
        }
        return this.f_colimit_attr_sets;
    }

    public COLIM_VECTOR get_colimit_items_total() {
        if (!this.f_total_valid || !this.f_colimit_valid) {
            this.totalize();
        }
        return this.f_diagram.get_colimit_set();
    }

    public COLIM_VECTOR get_colimit_refs_total() {
        if (!this.f_total_valid || !this.f_colimit_valid) {
            this.totalize();
            this.compute_colimit();
        }
        return this.f_colimit_refs;
    }

    public COLIM_VECTOR get_colimit_attrs_total() {
        if (!this.f_total_valid || !this.f_colimit_valid) {
            this.totalize();
            this.compute_colimit();
        }
        return this.f_colimit_attrs;
    }

    public COLIM_VECTOR get_colimit_attr_sets_total() {
        if (!this.f_total_valid || !this.f_colimit_valid) {
            this.totalize();
            this.compute_colimit();
            this.compute_colimit_attr_sets();
        } else if (!this.f_attr_sets_valid) {
            this.compute_colimit_attr_sets();
        }
        return this.f_colimit_attr_sets;
    }

    public INT_VECTOR get_references(int item) {
        return (INT_VECTOR)this.f_coprod_refs.item(item);
    }

    public COLIM_VECTOR get_attributes(int item) {
        return (COLIM_VECTOR)this.f_coprod_attrs.item(item);
    }

    public SET_DIAGRAM get_item_diagram() {
        return this.f_diagram;
    }

    public boolean is_dangling_ok() {
        this.compute_dependent();
        INT_VECTOR deleted = (INT_VECTOR)this.f_dependent.item(0);
        return deleted.size() == 0;
    }

    public boolean is_identification_ok(INT_VECTOR morphism, int target_node) {
        COPROD_OBJECT target = this.f_diagram.set_at_node(target_node);
        INT_VECTOR source_num = new INT_VECTOR();
        source_num.setSize(target.upper - target.lower + 1);
        int i = 0;
        while (i < morphism.size()) {
            int t = morphism.item(i);
            if (t != -1) {
                source_num.put(source_num.item(t) + 1, t);
            }
            ++i;
        }
        i = 0;
        while (i < morphism.size()) {
            if (source_num.item(i) > 1 && this.f_diagram.get_colimit_index(target.lower + i) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean is_gluing_ok(INT_VECTOR morphism, int target_node) {
        return this.is_dangling_ok() && this.is_identification_ok(morphism, target_node);
    }

    public String toString() {
        StringBuffer Result2 = new StringBuffer("\nitem diagram:\n");
        Result2.append(this.f_diagram.toString());
        Result2.append("coproduct:\n");
        Result2.append(this.out_object(this.f_diagram.get_coproduct_set(), this.f_coprod_refs, this.f_coprod_attrs));
        return new String(Result2);
    }

    public String out_object(COLIM_VECTOR items, COLIM_VECTOR refs, COLIM_VECTOR attrs) {
        StringBuffer Result2 = new StringBuffer("\n");
        int i = 0;
        while (i < items.size()) {
            if (items.item(i) != null) {
                Result2.append(items.item(i).toString());
                Result2.append(" -> ");
                INT_VECTOR refs_i = (INT_VECTOR)refs.item(i);
                int index = 0;
                while (index < refs_i.size()) {
                    int ref = refs_i.item(index);
                    Result2.append(items.item(ref).toString());
                    if (++index >= refs_i.size()) continue;
                    Result2.append(", ");
                }
                Result2.append("; attributes: ");
                COLIM_VECTOR attrs_i = (COLIM_VECTOR)attrs.item(i);
                int index2 = 0;
                while (index2 < attrs_i.size()) {
                    Result2.append(attrs_i.item(index2).toString());
                    if (++index2 >= attrs_i.size()) continue;
                    Result2.append(", ");
                }
            }
            Result2.append("\n");
            ++i;
        }
        return new String(Result2);
    }

    public String out_object_attr_sets(COLIM_VECTOR items, COLIM_VECTOR refs, COLIM_VECTOR attr_sets) {
        StringBuffer Result2 = new StringBuffer("\n");
        int i = 0;
        while (i < items.size()) {
            if (items.item(i) != null) {
                Result2.append(items.item(i).toString());
                Result2.append(" -> ");
                INT_VECTOR refs_i = (INT_VECTOR)refs.item(i);
                int index = 0;
                while (index < refs_i.size()) {
                    int ref = refs_i.item(index);
                    Result2.append(items.item(ref).toString());
                    if (++index >= refs_i.size()) continue;
                    Result2.append(", ");
                }
                Result2.append("; attribute sets: ");
                COLIM_VECTOR attr_sets_i = (COLIM_VECTOR)attr_sets.item(i);
                int index2 = 0;
                while (index2 < attr_sets_i.size()) {
                    Result2.append("{");
                    COLIM_VECTOR attrs_i = (COLIM_VECTOR)attr_sets_i.item(index2);
                    int elem = 0;
                    while (elem < attrs_i.size()) {
                        Result2.append(attrs_i.item(elem).toString());
                        if (++elem >= attrs_i.size()) continue;
                        Result2.append(", ");
                    }
                    Result2.append("}");
                    if (++index2 >= attr_sets_i.size()) continue;
                    Result2.append(", ");
                }
            }
            Result2.append("\n");
            ++i;
        }
        return new String(Result2);
    }

    private void compute_colimit() {
        INT_VECTOR colimit_items = this.f_diagram.get_colimit_indices();
        this.f_colimit_refs = new COLIM_VECTOR(colimit_items.size());
        this.f_colimit_attrs = new COLIM_VECTOR(colimit_items.size());
        int item = 0;
        while (item < colimit_items.size()) {
            INT_VECTOR ref = (INT_VECTOR)this.f_coprod_refs.item(colimit_items.item(item));
            INT_VECTOR colimit_ref = new INT_VECTOR();
            int item_ref = 0;
            while (item_ref < ref.size()) {
                int colimit_item_ref = this.f_diagram.get_colimit_pos(ref.item(item_ref));
                if (colimit_item_ref != -1) {
                    colimit_ref.push_back(colimit_item_ref);
                }
                ++item_ref;
            }
            this.f_colimit_refs.push_back(colimit_ref);
            this.f_colimit_attrs.push_back(this.f_coprod_attrs.item(colimit_items.item(item)));
            ++item;
        }
        this.f_colimit_valid = true;
    }

    private void compute_colimit_attr_sets() {
        INT_VECTOR colimit_items = this.f_diagram.get_colimit_indices();
        this.f_colimit_attr_sets = new COLIM_VECTOR();
        this.f_colimit_attr_sets.setSize(colimit_items.size());
        int item = 1;
        while (item < this.f_diagram.coproduct_size()) {
            int colimit_item = this.f_diagram.get_colimit_pos(item);
            if (colimit_item != -1) {
                COLIM_VECTOR attrs = (COLIM_VECTOR)this.f_coprod_attrs.item(item);
                COLIM_VECTOR attr_sets = (COLIM_VECTOR)this.f_colimit_attr_sets.item(colimit_item);
                if (attr_sets == null) {
                    attr_sets = new COLIM_VECTOR(attrs.size());
                    int i = 0;
                    while (i < attrs.size()) {
                        attr_sets.push_back(new COLIM_VECTOR());
                        ++i;
                    }
                }
                int attr = 0;
                while (attr < attrs.size()) {
                    COLIM_VECTOR attr_set = (COLIM_VECTOR)attr_sets.item(attr);
                    attr_set.push_back(attrs.item(attr));
                    ++attr;
                }
                this.f_colimit_attr_sets.put(attr_sets, colimit_item);
            }
            ++item;
        }
        this.f_attr_sets_valid = true;
    }

    private void totalize() {
        this.compute_dependent();
        INT_VECTOR deleted = (INT_VECTOR)this.f_dependent.item(0);
        this.delete_dependent(deleted);
        this.f_total_valid = true;
    }

    private void compute_dependent() {
        if (this.f_dependent == null || !this.f_colimit_valid) {
            this.f_dependent = new COLIM_VECTOR();
            this.f_dependent.setSize(this.f_coprod_refs.size());
            this.f_dependent.put(new INT_VECTOR(), 0);
            INT_VECTOR colimit_items = this.f_diagram.get_colimit_indices();
            int i = 0;
            while (i < colimit_items.size()) {
                this.f_dependent.put(new INT_VECTOR(), colimit_items.item(i));
                ++i;
            }
            i = 0;
            while (i < colimit_items.size()) {
                int item = colimit_items.item(i);
                INT_VECTOR item_refs = (INT_VECTOR)this.f_coprod_refs.item(item);
                int ref = 0;
                while (ref < item_refs.size()) {
                    int colimit_item_ref = this.f_diagram.get_colimit_index(item_refs.item(ref));
                    INT_VECTOR dependent = (INT_VECTOR)this.f_dependent.item(colimit_item_ref);
                    dependent.push_back(item);
                    ++ref;
                }
                ++i;
            }
        }
    }

    private void delete_dependent(INT_VECTOR deleted) {
        int i = 0;
        while (i < deleted.size()) {
            int item = deleted.item(i);
            if (this.f_diagram.get_colimit_index(item) != 0) {
                this.f_diagram.delete_element(item);
                INT_VECTOR del = (INT_VECTOR)this.f_dependent.item(item);
                this.delete_dependent(del);
            }
            ++i;
        }
    }
}

