/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.impl;

import agg.attribute.AttrMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ChainedObserver;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.TupleEvent;
import agg.attribute.view.AttrViewSetting;
import agg.util.Disposable;
import java.util.Vector;

public abstract class TupleObject
extends ChainedObserver
implements AttrTuple,
Disposable {
    protected TupleObject parent;
    protected final Vector<AttrMember> members = new Vector();

    public TupleObject(AttrTupleManager manager, TupleObject parent) {
        super(manager);
        this.assignParent(parent);
    }

    protected void finalize() {
    }

    @Override
    public void dispose() {
        if (this.parent != null) {
            this.parent.removeObserver(this);
        }
        this.members.clear();
    }

    protected void assignParent(TupleObject newParent) {
        if (this.parent != null) {
            this.parent.removeObserver(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addObserver(this);
        }
    }

    @Override
    protected void propagateEvent(TupleEvent e) {
        this.fireAttrChanged(e.cloneWithNewSource(this));
    }

    public void memberChanged(int code, AttrMember member) {
        this.fireAttrChanged(code, this.getIndexForMember(member));
    }

    protected synchronized int rawGetSize() {
        return this.members.size();
    }

    protected synchronized AttrMember rawGetMemberAt(int index) {
        int indx = index;
        if (this.members.size() == 0 || indx < 0) {
            return null;
        }
        if (indx >= this.members.size()) {
            indx = 0;
        }
        return this.members.elementAt(indx);
    }

    protected synchronized void rawAddMember(AttrMember member) {
        if (member != null) {
            this.members.add(member);
        }
    }

    protected synchronized void rawAddMember(int index, AttrMember member) {
        if (member != null) {
            this.members.add(index, member);
        }
    }

    protected synchronized void rawDeleteMemberAt(int index) {
        if (index == -1 || index >= this.members.size()) {
            return;
        }
        this.members.removeElementAt(index);
    }

    @Override
    public abstract DeclTuple getTupleType();

    public AttrType getType() {
        return this.getTupleType();
    }

    protected AttrViewSetting getForm() {
        return this.getTupleType().getForm();
    }

    protected void setForm(AttrViewSetting formSetting) {
        this.getTupleType().setForm(formSetting);
    }

    protected AttrViewSetting ensureNonNull(AttrViewSetting viewSetting) {
        if (viewSetting == null) {
            return this.manager.getDefaultMaskedView();
        }
        return viewSetting;
    }

    protected int getIndexInView(AttrViewSetting viewSetting, int slot) {
        return this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot);
    }

    protected TupleObject getParent() {
        return this.parent;
    }

    public int getParentSize() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getSize();
    }

    protected TupleObject getParentInCharge(int index) {
        if (index >= this.getParentSize()) {
            return this;
        }
        return this.parent.getParentInCharge(index);
    }

    protected void addMember(AttrMember member) {
        this.rawAddMember(member);
    }

    protected void addMember(int index, AttrMember member) {
        this.rawAddMember(index, member);
    }

    protected void deleteMemberAt(int index) {
        this.rawDeleteMemberAt(index);
    }

    public boolean isSubclassOf(TupleObject maybeParent) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == maybeParent) {
            return true;
        }
        return this.parent.isSubclassOf(maybeParent);
    }

    public int getSize() {
        return this.rawGetSize();
    }

    @Override
    public boolean isValid() {
        int i = 0;
        while (i < this.getSize()) {
            if (this.getMemberAt(i) == null || !this.getMemberAt(i).isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public AttrMember getMemberAt(int index) {
        return this.rawGetMemberAt(index);
    }

    @Override
    public AttrMember getMemberAt(AttrViewSetting viewSetting, int slot) {
        return this.getMemberAt(this.ensureNonNull(viewSetting).convertSlotToIndex(this, slot));
    }

    @Override
    public AttrMember getMemberAt(String name) {
        return this.getMemberAt(this.getIndexForName(name));
    }

    public int getIndexForName(String name) {
        return this.getTupleType().getIndexForName(name);
    }

    @Override
    public int getIndexForMember(AttrMember m) {
        if (m == null) {
            return -1;
        }
        int size = this.getSize();
        int i = 0;
        while (i < size) {
            if (m == this.getMemberAt(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getNumberOfEntries() {
        return this.getSize();
    }

    @Override
    public String getTypeAsString(int index) {
        return this.getType().getTypeAsString(index);
    }

    @Override
    public String getNameAsString(int index) {
        return this.getType().getNameAsString(index);
    }

    @Override
    public String getValueAsString(int index) {
        return "";
    }

    @Override
    public int getNumberOfEntries(AttrViewSetting viewSetting) {
        return this.ensureNonNull(viewSetting).getSize(this);
    }

    @Override
    public String getTypeAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getTypeAsString(this.getIndexInView(viewSetting, entryIndex));
    }

    @Override
    public String getNameAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getNameAsString(this.getIndexInView(viewSetting, entryIndex));
    }

    @Override
    public String getValueAsString(AttrViewSetting viewSetting, int entryIndex) {
        return this.getValueAsString(this.getIndexInView(viewSetting, entryIndex));
    }
}

