/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.matching.conditions.IFormula;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class ApplicationCondition
implements IFormula {
    public final EGraph graph;
    public final Map<Variable, DomainSlot> domainMap;
    public IFormula formula;
    public List<Variable> variables;

    public ApplicationCondition(EGraph graph, Map<Variable, DomainSlot> domainMap) {
        this.domainMap = domainMap;
        this.graph = graph;
    }

    public boolean findGraph() {
        for (Variable var : this.variables) {
            if (var.typeConstraint.instantiationPossible(this.domainMap.get(var), this.graph)) continue;
            return false;
        }
        return this.findMatch(0);
    }

    protected boolean findMatch(int index) {
        if (index == this.variables.size()) {
            for (Variable variable : this.variables) {
                DomainSlot slot;
                if (!variable.requiresFinalCheck || (slot = this.domainMap.get(variable)).recheck(variable, this.domainMap)) continue;
                return false;
            }
            return this.formula.eval();
        }
        Variable variable = this.variables.get(index);
        DomainSlot slot = this.domainMap.get(variable);
        boolean valid = false;
        while (!valid) {
            valid = slot.instantiate(variable, this.domainMap, this.graph);
            if (valid) {
                valid = this.findMatch(index + 1);
            }
            if (valid) continue;
            slot.unlock(variable);
            if (slot.instantiationPossible()) continue;
            slot.clear(variable);
            return false;
        }
        return true;
    }

    @Override
    public boolean eval() {
        boolean result = this.findGraph();
        for (Variable var : this.variables) {
            this.domainMap.get(var).reset(var);
        }
        return result;
    }
}

