/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.util.HenshinEGraph;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.TransformationSystem;

public class HenshinLoaders {
    public static final String HENSHIN_FILE_EXTENSION = "henshin";

    public static TransformationSystem loadHenshin(String fileName) {
        ModelHelper.registerFileExtension((String)HENSHIN_FILE_EXTENSION);
        return (TransformationSystem)ModelHelper.loadFile((String)fileName);
    }

    public static EGraph loadGraph(String modelFileName, String modelFileExt) {
        ModelHelper.registerFileExtension((String)modelFileExt);
        EObject graphRoot = ModelHelper.loadFile((String)modelFileName);
        EGraph graph = InterpreterFactory.INSTANCE.createEGraph();
        graph.addTree(graphRoot);
        return graph;
    }

    public static EGraph loadEmbeddedGraph(String embeddedGraphName, TransformationSystem ts) throws NullPointerException {
        HenshinEGraph hgr = null;
        for (Graph g : ts.getInstances()) {
            if (!g.getName().equals(embeddedGraphName)) continue;
            hgr = new HenshinEGraph(g);
            break;
        }
        if (hgr == null) {
            throw new NullPointerException("couldn't find embedded graph " + embeddedGraphName);
        }
        return hgr;
    }

    public static EGraph loadGraph(String embeddedGraphName, TransformationSystem ts) {
        return HenshinLoaders.loadEmbeddedGraph(embeddedGraphName, ts);
    }

    public static EGraph loadGraph(URI graphUri) {
        Resource resourceModel = new ResourceSetImpl().getResource(graphUri, true);
        EGraph egr = InterpreterFactory.INSTANCE.createEGraph();
        egr.addTree((EObject)resourceModel.getContents().get(0));
        return egr;
    }
}

