/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.compare.ui.editor.ModelCompareEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.ui.InterpreterUIPlugin;
import org.eclipse.emf.henshin.interpreter.ui.util.Capsule;
import org.eclipse.emf.henshin.interpreter.ui.util.Tuple;
import org.eclipse.emf.henshin.interpreter.ui.util.Tuples;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationException;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationPreview;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResult;
import org.eclipse.emf.henshin.interpreter.ui.wizard.HenshinationResultView;
import org.eclipse.emf.henshin.interpreter.ui.wizard.ParameterConfiguration;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class Henshination {
    protected TransformationUnit transformationUnit;
    protected Collection<ParameterConfiguration> paramCfgs;
    protected URI modelUri = null;
    protected EObject modelRoot;
    protected ResourceSet resourceSet;

    public URI getModelUri() {
        return this.modelUri;
    }

    public void setModelUri(URI modelUri) {
        this.modelUri = modelUri;
        this.modelRoot = null;
        this.resourceSet = new ResourceSetImpl();
        this.registerImportedPackages();
    }

    public TransformationUnit getTransformationUnit() {
        return this.transformationUnit;
    }

    public void setTransformationUnit(TransformationUnit transformationUnit, Collection<ParameterConfiguration> paramCfgs) {
        this.transformationUnit = transformationUnit;
        this.paramCfgs = paramCfgs;
        this.registerImportedPackages();
    }

    private void registerImportedPackages() {
        if (this.resourceSet == null || this.transformationUnit == null) {
            return;
        }
        TransformationSystem tSys = (TransformationSystem)this.transformationUnit.eContainer();
        for (EPackage pack : tSys.getImports()) {
            this.resourceSet.getPackageRegistry().put((Object)pack.getNsURI(), (Object)pack);
        }
    }

    public Object getParameterValue(String parameterName) {
        ParameterConfiguration pCfg = this.getParameterConfiguration(parameterName);
        if (pCfg == null) {
            return null;
        }
        return pCfg.getValue();
    }

    public ParameterConfiguration getParameterConfiguration(String parameterName) {
        for (ParameterConfiguration pCfg : this.paramCfgs) {
            if (!pCfg.getName().equals(parameterName)) continue;
            return pCfg;
        }
        return null;
    }

    public Collection<ParameterConfiguration> getParameterConfigurations() {
        return this.paramCfgs;
    }

    protected Map<String, Object> prepareParameterValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (ParameterConfiguration paramCfg : this.paramCfgs) {
            if (paramCfg.isClear()) continue;
            System.out.println(String.valueOf(paramCfg.getName()) + " => " + paramCfg.getValue() + "(" + paramCfg.getTypeLabel() + ")[isNull:" + (paramCfg.getValue() == null) + "]");
            result.put(paramCfg.getName(), paramCfg.getValue());
        }
        System.out.println(result);
        return result;
    }

    protected HenshinationResult applyTo(EObject model) throws HenshinationException {
        UnitApplication unitApplication = this.createUnitApplication(model);
        boolean result = this.runUnitApplication(unitApplication, false).getSecond();
        return new HenshinationResult(this, unitApplication, result);
    }

    protected Tuple<Boolean, Boolean> runUnitApplication(final UnitApplication ua, final boolean undoOnCancel) {
        final ApplicationMonitor appMon = InterpreterFactory.INSTANCE.createApplicationMonitor();
        final Capsule<Boolean> result = new Capsule<Boolean>(false);
        IRunnableWithProgress unitApplicationMonitor = new IRunnableWithProgress(){

            public synchronized void run(IProgressMonitor progMon) {
                Thread unitAppThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        result.setValue(ua.execute(appMon));
                    }
                });
                unitAppThread.start();
                while (unitAppThread.isAlive() && !progMon.isCanceled()) {
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (progMon.isCanceled() && unitAppThread.isAlive()) {
                    if (undoOnCancel) {
                        appMon.cancelAndUndo();
                    } else {
                        appMon.cancel();
                    }
                    try {
                        unitAppThread.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, unitApplicationMonitor);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new Tuple<Boolean, Boolean>(!appMon.isCanceled(), result.getValue());
    }

    protected UnitApplication createUnitApplication(EObject model) {
        EGraph context = InterpreterFactory.INSTANCE.createEGraph();
        context.addTree(model);
        Engine engine = InterpreterFactory.INSTANCE.createEngine();
        UnitApplication unitApplication = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        unitApplication.setEGraph(context);
        unitApplication.setUnit(this.transformationUnit);
        for (Map.Entry<String, Object> entry : this.prepareParameterValues().entrySet()) {
            unitApplication.setParameterValue(entry.getKey(), entry.getValue());
        }
        return unitApplication;
    }

    public boolean isModelAffectedByTransformation() {
        TransformationSystem tSys = (TransformationSystem)this.transformationUnit.eContainer();
        for (EPackage ep : tSys.getImports()) {
            EcoreUtil.resolveAll((EObject)ep);
        }
        return tSys.getImports().contains((Object)this.getModel().eClass().getEPackage());
    }

    public HenshinationResultView createPreview() throws HenshinationException {
        EObject originalModel = this.getModel();
        EObject previewModel = this.createCopy(originalModel);
        HenshinationResult result = this.applyTo(previewModel);
        if (!result.isSuccess()) {
            return new HenshinationResultView(){

                @Override
                public void showDialog(Shell shell) {
                    MessageBox mb = new MessageBox(shell, 40);
                    mb.setText(InterpreterUIPlugin.LL("_UI_Preview_ApplicationNotSuccessful_Title"));
                    mb.setMessage(InterpreterUIPlugin.LL("_UI_Preview_ApplicationNotSuccessful_Message"));
                    mb.open();
                }
            };
        }
        try {
            MatchModel matchModel = MatchService.doMatch((EObject)previewModel, (EObject)originalModel, Collections.emptyMap());
            DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
            ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
            snapshot.setMatch(matchModel);
            snapshot.setDiff(diffModel);
            ModelCompareEditorInput input = new ModelCompareEditorInput((ComparisonSnapshot)snapshot);
            return new HenshinationPreview(input, result);
        }
        catch (Exception exception) {
            return new HenshinationPreview(null, result);
        }
    }

    protected EObject createCopy(EObject eobj) {
        EObject result = EcoreUtil.copy((EObject)eobj);
        ResourceImpl resource = new ResourceImpl();
        resource.setURI(URI.createURI((String)"dummy"));
        resource.getContents().add((Object)result);
        return result;
    }

    public EObject getModel() {
        Resource res;
        if (this.modelRoot != null) {
            return this.modelRoot;
        }
        if (this.modelUri == null || this.modelUri.isEmpty()) {
            return null;
        }
        Map extReg = this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!extReg.containsKey(this.modelUri.fileExtension())) {
            extReg.put(this.modelUri.fileExtension(), new XMIResourceFactoryImpl());
        }
        try {
            res = this.resourceSet.getResource(this.modelUri, true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load Resource");
        }
        if (res.getContents().size() == 0) {
            throw new RuntimeException("Resource is empty");
        }
        this.modelRoot = (EObject)res.getContents().get(0);
        return this.modelRoot;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.transformationUnit.getName() + " " + this.paramCfgs.toString();
    }

    public IUndoableOperation getUndoableOperation() {
        Object resSet = this.resourceSet != null ? this.resourceSet : new ResourceSetImpl();
        Map extReg = resSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!extReg.containsKey(this.modelUri.fileExtension())) {
            extReg.put(this.modelUri.fileExtension(), new XMIResourceFactoryImpl());
        }
        final Resource resource = resSet.getResource(this.modelUri, true);
        final UnitApplication unitApplication = this.createUnitApplication((EObject)resource.getContents().get(0));
        String title = String.valueOf(InterpreterUIPlugin.LL("_UI_UndoableOperation_Henshin")) + ": " + this.getTransformationUnit().getName();
        AbstractOperation operation = new AbstractOperation(title){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    if (Tuples.and(Henshination.this.runUnitApplication(unitApplication, true)).booleanValue()) {
                        resource.save(null);
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", "Canceled by user!");
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    unitApplication.redo(null);
                    resource.save(null);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    unitApplication.undo(null);
                    resource.save(null);
                }
                catch (Exception e) {
                    return new Status(4, "org.eclipse.emf.henshin.interpreter.ui", e.getMessage());
                }
                return Status.OK_STATUS;
            }
        };
        operation.addContext(IOperationHistory.GLOBAL_UNDO_CONTEXT);
        return operation;
    }
}

