/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.TransformationSystemEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.UnitCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.part.HenshinDiagramEditorPlugin;
import org.eclipse.emf.henshin.diagram.part.Messages;
import org.eclipse.emf.henshin.diagram.providers.HenshinElementTypes;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class HenshinModelingAssistantProvider
extends ModelingAssistantProvider {
    public List getTypesForPopupBar(IAdaptable host) {
        IGraphicalEditPart editPart = (IGraphicalEditPart)host.getAdapter(IGraphicalEditPart.class);
        if (editPart instanceof TransformationSystemEditPart) {
            ArrayList<IElementType> types = new ArrayList<IElementType>(2);
            types.add(HenshinElementTypes.Rule_2001);
            types.add(HenshinElementTypes.TransformationUnit_2002);
            return types;
        }
        if (editPart instanceof NodeEditPart) {
            ArrayList<IElementType> types = new ArrayList<IElementType>(1);
            types.add(HenshinElementTypes.Attribute_3002);
            return types;
        }
        if (editPart instanceof RuleCompartmentEditPart) {
            ArrayList<IElementType> types = new ArrayList<IElementType>(1);
            types.add(HenshinElementTypes.Node_3001);
            return types;
        }
        if (editPart instanceof UnitCompartmentEditPart) {
            ArrayList<IElementType> types = new ArrayList<IElementType>(2);
            types.add(HenshinElementTypes.Node_3004);
            types.add(HenshinElementTypes.TransformationUnit_3003);
            return types;
        }
        return Collections.EMPTY_LIST;
    }

    public List getRelTypesOnSource(IAdaptable source) {
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)source.getAdapter(IGraphicalEditPart.class);
        if (sourceEditPart instanceof NodeEditPart) {
            return ((NodeEditPart)sourceEditPart).getMARelTypesOnSource();
        }
        return Collections.EMPTY_LIST;
    }

    public List getRelTypesOnTarget(IAdaptable target) {
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart)target.getAdapter(IGraphicalEditPart.class);
        if (targetEditPart instanceof NodeEditPart) {
            return ((NodeEditPart)targetEditPart).getMARelTypesOnTarget();
        }
        return Collections.EMPTY_LIST;
    }

    public List getRelTypesOnSourceAndTarget(IAdaptable source, IAdaptable target) {
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)source.getAdapter(IGraphicalEditPart.class);
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart)target.getAdapter(IGraphicalEditPart.class);
        if (sourceEditPart instanceof NodeEditPart) {
            return ((NodeEditPart)sourceEditPart).getMARelTypesOnSourceAndTarget(targetEditPart);
        }
        return Collections.EMPTY_LIST;
    }

    public List getTypesForSource(IAdaptable target, IElementType relationshipType) {
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart)target.getAdapter(IGraphicalEditPart.class);
        if (targetEditPart instanceof NodeEditPart) {
            return ((NodeEditPart)targetEditPart).getMATypesForSource(relationshipType);
        }
        return Collections.EMPTY_LIST;
    }

    public List getTypesForTarget(IAdaptable source, IElementType relationshipType) {
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart)source.getAdapter(IGraphicalEditPart.class);
        if (sourceEditPart instanceof NodeEditPart) {
            return ((NodeEditPart)sourceEditPart).getMATypesForTarget(relationshipType);
        }
        return Collections.EMPTY_LIST;
    }

    public EObject selectExistingElementForSource(IAdaptable target, IElementType relationshipType) {
        return this.selectExistingElement(target, this.getTypesForSource(target, relationshipType));
    }

    public EObject selectExistingElementForTarget(IAdaptable source, IElementType relationshipType) {
        return this.selectExistingElement(source, this.getTypesForTarget(source, relationshipType));
    }

    protected EObject selectExistingElement(IAdaptable host, Collection types) {
        if (types.isEmpty()) {
            return null;
        }
        IGraphicalEditPart editPart = (IGraphicalEditPart)host.getAdapter(IGraphicalEditPart.class);
        if (editPart == null) {
            return null;
        }
        Diagram diagram = (Diagram)editPart.getRoot().getContents().getModel();
        HashSet<EObject> elements = new HashSet<EObject>();
        TreeIterator it = diagram.getElement().eAllContents();
        while (it.hasNext()) {
            EObject element = (EObject)it.next();
            if (!this.isApplicableElement(element, types)) continue;
            elements.add(element);
        }
        if (elements.isEmpty()) {
            return null;
        }
        return this.selectElement(elements.toArray(new EObject[elements.size()]));
    }

    protected boolean isApplicableElement(EObject element, Collection types) {
        IElementType type = ElementTypeRegistry.getInstance().getElementType(element);
        return types.contains(type);
    }

    protected EObject selectElement(EObject[] elements) {
        Shell shell = Display.getCurrent().getActiveShell();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(HenshinDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setMessage(Messages.HenshinModelingAssistantProviderMessage);
        dialog.setTitle(Messages.HenshinModelingAssistantProviderTitle);
        dialog.setMultipleSelection(false);
        dialog.setElements((Object[])elements);
        EObject selected = null;
        if (dialog.open() == 0) {
            selected = (EObject)dialog.getFirstResult();
        }
        return selected;
    }
}

