/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.parsers;

import java.text.ParseException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.diagram.parsers.AbstractParser;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.Action;
import org.eclipse.emf.henshin.model.actions.ActionType;
import org.eclipse.emf.henshin.model.actions.HenshinActionHelper;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class AttributeParser
extends AbstractParser {
    public AttributeParser() {
        super(new EAttribute[]{HenshinPackage.eINSTANCE.getNamedElement_Name()});
    }

    public String getEditString(IAdaptable element, int flags) {
        Rule rule;
        Attribute image;
        if (!(element.getAdapter(EObject.class) instanceof Attribute)) {
            return "?";
        }
        Attribute attribute = (Attribute)element.getAdapter(EObject.class);
        String type = attribute.getType() != null ? attribute.getType().getName() : null;
        String result = String.valueOf(type) + "=" + attribute.getValue();
        if (attribute.getNode() == null || attribute.getNode().getGraph() == null || attribute.getNode().getGraph().getContainerRule() == null) {
            return result;
        }
        Action action = HenshinActionHelper.getAction((Attribute)attribute);
        Node actionNode = HenshinActionHelper.getActionNode((Node)attribute.getNode());
        Action nodeAction = HenshinActionHelper.getAction((Node)actionNode);
        if (action != null && !action.equals((Object)nodeAction) && action.getType() == ActionType.FORBID) {
            result = "<<" + action + ">> " + result;
        }
        if (nodeAction.getType() == ActionType.PRESERVE && (image = HenshinMappingUtil.getAttributeImage((Attribute)attribute, (Graph)(rule = attribute.getNode().getGraph().getContainerRule()).getRhs(), (List)rule.getMappings())) != null && !String.valueOf(attribute.getValue()).equals(String.valueOf(image.getValue()))) {
            result = String.valueOf(result) + "->" + image.getValue();
        }
        return result;
    }

    public String getPrintString(IAdaptable element, int flags) {
        return this.getEditString(element, flags);
    }

    public ICommand getParseCommand(IAdaptable element, final String value, int flags) {
        final Attribute attribute = (Attribute)element.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)attribute);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Parse Attribute", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return AttributeParser.this.doParsing(value, attribute);
            }
        };
        return command;
    }

    private CommandResult doParsing(String value, Attribute attribute) {
        Rule rule;
        Attribute image;
        int equalSign;
        Node actionNode;
        Action nodeAction;
        ActionType nodeActionType;
        boolean compatible;
        Node node = attribute.getNode();
        if (node == null || node.getType() == null) {
            return CommandResult.newErrorCommandResult((String)"Node and node type must be set");
        }
        if (node.getGraph() == null || node.getGraph().getContainerRule() == null) {
            return CommandResult.newErrorCommandResult((String)"Node is not properly contained in a graph/rule");
        }
        Action action = new Action(ActionType.PRESERVE, new String[0]);
        if ((value = value.trim()).startsWith("<<")) {
            value = value.substring(2);
            int end = value.indexOf(">>");
            try {
                action = Action.parse((String)value.substring(0, end));
            }
            catch (ParseException e) {
                return CommandResult.newErrorCommandResult((Throwable)e);
            }
            value = value.substring(end + 2);
        }
        boolean bl = compatible = (nodeActionType = (nodeAction = HenshinActionHelper.getAction((Node)(actionNode = HenshinActionHelper.getActionNode((Node)node)))).getType()) == ActionType.PRESERVE || nodeActionType == ActionType.DELETE && action.getType() == ActionType.FORBID;
        if (!compatible) {
            action = nodeAction;
        }
        if ((equalSign = value.indexOf(61)) < 0) {
            return CommandResult.newErrorCommandResult((String)"Expected '='");
        }
        String type = value.substring(0, equalSign).trim();
        String val = value.substring(equalSign + 1).trim();
        String newVal = null;
        int arrow = val.indexOf("->");
        if (arrow >= 0) {
            newVal = val.substring(arrow + 2).trim();
            val = val.substring(0, arrow).trim();
        }
        EAttribute attr = null;
        for (EAttribute current : node.getType().getEAllAttributes()) {
            if (!type.equals(current.getName())) continue;
            attr = current;
            break;
        }
        if (attr == null) {
            return CommandResult.newErrorCommandResult((String)("Unknown attribute: " + type));
        }
        if (action.getType() == ActionType.PRESERVE && (image = HenshinMappingUtil.getAttributeImage((Attribute)attribute, (Graph)(rule = node.getGraph().getContainerRule()).getRhs(), (List)rule.getMappings())) != null) {
            image.setValue(newVal != null && newVal.length() > 0 ? newVal : val);
            image.setType(attr);
        }
        attribute.setValue("?");
        attribute.setValue(val);
        attribute.setType(attr);
        Action currentAction = HenshinActionHelper.getAction((Attribute)attribute);
        if (currentAction != null && !currentAction.equals((Object)action)) {
            HenshinActionHelper.setAction((Attribute)attribute, (Action)action);
        }
        return CommandResult.newOKCommandResult();
    }

    @Override
    protected boolean isAffectingFeature(Object feature) {
        if (feature == HenshinPackage.eINSTANCE.getAttribute_Value()) {
            return true;
        }
        return feature == HenshinPackage.eINSTANCE.getAttribute_Type();
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.EDITABLE_STATUS;
    }
}

