/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.tuples;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.tuples.Tuple;
import org.eclipse.emf.henshin.statespace.tuples.TupleGenerator;

public class EcoreTupleGenerator
implements TupleGenerator {
    private static final List<EDataType> SUPPORTED_ATTRIBUTE_TYPES = new ArrayList<EDataType>();
    private int tupleSize;
    private StateSpaceIndex stateSpaceIndex;
    private List<EClass> usedTypes;
    private int[] maxLocalWidths;
    private Map<EReference, Integer> maxLinks;
    private int maxObjects;
    private int maxObjectSize;
    private EObject[][] cachedLayers;

    static {
        SUPPORTED_ATTRIBUTE_TYPES.add(EcorePackage.eINSTANCE.getEInt());
        SUPPORTED_ATTRIBUTE_TYPES.add(EcorePackage.eINSTANCE.getEBoolean());
    }

    @Override
    public Tuple createTuple(State state) throws StateSpaceException {
        Model model = this.stateSpaceIndex.getModel(state);
        EqualityHelper equalityHelper = this.stateSpaceIndex.getStateSpace().getEqualityHelper();
        Object[] rootLayer = model.getResource().getContents().toArray();
        Arrays.fill(this.cachedLayers[0], null);
        System.arraycopy(rootLayer, 0, this.cachedLayers[0], 0, rootLayer.length);
        int y = 1;
        while (y < this.cachedLayers.length) {
            Arrays.fill(this.cachedLayers[y], null);
            int x = 0;
            while (x < this.cachedLayers[y - 1].length) {
                EObject obj = this.cachedLayers[y - 1][x];
                if (obj != null) {
                    Object[] children = obj.eContents().toArray();
                    int pos = x * this.maxLocalWidths[y];
                    System.arraycopy(children, 0, this.cachedLayers[y], pos, children.length);
                }
                ++x;
            }
            ++y;
        }
        ArrayList<EObject> objects = new ArrayList<EObject>(this.maxObjects);
        int y2 = 0;
        while (y2 < this.cachedLayers.length) {
            int x = 0;
            while (x < this.cachedLayers[y2].length) {
                objects.add(this.cachedLayers[y2][x]);
                ++x;
            }
            ++y2;
        }
        Tuple tuple = new Tuple(this.tupleSize);
        int[] data = tuple.data();
        int node = 0;
        int y3 = 0;
        while (y3 < this.cachedLayers.length) {
            int x = 0;
            while (x < this.cachedLayers[y3].length) {
                EObject obj = this.cachedLayers[y3][x];
                if (obj != null) {
                    EClass type = obj.eClass();
                    int pos = node * this.maxObjectSize;
                    data[pos++] = this.usedTypes.indexOf(type);
                    for (EAttribute att : type.getEAllAttributes()) {
                        if (equalityHelper.getIgnoredAttributes().contains((Object)att)) continue;
                        if (att.isMany() || !SUPPORTED_ATTRIBUTE_TYPES.contains(att.getEAttributeType())) {
                            throw new StateSpaceException("Unsupported attribute: " + att.getName());
                        }
                        Object value = obj.eGet((EStructuralFeature)att);
                        if (value instanceof Integer) {
                            data[pos++] = (Integer)value;
                            continue;
                        }
                        int n = data[pos++] = (Boolean)value != false ? 1 : 0;
                    }
                    EList refs = type.getEAllReferences();
                    int k = 0;
                    while (k < refs.size()) {
                        EReference ref = (EReference)refs.get(k);
                        if (ref.isMany()) {
                            List links = (List)obj.eGet((EStructuralFeature)ref);
                            int l = 0;
                            while (l < links.size()) {
                                data[pos + l] = objects.indexOf(links.get(l)) + 1;
                                ++l;
                            }
                        } else {
                            Object link = obj.eGet((EStructuralFeature)ref);
                            if (link != null) {
                                data[pos] = objects.indexOf(link) + 1;
                            }
                        }
                        pos += this.maxLinks.get(ref).intValue();
                        ++k;
                    }
                    ++node;
                }
                ++x;
            }
            ++y3;
        }
        return tuple;
    }

    @Override
    public void initialize(StateSpaceIndex index, IProgressMonitor monitor) throws StateSpaceException {
        monitor.beginTask("Initialize tuple generator", index.getStateSpace().getStates().size());
        this.stateSpaceIndex = index;
        EqualityHelper equalityHelper = index.getStateSpace().getEqualityHelper();
        this.usedTypes = new ArrayList<EClass>();
        this.maxLocalWidths = new int[0];
        this.maxLinks = new HashMap<EReference, Integer>();
        for (State state : this.stateSpaceIndex.getStateSpace().getStates()) {
            Model model = this.stateSpaceIndex.getModel(state);
            this.updateInfo(model);
            monitor.worked(1);
        }
        if (this.maxLocalWidths.length == 0) {
            monitor.done();
            return;
        }
        this.maxObjectSize = 0;
        for (EClass type : this.usedTypes) {
            int space = 1;
            for (EAttribute attribute : type.getEAllAttributes()) {
                if (equalityHelper.getIgnoredAttributes().contains((Object)attribute)) continue;
                ++space;
            }
            for (EReference ref : type.getEAllReferences()) {
                space += this.maxLinks.get(ref).intValue();
            }
            this.maxObjectSize = Math.max(this.maxObjectSize, space);
        }
        int[] maxLayerWidths = new int[this.maxLocalWidths.length];
        maxLayerWidths[0] = this.maxLocalWidths[0];
        int i = 1;
        while (i < maxLayerWidths.length) {
            maxLayerWidths[i] = maxLayerWidths[i - 1] * this.maxLocalWidths[i];
            ++i;
        }
        this.maxObjects = 0;
        i = 0;
        while (i < maxLayerWidths.length) {
            this.maxObjects += maxLayerWidths[i];
            ++i;
        }
        this.tupleSize = this.maxObjects * this.maxObjectSize;
        this.cachedLayers = new EObject[maxLayerWidths.length][];
        i = 0;
        while (i < maxLayerWidths.length) {
            this.cachedLayers[i] = new EObject[maxLayerWidths[i]];
            ++i;
        }
        monitor.done();
    }

    private void updateInfo(Model model) {
        Object layer = model.getResource().getContents();
        if (layer.isEmpty()) {
            return;
        }
        if (this.maxLocalWidths.length == 0) {
            this.maxLocalWidths = new int[1];
        }
        this.maxLocalWidths[0] = Math.max(this.maxLocalWidths[0], layer.size());
        int level = 0;
        while (!layer.isEmpty()) {
            ArrayList nextLayer = new ArrayList();
            int maxChildren = 0;
            for (EObject obj : layer) {
                EClass type = obj.eClass();
                if (!this.usedTypes.contains(type)) {
                    this.usedTypes.add(type);
                }
                for (EReference ref : type.getEAllReferences()) {
                    Object tar = obj.eGet((EStructuralFeature)ref);
                    int links = ref.isMany() ? ((List)tar).size() : (tar != null ? 1 : 0);
                    Integer oldLinks = this.maxLinks.get(ref);
                    if (oldLinks == null) {
                        this.maxLinks.put(ref, links);
                        continue;
                    }
                    this.maxLinks.put(ref, Math.max(links, oldLinks));
                }
                EList children = obj.eContents();
                maxChildren = Math.max(maxChildren, children.size());
                nextLayer.addAll(children);
            }
            if (maxChildren == 0) break;
            if (this.maxLocalWidths.length <= ++level) {
                this.maxLocalWidths = Arrays.copyOf(this.maxLocalWidths, level + 1);
            }
            this.maxLocalWidths[level] = Math.max(this.maxLocalWidths[level], maxChildren);
            layer = nextLayer;
        }
    }
}

