/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.SingleThreadedStateSpaceManager;
import org.eclipse.emf.henshin.statespace.impl.StateExplorer;

public class ProfilingStateSpaceManager
extends SingleThreadedStateSpaceManager {
    protected long explorationTime = 0L;
    protected long derivationTime = 0L;
    protected long stateFindingTime = 0L;
    protected long lastPrintTime = System.currentTimeMillis();
    protected long printInterval = 5000L;

    public ProfilingStateSpaceManager(StateSpace stateSpace) {
        super(stateSpace);
    }

    @Override
    protected State getState(Model model, int hash) throws StateSpaceException {
        long time = System.currentTimeMillis();
        State state = super.getState(model, hash);
        this.stateFindingTime += System.currentTimeMillis() - time;
        return state;
    }

    @Override
    protected State findState(Model model, int hashCode, Collection<State> states) throws StateSpaceException {
        long time = System.currentTimeMillis();
        State state = super.findState(model, hashCode, states);
        this.stateFindingTime += System.currentTimeMillis() - time;
        return state;
    }

    @Override
    protected Model deriveModel(State state, boolean fromInitial) throws StateSpaceException {
        long time = System.currentTimeMillis();
        Model model = super.deriveModel(state, fromInitial);
        this.derivationTime += System.currentTimeMillis() - time;
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateExplorer acquireExplorer() {
        Stack stack = this.explorers;
        synchronized (stack) {
            try {
                return (StateExplorer)this.explorers.pop();
            }
            catch (Throwable throwable) {
                return new ProfilingStateExplorer(this);
            }
        }
    }

    public void printStats() {
        System.out.println("Exploration time:   " + this.explorationTime);
        System.out.println("State finding time: " + this.stateFindingTime);
        System.out.println("Derivation time:    " + this.derivationTime + "\n");
        this.lastPrintTime = System.currentTimeMillis();
    }

    private class ProfilingStateExplorer
    extends StateExplorer {
        public ProfilingStateExplorer(StateSpaceManager manager) {
            super(manager);
        }

        @Override
        public List<Transition> doExplore(State state) throws StateSpaceException {
            long time = System.currentTimeMillis();
            List<Transition> result = super.doExplore(state);
            ProfilingStateSpaceManager.this.explorationTime += System.currentTimeMillis() - time;
            if (time > ProfilingStateSpaceManager.this.lastPrintTime + ProfilingStateSpaceManager.this.printInterval) {
                ProfilingStateSpaceManager.this.printStats();
            }
            return result;
        }
    }
}

