/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;
import org.eclipse.emf.henshin.statespace.validation.StateSpaceXYPlot;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class PRISMExperiment {
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ENGLISH);
    private Map<String, Double> constants = new LinkedHashMap<String, Double>();
    private double result = 0.0;

    public double getResult() {
        return this.result;
    }

    public void setResult(double result) {
        this.result = result;
    }

    public Map<String, Double> getConstants() {
        return this.constants;
    }

    public static PRISMExperiment parse(BufferedReader reader, IProgressMonitor monitor) throws Exception {
        PRISMExperiment experiment = new PRISMExperiment();
        String line = null;
        String error = null;
        boolean parseError = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) {
                if (!parseError) continue;
                throw new RuntimeException(error);
            }
            if (parseError) {
                error = String.valueOf(error) + "\n" + line;
            } else if (line.startsWith("Error")) {
                error = line;
                parseError = true;
            } else if (line.startsWith("Model constants:") && experiment.getConstants().isEmpty()) {
                String[] constants;
                System.out.println("\n" + line);
                line = line.substring("Model constants:".length()).trim();
                String[] stringArray = constants = line.split(",");
                int n = constants.length;
                int n2 = 0;
                while (n2 < n) {
                    String constant = stringArray[n2];
                    String[] keyval = constant.split("=");
                    if (keyval.length != 2) {
                        throw new RuntimeException("Unexpected PRISM output");
                    }
                    experiment.getConstants().put(keyval[0], NUMBER_FORMAT.parse(keyval[1]).doubleValue());
                    ++n2;
                }
            } else if (line.startsWith("Result:")) {
                System.out.println(line);
                line = line.substring("Result:".length()).trim();
                experiment.setResult(NUMBER_FORMAT.parse(line).doubleValue());
                return experiment;
            }
            if (!monitor.isCanceled()) continue;
            return null;
        }
        if (parseError) {
            throw new RuntimeException(error);
        }
        return null;
    }

    public static List<PRISMExperiment> parseAll(Process process, IProgressMonitor monitor) throws Exception {
        PRISMExperiment next;
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<PRISMExperiment> experiments = new ArrayList<PRISMExperiment>();
        while ((next = PRISMExperiment.parse(reader, monitor)) != null) {
            experiments.add(next);
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        return experiments;
    }

    /*
     * WARNING - void declaration
     */
    public static StateSpaceXYPlot generatePlot(StateSpace stateSpace, List<PRISMExperiment> experiments) {
        Set<String> parameters = experiments.get(0).getConstants().keySet();
        ArrayList<String> changing = new ArrayList<String>();
        block0: for (String param : parameters) {
            int i = 1;
            while (i < experiments.size()) {
                double val2;
                double val1 = experiments.get(i - 1).getConstants().get(param);
                if (val1 != (val2 = experiments.get(i).getConstants().get(param).doubleValue())) {
                    changing.add(param);
                    continue block0;
                }
                ++i;
            }
        }
        String variable = (String)changing.get(0);
        String userPreference = PRISMUtil.getPRISMExperiment(stateSpace);
        if (userPreference != null && changing.contains(userPreference)) {
            variable = userPreference;
        }
        ArrayList plots = new ArrayList();
        for (PRISMExperiment experiment1 : experiments) {
            boolean found = false;
            for (List list : plots) {
                PRISMExperiment experiment2 = (PRISMExperiment)list.get(0);
                boolean compatible = true;
                for (String param : parameters) {
                    Double val1 = experiment1.getConstants().get(param);
                    Double val2 = experiment2.getConstants().get(param);
                    if (param.equals(variable) || val1.equals(val2)) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                list.add(experiment1);
                found = true;
                break;
            }
            if (found) continue;
            plots.add(new ArrayList());
            ((List)plots.get(plots.size() - 1)).add(experiment1);
        }
        double[][] xValues = new double[plots.size()][];
        double[][] yValues = new double[plots.size()][];
        int i = 0;
        while (i < plots.size()) {
            List list = (List)plots.get(i);
            int length = list.size();
            xValues[i] = new double[length];
            yValues[i] = new double[length];
            int j = 0;
            while (j < length) {
                xValues[i][j] = ((PRISMExperiment)list.get(j)).getConstants().get(variable);
                yValues[i][j] = ((PRISMExperiment)list.get(j)).getResult();
                ++j;
            }
            ++i;
        }
        String[] legend = null;
        if (plots.size() > 1) {
            void var10_20;
            legend = new String[plots.size()];
            boolean bl = false;
            while (var10_20 < legend.length) {
                legend[var10_20] = "";
                for (String param : changing) {
                    if (param.equals(variable)) continue;
                    if (legend[var10_20].length() > 0) {
                        legend[var10_20] = String.valueOf(legend[var10_20]) + ",";
                    }
                    String value = NUMBER_FORMAT.format(experiments.get((int)var10_20).getConstants().get(param));
                    legend[var10_20] = String.valueOf(legend[var10_20]) + param + "=" + value;
                }
                ++var10_20;
            }
        }
        StateSpaceXYPlot stateSpaceXYPlot = new StateSpaceXYPlot(variable, "Result", (double[][])xValues, (double[][])yValues, legend);
        System.out.println(stateSpaceXYPlot);
        return stateSpaceXYPlot;
    }

    public static ValidationResult parseValidationResult(StateSpace stateSpace, Process process, IProgressMonitor monitor) throws Exception {
        List<PRISMExperiment> experiments = PRISMExperiment.parseAll(process, monitor);
        if (experiments.isEmpty()) {
            throw new RuntimeException("Unexpected PRISM output");
        }
        if (experiments.size() == 1) {
            return new ValidationResult(true, "Result: " + NUMBER_FORMAT.format(experiments.get(0).getResult()));
        }
        StateSpaceXYPlot plot = PRISMExperiment.generatePlot(stateSpace, experiments);
        return new ValidationResult(true, null, (Object)plot);
    }
}

