/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;

public class HenshinGraph
extends EmfGraph
implements Adapter {
    private Graph henshinGraph;
    private Map<Node, EObject> node2eObjectMap = new HashMap<Node, EObject>();
    private Map<EObject, Node> eObject2nodeMap = new HashMap<EObject, Node>();

    public HenshinGraph(Graph graph) {
        this.henshinGraph = graph;
        this.henshin2emfGraph();
    }

    private void henshin2emfGraph() {
        this.eObjects.clear();
        this.eObject2nodeMap.clear();
        this.node2eObjectMap.clear();
        for (Node node : this.henshinGraph.getNodes()) {
            EObject eObject = this.node2eObjectMap.get(node);
            if (eObject == null) {
                EClass nodeType = node.getType();
                Iterator factory = nodeType.getEPackage().getEFactoryInstance();
                eObject = factory.create(nodeType);
                this.addEObjectToGraph(eObject);
                this.addSynchronizedPair(node, eObject);
            }
            for (Attribute attr : node.getAttributes()) {
                eObject.eAdapters().remove((Object)this);
                EAttribute attrType = attr.getType();
                String attrValue = attr.getValue();
                attrValue = attrValue.replaceAll("\"", "");
                if (attrType.isMany()) {
                    List attrValues = (List)eObject.eGet((EStructuralFeature)attrType);
                    attrValues.add(attrValue);
                } else {
                    eObject.eSet((EStructuralFeature)attrType, EcoreUtil.createFromString((EDataType)attrType.getEAttributeType(), (String)attrValue));
                }
                eObject.eAdapters().add((Object)this);
            }
        }
        for (Edge edge : new ArrayList(this.henshinGraph.getEdges())) {
            EReference edgeType = edge.getType();
            if (edgeType.isDerived()) continue;
            EObject ownerObject = this.node2eObjectMap.get(edge.getSource());
            EObject targetObject = this.node2eObjectMap.get(edge.getTarget());
            if (!edgeType.isChangeable()) {
                if (edgeType.getEOpposite() == null || !edgeType.getEOpposite().isChangeable()) continue;
                edgeType = edgeType.getEOpposite();
                EObject temp = ownerObject;
                ownerObject = targetObject;
                targetObject = temp;
            }
            ownerObject.eAdapters().remove((Object)this);
            if (edgeType.isMany()) {
                List edgeValues = (List)ownerObject.eGet((EStructuralFeature)edgeType);
                edgeValues.add(targetObject);
            } else {
                ownerObject.eSet((EStructuralFeature)edgeType, (Object)targetObject);
            }
            ownerObject.eAdapters().add((Object)this);
        }
    }

    public boolean addEObject(EObject eObject) {
        boolean isNew = super.addEObject(eObject);
        if (isNew) {
            HenshinFactory factory = HenshinFactory.eINSTANCE;
            Node node = this.eObject2nodeMap.get(eObject);
            if (node == null) {
                node = factory.createNode();
                node.setType(eObject.eClass());
                this.henshinGraph.getNodes().add((Object)node);
                this.addSynchronizedPair(node, eObject);
            } else if (!this.henshinGraph.getNodes().contains((Object)node)) {
                this.henshinGraph.getNodes().add((Object)node);
            }
        }
        return isNew;
    }

    public boolean removeEObject(EObject eObject) {
        Node node;
        boolean wasRemoved = super.removeEObject(eObject);
        if (wasRemoved && (node = this.eObject2nodeMap.get(eObject)) != null) {
            this.henshinGraph.getNodes().remove((Object)node);
            ArrayList list = new ArrayList(node.getIncoming());
            list.addAll(node.getOutgoing());
            for (Edge edge : list) {
                edge.setSource(null);
                edge.setTarget(null);
                edge.setGraph(null);
            }
            this.removeSynchronizedPair(node, eObject);
        }
        return wasRemoved;
    }

    public void updateEmfGraph() {
        this.henshin2emfGraph();
    }

    private void addSynchronizedPair(Node node, EObject eObject) {
        this.node2eObjectMap.put(node, eObject);
        this.eObject2nodeMap.put(eObject, node);
        eObject.eAdapters().add((Object)this);
    }

    private void removeSynchronizedPair(Node node, EObject eObject) {
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
        EObject owner = (EObject)notification.getNotifier();
        Node ownerNode = this.eObject2nodeMap.get(owner);
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (feature instanceof EStructuralFeature && ownerNode != null) {
            if (oldValue != null && newValue != oldValue) {
                this.removeFromHenshinGraph(ownerNode, (EStructuralFeature)feature, oldValue);
            }
            if (newValue != null) {
                this.addToHenshinGraph(owner, (EStructuralFeature)feature, newValue);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
    }

    private void removeFromHenshinGraph(Node owner, EStructuralFeature feature, Object value) {
        if (feature instanceof EAttribute) {
            Attribute attribute = null;
            for (Attribute nodeAttribute : owner.getAttributes()) {
                if (nodeAttribute.getType() != feature) continue;
                attribute = nodeAttribute;
                break;
            }
            if (attribute != null) {
                attribute.setNode(null);
            }
        } else if (feature instanceof EReference) {
            Edge edge = null;
            if (value instanceof EObject) {
                Node targetNode = this.eObject2nodeMap.get(value);
                for (Edge outgoingEdge : owner.getOutgoing()) {
                    if (outgoingEdge.getTarget() != targetNode || outgoingEdge.getType() != feature) continue;
                    edge = outgoingEdge;
                    break;
                }
                if (edge != null) {
                    edge.setSource(null);
                    edge.setTarget(null);
                    edge.setGraph(null);
                }
            }
        }
    }

    private void addToHenshinGraph(EObject owner, EStructuralFeature feature, Object value) {
        Node node = this.eObject2nodeMap.get(owner);
        if (node != null && value != null) {
            if (feature instanceof EAttribute) {
                Attribute attribute = null;
                for (Attribute nodeAttribute : node.getAttributes()) {
                    if (nodeAttribute.getType() != feature) continue;
                    attribute = nodeAttribute;
                    break;
                }
                if (attribute == null) {
                    attribute = HenshinFactory.eINSTANCE.createAttribute();
                    attribute.setType((EAttribute)feature);
                    attribute.setNode(node);
                }
                attribute.setValue(value.toString());
            } else if (feature instanceof EReference) {
                Edge edge = null;
                if (value instanceof EObject) {
                    Node targetNode = this.eObject2nodeMap.get(value);
                    for (Edge outgoingEdge : node.getOutgoing()) {
                        if (outgoingEdge.getTarget() != targetNode || outgoingEdge.getType() != feature) continue;
                        edge = outgoingEdge;
                        break;
                    }
                    if (edge == null) {
                        edge = HenshinFactory.eINSTANCE.createEdge();
                        edge.setSource(node);
                        edge.setTarget(targetNode);
                        edge.setGraph(this.henshinGraph);
                        edge.setType((EReference)feature);
                    }
                }
            }
        }
    }

    public Map<Node, EObject> getNode2eObjectMap() {
        return this.node2eObjectMap;
    }

    public void setNode2eObjectMap(Map<Node, EObject> node2eObjectMap) {
        this.node2eObjectMap = node2eObjectMap;
    }

    public Map<EObject, Node> geteObject2nodeMap() {
        return this.eObject2nodeMap;
    }

    public void seteObject2nodeMap(Map<EObject, Node> eObject2nodeMap) {
        this.eObject2nodeMap = eObject2nodeMap;
    }
}

