/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceExporter;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateSpaceEditPart;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportStateSpaceWizard
extends Wizard
implements IExportWizard {
    private FileCreationPage fileCreationPage;
    private ChooseExporterPage chooseExporterPage;
    private IWorkbench workbench;
    private StateSpace stateSpace;
    private IStructuredSelection selection;
    private String baseName;
    private ImageDescriptor wizban = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/wizban/export_wiz.png");

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Export State Space");
        this.workbench = workbench;
        this.selection = selection;
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext() && this.stateSpace == null) {
                Object current = iterator.next();
                if (current instanceof StateSpaceEditPart) {
                    this.stateSpace = ((StateSpaceEditPart)((Object)current)).getStateSpace();
                    continue;
                }
                if (!(current instanceof IFile)) continue;
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                URI fileURI = URI.createPlatformResourceURI((String)((IFile)current).getFullPath().toString(), (boolean)true);
                try {
                    this.stateSpace = ((StateSpaceResource)resourceSet.createResource(fileURI)).getStateSpace();
                }
                catch (Throwable t) {
                    StateSpaceExplorerPlugin.getInstance().logError("Error loading state space from file " + fileURI.toFileString(), t);
                }
            }
        }
        if (this.stateSpace == null) {
            throw new RuntimeException("State space not set");
        }
        this.baseName = this.stateSpace.eResource().getURI().trimFileExtension().lastSegment();
    }

    public void addPages() {
        this.chooseExporterPage = new ChooseExporterPage("exporter-selection");
        this.addPage((IWizardPage)this.chooseExporterPage);
        this.fileCreationPage = new FileCreationPage("file-creation", this.selection);
        this.addPage((IWizardPage)this.fileCreationPage);
    }

    private void updateFileName(String ext) {
        String directory = this.stateSpace.eResource().getURI().trimSegments(1).toPlatformString(true);
        IContainer container = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(directory));
        this.fileCreationPage.setContainerFullPath(container.getFullPath());
        String filename = String.valueOf(this.baseName) + "." + ext;
        int i = 1;
        while (container.findMember(filename) != null) {
            filename = String.valueOf(this.baseName) + i + "." + ext;
            ++i;
        }
        this.fileCreationPage.setFileName(filename);
    }

    private String printAllowedExtensions(StateSpaceExporter exporter) {
        String[] allowed = exporter.getFileExtensions();
        String pretty = "";
        int i = 0;
        while (i < allowed.length) {
            pretty = String.valueOf(pretty) + "*." + allowed[i];
            if (i < allowed.length - 1) {
                pretty = String.valueOf(pretty) + ", ";
            }
            ++i;
        }
        return pretty;
    }

    public void setStateSpace(StateSpace stateSpace) {
        this.stateSpace = stateSpace;
    }

    public boolean performFinish() {
        try {
            final IFile file = this.getFile();
            final StateSpaceExporter exporter = this.getExporter();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        try {
                            ExportStateSpaceWizard.this.performExport(exporter, file, monitor);
                        }
                        catch (Throwable t) {
                            StateSpaceExplorerPlugin.getInstance().logError("Error exporting state space", t);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            this.selectExport(file);
            return true;
        }
        catch (Throwable t) {
            StateSpaceExplorerPlugin.getInstance().logError("Error exporting state space", t);
            return false;
        }
    }

    protected void performExport(StateSpaceExporter exporter, IFile file, IProgressMonitor monitor) throws Exception {
        String extension = file.getFileExtension();
        extension = extension != null ? "." + extension : "";
        File tmp = File.createTempFile("export", extension);
        URI fileURI = URI.createFileURI((String)tmp.getAbsolutePath());
        monitor.beginTask("Exporting state space...", 2);
        exporter.export(this.stateSpace, fileURI, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(tmp), 65536);
        file.create((InputStream)in, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        in.close();
        tmp.delete();
    }

    protected void selectExport(IFile file) {
        try {
            IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        catch (Throwable t) {
            StateSpaceExplorerPlugin.getInstance().logError("Error opening exported file.", t);
        }
    }

    public IFile getFile() {
        return this.fileCreationPage.getFile();
    }

    public StateSpaceExporter getExporter() {
        return this.chooseExporterPage.getExporter();
    }

    protected class ChooseExporterPage
    extends WizardPage {
        private List<StateSpaceExporter> exporters;
        private int current;

        public ChooseExporterPage(String pageId) {
            super(pageId);
            this.current = 0;
            this.setDescription("Choose a state space exporter");
            if (ExportStateSpaceWizard.this.wizban != null) {
                this.setImageDescriptor(ExportStateSpaceWizard.this.wizban);
            }
            this.exporters = new ArrayList(StateSpacePlugin.INSTANCE.getExporters().values());
            Collections.sort(this.exporters, new Comparator<StateSpaceExporter>(){

                @Override
                public int compare(StateSpaceExporter o1, StateSpaceExporter o2) {
                    return String.valueOf(o1.getName()).compareTo(String.valueOf(o2.getName()));
                }
            });
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            final org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(container, 2048);
            for (StateSpaceExporter exporter : this.exporters) {
                list.add(String.valueOf(exporter.getName()) + " (" + ExportStateSpaceWizard.this.printAllowedExtensions(exporter) + ")");
            }
            list.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ChooseExporterPage.this.current = list.getSelectionIndex();
                    ChooseExporterPage.this.updateFilePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                    ChooseExporterPage.this.getContainer().showPage((IWizardPage)ExportStateSpaceWizard.this.fileCreationPage);
                }
            });
            list.select(this.current);
            this.updateFilePage();
            this.setControl((Control)container);
        }

        private void updateFilePage() {
            String[] fileExts;
            if (ExportStateSpaceWizard.this.fileCreationPage != null && this.current < this.exporters.size() && (fileExts = this.exporters.get(this.current).getFileExtensions()).length > 0) {
                ExportStateSpaceWizard.this.updateFileName(fileExts[0]);
            }
        }

        public StateSpaceExporter getExporter() {
            return this.exporters.get(this.current);
        }
    }

    protected class FileCreationPage
    extends WizardNewFileCreationPage {
        public FileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
            this.setDescription("Choose the file for the export");
            if (ExportStateSpaceWizard.this.wizban != null) {
                this.setImageDescriptor(ExportStateSpaceWizard.this.wizban);
            }
        }

        protected boolean validatePage() {
            if (!super.validatePage()) {
                return false;
            }
            String extension = new Path(this.getFileName()).getFileExtension();
            String[] allowed = ExportStateSpaceWizard.this.getExporter().getFileExtensions();
            boolean ok = false;
            int i = 0;
            while (i < allowed.length) {
                if (String.valueOf(allowed[i]).equals(extension)) {
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                this.setErrorMessage("Invalid file extension, should be one of " + ExportStateSpaceWizard.this.printAllowedExtensions(ExportStateSpaceWizard.this.getExporter()));
                return false;
            }
            return true;
        }

        public IFile getFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

